/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.base.domain;

import dagger.Lazy;
import de.ii.xtraplatform.base.domain.Jackson;
import de.ii.xtraplatform.base.domain.JacksonSubTypeIds;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.annotation.JsonInclude;
import shadow.com.fasterxml.jackson.annotation.JsonTypeInfo;
import shadow.com.fasterxml.jackson.core.JsonFactory;
import shadow.com.fasterxml.jackson.databind.DatabindContext;
import shadow.com.fasterxml.jackson.databind.DeserializationConfig;
import shadow.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.JsonSerializer;
import shadow.com.fasterxml.jackson.databind.KeyDeserializer;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.com.fasterxml.jackson.databind.SerializationConfig;
import shadow.com.fasterxml.jackson.databind.SerializationFeature;
import shadow.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import shadow.com.fasterxml.jackson.databind.cfg.MapperConfig;
import shadow.com.fasterxml.jackson.databind.introspect.Annotated;
import shadow.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import shadow.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import shadow.com.fasterxml.jackson.databind.type.TypeFactory;
import shadow.com.fasterxml.jackson.datatype.guava.GuavaModule;
import shadow.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import shadow.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import shadow.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.collect.BiMap;
import shadow.com.google.common.collect.HashBiMap;
import shadow.io.dropwizard.jackson.CaffeineModule;
import shadow.io.dropwizard.jackson.FuzzyEnumModule;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind
public class JacksonProvider
implements Jackson {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonProvider.class);
    private final DynamicHandlerInstantiator dynamicHandlerInstantiator = new DynamicHandlerInstantiator();
    private final ObjectMapper jsonMapper = this.configureMapper(new ObjectMapper());
    private final Lazy<Set<JacksonSubTypeIds>> subTypeIds;
    private final BiMap<Class<?>, String> mapping;

    @Inject
    public JacksonProvider(Lazy<Set<JacksonSubTypeIds>> subTypeIds) {
        this.subTypeIds = subTypeIds;
        this.mapping = HashBiMap.create();
    }

    private ObjectMapper configureMapper(ObjectMapper mapper) {
        return (ObjectMapper)mapper.enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_ABSENT).registerModule(new Jdk8Module()).registerModule(new GuavaModule()).registerModule(new CaffeineModule()).registerModule(new AfterburnerModule()).registerModule(new FuzzyEnumModule()).registerModule(new JavaTimeModule()).setDefaultMergeable(false).setHandlerInstantiator(this.dynamicHandlerInstantiator);
    }

    @Override
    public ObjectMapper getDefaultObjectMapper() {
        return this.jsonMapper;
    }

    @Override
    public ObjectMapper getNewObjectMapper(JsonFactory jsonFactory) {
        return this.configureMapper(new ObjectMapper(jsonFactory));
    }

    private BiMap<Class<?>, String> getMapping() {
        if (this.mapping.isEmpty()) {
            this.subTypeIds.get().forEach(ids -> this.mapping.putAll(ids.getMapping()));
        }
        return this.mapping;
    }

    class DynamicHandlerInstantiator
    extends HandlerInstantiator {
        private final Map<String, DynamicTypeIdResolver> typeIdResolvers = new HashMap<String, DynamicTypeIdResolver>();

        DynamicHandlerInstantiator() {
        }

        @Override
        public JsonDeserializer<?> deserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> deserClass) {
            return null;
        }

        @Override
        public KeyDeserializer keyDeserializerInstance(DeserializationConfig config, Annotated annotated, Class<?> keyDeserClass) {
            return null;
        }

        @Override
        public JsonSerializer<?> serializerInstance(SerializationConfig config, Annotated annotated, Class<?> serClass) {
            return null;
        }

        @Override
        public TypeResolverBuilder<?> typeResolverBuilderInstance(MapperConfig<?> config, Annotated annotated, Class<?> builderClass) {
            return null;
        }

        @Override
        public TypeIdResolver typeIdResolverInstance(MapperConfig<?> config, Annotated annotated, Class<?> resolverClass) {
            if (resolverClass.equals(DynamicTypeIdResolver.class)) {
                this.typeIdResolvers.putIfAbsent(annotated.getName(), new DynamicTypeIdResolver(annotated.getType()));
                return this.typeIdResolvers.get(annotated.getName());
            }
            return null;
        }
    }

    public class DynamicTypeIdResolver
    implements TypeIdResolver {
        private JavaType mBaseType;

        public DynamicTypeIdResolver(JavaType mBaseType) {
            this.mBaseType = mBaseType;
        }

        @Override
        public void init(JavaType baseType) {
            this.mBaseType = baseType;
        }

        @Override
        public String idFromValue(Object value) {
            return this.idFromValueAndType(value, value.getClass());
        }

        @Override
        public String idFromBaseType() {
            return this.idFromValueAndType(null, this.mBaseType.getRawClass());
        }

        @Override
        public String getDescForKnownTypeIds() {
            return null;
        }

        @Override
        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            if (JacksonProvider.this.getMapping().containsKey(suggestedType)) {
                return (String)JacksonProvider.this.getMapping().get(suggestedType);
            }
            for (Class<?> aClass = value.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                if (!JacksonProvider.this.getMapping().containsKey(aClass)) continue;
                return (String)JacksonProvider.this.getMapping().get(aClass);
            }
            return null;
        }

        @Override
        public JavaType typeFromId(DatabindContext context, String id) {
            if (JacksonProvider.this.getMapping().inverse().containsKey(id)) {
                Class clazz = (Class)JacksonProvider.this.getMapping().inverse().get(id);
                JavaType javaType = TypeFactory.defaultInstance().constructSpecializedType(this.mBaseType, clazz);
                return javaType;
            }
            return null;
        }

        @Override
        public JsonTypeInfo.Id getMechanism() {
            return JsonTypeInfo.Id.CUSTOM;
        }
    }
}

