/*
 * Decompiled with CFR 0.152.
 */
package de.ii.xtraplatform.base.domain;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.Strings;
import shadow.javax.validation.Valid;
import shadow.javax.validation.constraints.NotNull;

public class AuthConfig {
    @Valid
    @NotNull
    @JsonProperty
    public boolean allowAnonymousAccess = false;
    @Valid
    @JsonProperty
    public String jwtSigningKey;
    @Valid
    @NotNull
    @JsonProperty
    public String getUserNameKey = "name";
    @Valid
    @NotNull
    @JsonProperty
    public String getUserRoleKey = "role";
    @Valid
    @NotNull
    @JsonProperty
    public String getUserInfoEndpoint = "";
    @Valid
    @NotNull
    @JsonProperty
    public String getConnectionInfoEndpoint = "";
    @Valid
    @NotNull
    @JsonProperty
    public String getExternalDynamicAuthorizationEndpoint = "";
    @Valid
    @NotNull
    @JsonProperty
    public String getPostProcessingEndpoint = "";

    @JsonIgnore
    public boolean isJwt() {
        return Objects.nonNull(Strings.emptyToNull(this.jwtSigningKey));
    }

    @JsonIgnore
    public boolean isActive() {
        try {
            return this.isJwt() || new URI(this.getUserInfoEndpoint.replace("{{token}}", "token")).isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

