/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.transactional.app;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.transactional.app.TransactionalConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionalConfiguration", generator="Immutables")
@Immutable
public final class ImmutableTransactionalConfiguration
implements TransactionalConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;

    private ImmutableTransactionalConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.isEnabled = TransactionalConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    public final ImmutableTransactionalConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableTransactionalConfiguration(value, this.defaultValues);
    }

    public final ImmutableTransactionalConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableTransactionalConfiguration(this.enabled, newValue);
    }

    public final ImmutableTransactionalConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableTransactionalConfiguration(this.enabled, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionalConfiguration && this.equalTo((ImmutableTransactionalConfiguration)another);
    }

    private boolean equalTo(ImmutableTransactionalConfiguration another) {
        return Objects.equals(this.enabled, another.enabled);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionalConfiguration").omitNullValues().add("enabled", this.enabled).toString();
    }

    public static ImmutableTransactionalConfiguration copyOf(TransactionalConfiguration instance) {
        if (instance instanceof ImmutableTransactionalConfiguration) {
            return (ImmutableTransactionalConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="TransactionalConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends TransactionalConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(TransactionalConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                ExtensionConfiguration instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @Override
        public ImmutableTransactionalConfiguration build() {
            return new ImmutableTransactionalConfiguration(this.enabled, this.defaultValues);
        }
    }
}

