/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.tiles.domain.tileMatrixSet.ImmutableTilesBoundingBox;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTilesBoundingBox.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TilesBoundingBox {
    public static final Funnel<TilesBoundingBox> FUNNEL = (from, into) -> {
        Arrays.stream(from.getLowerLeft()).forEachOrdered(val -> into.putDouble(val.doubleValue()));
        Arrays.stream(from.getUpperRight()).forEachOrdered(val -> into.putDouble(val.doubleValue()));
        from.getCrs().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
    };

    public abstract BigDecimal[] getLowerLeft();

    public abstract BigDecimal[] getUpperRight();

    public abstract Optional<String> getCrs();
}

