/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.foundation.domain.PageRepresentationWithId;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.ImmutableTileMatrixSetData;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrix;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TilesBoundingBox;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTileMatrixSetData.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TileMatrixSetData
extends PageRepresentationWithId {
    public static final Funnel<TileMatrixSetData> FUNNEL = (from, into) -> {
        PageRepresentationWithId.FUNNEL.funnel((PageRepresentationWithId)from, into);
        from.getKeywords().stream().sorted().forEachOrdered(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getLinks().stream().sorted(Comparator.comparing(Link::getHref)).forEachOrdered(link -> into.putString(link.getHref(), StandardCharsets.UTF_8).putString(Objects.requireNonNullElse(link.getRel(), ""), StandardCharsets.UTF_8));
        into.putString(from.getCrs(), StandardCharsets.UTF_8);
        from.getUri().ifPresent(s -> into.putString(s.toString(), StandardCharsets.UTF_8));
        from.getBoundingBox().ifPresent(val -> TilesBoundingBox.FUNNEL.funnel((TilesBoundingBox)val, into));
        from.getTileMatrices().stream().sorted(Comparator.comparing(TileMatrix::getId)).forEachOrdered(val -> TileMatrix.FUNNEL.funnel((TileMatrix)val, into));
        from.getOrderedAxes().stream().sorted().forEachOrdered(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
    };

    public abstract List<String> getKeywords();

    public abstract String getCrs();

    public abstract Optional<URI> getWellKnownScaleSet();

    public abstract Optional<URI> getUri();

    public abstract Optional<TilesBoundingBox> getBoundingBox();

    public abstract List<TileMatrix> getTileMatrices();

    public abstract List<String> getOrderedAxes();
}

