/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.tiles.app.tileMatrixSet.TileMatrixSetImpl;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.ImmutableTileMatrixSetLimits;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrix;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetData;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetLimits;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.CrsTransformationException;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.com.fasterxml.jackson.datatype.guava.GuavaModule;
import shadow.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.io.Files;
import shadow.com.google.common.io.Resources;

public interface TileMatrixSet {
    public static final Logger LOGGER = LoggerFactory.getLogger(TileMatrixSet.class);

    public static Optional<TileMatrixSet> fromWellKnownId(String tileMatrixSetId) {
        InputStream inputStream;
        try {
            inputStream = Resources.asByteSource(Resources.getResource(TileMatrixSetImpl.class, "/tileMatrixSets/" + tileMatrixSetId + ".json")).openStream();
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Tile matrix set '{}' not found: {}", (Object)tileMatrixSetId, (Object)e.getMessage());
            return Optional.empty();
        }
        catch (IOException e) {
            LOGGER.error("Could not load tile matrix set '{}': {}", (Object)tileMatrixSetId, (Object)e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stacktrace: ", e);
            }
            return Optional.empty();
        }
        return TileMatrixSet.fromInputStream(inputStream, tileMatrixSetId);
    }

    public static Optional<TileMatrixSet> fromDefinition(String tileMatrixSetId, Path customTileMatrixSetsStore) {
        FileInputStream inputStream;
        Optional<File> tileMatrixSetFile;
        File dir = customTileMatrixSetsStore.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((tileMatrixSetFile = Arrays.stream(Objects.requireNonNullElse(dir.listFiles(), (File[])ImmutableList.of().toArray(File[]::new))).filter(file -> !file.isHidden()).filter(file -> Files.getFileExtension(file.getName()).equals("json")).filter(file -> Files.getNameWithoutExtension(file.getName()).equals(tileMatrixSetId)).findAny()).isEmpty()) {
            LOGGER.debug("Tile matrix set '{}' not found.", (Object)tileMatrixSetId);
            return Optional.empty();
        }
        try {
            inputStream = new FileInputStream(tileMatrixSetFile.get());
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Tile matrix set '{}' not found: {}", (Object)tileMatrixSetId, (Object)e.getMessage());
            return Optional.empty();
        }
        return TileMatrixSet.fromInputStream(inputStream, tileMatrixSetId);
    }

    public static Optional<TileMatrixSet> fromInputStream(InputStream tileMatrixSetInputStream, String tileMatrixSetId) {
        TileMatrixSetData data;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new GuavaModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        mapper.enable(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY);
        try {
            data = mapper.readValue(tileMatrixSetInputStream, TileMatrixSetData.class);
        }
        catch (IOException e) {
            LOGGER.error("Could not deserialize tile matrix set '{}': {}", (Object)tileMatrixSetId, (Object)e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Stacktrace: ", e);
            }
            return Optional.empty();
        }
        return Optional.of(new TileMatrixSetImpl(data));
    }

    public String getId();

    default public Optional<URI> getURI() {
        return Optional.empty();
    }

    default public Optional<String> getTitle() {
        return Optional.empty();
    }

    default public Optional<String> getDescription() {
        return Optional.empty();
    }

    default public List<String> getKeywords() {
        return ImmutableList.of();
    }

    public EpsgCrs getCrs();

    default public List<String> getOrderedAxes() {
        return ImmutableList.of();
    }

    default public Optional<URI> getWellKnownScaleSet() {
        return Optional.empty();
    }

    default public BoundingBox getTileBoundingBox(int level, int col, int row) {
        BoundingBox bbox = this.getBoundingBox();
        double rows = this.getRows(level);
        double cols = this.getCols(level);
        double tileWidth = (bbox.getXmax() - bbox.getXmin()) / cols;
        double tileHeight = (bbox.getYmax() - bbox.getYmin()) / rows;
        double minX = bbox.getXmin() + tileWidth * (double)col;
        double maxX = minX + tileWidth;
        double maxY = bbox.getYmax() - tileHeight * (double)row;
        double minY = maxY - tileHeight;
        return BoundingBox.of(minX, minY, maxX, maxY, this.getCrs());
    }

    default public int getCols(int level) {
        return (int)Math.round(Math.pow(2.0, level) * (double)this.getInitialWidth());
    }

    default public int getRows(int level) {
        return (int)Math.round(Math.pow(2.0, level) * (double)this.getInitialHeight());
    }

    default public double getMaxAllowableOffset(int level, int row, int col) {
        BoundingBox bbox = this.getBoundingBox();
        return (bbox.getXmax() - bbox.getXmin()) / (double)this.getCols(level) / (double)this.getTileExtent();
    }

    public int getMaxLevel();

    default public int getMinLevel() {
        return 0;
    }

    default public int getTileSize() {
        return 256;
    }

    default public int getTileExtent() {
        return 4096;
    }

    public TileMatrixSetData getTileMatrixSetData();

    public double getInitialScaleDenominator();

    public int getInitialWidth();

    public int getInitialHeight();

    public BoundingBox getBoundingBox();

    public BoundingBox getBoundingBoxCrs84(CrsTransformerFactory var1) throws CrsTransformationException;

    default public boolean validateRow(int level, int row) {
        if (level < this.getMinLevel() || level > this.getMaxLevel()) {
            return false;
        }
        return row >= 0 && row <= this.getRows(level);
    }

    default public boolean validateCol(int level, int col) {
        if (level < this.getMinLevel() || level > this.getMaxLevel()) {
            return false;
        }
        return col >= 0 && col <= this.getCols(level);
    }

    default public List<TileMatrix> getTileMatrices(int minLevel, int maxLevel) {
        ImmutableList.Builder tileMatrices = new ImmutableList.Builder();
        for (int i = minLevel; i <= maxLevel; ++i) {
            TileMatrix tileMatrix = this.getTileMatrix(i);
            tileMatrices.add(tileMatrix);
        }
        return tileMatrices.build();
    }

    public TileMatrix getTileMatrix(int var1);

    default public BigDecimal getBigDecimal(double value) {
        BigDecimal decimalValue = new BigDecimal(value);
        return decimalValue.setScale(15 - decimalValue.precision() + decimalValue.scale(), RoundingMode.HALF_UP).stripTrailingZeros();
    }

    default public List<Integer> getRowCol(double x, double y, int level) {
        BoundingBox bbox = this.getBoundingBox();
        int cols = this.getCols(level);
        int rows = this.getRows(level);
        double tileWidth = (bbox.getXmax() - bbox.getXmin()) / (double)cols;
        double tileHeight = (bbox.getYmax() - bbox.getYmin()) / (double)rows;
        int tileCol = (int)Math.floor((x - bbox.getXmin()) / tileWidth);
        int tileRow = (int)Math.floor((bbox.getYmax() - y) / tileHeight);
        return ImmutableList.of(Integer.valueOf(Math.min(Math.max(tileRow, 0), rows - 1)), Integer.valueOf(Math.min(Math.max(tileCol, 0), cols - 1)));
    }

    default public TileMatrixSetLimits getLimits(int level, BoundingBox bbox) {
        List<Integer> upperLeftCornerTile = this.getRowCol(bbox.getXmin(), bbox.getYmax(), level);
        List<Integer> lowerRightCornerTile = this.getRowCol(bbox.getXmax(), bbox.getYmin(), level);
        return new ImmutableTileMatrixSetLimits.Builder().minTileRow(upperLeftCornerTile.get(0)).maxTileRow(lowerRightCornerTile.get(0)).minTileCol(upperLeftCornerTile.get(1)).maxTileCol(lowerRightCornerTile.get(1)).tileMatrix(Integer.toString(level)).build();
    }

    default public List<TileMatrixSetLimits> getLimitsList(MinMax tileMatrixRange, BoundingBox bbox) {
        ImmutableList.Builder limits = new ImmutableList.Builder();
        for (int tileMatrix = tileMatrixRange.getMin(); tileMatrix <= tileMatrixRange.getMax(); ++tileMatrix) {
            limits.add(this.getLimits(tileMatrix, bbox));
        }
        return limits.build();
    }

    default public int getTmsRow(int level, int row) {
        return this.getRows(level) - 1 - row;
    }
}

