/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.tiles.domain.tileMatrixSet.ImmutableTileMatrix;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTileMatrix.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TileMatrix {
    public static final int SIGNIFICANT_DIGITS = 15;
    public static final Funnel<TileMatrix> FUNNEL = (from, into) -> {
        into.putString(from.getId(), StandardCharsets.UTF_8);
        from.getTitle().ifPresent(s -> into.putString((CharSequence)s, StandardCharsets.UTF_8));
        from.getDescription().ifPresent(s -> into.putString((CharSequence)s, StandardCharsets.UTF_8));
        from.getKeywords().stream().sorted().forEachOrdered(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        into.putLong(from.getTileWidth());
        into.putLong(from.getTileHeight());
        into.putLong(from.getMatrixWidth());
        into.putLong(from.getMatrixHeight());
        into.putDouble(from.getScaleDenominator().doubleValue());
        Arrays.stream(from.getPointOfOrigin()).forEachOrdered(val -> into.putDouble(val.doubleValue()));
        into.putString(from.getCornerOfOrigin(), StandardCharsets.UTF_8);
    };

    public abstract String getId();

    public abstract Optional<String> getTitle();

    public abstract Optional<String> getDescription();

    public abstract List<String> getKeywords();

    public abstract long getTileWidth();

    public abstract long getTileHeight();

    public abstract long getMatrixWidth();

    public abstract long getMatrixHeight();

    public abstract BigDecimal getScaleDenominator();

    public abstract BigDecimal getCellSize();

    public abstract BigDecimal[] getPointOfOrigin();

    @Value.Default
    public String getCornerOfOrigin() {
        return "topLeft";
    }

    @JsonIgnore
    @Value.Derived
    public int getTileLevel() {
        return Integer.parseInt(this.getId());
    }
}

