/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.tiles.domain.tileMatrixSet.TilesBoundingBox;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TilesBoundingBox", generator="Immutables")
@Immutable
public final class ImmutableTilesBoundingBox
extends TilesBoundingBox {
    private final BigDecimal[] lowerLeft;
    private final BigDecimal[] upperRight;
    @Nullable
    private final String crs;

    private ImmutableTilesBoundingBox(BigDecimal[] lowerLeft, BigDecimal[] upperRight, @Nullable String crs) {
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
        this.crs = crs;
    }

    @Override
    @JsonProperty(value="lowerLeft")
    public BigDecimal[] getLowerLeft() {
        return (BigDecimal[])this.lowerLeft.clone();
    }

    @Override
    @JsonProperty(value="upperRight")
    public BigDecimal[] getUpperRight() {
        return (BigDecimal[])this.upperRight.clone();
    }

    @Override
    @JsonProperty(value="crs")
    public Optional<String> getCrs() {
        return Optional.ofNullable(this.crs);
    }

    public final ImmutableTilesBoundingBox withLowerLeft(BigDecimal ... elements) {
        BigDecimal[] newValue = (BigDecimal[])elements.clone();
        return new ImmutableTilesBoundingBox(newValue, this.upperRight, this.crs);
    }

    public final ImmutableTilesBoundingBox withUpperRight(BigDecimal ... elements) {
        BigDecimal[] newValue = (BigDecimal[])elements.clone();
        return new ImmutableTilesBoundingBox(this.lowerLeft, newValue, this.crs);
    }

    public final ImmutableTilesBoundingBox withCrs(String value) {
        String newValue = Objects.requireNonNull(value, "crs");
        if (Objects.equals(this.crs, newValue)) {
            return this;
        }
        return new ImmutableTilesBoundingBox(this.lowerLeft, this.upperRight, newValue);
    }

    public final ImmutableTilesBoundingBox withCrs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.crs, value)) {
            return this;
        }
        return new ImmutableTilesBoundingBox(this.lowerLeft, this.upperRight, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTilesBoundingBox && this.equalTo((ImmutableTilesBoundingBox)another);
    }

    private boolean equalTo(ImmutableTilesBoundingBox another) {
        return Arrays.equals(this.lowerLeft, another.lowerLeft) && Arrays.equals(this.upperRight, another.upperRight) && Objects.equals(this.crs, another.crs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.lowerLeft);
        h += (h << 5) + Arrays.hashCode(this.upperRight);
        h += (h << 5) + Objects.hashCode(this.crs);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TilesBoundingBox").omitNullValues().add("lowerLeft", Arrays.toString(this.lowerLeft)).add("upperRight", Arrays.toString(this.upperRight)).add("crs", this.crs).toString();
    }

    public static ImmutableTilesBoundingBox copyOf(TilesBoundingBox instance) {
        if (instance instanceof ImmutableTilesBoundingBox) {
            return (ImmutableTilesBoundingBox)instance;
        }
        return ImmutableTilesBoundingBox.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TilesBoundingBox", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOWER_LEFT = 1L;
        private static final long INIT_BIT_UPPER_RIGHT = 2L;
        private long initBits = 3L;
        @Nullable
        private BigDecimal[] lowerLeft;
        @Nullable
        private BigDecimal[] upperRight;
        @Nullable
        private String crs;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TilesBoundingBox instance) {
            Objects.requireNonNull(instance, "instance");
            this.lowerLeft(instance.getLowerLeft());
            this.upperRight(instance.getUpperRight());
            Optional<String> crsOptional = instance.getCrs();
            if (crsOptional.isPresent()) {
                this.crs(crsOptional);
            }
            return this;
        }

        @JsonProperty(value="lowerLeft")
        @CanIgnoreReturnValue
        public final Builder lowerLeft(BigDecimal ... lowerLeft) {
            this.lowerLeft = (BigDecimal[])lowerLeft.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="upperRight")
        @CanIgnoreReturnValue
        public final Builder upperRight(BigDecimal ... upperRight) {
            this.upperRight = (BigDecimal[])upperRight.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder crs(String crs) {
            this.crs = Objects.requireNonNull(crs, "crs");
            return this;
        }

        @JsonProperty(value="crs")
        @CanIgnoreReturnValue
        public final Builder crs(Optional<String> crs) {
            this.crs = crs.orElse(null);
            return this;
        }

        public ImmutableTilesBoundingBox build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTilesBoundingBox(this.lowerLeft, this.upperRight, this.crs);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lowerLeft");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("upperRight");
            }
            return "Cannot build TilesBoundingBox, some of required attributes are not set " + attributes;
        }
    }
}

