/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetLimits;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TileMatrixSetLimits", generator="Immutables")
@Immutable
public final class ImmutableTileMatrixSetLimits
extends TileMatrixSetLimits {
    private final String tileMatrix;
    private final Integer minTileRow;
    private final Integer maxTileRow;
    private final Integer minTileCol;
    private final Integer maxTileCol;

    private ImmutableTileMatrixSetLimits(String tileMatrix, Integer minTileRow, Integer maxTileRow, Integer minTileCol, Integer maxTileCol) {
        this.tileMatrix = tileMatrix;
        this.minTileRow = minTileRow;
        this.maxTileRow = maxTileRow;
        this.minTileCol = minTileCol;
        this.maxTileCol = maxTileCol;
    }

    @Override
    @JsonProperty(value="tileMatrix")
    public String getTileMatrix() {
        return this.tileMatrix;
    }

    @Override
    @JsonProperty(value="minTileRow")
    public Integer getMinTileRow() {
        return this.minTileRow;
    }

    @Override
    @JsonProperty(value="maxTileRow")
    public Integer getMaxTileRow() {
        return this.maxTileRow;
    }

    @Override
    @JsonProperty(value="minTileCol")
    public Integer getMinTileCol() {
        return this.minTileCol;
    }

    @Override
    @JsonProperty(value="maxTileCol")
    public Integer getMaxTileCol() {
        return this.maxTileCol;
    }

    public final ImmutableTileMatrixSetLimits withTileMatrix(String value) {
        String newValue = Objects.requireNonNull(value, "tileMatrix");
        if (this.tileMatrix.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetLimits(newValue, this.minTileRow, this.maxTileRow, this.minTileCol, this.maxTileCol);
    }

    public final ImmutableTileMatrixSetLimits withMinTileRow(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "minTileRow");
        if (this.minTileRow.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetLimits(this.tileMatrix, newValue, this.maxTileRow, this.minTileCol, this.maxTileCol);
    }

    public final ImmutableTileMatrixSetLimits withMaxTileRow(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "maxTileRow");
        if (this.maxTileRow.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetLimits(this.tileMatrix, this.minTileRow, newValue, this.minTileCol, this.maxTileCol);
    }

    public final ImmutableTileMatrixSetLimits withMinTileCol(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "minTileCol");
        if (this.minTileCol.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetLimits(this.tileMatrix, this.minTileRow, this.maxTileRow, newValue, this.maxTileCol);
    }

    public final ImmutableTileMatrixSetLimits withMaxTileCol(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "maxTileCol");
        if (this.maxTileCol.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetLimits(this.tileMatrix, this.minTileRow, this.maxTileRow, this.minTileCol, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTileMatrixSetLimits && this.equalTo((ImmutableTileMatrixSetLimits)another);
    }

    private boolean equalTo(ImmutableTileMatrixSetLimits another) {
        return this.tileMatrix.equals(another.tileMatrix) && this.minTileRow.equals(another.minTileRow) && this.maxTileRow.equals(another.maxTileRow) && this.minTileCol.equals(another.minTileCol) && this.maxTileCol.equals(another.maxTileCol);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tileMatrix.hashCode();
        h += (h << 5) + this.minTileRow.hashCode();
        h += (h << 5) + this.maxTileRow.hashCode();
        h += (h << 5) + this.minTileCol.hashCode();
        h += (h << 5) + this.maxTileCol.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TileMatrixSetLimits").omitNullValues().add("tileMatrix", this.tileMatrix).add("minTileRow", this.minTileRow).add("maxTileRow", this.maxTileRow).add("minTileCol", this.minTileCol).add("maxTileCol", this.maxTileCol).toString();
    }

    public static ImmutableTileMatrixSetLimits copyOf(TileMatrixSetLimits instance) {
        if (instance instanceof ImmutableTileMatrixSetLimits) {
            return (ImmutableTileMatrixSetLimits)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="TileMatrixSetLimits", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TILE_MATRIX = 1L;
        private static final long INIT_BIT_MIN_TILE_ROW = 2L;
        private static final long INIT_BIT_MAX_TILE_ROW = 4L;
        private static final long INIT_BIT_MIN_TILE_COL = 8L;
        private static final long INIT_BIT_MAX_TILE_COL = 16L;
        private long initBits = 31L;
        @Nullable
        private String tileMatrix;
        @Nullable
        private Integer minTileRow;
        @Nullable
        private Integer maxTileRow;
        @Nullable
        private Integer minTileCol;
        @Nullable
        private Integer maxTileCol;

        @CanIgnoreReturnValue
        public final Builder from(TileMatrixSetLimits instance) {
            Objects.requireNonNull(instance, "instance");
            this.tileMatrix(instance.getTileMatrix());
            this.minTileRow(instance.getMinTileRow());
            this.maxTileRow(instance.getMaxTileRow());
            this.minTileCol(instance.getMinTileCol());
            this.maxTileCol(instance.getMaxTileCol());
            return this;
        }

        @JsonProperty(value="tileMatrix")
        @CanIgnoreReturnValue
        public final Builder tileMatrix(String tileMatrix) {
            this.tileMatrix = Objects.requireNonNull(tileMatrix, "tileMatrix");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="minTileRow")
        @CanIgnoreReturnValue
        public final Builder minTileRow(Integer minTileRow) {
            this.minTileRow = Objects.requireNonNull(minTileRow, "minTileRow");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="maxTileRow")
        @CanIgnoreReturnValue
        public final Builder maxTileRow(Integer maxTileRow) {
            this.maxTileRow = Objects.requireNonNull(maxTileRow, "maxTileRow");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="minTileCol")
        @CanIgnoreReturnValue
        public final Builder minTileCol(Integer minTileCol) {
            this.minTileCol = Objects.requireNonNull(minTileCol, "minTileCol");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="maxTileCol")
        @CanIgnoreReturnValue
        public final Builder maxTileCol(Integer maxTileCol) {
            this.maxTileCol = Objects.requireNonNull(maxTileCol, "maxTileCol");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableTileMatrixSetLimits build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTileMatrixSetLimits(this.tileMatrix, this.minTileRow, this.maxTileRow, this.minTileCol, this.maxTileCol);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tileMatrix");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minTileRow");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("maxTileRow");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("minTileCol");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("maxTileCol");
            }
            return "Cannot build TileMatrixSetLimits, some of required attributes are not set " + attributes;
        }
    }
}

