/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.foundation.domain.ImmutableLink;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.foundation.domain.PageRepresentation;
import de.ii.ogcapi.foundation.domain.PageRepresentationWithId;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.ImmutableTileMatrix;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrix;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetData;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TilesBoundingBox;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TileMatrixSetData", generator="Immutables")
@Immutable
public final class ImmutableTileMatrixSetData
extends TileMatrixSetData {
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    private final ImmutableList<Link> links;
    @Nullable
    private final Date lastModified;
    private final ImmutableList<Map<String, Object>> sections;
    private final transient List<Map<String, Object>> orderedSections;
    private final boolean sectionsFirst;
    private final String id;
    private final ImmutableList<String> keywords;
    private final String crs;
    @Nullable
    private final URI wellKnownScaleSet;
    @Nullable
    private final URI uri;
    @Nullable
    private final TilesBoundingBox boundingBox;
    private final ImmutableList<TileMatrix> tileMatrices;
    private final ImmutableList<String> orderedAxes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTileMatrixSetData(Builder builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.links = builder.links.build();
        this.lastModified = builder.lastModified;
        this.sections = builder.sections.build();
        this.id = builder.id;
        this.keywords = builder.keywords.build();
        this.crs = builder.crs;
        this.wellKnownScaleSet = builder.wellKnownScaleSet;
        this.uri = builder.uri;
        this.boundingBox = builder.boundingBox;
        this.tileMatrices = builder.tileMatrices.build();
        this.orderedAxes = builder.orderedAxes.build();
        if (builder.sectionsFirstIsSet()) {
            this.initShim.sectionsFirst(builder.sectionsFirst);
        }
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.initShim = null;
    }

    private ImmutableTileMatrixSetData(@Nullable String title, @Nullable String description, ImmutableList<Link> links, @Nullable Date lastModified, ImmutableList<Map<String, Object>> sections, boolean sectionsFirst, String id, ImmutableList<String> keywords, String crs, @Nullable URI wellKnownScaleSet, @Nullable URI uri, @Nullable TilesBoundingBox boundingBox, ImmutableList<TileMatrix> tileMatrices, ImmutableList<String> orderedAxes) {
        this.title = title;
        this.description = description;
        this.links = links;
        this.lastModified = lastModified;
        this.sections = sections;
        this.initShim.sectionsFirst(sectionsFirst);
        this.id = id;
        this.keywords = keywords;
        this.crs = crs;
        this.wellKnownScaleSet = wellKnownScaleSet;
        this.uri = uri;
        this.boundingBox = boundingBox;
        this.tileMatrices = tileMatrices;
        this.orderedAxes = orderedAxes;
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="links")
    public ImmutableList<Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="lastModified")
    @JsonIgnore
    public Optional<Date> getLastModified() {
        return Optional.ofNullable(this.lastModified);
    }

    @JsonProperty(value="sections")
    @JsonIgnore
    public ImmutableList<Map<String, Object>> getSections() {
        return this.sections;
    }

    @Override
    @JsonProperty(value="orderedSections")
    @JsonIgnore
    public List<Map<String, Object>> getOrderedSections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOrderedSections() : this.orderedSections;
    }

    @Override
    @JsonProperty(value="sectionsFirst")
    @JsonIgnore
    public boolean getSectionsFirst() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSectionsFirst() : this.sectionsFirst;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="keywords")
    public ImmutableList<String> getKeywords() {
        return this.keywords;
    }

    @Override
    @JsonProperty(value="crs")
    public String getCrs() {
        return this.crs;
    }

    @Override
    @JsonProperty(value="wellKnownScaleSet")
    public Optional<URI> getWellKnownScaleSet() {
        return Optional.ofNullable(this.wellKnownScaleSet);
    }

    @Override
    @JsonProperty(value="uri")
    public Optional<URI> getUri() {
        return Optional.ofNullable(this.uri);
    }

    @Override
    @JsonProperty(value="boundingBox")
    public Optional<TilesBoundingBox> getBoundingBox() {
        return Optional.ofNullable(this.boundingBox);
    }

    @JsonProperty(value="tileMatrices")
    public ImmutableList<TileMatrix> getTileMatrices() {
        return this.tileMatrices;
    }

    @JsonProperty(value="orderedAxes")
    public ImmutableList<String> getOrderedAxes() {
        return this.orderedAxes;
    }

    public final ImmutableTileMatrixSetData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetData(newValue, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableTileMatrixSetData(value, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, newValue, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, value, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withLinks(Link ... elements) {
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withLinks(Iterable<? extends Link> elements) {
        if (this.links == elements) {
            return this;
        }
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withLastModified(Date value) {
        Date newValue = Objects.requireNonNull(value, "lastModified");
        if (this.lastModified == newValue) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, newValue, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withLastModified(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, value, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    @SafeVarargs
    public final ImmutableTileMatrixSetData withSections(Map<String, Object> ... elements) {
        ImmutableList<Map<String, Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withSections(Iterable<? extends Map<String, Object>> elements) {
        if (this.sections == elements) {
            return this;
        }
        ImmutableList<Map<String, Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withSectionsFirst(boolean value) {
        if (this.sectionsFirst == value) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, value, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, newValue, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withKeywords(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, newValue, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withKeywords(Iterable<String> elements) {
        if (this.keywords == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, newValue, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withCrs(String value) {
        String newValue = Objects.requireNonNull(value, "crs");
        if (this.crs.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, newValue, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withWellKnownScaleSet(URI value) {
        URI newValue = Objects.requireNonNull(value, "wellKnownScaleSet");
        if (this.wellKnownScaleSet == newValue) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, newValue, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withWellKnownScaleSet(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.wellKnownScaleSet == value) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, value, this.uri, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withUri(URI value) {
        URI newValue = Objects.requireNonNull(value, "uri");
        if (this.uri == newValue) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, newValue, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withUri(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.uri == value) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, value, this.boundingBox, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withBoundingBox(TilesBoundingBox value) {
        TilesBoundingBox newValue = Objects.requireNonNull(value, "boundingBox");
        if (this.boundingBox == newValue) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, newValue, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withBoundingBox(Optional<? extends TilesBoundingBox> optional) {
        TilesBoundingBox value = optional.orElse(null);
        if (this.boundingBox == value) {
            return this;
        }
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, value, this.tileMatrices, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withTileMatrices(TileMatrix ... elements) {
        ImmutableList<TileMatrix> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, newValue, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withTileMatrices(Iterable<? extends TileMatrix> elements) {
        if (this.tileMatrices == elements) {
            return this;
        }
        ImmutableList<TileMatrix> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, newValue, this.orderedAxes);
    }

    public final ImmutableTileMatrixSetData withOrderedAxes(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, newValue);
    }

    public final ImmutableTileMatrixSetData withOrderedAxes(Iterable<String> elements) {
        if (this.orderedAxes == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrixSetData(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.id, this.keywords, this.crs, this.wellKnownScaleSet, this.uri, this.boundingBox, this.tileMatrices, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTileMatrixSetData && this.equalTo((ImmutableTileMatrixSetData)another);
    }

    private boolean equalTo(ImmutableTileMatrixSetData another) {
        return Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && this.links.equals(another.links) && Objects.equals(this.lastModified, another.lastModified) && this.sections.equals(another.sections) && this.orderedSections.equals(another.orderedSections) && this.sectionsFirst == another.sectionsFirst && this.id.equals(another.id) && this.keywords.equals(another.keywords) && this.crs.equals(another.crs) && Objects.equals(this.wellKnownScaleSet, another.wellKnownScaleSet) && Objects.equals(this.uri, another.uri) && Objects.equals(this.boundingBox, another.boundingBox) && this.tileMatrices.equals(another.tileMatrices) && this.orderedAxes.equals(another.orderedAxes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + this.sections.hashCode();
        h += (h << 5) + this.orderedSections.hashCode();
        h += (h << 5) + Booleans.hashCode(this.sectionsFirst);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.keywords.hashCode();
        h += (h << 5) + this.crs.hashCode();
        h += (h << 5) + Objects.hashCode(this.wellKnownScaleSet);
        h += (h << 5) + Objects.hashCode(this.uri);
        h += (h << 5) + Objects.hashCode(this.boundingBox);
        h += (h << 5) + this.tileMatrices.hashCode();
        h += (h << 5) + this.orderedAxes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TileMatrixSetData").omitNullValues().add("title", this.title).add("description", this.description).add("links", this.links).add("lastModified", this.lastModified).add("sections", this.sections).add("orderedSections", this.orderedSections).add("sectionsFirst", this.sectionsFirst).add("id", this.id).add("keywords", this.keywords).add("crs", this.crs).add("wellKnownScaleSet", this.wellKnownScaleSet).add("uri", this.uri).add("boundingBox", this.boundingBox).add("tileMatrices", this.tileMatrices).add("orderedAxes", this.orderedAxes).toString();
    }

    public static ImmutableTileMatrixSetData copyOf(TileMatrixSetData instance) {
        if (instance instanceof ImmutableTileMatrixSetData) {
            return (ImmutableTileMatrixSetData)instance;
        }
        return ImmutableTileMatrixSetData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TileMatrixSetData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CRS = 2L;
        private static final long OPT_BIT_SECTIONS_FIRST = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String title;
        @Nullable
        private String description;
        private ImmutableList.Builder<Link> links = ImmutableList.builder();
        @Nullable
        private Date lastModified;
        private ImmutableList.Builder<Map<String, Object>> sections = ImmutableList.builder();
        private boolean sectionsFirst;
        @Nullable
        private String id;
        private ImmutableList.Builder<String> keywords = ImmutableList.builder();
        @Nullable
        private String crs;
        @Nullable
        private URI wellKnownScaleSet;
        @Nullable
        private URI uri;
        @Nullable
        private TilesBoundingBox boundingBox;
        private ImmutableList.Builder<TileMatrix> tileMatrices = ImmutableList.builder();
        private ImmutableList.Builder<String> orderedAxes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TileMatrixSetData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PageRepresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PageRepresentationWithId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageRepresentation instance;
            if (object instanceof TileMatrixSetData) {
                Optional<URI> wellKnownScaleSetOptional;
                instance = (TileMatrixSetData)object;
                this.addAllTileMatrices(((TileMatrixSetData)instance).getTileMatrices());
                Optional<TilesBoundingBox> boundingBoxOptional = ((TileMatrixSetData)instance).getBoundingBox();
                if (boundingBoxOptional.isPresent()) {
                    this.boundingBox(boundingBoxOptional);
                }
                this.addAllOrderedAxes(((TileMatrixSetData)instance).getOrderedAxes());
                this.addAllKeywords(((TileMatrixSetData)instance).getKeywords());
                this.crs(((TileMatrixSetData)instance).getCrs());
                Optional<URI> uriOptional = ((TileMatrixSetData)instance).getUri();
                if (uriOptional.isPresent()) {
                    this.uri(uriOptional);
                }
                if ((wellKnownScaleSetOptional = ((TileMatrixSetData)instance).getWellKnownScaleSet()).isPresent()) {
                    this.wellKnownScaleSet(wellKnownScaleSetOptional);
                }
            }
            if (object instanceof PageRepresentation) {
                Optional<String> titleOptional;
                instance = (PageRepresentation)object;
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.description(descriptionOptional);
                }
                this.addAllLinks(instance.getLinks());
                Optional<Date> lastModifiedOptional = instance.getLastModified();
                if (lastModifiedOptional.isPresent()) {
                    this.lastModified(lastModifiedOptional);
                }
                if ((titleOptional = instance.getTitle()).isPresent()) {
                    this.title(titleOptional);
                }
                this.addAllSections(instance.getSections());
                this.sectionsFirst(instance.getSectionsFirst());
            }
            if (object instanceof PageRepresentationWithId) {
                instance = (PageRepresentationWithId)object;
                this.id(((PageRepresentationWithId)instance).getId());
            }
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link element) {
            element = ImmutableLink.copyOf(element);
            this.links.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link ... elements) {
            for (Link element : elements) {
                element = ImmutableLink.copyOf(element);
                this.links.add((Object)Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @JsonProperty(value="links")
        @CanIgnoreReturnValue
        public final Builder links(Iterable<? extends Link> elements) {
            this.links = ImmutableList.builder();
            return this.addAllLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLinks(Iterable<? extends Link> elements) {
            for (Link link : elements) {
                ImmutableLink immutableLink = ImmutableLink.copyOf(link);
                this.links.add((Object)Objects.requireNonNull(immutableLink, "links element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastModified(Date lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            return this;
        }

        @JsonProperty(value="lastModified")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder lastModified(Optional<? extends Date> lastModified) {
            this.lastModified = lastModified.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> element) {
            this.sections.add((Object)element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> ... elements) {
            this.sections.add(elements);
            return this;
        }

        @JsonProperty(value="sections")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sections(Iterable<? extends Map<String, Object>> elements) {
            this.sections = ImmutableList.builder();
            return this.addAllSections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSections(Iterable<? extends Map<String, Object>> elements) {
            this.sections.addAll(elements);
            return this;
        }

        @JsonProperty(value="sectionsFirst")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String element) {
            this.keywords.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String ... elements) {
            this.keywords.add(elements);
            return this;
        }

        @JsonProperty(value="keywords")
        @CanIgnoreReturnValue
        public final Builder keywords(Iterable<String> elements) {
            this.keywords = ImmutableList.builder();
            return this.addAllKeywords(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeywords(Iterable<String> elements) {
            this.keywords.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="crs")
        @CanIgnoreReturnValue
        public final Builder crs(String crs) {
            this.crs = Objects.requireNonNull(crs, "crs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder wellKnownScaleSet(URI wellKnownScaleSet) {
            this.wellKnownScaleSet = Objects.requireNonNull(wellKnownScaleSet, "wellKnownScaleSet");
            return this;
        }

        @JsonProperty(value="wellKnownScaleSet")
        @CanIgnoreReturnValue
        public final Builder wellKnownScaleSet(Optional<? extends URI> wellKnownScaleSet) {
            this.wellKnownScaleSet = wellKnownScaleSet.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uri(URI uri) {
            this.uri = Objects.requireNonNull(uri, "uri");
            return this;
        }

        @JsonProperty(value="uri")
        @CanIgnoreReturnValue
        public final Builder uri(Optional<? extends URI> uri) {
            this.uri = uri.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder boundingBox(TilesBoundingBox boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox, "boundingBox");
            return this;
        }

        @JsonProperty(value="boundingBox")
        @CanIgnoreReturnValue
        public final Builder boundingBox(Optional<? extends TilesBoundingBox> boundingBox) {
            this.boundingBox = boundingBox.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileMatrices(TileMatrix element) {
            element = ImmutableTileMatrix.copyOf(element);
            this.tileMatrices.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileMatrices(TileMatrix ... elements) {
            for (TileMatrix element : elements) {
                element = ImmutableTileMatrix.copyOf(element);
                this.tileMatrices.add((Object)Objects.requireNonNull(element, "tileMatrices element"));
            }
            return this;
        }

        @JsonProperty(value="tileMatrices")
        @CanIgnoreReturnValue
        public final Builder tileMatrices(Iterable<? extends TileMatrix> elements) {
            this.tileMatrices = ImmutableList.builder();
            return this.addAllTileMatrices(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTileMatrices(Iterable<? extends TileMatrix> elements) {
            for (TileMatrix tileMatrix : elements) {
                ImmutableTileMatrix immutableTileMatrix = ImmutableTileMatrix.copyOf(tileMatrix);
                this.tileMatrices.add((Object)Objects.requireNonNull(immutableTileMatrix, "tileMatrices element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOrderedAxes(String element) {
            this.orderedAxes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addOrderedAxes(String ... elements) {
            this.orderedAxes.add(elements);
            return this;
        }

        @JsonProperty(value="orderedAxes")
        @CanIgnoreReturnValue
        public final Builder orderedAxes(Iterable<String> elements) {
            this.orderedAxes = ImmutableList.builder();
            return this.addAllOrderedAxes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllOrderedAxes(Iterable<String> elements) {
            this.orderedAxes.addAll((Iterable)elements);
            return this;
        }

        public ImmutableTileMatrixSetData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTileMatrixSetData(this);
        }

        private boolean sectionsFirstIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("crs");
            }
            return "Cannot build TileMatrixSetData, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="TileMatrixSetData", generator="Immutables")
    private final class InitShim {
        private byte orderedSectionsBuildStage = 0;
        private List<Map<String, Object>> orderedSections;
        private byte sectionsFirstBuildStage = 0;
        private boolean sectionsFirst;

        private InitShim() {
        }

        List<Map<String, Object>> getOrderedSections() {
            if (this.orderedSectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orderedSectionsBuildStage == 0) {
                this.orderedSectionsBuildStage = (byte)-1;
                this.orderedSections = Objects.requireNonNull(ImmutableTileMatrixSetData.super.getOrderedSections(), "orderedSections");
                this.orderedSectionsBuildStage = 1;
            }
            return this.orderedSections;
        }

        boolean getSectionsFirst() {
            if (this.sectionsFirstBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sectionsFirstBuildStage == 0) {
                this.sectionsFirstBuildStage = (byte)-1;
                this.sectionsFirst = ImmutableTileMatrixSetData.super.getSectionsFirst();
                this.sectionsFirstBuildStage = 1;
            }
            return this.sectionsFirst;
        }

        void sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.sectionsFirstBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.orderedSectionsBuildStage == -1) {
                attributes.add("orderedSections");
            }
            if (this.sectionsFirstBuildStage == -1) {
                attributes.add("sectionsFirst");
            }
            return "Cannot build TileMatrixSetData, attribute initializers form cycle " + attributes;
        }
    }
}

