/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain.tileMatrixSet;

import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrix;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Longs;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TileMatrix", generator="Immutables")
@Immutable
public final class ImmutableTileMatrix
extends TileMatrix {
    private final String id;
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    private final ImmutableList<String> keywords;
    private final long tileWidth;
    private final long tileHeight;
    private final long matrixWidth;
    private final long matrixHeight;
    private final BigDecimal scaleDenominator;
    private final BigDecimal cellSize;
    private final BigDecimal[] pointOfOrigin;
    private final String cornerOfOrigin;
    private final transient int tileLevel;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTileMatrix(Builder builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.description = builder.description;
        this.keywords = builder.keywords.build();
        this.tileWidth = builder.tileWidth;
        this.tileHeight = builder.tileHeight;
        this.matrixWidth = builder.matrixWidth;
        this.matrixHeight = builder.matrixHeight;
        this.scaleDenominator = builder.scaleDenominator;
        this.cellSize = builder.cellSize;
        this.pointOfOrigin = builder.pointOfOrigin;
        if (builder.cornerOfOrigin != null) {
            this.initShim.cornerOfOrigin(builder.cornerOfOrigin);
        }
        this.cornerOfOrigin = this.initShim.getCornerOfOrigin();
        this.tileLevel = this.initShim.getTileLevel();
        this.initShim = null;
    }

    private ImmutableTileMatrix(String id, @Nullable String title, @Nullable String description, ImmutableList<String> keywords, long tileWidth, long tileHeight, long matrixWidth, long matrixHeight, BigDecimal scaleDenominator, BigDecimal cellSize, BigDecimal[] pointOfOrigin, String cornerOfOrigin) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.keywords = keywords;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.matrixWidth = matrixWidth;
        this.matrixHeight = matrixHeight;
        this.scaleDenominator = scaleDenominator;
        this.cellSize = cellSize;
        this.pointOfOrigin = pointOfOrigin;
        this.initShim.cornerOfOrigin(cornerOfOrigin);
        this.cornerOfOrigin = this.initShim.getCornerOfOrigin();
        this.tileLevel = this.initShim.getTileLevel();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="keywords")
    public ImmutableList<String> getKeywords() {
        return this.keywords;
    }

    @Override
    @JsonProperty(value="tileWidth")
    public long getTileWidth() {
        return this.tileWidth;
    }

    @Override
    @JsonProperty(value="tileHeight")
    public long getTileHeight() {
        return this.tileHeight;
    }

    @Override
    @JsonProperty(value="matrixWidth")
    public long getMatrixWidth() {
        return this.matrixWidth;
    }

    @Override
    @JsonProperty(value="matrixHeight")
    public long getMatrixHeight() {
        return this.matrixHeight;
    }

    @Override
    @JsonProperty(value="scaleDenominator")
    public BigDecimal getScaleDenominator() {
        return this.scaleDenominator;
    }

    @Override
    @JsonProperty(value="cellSize")
    public BigDecimal getCellSize() {
        return this.cellSize;
    }

    @Override
    @JsonProperty(value="pointOfOrigin")
    public BigDecimal[] getPointOfOrigin() {
        return (BigDecimal[])this.pointOfOrigin.clone();
    }

    @Override
    @JsonProperty(value="cornerOfOrigin")
    public String getCornerOfOrigin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCornerOfOrigin() : this.cornerOfOrigin;
    }

    @Override
    @JsonProperty(value="tileLevel")
    @JsonIgnore
    public int getTileLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTileLevel() : this.tileLevel;
    }

    public final ImmutableTileMatrix withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrix(newValue, this.title, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, newValue, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, value, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, newValue, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, value, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withKeywords(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrix(this.id, this.title, this.description, newValue, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withKeywords(Iterable<String> elements) {
        if (this.keywords == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileMatrix(this.id, this.title, this.description, newValue, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withTileWidth(long value) {
        if (this.tileWidth == value) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, value, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withTileHeight(long value) {
        if (this.tileHeight == value) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, this.tileWidth, value, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withMatrixWidth(long value) {
        if (this.matrixWidth == value) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, this.tileWidth, this.tileHeight, value, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withMatrixHeight(long value) {
        if (this.matrixHeight == value) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, value, this.scaleDenominator, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withScaleDenominator(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "scaleDenominator");
        if (this.scaleDenominator.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, newValue, this.cellSize, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withCellSize(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "cellSize");
        if (this.cellSize.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, newValue, this.pointOfOrigin, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withPointOfOrigin(BigDecimal ... elements) {
        BigDecimal[] newValue = (BigDecimal[])elements.clone();
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, newValue, this.cornerOfOrigin);
    }

    public final ImmutableTileMatrix withCornerOfOrigin(String value) {
        String newValue = Objects.requireNonNull(value, "cornerOfOrigin");
        if (this.cornerOfOrigin.equals(newValue)) {
            return this;
        }
        return new ImmutableTileMatrix(this.id, this.title, this.description, this.keywords, this.tileWidth, this.tileHeight, this.matrixWidth, this.matrixHeight, this.scaleDenominator, this.cellSize, this.pointOfOrigin, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTileMatrix && this.equalTo((ImmutableTileMatrix)another);
    }

    private boolean equalTo(ImmutableTileMatrix another) {
        return this.id.equals(another.id) && Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && this.keywords.equals(another.keywords) && this.tileWidth == another.tileWidth && this.tileHeight == another.tileHeight && this.matrixWidth == another.matrixWidth && this.matrixHeight == another.matrixHeight && this.scaleDenominator.equals(another.scaleDenominator) && this.cellSize.equals(another.cellSize) && Arrays.equals(this.pointOfOrigin, another.pointOfOrigin) && this.cornerOfOrigin.equals(another.cornerOfOrigin) && this.tileLevel == another.tileLevel;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.keywords.hashCode();
        h += (h << 5) + Longs.hashCode(this.tileWidth);
        h += (h << 5) + Longs.hashCode(this.tileHeight);
        h += (h << 5) + Longs.hashCode(this.matrixWidth);
        h += (h << 5) + Longs.hashCode(this.matrixHeight);
        h += (h << 5) + this.scaleDenominator.hashCode();
        h += (h << 5) + this.cellSize.hashCode();
        h += (h << 5) + Arrays.hashCode(this.pointOfOrigin);
        h += (h << 5) + this.cornerOfOrigin.hashCode();
        h += (h << 5) + this.tileLevel;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TileMatrix").omitNullValues().add("id", this.id).add("title", this.title).add("description", this.description).add("keywords", this.keywords).add("tileWidth", this.tileWidth).add("tileHeight", this.tileHeight).add("matrixWidth", this.matrixWidth).add("matrixHeight", this.matrixHeight).add("scaleDenominator", this.scaleDenominator).add("cellSize", this.cellSize).add("pointOfOrigin", Arrays.toString(this.pointOfOrigin)).add("cornerOfOrigin", this.cornerOfOrigin).add("tileLevel", this.tileLevel).toString();
    }

    public static ImmutableTileMatrix copyOf(TileMatrix instance) {
        if (instance instanceof ImmutableTileMatrix) {
            return (ImmutableTileMatrix)instance;
        }
        return ImmutableTileMatrix.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TileMatrix", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TILE_WIDTH = 2L;
        private static final long INIT_BIT_TILE_HEIGHT = 4L;
        private static final long INIT_BIT_MATRIX_WIDTH = 8L;
        private static final long INIT_BIT_MATRIX_HEIGHT = 16L;
        private static final long INIT_BIT_SCALE_DENOMINATOR = 32L;
        private static final long INIT_BIT_CELL_SIZE = 64L;
        private static final long INIT_BIT_POINT_OF_ORIGIN = 128L;
        private long initBits = 255L;
        @Nullable
        private String id;
        @Nullable
        private String title;
        @Nullable
        private String description;
        private ImmutableList.Builder<String> keywords = ImmutableList.builder();
        private long tileWidth;
        private long tileHeight;
        private long matrixWidth;
        private long matrixHeight;
        @Nullable
        private BigDecimal scaleDenominator;
        @Nullable
        private BigDecimal cellSize;
        @Nullable
        private BigDecimal[] pointOfOrigin;
        @Nullable
        private String cornerOfOrigin;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TileMatrix instance) {
            Optional<String> descriptionOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            Optional<String> titleOptional = instance.getTitle();
            if (titleOptional.isPresent()) {
                this.title(titleOptional);
            }
            if ((descriptionOptional = instance.getDescription()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.addAllKeywords(instance.getKeywords());
            this.tileWidth(instance.getTileWidth());
            this.tileHeight(instance.getTileHeight());
            this.matrixWidth(instance.getMatrixWidth());
            this.matrixHeight(instance.getMatrixHeight());
            this.scaleDenominator(instance.getScaleDenominator());
            this.cellSize(instance.getCellSize());
            this.pointOfOrigin(instance.getPointOfOrigin());
            this.cornerOfOrigin(instance.getCornerOfOrigin());
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String element) {
            this.keywords.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String ... elements) {
            this.keywords.add(elements);
            return this;
        }

        @JsonProperty(value="keywords")
        @CanIgnoreReturnValue
        public final Builder keywords(Iterable<String> elements) {
            this.keywords = ImmutableList.builder();
            return this.addAllKeywords(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeywords(Iterable<String> elements) {
            this.keywords.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="tileWidth")
        @CanIgnoreReturnValue
        public final Builder tileWidth(long tileWidth) {
            this.tileWidth = tileWidth;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="tileHeight")
        @CanIgnoreReturnValue
        public final Builder tileHeight(long tileHeight) {
            this.tileHeight = tileHeight;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="matrixWidth")
        @CanIgnoreReturnValue
        public final Builder matrixWidth(long matrixWidth) {
            this.matrixWidth = matrixWidth;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="matrixHeight")
        @CanIgnoreReturnValue
        public final Builder matrixHeight(long matrixHeight) {
            this.matrixHeight = matrixHeight;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="scaleDenominator")
        @CanIgnoreReturnValue
        public final Builder scaleDenominator(BigDecimal scaleDenominator) {
            this.scaleDenominator = Objects.requireNonNull(scaleDenominator, "scaleDenominator");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="cellSize")
        @CanIgnoreReturnValue
        public final Builder cellSize(BigDecimal cellSize) {
            this.cellSize = Objects.requireNonNull(cellSize, "cellSize");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="pointOfOrigin")
        @CanIgnoreReturnValue
        public final Builder pointOfOrigin(BigDecimal ... pointOfOrigin) {
            this.pointOfOrigin = (BigDecimal[])pointOfOrigin.clone();
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="cornerOfOrigin")
        @CanIgnoreReturnValue
        public final Builder cornerOfOrigin(String cornerOfOrigin) {
            this.cornerOfOrigin = Objects.requireNonNull(cornerOfOrigin, "cornerOfOrigin");
            return this;
        }

        public ImmutableTileMatrix build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTileMatrix(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tileWidth");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tileHeight");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("matrixWidth");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("matrixHeight");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("scaleDenominator");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("cellSize");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("pointOfOrigin");
            }
            return "Cannot build TileMatrix, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="TileMatrix", generator="Immutables")
    private final class InitShim {
        private byte cornerOfOriginBuildStage = 0;
        private String cornerOfOrigin;
        private byte tileLevelBuildStage = 0;
        private int tileLevel;

        private InitShim() {
        }

        String getCornerOfOrigin() {
            if (this.cornerOfOriginBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.cornerOfOriginBuildStage == 0) {
                this.cornerOfOriginBuildStage = (byte)-1;
                this.cornerOfOrigin = Objects.requireNonNull(ImmutableTileMatrix.super.getCornerOfOrigin(), "cornerOfOrigin");
                this.cornerOfOriginBuildStage = 1;
            }
            return this.cornerOfOrigin;
        }

        void cornerOfOrigin(String cornerOfOrigin) {
            this.cornerOfOrigin = cornerOfOrigin;
            this.cornerOfOriginBuildStage = 1;
        }

        int getTileLevel() {
            if (this.tileLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tileLevelBuildStage == 0) {
                this.tileLevelBuildStage = (byte)-1;
                this.tileLevel = ImmutableTileMatrix.super.getTileLevel();
                this.tileLevelBuildStage = 1;
            }
            return this.tileLevel;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.cornerOfOriginBuildStage == -1) {
                attributes.add("cornerOfOrigin");
            }
            if (this.tileLevelBuildStage == -1) {
                attributes.add("tileLevel");
            }
            return "Cannot build TileMatrix, attribute initializers form cycle " + attributes;
        }
    }
}

