/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.features.core.domain.processing.FeatureProcessChain;
import de.ii.ogcapi.foundation.domain.QueriesHandler;
import de.ii.ogcapi.foundation.domain.QueryHandler;
import de.ii.ogcapi.foundation.domain.QueryIdentifier;
import de.ii.ogcapi.foundation.domain.QueryInput;
import de.ii.ogcapi.tiles.app.TileProviderMbtiles;
import de.ii.ogcapi.tiles.app.TileProviderTileServer;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.Tile;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.org.immutables.value.Value;

public interface TilesQueriesHandler
extends QueriesHandler<Query> {
    @Override
    public Map<Query, QueryHandler<? extends QueryInput>> getQueryHandlers();

    @Value.Immutable
    public static interface QueryInputTileSet
    extends QueryInput {
        public Optional<String> getCollectionId();

        public String getTileMatrixSetId();

        public List<Double> getCenter();

        public MinMax getZoomLevels();

        public String getPath();
    }

    @Value.Immutable
    public static interface QueryInputTileSets
    extends QueryInput {
        public Optional<String> getCollectionId();

        public List<Double> getCenter();

        public Map<String, MinMax> getTileMatrixSetZoomLevels();

        public String getPath();

        public boolean getOnlyWebMercatorQuad();

        public List<String> getTileEncodings();
    }

    @Value.Immutable
    public static interface QueryInputTileSingleLayer
    extends QueryInput {
        public Tile getTile();

        public FeatureQuery getQuery();

        public EpsgCrs getDefaultCrs();

        public Optional<OutputStream> getOutputStream();

        public Optional<FeatureProcessChain> getProcesses();

        public Map<String, Object> getProcessingParameters();
    }

    @Value.Immutable
    public static interface QueryInputTileMultiLayer
    extends QueryInput {
        public Tile getTile();

        public Map<String, Tile> getSingleLayerTileMap();

        public Map<String, FeatureQuery> getQueryMap();

        public EpsgCrs getDefaultCrs();

        public Optional<OutputStream> getOutputStream();

        public Optional<FeatureProcessChain> getProcesses();

        public Map<String, Object> getProcessingParameters();
    }

    @Value.Immutable
    public static interface QueryInputTileTileServerTile
    extends QueryInput {
        public Tile getTile();

        public TileProviderTileServer getProvider();
    }

    @Value.Immutable
    public static interface QueryInputTileMbtilesTile
    extends QueryInput {
        public Tile getTile();

        public TileProviderMbtiles getProvider();
    }

    @Value.Immutable
    public static interface QueryInputTileStream
    extends QueryInput {
        public Tile getTile();

        public InputStream getTileContent();
    }

    @Value.Immutable
    public static interface QueryInputTileEmpty
    extends QueryInput {
        public Tile getTile();
    }

    public static enum Query implements QueryIdentifier
    {
        TILE_SETS,
        TILE_SET,
        SINGLE_LAYER_TILE,
        MULTI_LAYER_TILE,
        TILE_STREAM,
        EMPTY_TILE,
        MBTILES_TILE,
        TILESERVER_TILE;

    }
}

