/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.html.domain.MapClient;
import de.ii.ogcapi.tiles.app.TileProviderFeatures;
import de.ii.ogcapi.tiles.app.TileProviderMbtiles;
import de.ii.ogcapi.tiles.app.TileProviderTileServer;
import de.ii.ogcapi.tiles.domain.ImmutableMinMax;
import de.ii.ogcapi.tiles.domain.ImmutableTilesConfiguration;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.PredefinedFilter;
import de.ii.ogcapi.tiles.domain.Rule;
import de.ii.ogcapi.tiles.domain.SeedingOptions;
import de.ii.ogcapi.tiles.domain.TileProvider;
import de.ii.xtraplatform.features.domain.transform.ImmutablePropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.Lists;
import shadow.com.google.common.collect.Maps;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTilesConfiguration.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new")
public interface TilesConfiguration
extends ExtensionConfiguration,
PropertyTransformations,
CachingConfiguration {
    @Nullable
    public TileProvider getTileProvider();

    public List<String> getTileSetEncodings();

    @Nullable
    public TileCacheType getCache();

    @Nullable
    public MapClient.Type getMapClientType();

    @Nullable
    public String getStyle();

    @Nullable
    public Boolean getRemoveZoomLevelConstraints();

    @Deprecated
    public List<String> getTileEncodings();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public List<String> getTileEncodingsDerived() {
        return !this.getTileEncodings().isEmpty() ? this.getTileEncodings() : (this.getTileProvider() instanceof TileProviderFeatures ? this.getTileProvider().getTileEncodings() : (this.getTileProvider() instanceof TileProviderMbtiles && Objects.nonNull(((TileProviderMbtiles)this.getTileProvider()).getTileEncoding()) ? ImmutableList.of(((TileProviderMbtiles)this.getTileProvider()).getTileEncoding()) : (this.getTileProvider() instanceof TileProviderTileServer && Objects.nonNull(((TileProviderTileServer)this.getTileProvider()).getTileEncodings()) ? this.getTileProvider().getTileEncodings() : ImmutableList.of())));
    }

    @Deprecated
    public List<Double> getCenter();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public List<Double> getCenterDerived() {
        return !this.getCenter().isEmpty() ? this.getCenter() : (this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getCenter() : (this.getTileProvider() instanceof TileProviderMbtiles ? ((TileProviderMbtiles)this.getTileProvider()).getCenter() : ImmutableList.of()));
    }

    @Deprecated
    public Map<String, MinMax> getZoomLevels();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public Map<String, MinMax> getZoomLevelsDerived() {
        return !this.getZoomLevels().isEmpty() ? this.getZoomLevels() : (this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getZoomLevels() : (this.getTileProvider() instanceof TileProviderMbtiles ? ((TileProviderMbtiles)this.getTileProvider()).getZoomLevels() : ImmutableMap.of()));
    }

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public Set<String> getTileMatrixSets() {
        return this.getZoomLevelsDerived().keySet();
    }

    @Deprecated
    @Nullable
    public Boolean getSingleCollectionEnabled();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public boolean isSingleCollectionEnabled() {
        return Objects.equals(this.getSingleCollectionEnabled(), true) || Objects.nonNull(this.getTileProvider()) && this.getTileProvider().isSingleCollectionEnabled() || this.isEnabled();
    }

    @Deprecated
    @Nullable
    public Boolean getMultiCollectionEnabled();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public boolean isMultiCollectionEnabled() {
        return Objects.equals(this.getMultiCollectionEnabled(), true) || Objects.nonNull(this.getTileProvider()) && this.getTileProvider().isMultiCollectionEnabled() || this.isEnabled();
    }

    @Deprecated
    public Map<String, MinMax> getZoomLevelsCache();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public Map<String, MinMax> getZoomLevelsCacheDerived() {
        return !this.getZoomLevelsCache().isEmpty() ? this.getZoomLevelsCache() : (this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getZoomLevelsCache() : ImmutableMap.of());
    }

    @Deprecated
    public Map<String, MinMax> getSeeding();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public Map<String, MinMax> getSeedingDerived() {
        return !this.getSeeding().isEmpty() ? this.getSeeding() : (this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getSeeding() : ImmutableMap.of());
    }

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public Optional<SeedingOptions> getSeedingOptions() {
        return this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getSeedingOptions() : Optional.empty();
    }

    @Deprecated
    @Nullable
    public Integer getLimit();

    @JsonIgnore
    @Nullable
    @Value.Auxiliary
    @Value.Derived
    default public Integer getLimitDerived() {
        return Objects.nonNull(this.getLimit()) ? this.getLimit() : (this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getLimit() : null);
    }

    @Deprecated
    @Nullable
    public Boolean getIgnoreInvalidGeometries();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public boolean isIgnoreInvalidGeometriesDerived() {
        return Objects.equals(this.getIgnoreInvalidGeometries(), true) || this.getTileProvider() instanceof TileProviderFeatures && ((TileProviderFeatures)this.getTileProvider()).isIgnoreInvalidGeometries() || this.isEnabled();
    }

    @Deprecated
    public Map<String, List<PredefinedFilter>> getFilters();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public Map<String, List<PredefinedFilter>> getFiltersDerived() {
        return !this.getFilters().isEmpty() ? this.getFilters() : (this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getFilters() : ImmutableMap.of());
    }

    @Deprecated
    public Map<String, List<Rule>> getRules();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public Map<String, List<Rule>> getRulesDerived() {
        return !this.getRules().isEmpty() ? this.getRules() : (this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getRules() : ImmutableMap.of());
    }

    @Deprecated
    public Optional<Double> getMaxRelativeAreaChangeInPolygonRepair();

    @Deprecated
    public Optional<Double> getMaxAbsoluteAreaChangeInPolygonRepair();

    @Deprecated
    @Nullable
    public Double getMinimumSizeInPixel();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public double getMinimumSizeInPixelDerived() {
        return Objects.requireNonNullElse(this.getMinimumSizeInPixel(), Objects.requireNonNullElse(this.getTileProvider() instanceof TileProviderFeatures ? ((TileProviderFeatures)this.getTileProvider()).getMinimumSizeInPixel() : null, 0.5));
    }

    default public Builder getBuilder() {
        return new ImmutableTilesConfiguration.Builder();
    }

    @Override
    default public ExtensionConfiguration mergeInto(ExtensionConfiguration source) {
        LinkedHashMap mergedFilters;
        LinkedHashMap mergedRules;
        LinkedHashMap mergedZoomLevelsCache;
        LinkedHashMap mergedZoomLevels;
        LinkedHashMap mergedSeeding;
        ImmutableTilesConfiguration.Builder builder = ((ImmutableTilesConfiguration.Builder)source.getBuilder()).from(source).from(this).transformations(PropertyTransformations.super.mergeInto((PropertyTransformations)((Object)source)).getTransformations());
        TilesConfiguration src = (TilesConfiguration)source;
        if (Objects.nonNull(this.getTileProvider()) && Objects.nonNull(src.getTileProvider())) {
            builder.tileProvider(this.getTileProvider().mergeInto(src.getTileProvider()));
        }
        ArrayList<String> tileEncodings = Objects.nonNull(src.getTileEncodings()) ? Lists.newArrayList(src.getTileEncodings()) : Lists.newArrayList();
        this.getTileEncodings().forEach(tileEncoding -> {
            if (!tileEncodings.contains(tileEncoding)) {
                tileEncodings.add((String)tileEncoding);
            }
        });
        builder.tileEncodings(tileEncodings);
        ArrayList<String> tileSetEncodings = Objects.nonNull(src.getTileSetEncodings()) ? Lists.newArrayList(src.getTileSetEncodings()) : Lists.newArrayList();
        this.getTileSetEncodings().forEach(tileSetEncoding -> {
            if (!tileSetEncodings.contains(tileSetEncoding)) {
                tileSetEncodings.add((String)tileSetEncoding);
            }
        });
        builder.tileSetEncodings(tileSetEncodings);
        LinkedHashMap<Object, Object> linkedHashMap = mergedSeeding = Objects.nonNull(src.getSeeding()) ? Maps.newLinkedHashMap(src.getSeeding()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getSeeding())) {
            this.getSeeding().forEach(mergedSeeding::put);
        }
        builder.seeding(mergedSeeding);
        LinkedHashMap<Object, Object> linkedHashMap2 = mergedZoomLevels = Objects.nonNull(src.getZoomLevels()) ? Maps.newLinkedHashMap(src.getZoomLevels()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getZoomLevels())) {
            this.getZoomLevels().forEach(mergedZoomLevels::put);
        }
        builder.zoomLevels(mergedZoomLevels);
        LinkedHashMap<Object, Object> linkedHashMap3 = mergedZoomLevelsCache = Objects.nonNull(src.getZoomLevelsCache()) ? Maps.newLinkedHashMap(src.getZoomLevelsCache()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getZoomLevelsCache())) {
            this.getZoomLevelsCache().forEach(mergedZoomLevelsCache::put);
        }
        builder.zoomLevelsCache(mergedZoomLevelsCache);
        LinkedHashMap<Object, Object> linkedHashMap4 = mergedRules = Objects.nonNull(src.getRules()) ? Maps.newLinkedHashMap(src.getRules()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getRules())) {
            this.getRules().forEach(mergedRules::put);
        }
        builder.rules(mergedRules);
        LinkedHashMap<Object, Object> linkedHashMap5 = mergedFilters = Objects.nonNull(src.getFilters()) ? Maps.newLinkedHashMap(src.getFilters()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getFilters())) {
            this.getFilters().forEach(mergedFilters::put);
        }
        builder.filters(mergedFilters);
        if (!this.getCenter().isEmpty()) {
            builder.center(this.getCenter());
        } else if (!src.getCenter().isEmpty()) {
            builder.center(src.getCenter());
        }
        return builder.build();
    }

    @JsonIgnore
    @Value.Lazy
    default public Map<String, MinMax> getEffectiveSeeding() {
        Map<String, MinMax> baseSeeding = this.getSeedingDerived();
        if (baseSeeding.isEmpty()) {
            return baseSeeding;
        }
        Map<String, MinMax> zoomLevels = this.getZoomLevelsDerived();
        ImmutableMap.Builder<String, ImmutableMinMax> responseBuilder = ImmutableMap.builder();
        for (Map.Entry<String, MinMax> entry : baseSeeding.entrySet()) {
            if (!zoomLevels.containsKey(entry.getKey())) continue;
            MinMax minmax = zoomLevels.get(entry.getKey());
            int minSeeding = entry.getValue().getMin();
            int maxSeeding = entry.getValue().getMax();
            int minRange = minmax.getMin();
            int maxRange = minmax.getMax();
            if (maxSeeding < minRange || minSeeding > maxRange) continue;
            responseBuilder.put(entry.getKey(), new ImmutableMinMax.Builder().min(Math.max(minSeeding, minRange)).max(Math.min(maxSeeding, maxRange)).build());
        }
        return responseBuilder.build();
    }

    @Value.Check
    default public TilesConfiguration alwaysFlatten() {
        if (!this.hasTransformation("*", transformation -> transformation.getFlatten().isPresent())) {
            Map<String, List<PropertyTransformation>> transformations = this.withTransformation("*", new ImmutablePropertyTransformation.Builder().flatten(".").build());
            return new ImmutableTilesConfiguration.Builder().from(this).transformations(transformations).build();
        }
        return this;
    }

    public static abstract class Builder
    extends ExtensionConfiguration.Builder {
    }

    public static enum TileCacheType {
        FILES,
        MBTILES,
        NONE;

    }
}

