/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.foundation.domain.Metadata2;
import de.ii.ogcapi.tiles.domain.ImmutableTileSet;
import de.ii.ogcapi.tiles.domain.TileLayer;
import de.ii.ogcapi.tiles.domain.TilePoint;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetData;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetLimits;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TilesBoundingBox;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTileSet.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TileSet
extends Metadata2 {
    public static final Funnel<TileSet> FUNNEL = (from, into) -> {
        Metadata2.FUNNEL.funnel((Metadata2)from, into);
        into.putString(from.getDataType().toString(), StandardCharsets.UTF_8);
        into.putString(from.getTileMatrixSetId(), StandardCharsets.UTF_8);
        from.getTileMatrixSet().ifPresent(val -> TileMatrixSetData.FUNNEL.funnel((TileMatrixSetData)val, into));
        from.getTileMatrixSetURI().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getTileMatrixSetDefinition().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        TilesBoundingBox.FUNNEL.funnel(from.getBoundingBox(), into);
        from.getCenterPoint().ifPresent(val -> TilePoint.FUNNEL.funnel((TilePoint)val, into));
        from.getTileMatrixSetLimits().stream().sorted(Comparator.comparing(TileMatrixSetLimits::getTileMatrix)).forEachOrdered(val -> TileMatrixSetLimits.FUNNEL.funnel((TileMatrixSetLimits)val, into));
        from.getLayers().stream().sorted(Comparator.comparing(TileLayer::getId)).forEachOrdered(val -> TileLayer.FUNNEL.funnel((TileLayer)val, into));
        from.getExtensions().keySet().stream().sorted().forEachOrdered(key -> into.putString((CharSequence)key, StandardCharsets.UTF_8));
    };

    public abstract DataType getDataType();

    public abstract String getTileMatrixSetId();

    public abstract Optional<TileMatrixSetData> getTileMatrixSet();

    public abstract Optional<String> getTileMatrixSetURI();

    public abstract Optional<String> getTileMatrixSetDefinition();

    public abstract List<TileMatrixSetLimits> getTileMatrixSetLimits();

    public abstract TilesBoundingBox getBoundingBox();

    public abstract Optional<TilePoint> getCenterPoint();

    public abstract List<TileLayer> getLayers();

    @JsonAnyGetter
    public abstract Map<String, Object> getExtensions();

    public static enum DataType {
        map,
        vector,
        coverage;

    }
}

