/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.features.geojson.domain.JsonSchema;
import de.ii.ogcapi.features.geojson.domain.JsonSchemaObject;
import de.ii.ogcapi.foundation.domain.Metadata2;
import de.ii.ogcapi.tiles.domain.ImmutableTileLayer;
import de.ii.ogcapi.tiles.domain.TileSet;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TilesBoundingBox;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableTileLayer.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TileLayer
extends Metadata2 {
    public static final Funnel<TileLayer> FUNNEL = (from, into) -> {
        Metadata2.FUNNEL.funnel((Metadata2)from, into);
        into.putString(from.getId(), StandardCharsets.UTF_8);
        into.putString(from.getDataType().toString(), StandardCharsets.UTF_8);
        from.getFeatureType().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getGeometryType().ifPresent(val -> into.putString(val.toString(), StandardCharsets.UTF_8));
        from.getTheme().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getMinTileMatrix().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getMaxTileMatrix().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getMinCellSize().ifPresent(into::putDouble);
        from.getMaxCellSize().ifPresent(into::putDouble);
        from.getMinScaleDenominator().ifPresent(into::putDouble);
        from.getMaxScaleDenominator().ifPresent(into::putDouble);
        from.getBoundingBox().ifPresent(val -> TilesBoundingBox.FUNNEL.funnel((TilesBoundingBox)val, into));
        from.getPropertiesSchema().ifPresent(val -> JsonSchema.FUNNEL.funnel((JsonSchema)val, into));
    };

    public abstract String getId();

    public abstract TileSet.DataType getDataType();

    public abstract Optional<String> getFeatureType();

    public abstract Optional<GeometryType> getGeometryType();

    public abstract Optional<String> getTheme();

    public abstract Optional<String> getMinTileMatrix();

    public abstract Optional<String> getMaxTileMatrix();

    public abstract Optional<Double> getMinCellSize();

    public abstract Optional<Double> getMaxCellSize();

    public abstract Optional<Double> getMinScaleDenominator();

    public abstract Optional<Double> getMaxScaleDenominator();

    public abstract Optional<TilesBoundingBox> getBoundingBox();

    public abstract Optional<JsonSchemaObject> getPropertiesSchema();

    public static enum GeometryType {
        points,
        lines,
        polygons;

    }
}

