/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.FormatExtension;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.tiles.domain.Tile;
import de.ii.ogcapi.tiles.domain.TileFromFeatureQuery;
import de.ii.ogcapi.tiles.domain.TileSet;
import de.ii.ogcapi.tiles.domain.TilesConfiguration;
import java.util.List;
import shadow.com.google.common.collect.ImmutableList;
import shadow.io.swagger.v3.oas.models.media.BinarySchema;
import shadow.io.swagger.v3.oas.models.media.Schema;

public abstract class TileFormatExtension
implements FormatExtension {
    protected String SCHEMA_REF_TILE = "#/components/schemas/Binary";
    protected Schema SCHEMA_TILE = new BinarySchema();

    @Override
    public boolean isEnabledForApi(OgcApiDataV2 apiData) {
        return apiData.getExtension(TilesConfiguration.class).filter(ExtensionConfiguration::getEnabled).filter(TilesConfiguration::isMultiCollectionEnabled).filter(config -> config.getTileEncodingsDerived().contains(this.getMediaType().label())).isPresent();
    }

    @Override
    public boolean isEnabledForApi(OgcApiDataV2 apiData, String collectionId) {
        return apiData.getExtension(TilesConfiguration.class, collectionId).filter(ExtensionConfiguration::getEnabled).filter(TilesConfiguration::isSingleCollectionEnabled).filter(config -> config.getTileEncodingsDerived().contains(this.getMediaType().label())).isPresent();
    }

    @Override
    public String getPathPattern() {
        return "^(?:/collections/[\\w\\-]+)?/tiles/\\w+/\\w+/\\w+/\\w+/?$";
    }

    public boolean isApplicable(OgcApiDataV2 apiData, String definitionPath) {
        List formats = apiData.getExtension(TilesConfiguration.class).map(TilesConfiguration::getTileEncodingsDerived).orElse(ImmutableList.of());
        return this.isEnabledForApi(apiData) && definitionPath.startsWith("/tiles") && (formats.isEmpty() && this.isEnabledByDefault() || formats.contains(this.getMediaType().label()));
    }

    public boolean isApplicable(OgcApiDataV2 apiData, String collectionId, String definitionPath) {
        List formats = apiData.getExtension(TilesConfiguration.class, collectionId).map(TilesConfiguration::getTileEncodingsDerived).orElse(ImmutableList.of());
        return this.isEnabledForApi(apiData, collectionId) && definitionPath.startsWith("/collections/{collectionId}/tiles") && (formats.isEmpty() && this.isEnabledByDefault() || formats.contains(this.getMediaType().label()));
    }

    public boolean canMultiLayer() {
        return false;
    }

    public boolean supportsFeatureQuery() {
        return this instanceof TileFromFeatureQuery;
    }

    public abstract String getExtension();

    public boolean getGzippedInMbtiles() {
        return false;
    }

    public boolean getSupportsEmptyTile() {
        return false;
    }

    public byte[] getEmptyTile(Tile tile) {
        throw new IllegalStateException(String.format("No empty tile available for tile format %s.", this.getClass().getSimpleName()));
    }

    public abstract TileSet.DataType getDataType();

    @Override
    public Class<? extends ExtensionConfiguration> getBuildingBlockConfigurationType() {
        return TilesConfiguration.class;
    }
}

