/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.tiles.domain.TileFormatExtension;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSet;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.CrsTransformationException;
import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;
import shadow.org.locationtech.jts.geom.util.AffineTransformation;

@Value.Immutable
@Value.Style(builder="new", deepImmutablesDetection=true)
public abstract class Tile {
    public abstract TileMatrixSet getTileMatrixSet();

    public abstract int getTileLevel();

    public abstract int getTileRow();

    public abstract int getTileCol();

    public abstract List<String> getCollectionIds();

    public abstract OgcApiDataV2 getApiData();

    public abstract Optional<FeatureProvider2> getFeatureProvider();

    public abstract TileFormatExtension getOutputFormat();

    public abstract boolean getTemporary();

    public abstract boolean isDatasetTile();

    @Nullable
    @Value.Derived
    @Value.Auxiliary
    public String getCollectionId() {
        return !this.isDatasetTile() && this.getCollectionIds().size() == 1 ? this.getCollectionIds().get(0) : null;
    }

    @Value.Derived
    @Value.Auxiliary
    public Path getRelativePath() {
        String extension = this.getOutputFormat().getExtension();
        Path tilePath = this.getTemporary() ? Paths.get(String.format("%s.%s", UUID.randomUUID(), extension), new String[0]) : Paths.get(String.valueOf(this.getTileLevel()), String.valueOf(this.getTileRow()), String.format("%d.%s", this.getTileCol(), extension));
        return tilePath;
    }

    @Value.Derived
    @Value.Auxiliary
    public void check() {
        if (this.getTileLevel() > this.getTileMatrixSet().getMaxLevel() || this.getTileLevel() < this.getTileMatrixSet().getMinLevel()) {
            throw new IllegalStateException(MessageFormat.format("Tile is not valid in tiling scheme {0}, zoom level {1} is outside of the range {2}..{3}.", this.getTileMatrixSet().getId(), this.getTileLevel(), this.getTileLevel() < this.getTileMatrixSet().getMinLevel(), this.getTileMatrixSet().getMaxLevel()));
        }
        if (!this.getTileMatrixSet().validateRow(this.getTileLevel(), this.getTileRow())) {
            throw new IllegalStateException(MessageFormat.format("Tile is not valid in tiling scheme {0}, row {1} is outside of the range for zoom level {2}.", this.getTileMatrixSet().getId(), this.getTileRow(), this.getTileLevel()));
        }
        if (!this.getTileMatrixSet().validateCol(this.getTileLevel(), this.getTileCol())) {
            throw new IllegalStateException(MessageFormat.format("Tile is not valid in tiling scheme {0}, column {1} is outside of the range for zoom level {2}.", this.getTileMatrixSet().getId(), this.getTileCol(), this.getTileLevel()));
        }
    }

    @Value.Derived
    @Value.Auxiliary
    public AffineTransformation createTransformNativeToTile() {
        BoundingBox bbox = this.getBoundingBox();
        double xMin = bbox.getXmin();
        double xMax = bbox.getXmax();
        double yMin = bbox.getYmin();
        double yMax = bbox.getYmax();
        double tileSize = this.getTileMatrixSet().getTileSize();
        double xScale = tileSize / (xMax - xMin);
        double yScale = tileSize / (yMax - yMin);
        double xOffset = -xMin * xScale;
        double yOffset = yMin * yScale + tileSize;
        return new AffineTransformation(xScale, 0.0, xOffset, 0.0, -yScale, yOffset);
    }

    public AffineTransformation createTransformLonLatToTile(CrsTransformerFactory crsTransformerFactory) throws CrsTransformationException {
        BoundingBox bbox = this.getBoundingBox(OgcCrs.CRS84, crsTransformerFactory);
        double lonMin = bbox.getXmin();
        double lonMax = bbox.getXmax();
        double latMin = bbox.getYmin();
        double latMax = bbox.getYmax();
        double tileSize = this.getTileMatrixSet().getTileSize();
        double xScale = tileSize / (lonMax - lonMin);
        double yScale = tileSize / (latMax - latMin);
        double xOffset = -lonMin * xScale;
        double yOffset = latMin * yScale + tileSize;
        return new AffineTransformation(xScale, 0.0, xOffset, 0.0, -yScale, yOffset);
    }

    @Value.Derived
    @Value.Auxiliary
    public BoundingBox getBoundingBox() {
        return this.getTileMatrixSet().getTileBoundingBox(this.getTileLevel(), this.getTileCol(), this.getTileRow());
    }

    public BoundingBox getBoundingBox(EpsgCrs crs, CrsTransformerFactory crsTransformerFactory) throws CrsTransformationException {
        BoundingBox bboxTileMatrixSetCrs = this.getBoundingBox();
        Optional<CrsTransformer> transformer = crsTransformerFactory.getTransformer(this.getTileMatrixSet().getCrs(), crs, true);
        if (transformer.isEmpty()) {
            return bboxTileMatrixSetCrs;
        }
        return transformer.get().transformBoundingBox(bboxTileMatrixSetCrs);
    }
}

