/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.tiles.domain.ImmutableSeedingOptions;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableSeedingOptions.Builder.class)
@Value.Immutable
@Value.Style(builder="new")
public interface SeedingOptions {
    @Nullable
    public Boolean getRunOnStartup();

    @JsonIgnore
    @Value.Lazy
    default public boolean shouldRunOnStartup() {
        return !Objects.equals(this.getRunOnStartup(), false);
    }

    @Nullable
    public String getRunPeriodic();

    @JsonIgnore
    @Value.Lazy
    default public boolean shouldRunPeriodic() {
        return Objects.nonNull(this.getRunPeriodic());
    }

    @JsonIgnore
    @Value.Lazy
    default public Optional<String> getCronExpression() {
        return Optional.ofNullable(this.getRunPeriodic());
    }

    @Nullable
    public Boolean getPurge();

    @JsonIgnore
    @Value.Lazy
    default public boolean shouldPurge() {
        return Objects.equals(this.getPurge(), true);
    }

    @Nullable
    public Integer getMaxThreads();

    @JsonIgnore
    @Value.Lazy
    default public int getEffectiveMaxThreads() {
        return Objects.isNull(this.getMaxThreads()) || this.getMaxThreads() <= 1 ? 1 : this.getMaxThreads();
    }
}

