/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.ImmutableCaching;
import de.ii.ogcapi.html.domain.MapClient;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.PredefinedFilter;
import de.ii.ogcapi.tiles.domain.Rule;
import de.ii.ogcapi.tiles.domain.SeedingOptions;
import de.ii.ogcapi.tiles.domain.TileProvider;
import de.ii.ogcapi.tiles.domain.TilesConfiguration;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformation;
import de.ii.xtraplatform.features.domain.transform.PropertyTransformations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TilesConfiguration", generator="Immutables")
@Immutable
public final class ImmutableTilesConfiguration
implements TilesConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    private final ImmutableMap<String, List<PropertyTransformation>> transformations;
    private final transient boolean hasDeprecatedTransformationKeys;
    @Nullable
    private final ImmutableCaching caching;
    @Nullable
    private final TileProvider tileProvider;
    private final ImmutableList<String> tileSetEncodings;
    @Nullable
    private final TilesConfiguration.TileCacheType cache;
    @Nullable
    private final MapClient.Type mapClientType;
    @Nullable
    private final String style;
    @Nullable
    private final Boolean removeZoomLevelConstraints;
    private final ImmutableList<String> tileEncodings;
    private final transient List<String> tileEncodingsDerived;
    private final ImmutableList<Double> center;
    private final transient List<Double> centerDerived;
    private final ImmutableMap<String, MinMax> zoomLevels;
    private final transient Map<String, MinMax> zoomLevelsDerived;
    private final transient Set<String> tileMatrixSets;
    @Nullable
    private final Boolean singleCollectionEnabled;
    private final transient boolean isSingleCollectionEnabled;
    @Nullable
    private final Boolean multiCollectionEnabled;
    private final transient boolean isMultiCollectionEnabled;
    private final ImmutableMap<String, MinMax> zoomLevelsCache;
    private final transient Map<String, MinMax> zoomLevelsCacheDerived;
    private final ImmutableMap<String, MinMax> seeding;
    private final transient Map<String, MinMax> seedingDerived;
    private final transient Optional<SeedingOptions> seedingOptions;
    @Nullable
    private final Integer limit;
    @Nullable
    private final transient Integer limitDerived;
    @Nullable
    private final Boolean ignoreInvalidGeometries;
    private final transient boolean isIgnoreInvalidGeometriesDerived;
    private final ImmutableMap<String, List<PredefinedFilter>> filters;
    private final transient Map<String, List<PredefinedFilter>> filtersDerived;
    private final ImmutableMap<String, List<Rule>> rules;
    private final transient Map<String, List<Rule>> rulesDerived;
    @Nullable
    private final Double maxRelativeAreaChangeInPolygonRepair;
    @Nullable
    private final Double maxAbsoluteAreaChangeInPolygonRepair;
    @Nullable
    private final Double minimumSizeInPixel;
    private final transient double minimumSizeInPixelDerived;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long EFFECTIVE_SEEDING_LAZY_INIT_BIT = 1L;
    private transient Map<String, MinMax> effectiveSeeding;

    private ImmutableTilesConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, ImmutableMap<String, List<PropertyTransformation>> transformations, @Nullable ImmutableCaching caching, @Nullable TileProvider tileProvider, ImmutableList<String> tileSetEncodings, @Nullable TilesConfiguration.TileCacheType cache, @Nullable MapClient.Type mapClientType, @Nullable String style, @Nullable Boolean removeZoomLevelConstraints, ImmutableList<String> tileEncodings, ImmutableList<Double> center, ImmutableMap<String, MinMax> zoomLevels, @Nullable Boolean singleCollectionEnabled, @Nullable Boolean multiCollectionEnabled, ImmutableMap<String, MinMax> zoomLevelsCache, ImmutableMap<String, MinMax> seeding, @Nullable Integer limit, @Nullable Boolean ignoreInvalidGeometries, ImmutableMap<String, List<PredefinedFilter>> filters, ImmutableMap<String, List<Rule>> rules, @Nullable Double maxRelativeAreaChangeInPolygonRepair, @Nullable Double maxAbsoluteAreaChangeInPolygonRepair, @Nullable Double minimumSizeInPixel) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.transformations = transformations;
        this.caching = caching;
        this.tileProvider = tileProvider;
        this.tileSetEncodings = tileSetEncodings;
        this.cache = cache;
        this.mapClientType = mapClientType;
        this.style = style;
        this.removeZoomLevelConstraints = removeZoomLevelConstraints;
        this.tileEncodings = tileEncodings;
        this.center = center;
        this.zoomLevels = zoomLevels;
        this.singleCollectionEnabled = singleCollectionEnabled;
        this.multiCollectionEnabled = multiCollectionEnabled;
        this.zoomLevelsCache = zoomLevelsCache;
        this.seeding = seeding;
        this.limit = limit;
        this.ignoreInvalidGeometries = ignoreInvalidGeometries;
        this.filters = filters;
        this.rules = rules;
        this.maxRelativeAreaChangeInPolygonRepair = maxRelativeAreaChangeInPolygonRepair;
        this.maxAbsoluteAreaChangeInPolygonRepair = maxAbsoluteAreaChangeInPolygonRepair;
        this.minimumSizeInPixel = minimumSizeInPixel;
        this.isEnabled = this.initShim.isEnabled();
        this.hasDeprecatedTransformationKeys = this.initShim.hasDeprecatedTransformationKeys();
        this.tileEncodingsDerived = this.initShim.getTileEncodingsDerived();
        this.centerDerived = this.initShim.getCenterDerived();
        this.zoomLevelsDerived = this.initShim.getZoomLevelsDerived();
        this.tileMatrixSets = this.initShim.getTileMatrixSets();
        this.isSingleCollectionEnabled = this.initShim.isSingleCollectionEnabled();
        this.isMultiCollectionEnabled = this.initShim.isMultiCollectionEnabled();
        this.zoomLevelsCacheDerived = this.initShim.getZoomLevelsCacheDerived();
        this.seedingDerived = this.initShim.getSeedingDerived();
        this.seedingOptions = this.initShim.getSeedingOptions();
        this.limitDerived = this.initShim.getLimitDerived();
        this.isIgnoreInvalidGeometriesDerived = this.initShim.isIgnoreInvalidGeometriesDerived();
        this.filtersDerived = this.initShim.getFiltersDerived();
        this.rulesDerived = this.initShim.getRulesDerived();
        this.minimumSizeInPixelDerived = this.initShim.getMinimumSizeInPixelDerived();
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return TilesConfiguration.super.isEnabled();
    }

    private boolean hasDeprecatedTransformationKeysInitialize() {
        return TilesConfiguration.super.hasDeprecatedTransformationKeys();
    }

    private List<String> getTileEncodingsDerivedInitialize() {
        return TilesConfiguration.super.getTileEncodingsDerived();
    }

    private List<Double> getCenterDerivedInitialize() {
        return TilesConfiguration.super.getCenterDerived();
    }

    private Map<String, MinMax> getZoomLevelsDerivedInitialize() {
        return TilesConfiguration.super.getZoomLevelsDerived();
    }

    private Set<String> getTileMatrixSetsInitialize() {
        return TilesConfiguration.super.getTileMatrixSets();
    }

    private boolean isSingleCollectionEnabledInitialize() {
        return TilesConfiguration.super.isSingleCollectionEnabled();
    }

    private boolean isMultiCollectionEnabledInitialize() {
        return TilesConfiguration.super.isMultiCollectionEnabled();
    }

    private Map<String, MinMax> getZoomLevelsCacheDerivedInitialize() {
        return TilesConfiguration.super.getZoomLevelsCacheDerived();
    }

    private Map<String, MinMax> getSeedingDerivedInitialize() {
        return TilesConfiguration.super.getSeedingDerived();
    }

    private Optional<SeedingOptions> getSeedingOptionsInitialize() {
        return TilesConfiguration.super.getSeedingOptions();
    }

    @Nullable
    private Integer getLimitDerivedInitialize() {
        return TilesConfiguration.super.getLimitDerived();
    }

    private boolean isIgnoreInvalidGeometriesDerivedInitialize() {
        return TilesConfiguration.super.isIgnoreInvalidGeometriesDerived();
    }

    private Map<String, List<PredefinedFilter>> getFiltersDerivedInitialize() {
        return TilesConfiguration.super.getFiltersDerived();
    }

    private Map<String, List<Rule>> getRulesDerivedInitialize() {
        return TilesConfiguration.super.getRulesDerived();
    }

    private double getMinimumSizeInPixelDerivedInitialize() {
        return TilesConfiguration.super.getMinimumSizeInPixelDerived();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @JsonProperty(value="transformations")
    public ImmutableMap<String, List<PropertyTransformation>> getTransformations() {
        return this.transformations;
    }

    @Override
    @JsonProperty(value="hasDeprecatedTransformationKeys")
    @JsonIgnore
    public boolean hasDeprecatedTransformationKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasDeprecatedTransformationKeys() : this.hasDeprecatedTransformationKeys;
    }

    @Override
    @JsonProperty(value="caching")
    @Nullable
    public ImmutableCaching getCaching() {
        return this.caching;
    }

    @Override
    @JsonProperty(value="tileProvider")
    @Nullable
    public TileProvider getTileProvider() {
        return this.tileProvider;
    }

    @JsonProperty(value="tileSetEncodings")
    public ImmutableList<String> getTileSetEncodings() {
        return this.tileSetEncodings;
    }

    @Override
    @JsonProperty(value="cache")
    @Nullable
    public TilesConfiguration.TileCacheType getCache() {
        return this.cache;
    }

    @Override
    @JsonProperty(value="mapClientType")
    @Nullable
    public MapClient.Type getMapClientType() {
        return this.mapClientType;
    }

    @Override
    @JsonProperty(value="style")
    @Nullable
    public String getStyle() {
        return this.style;
    }

    @Override
    @JsonProperty(value="removeZoomLevelConstraints")
    @Nullable
    public Boolean getRemoveZoomLevelConstraints() {
        return this.removeZoomLevelConstraints;
    }

    @JsonProperty(value="tileEncodings")
    @Deprecated
    public ImmutableList<String> getTileEncodings() {
        return this.tileEncodings;
    }

    @Override
    @JsonProperty(value="tileEncodingsDerived")
    @JsonIgnore
    public List<String> getTileEncodingsDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTileEncodingsDerived() : this.tileEncodingsDerived;
    }

    @JsonProperty(value="center")
    @Deprecated
    public ImmutableList<Double> getCenter() {
        return this.center;
    }

    @Override
    @JsonProperty(value="centerDerived")
    @JsonIgnore
    public List<Double> getCenterDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCenterDerived() : this.centerDerived;
    }

    @JsonProperty(value="zoomLevels")
    @Deprecated
    public ImmutableMap<String, MinMax> getZoomLevels() {
        return this.zoomLevels;
    }

    @Override
    @JsonProperty(value="zoomLevelsDerived")
    @JsonIgnore
    public Map<String, MinMax> getZoomLevelsDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getZoomLevelsDerived() : this.zoomLevelsDerived;
    }

    @Override
    @JsonProperty(value="tileMatrixSets")
    @JsonIgnore
    public Set<String> getTileMatrixSets() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTileMatrixSets() : this.tileMatrixSets;
    }

    @Override
    @JsonProperty(value="singleCollectionEnabled")
    @Deprecated
    @Nullable
    public Boolean getSingleCollectionEnabled() {
        return this.singleCollectionEnabled;
    }

    @Override
    @JsonProperty(value="isSingleCollectionEnabled")
    @JsonIgnore
    public boolean isSingleCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSingleCollectionEnabled() : this.isSingleCollectionEnabled;
    }

    @Override
    @JsonProperty(value="multiCollectionEnabled")
    @Deprecated
    @Nullable
    public Boolean getMultiCollectionEnabled() {
        return this.multiCollectionEnabled;
    }

    @Override
    @JsonProperty(value="isMultiCollectionEnabled")
    @JsonIgnore
    public boolean isMultiCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isMultiCollectionEnabled() : this.isMultiCollectionEnabled;
    }

    @JsonProperty(value="zoomLevelsCache")
    @Deprecated
    public ImmutableMap<String, MinMax> getZoomLevelsCache() {
        return this.zoomLevelsCache;
    }

    @Override
    @JsonProperty(value="zoomLevelsCacheDerived")
    @JsonIgnore
    public Map<String, MinMax> getZoomLevelsCacheDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getZoomLevelsCacheDerived() : this.zoomLevelsCacheDerived;
    }

    @JsonProperty(value="seeding")
    @Deprecated
    public ImmutableMap<String, MinMax> getSeeding() {
        return this.seeding;
    }

    @Override
    @JsonProperty(value="seedingDerived")
    @JsonIgnore
    public Map<String, MinMax> getSeedingDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSeedingDerived() : this.seedingDerived;
    }

    @Override
    @JsonProperty(value="seedingOptions")
    @JsonIgnore
    public Optional<SeedingOptions> getSeedingOptions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSeedingOptions() : this.seedingOptions;
    }

    @Override
    @JsonProperty(value="limit")
    @Deprecated
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    @JsonProperty(value="limitDerived")
    @JsonIgnore
    @Nullable
    public Integer getLimitDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLimitDerived() : this.limitDerived;
    }

    @Override
    @JsonProperty(value="ignoreInvalidGeometries")
    @Deprecated
    @Nullable
    public Boolean getIgnoreInvalidGeometries() {
        return this.ignoreInvalidGeometries;
    }

    @Override
    @JsonProperty(value="isIgnoreInvalidGeometriesDerived")
    @JsonIgnore
    public boolean isIgnoreInvalidGeometriesDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isIgnoreInvalidGeometriesDerived() : this.isIgnoreInvalidGeometriesDerived;
    }

    @JsonProperty(value="filters")
    @Deprecated
    public ImmutableMap<String, List<PredefinedFilter>> getFilters() {
        return this.filters;
    }

    @Override
    @JsonProperty(value="filtersDerived")
    @JsonIgnore
    public Map<String, List<PredefinedFilter>> getFiltersDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFiltersDerived() : this.filtersDerived;
    }

    @JsonProperty(value="rules")
    @Deprecated
    public ImmutableMap<String, List<Rule>> getRules() {
        return this.rules;
    }

    @Override
    @JsonProperty(value="rulesDerived")
    @JsonIgnore
    public Map<String, List<Rule>> getRulesDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRulesDerived() : this.rulesDerived;
    }

    @Override
    @JsonProperty(value="maxRelativeAreaChangeInPolygonRepair")
    @Deprecated
    public Optional<Double> getMaxRelativeAreaChangeInPolygonRepair() {
        return Optional.ofNullable(this.maxRelativeAreaChangeInPolygonRepair);
    }

    @Override
    @JsonProperty(value="maxAbsoluteAreaChangeInPolygonRepair")
    @Deprecated
    public Optional<Double> getMaxAbsoluteAreaChangeInPolygonRepair() {
        return Optional.ofNullable(this.maxAbsoluteAreaChangeInPolygonRepair);
    }

    @Override
    @JsonProperty(value="minimumSizeInPixel")
    @Deprecated
    @Nullable
    public Double getMinimumSizeInPixel() {
        return this.minimumSizeInPixel;
    }

    @Override
    @JsonProperty(value="minimumSizeInPixelDerived")
    @JsonIgnore
    public double getMinimumSizeInPixelDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinimumSizeInPixelDerived() : this.minimumSizeInPixelDerived;
    }

    public final ImmutableTilesConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(value, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, newValue, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, value, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withTransformations(Map<String, ? extends List<PropertyTransformation>> entries) {
        if (this.transformations == entries) {
            return this;
        }
        ImmutableMap<String, List<PropertyTransformation>> newValue = ImmutableMap.copyOf(entries);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, newValue, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withCaching(@Nullable Caching value) {
        if (this.caching == value) {
            return this;
        }
        ImmutableCaching newValue = value == null ? null : ImmutableCaching.copyOf(value);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, newValue, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withTileProvider(@Nullable TileProvider value) {
        if (this.tileProvider == value) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, value, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withTileSetEncodings(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, newValue, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withTileSetEncodings(Iterable<String> elements) {
        if (this.tileSetEncodings == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, newValue, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withCache(@Nullable TilesConfiguration.TileCacheType value) {
        if (this.cache == value) {
            return this;
        }
        if (Objects.equals((Object)this.cache, (Object)value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, value, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withMapClientType(@Nullable MapClient.Type value) {
        if (this.mapClientType == value) {
            return this;
        }
        if (Objects.equals((Object)this.mapClientType, (Object)value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, value, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withStyle(@Nullable String value) {
        if (Objects.equals(this.style, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, value, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    public final ImmutableTilesConfiguration withRemoveZoomLevelConstraints(@Nullable Boolean value) {
        if (Objects.equals(this.removeZoomLevelConstraints, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, value, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withTileEncodings(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, newValue, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withTileEncodings(Iterable<String> elements) {
        if (this.tileEncodings == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, newValue, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withCenter(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, newValue, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withCenter(Iterable<Double> elements) {
        if (this.center == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, newValue, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withZoomLevels(Map<String, ? extends MinMax> entries) {
        if (this.zoomLevels == entries) {
            return this;
        }
        ImmutableMap<String, MinMax> newValue = ImmutableMap.copyOf(entries);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, newValue, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withSingleCollectionEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.singleCollectionEnabled, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, value, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withMultiCollectionEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.multiCollectionEnabled, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, value, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withZoomLevelsCache(Map<String, ? extends MinMax> entries) {
        if (this.zoomLevelsCache == entries) {
            return this;
        }
        ImmutableMap<String, MinMax> newValue = ImmutableMap.copyOf(entries);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, newValue, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withSeeding(Map<String, ? extends MinMax> entries) {
        if (this.seeding == entries) {
            return this;
        }
        ImmutableMap<String, MinMax> newValue = ImmutableMap.copyOf(entries);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, newValue, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withLimit(@Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, value, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withIgnoreInvalidGeometries(@Nullable Boolean value) {
        if (Objects.equals(this.ignoreInvalidGeometries, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, value, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withFilters(Map<String, ? extends List<PredefinedFilter>> entries) {
        if (this.filters == entries) {
            return this;
        }
        ImmutableMap<String, List<PredefinedFilter>> newValue = ImmutableMap.copyOf(entries);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, newValue, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withRules(Map<String, ? extends List<Rule>> entries) {
        if (this.rules == entries) {
            return this;
        }
        ImmutableMap<String, List<Rule>> newValue = ImmutableMap.copyOf(entries);
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, newValue, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withMaxRelativeAreaChangeInPolygonRepair(double value) {
        Double newValue = value;
        if (Objects.equals(this.maxRelativeAreaChangeInPolygonRepair, newValue)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, newValue, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withMaxRelativeAreaChangeInPolygonRepair(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.maxRelativeAreaChangeInPolygonRepair, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, value, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withMaxAbsoluteAreaChangeInPolygonRepair(double value) {
        Double newValue = value;
        if (Objects.equals(this.maxAbsoluteAreaChangeInPolygonRepair, newValue)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, newValue, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withMaxAbsoluteAreaChangeInPolygonRepair(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.maxAbsoluteAreaChangeInPolygonRepair, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, value, this.minimumSizeInPixel));
    }

    @Deprecated
    public final ImmutableTilesConfiguration withMinimumSizeInPixel(@Nullable Double value) {
        if (Objects.equals(this.minimumSizeInPixel, value)) {
            return this;
        }
        return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations, this.caching, this.tileProvider, this.tileSetEncodings, this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, this.tileEncodings, this.center, this.zoomLevels, this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache, this.seeding, this.limit, this.ignoreInvalidGeometries, this.filters, this.rules, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTilesConfiguration && this.equalTo((ImmutableTilesConfiguration)another);
    }

    private boolean equalTo(ImmutableTilesConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && this.transformations.equals(another.transformations) && Objects.equals(this.caching, another.caching) && Objects.equals(this.tileProvider, another.tileProvider) && this.tileSetEncodings.equals(another.tileSetEncodings) && Objects.equals((Object)this.cache, (Object)another.cache) && Objects.equals((Object)this.mapClientType, (Object)another.mapClientType) && Objects.equals(this.style, another.style) && Objects.equals(this.removeZoomLevelConstraints, another.removeZoomLevelConstraints) && this.tileEncodings.equals(another.tileEncodings) && this.center.equals(another.center) && this.zoomLevels.equals(another.zoomLevels) && Objects.equals(this.singleCollectionEnabled, another.singleCollectionEnabled) && Objects.equals(this.multiCollectionEnabled, another.multiCollectionEnabled) && this.zoomLevelsCache.equals(another.zoomLevelsCache) && this.seeding.equals(another.seeding) && Objects.equals(this.limit, another.limit) && Objects.equals(this.ignoreInvalidGeometries, another.ignoreInvalidGeometries) && this.filters.equals(another.filters) && this.rules.equals(another.rules) && Objects.equals(this.maxRelativeAreaChangeInPolygonRepair, another.maxRelativeAreaChangeInPolygonRepair) && Objects.equals(this.maxAbsoluteAreaChangeInPolygonRepair, another.maxAbsoluteAreaChangeInPolygonRepair) && Objects.equals(this.minimumSizeInPixel, another.minimumSizeInPixel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + this.transformations.hashCode();
        h += (h << 5) + Objects.hashCode(this.caching);
        h += (h << 5) + Objects.hashCode(this.tileProvider);
        h += (h << 5) + this.tileSetEncodings.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.cache);
        h += (h << 5) + Objects.hashCode((Object)this.mapClientType);
        h += (h << 5) + Objects.hashCode(this.style);
        h += (h << 5) + Objects.hashCode(this.removeZoomLevelConstraints);
        h += (h << 5) + this.tileEncodings.hashCode();
        h += (h << 5) + this.center.hashCode();
        h += (h << 5) + this.zoomLevels.hashCode();
        h += (h << 5) + Objects.hashCode(this.singleCollectionEnabled);
        h += (h << 5) + Objects.hashCode(this.multiCollectionEnabled);
        h += (h << 5) + this.zoomLevelsCache.hashCode();
        h += (h << 5) + this.seeding.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.ignoreInvalidGeometries);
        h += (h << 5) + this.filters.hashCode();
        h += (h << 5) + this.rules.hashCode();
        h += (h << 5) + Objects.hashCode(this.maxRelativeAreaChangeInPolygonRepair);
        h += (h << 5) + Objects.hashCode(this.maxAbsoluteAreaChangeInPolygonRepair);
        h += (h << 5) + Objects.hashCode(this.minimumSizeInPixel);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TilesConfiguration").omitNullValues().add("enabled", this.enabled).add("transformations", this.transformations).add("caching", this.caching).add("tileProvider", this.tileProvider).add("tileSetEncodings", this.tileSetEncodings).add("cache", (Object)this.cache).add("mapClientType", (Object)this.mapClientType).add("style", this.style).add("removeZoomLevelConstraints", this.removeZoomLevelConstraints).add("tileEncodings", this.tileEncodings).add("center", this.center).add("zoomLevels", this.zoomLevels).add("singleCollectionEnabled", this.singleCollectionEnabled).add("multiCollectionEnabled", this.multiCollectionEnabled).add("zoomLevelsCache", this.zoomLevelsCache).add("seeding", this.seeding).add("limit", this.limit).add("ignoreInvalidGeometries", this.ignoreInvalidGeometries).add("filters", this.filters).add("rules", this.rules).add("maxRelativeAreaChangeInPolygonRepair", this.maxRelativeAreaChangeInPolygonRepair).add("maxAbsoluteAreaChangeInPolygonRepair", this.maxAbsoluteAreaChangeInPolygonRepair).add("minimumSizeInPixel", this.minimumSizeInPixel).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MinMax> getEffectiveSeeding() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableTilesConfiguration immutableTilesConfiguration = this;
            synchronized (immutableTilesConfiguration) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.effectiveSeeding = Objects.requireNonNull(TilesConfiguration.super.getEffectiveSeeding(), "effectiveSeeding");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.effectiveSeeding;
    }

    private static ImmutableTilesConfiguration validate(ImmutableTilesConfiguration instance) {
        instance = (ImmutableTilesConfiguration)instance.alwaysFlatten();
        return instance;
    }

    public static ImmutableTilesConfiguration copyOf(TilesConfiguration instance) {
        if (instance instanceof ImmutableTilesConfiguration) {
            return (ImmutableTilesConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="TilesConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends TilesConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        private ImmutableMap.Builder<String, List<PropertyTransformation>> transformations = ImmutableMap.builder();
        @Nullable
        private Caching caching;
        @Nullable
        private TileProvider tileProvider;
        private ImmutableList.Builder<String> tileSetEncodings = ImmutableList.builder();
        @Nullable
        private TilesConfiguration.TileCacheType cache;
        @Nullable
        private MapClient.Type mapClientType;
        @Nullable
        private String style;
        @Nullable
        private Boolean removeZoomLevelConstraints;
        private ImmutableList.Builder<String> tileEncodings = ImmutableList.builder();
        private ImmutableList.Builder<Double> center = ImmutableList.builder();
        private ImmutableMap.Builder<String, MinMax> zoomLevels = ImmutableMap.builder();
        @Nullable
        private Boolean singleCollectionEnabled;
        @Nullable
        private Boolean multiCollectionEnabled;
        private ImmutableMap.Builder<String, MinMax> zoomLevelsCache = ImmutableMap.builder();
        private ImmutableMap.Builder<String, MinMax> seeding = ImmutableMap.builder();
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean ignoreInvalidGeometries;
        private ImmutableMap.Builder<String, List<PredefinedFilter>> filters = ImmutableMap.builder();
        private ImmutableMap.Builder<String, List<Rule>> rules = ImmutableMap.builder();
        @Nullable
        private Double maxRelativeAreaChangeInPolygonRepair;
        @Nullable
        private Double maxAbsoluteAreaChangeInPolygonRepair;
        @Nullable
        private Double minimumSizeInPixel;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CachingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(PropertyTransformations instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(TilesConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Caching cachingValue;
            Object instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof CachingConfiguration && (cachingValue = (instance = (CachingConfiguration)object).getCaching()) != null) {
                this.caching(cachingValue);
            }
            if (object instanceof PropertyTransformations) {
                instance = (PropertyTransformations)object;
                this.putAllTransformations(instance.getTransformations());
            }
            if (object instanceof TilesConfiguration) {
                String styleValue;
                TileProvider tileProviderValue;
                Boolean multiCollectionEnabledValue;
                Boolean removeZoomLevelConstraintsValue;
                Double minimumSizeInPixelValue;
                Boolean singleCollectionEnabledValue;
                TilesConfiguration.TileCacheType cacheValue;
                instance = (TilesConfiguration)object;
                this.addAllTileSetEncodings(instance.getTileSetEncodings());
                Boolean ignoreInvalidGeometriesValue = instance.getIgnoreInvalidGeometries();
                if (ignoreInvalidGeometriesValue != null) {
                    this.ignoreInvalidGeometries(ignoreInvalidGeometriesValue);
                }
                if ((cacheValue = instance.getCache()) != null) {
                    this.cache(cacheValue);
                }
                if ((singleCollectionEnabledValue = instance.getSingleCollectionEnabled()) != null) {
                    this.singleCollectionEnabled(singleCollectionEnabledValue);
                }
                if ((minimumSizeInPixelValue = instance.getMinimumSizeInPixel()) != null) {
                    this.minimumSizeInPixel(minimumSizeInPixelValue);
                }
                this.addAllCenter(instance.getCenter());
                this.putAllZoomLevelsCache(instance.getZoomLevelsCache());
                this.putAllRules(instance.getRules());
                this.putAllFilters(instance.getFilters());
                MapClient.Type mapClientTypeValue = instance.getMapClientType();
                if (mapClientTypeValue != null) {
                    this.mapClientType(mapClientTypeValue);
                }
                this.putAllZoomLevels(instance.getZoomLevels());
                Optional<Double> maxAbsoluteAreaChangeInPolygonRepairOptional = instance.getMaxAbsoluteAreaChangeInPolygonRepair();
                if (maxAbsoluteAreaChangeInPolygonRepairOptional.isPresent()) {
                    this.maxAbsoluteAreaChangeInPolygonRepair(maxAbsoluteAreaChangeInPolygonRepairOptional);
                }
                if ((removeZoomLevelConstraintsValue = instance.getRemoveZoomLevelConstraints()) != null) {
                    this.removeZoomLevelConstraints(removeZoomLevelConstraintsValue);
                }
                if ((multiCollectionEnabledValue = instance.getMultiCollectionEnabled()) != null) {
                    this.multiCollectionEnabled(multiCollectionEnabledValue);
                }
                this.putAllSeeding(instance.getSeeding());
                Integer limitValue = instance.getLimit();
                if (limitValue != null) {
                    this.limit(limitValue);
                }
                if ((tileProviderValue = instance.getTileProvider()) != null) {
                    this.tileProvider(tileProviderValue);
                }
                if ((styleValue = instance.getStyle()) != null) {
                    this.style(styleValue);
                }
                this.addAllTileEncodings(instance.getTileEncodings());
                Optional<Double> maxRelativeAreaChangeInPolygonRepairOptional = instance.getMaxRelativeAreaChangeInPolygonRepair();
                if (maxRelativeAreaChangeInPolygonRepairOptional.isPresent()) {
                    this.maxRelativeAreaChangeInPolygonRepair(maxRelativeAreaChangeInPolygonRepairOptional);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(String key, List<PropertyTransformation> value) {
            this.transformations.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putTransformations(Map.Entry<String, ? extends List<PropertyTransformation>> entry) {
            this.transformations.put(entry);
            return this;
        }

        @JsonProperty(value="transformations")
        @CanIgnoreReturnValue
        public final Builder transformations(Map<String, ? extends List<PropertyTransformation>> entries) {
            this.transformations = ImmutableMap.builder();
            return this.putAllTransformations(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllTransformations(Map<String, ? extends List<PropertyTransformation>> entries) {
            this.transformations.putAll(entries);
            return this;
        }

        @JsonProperty(value="caching")
        @CanIgnoreReturnValue
        public final Builder caching(@Nullable Caching caching) {
            this.caching = caching == null ? null : ImmutableCaching.copyOf(caching);
            return this;
        }

        @JsonProperty(value="tileProvider")
        @CanIgnoreReturnValue
        public final Builder tileProvider(@Nullable TileProvider tileProvider) {
            this.tileProvider = tileProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileSetEncodings(String element) {
            this.tileSetEncodings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileSetEncodings(String ... elements) {
            this.tileSetEncodings.add(elements);
            return this;
        }

        @JsonProperty(value="tileSetEncodings")
        @CanIgnoreReturnValue
        public final Builder tileSetEncodings(Iterable<String> elements) {
            this.tileSetEncodings = ImmutableList.builder();
            return this.addAllTileSetEncodings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTileSetEncodings(Iterable<String> elements) {
            this.tileSetEncodings.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="cache")
        @CanIgnoreReturnValue
        public final Builder cache(@Nullable TilesConfiguration.TileCacheType cache) {
            this.cache = cache;
            return this;
        }

        @JsonProperty(value="mapClientType")
        @CanIgnoreReturnValue
        public final Builder mapClientType(@Nullable MapClient.Type mapClientType) {
            this.mapClientType = mapClientType;
            return this;
        }

        @JsonProperty(value="style")
        @CanIgnoreReturnValue
        public final Builder style(@Nullable String style) {
            this.style = style;
            return this;
        }

        @JsonProperty(value="removeZoomLevelConstraints")
        @CanIgnoreReturnValue
        public final Builder removeZoomLevelConstraints(@Nullable Boolean removeZoomLevelConstraints) {
            this.removeZoomLevelConstraints = removeZoomLevelConstraints;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addTileEncodings(String element) {
            this.tileEncodings.add((Object)element);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addTileEncodings(String ... elements) {
            this.tileEncodings.add(elements);
            return this;
        }

        @JsonProperty(value="tileEncodings")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder tileEncodings(Iterable<String> elements) {
            this.tileEncodings = ImmutableList.builder();
            return this.addAllTileEncodings(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addAllTileEncodings(Iterable<String> elements) {
            this.tileEncodings.addAll((Iterable)elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addCenter(double element) {
            this.center.add((Object)element);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addCenter(double ... elements) {
            this.center.addAll(Doubles.asList(elements));
            return this;
        }

        @JsonProperty(value="center")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder center(Iterable<Double> elements) {
            this.center = ImmutableList.builder();
            return this.addAllCenter(elements);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder addAllCenter(Iterable<Double> elements) {
            this.center.addAll((Iterable)elements);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putZoomLevels(String key, MinMax value) {
            this.zoomLevels.put(key, value);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putZoomLevels(Map.Entry<String, ? extends MinMax> entry) {
            this.zoomLevels.put(entry);
            return this;
        }

        @JsonProperty(value="zoomLevels")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder zoomLevels(Map<String, ? extends MinMax> entries) {
            this.zoomLevels = ImmutableMap.builder();
            return this.putAllZoomLevels(entries);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putAllZoomLevels(Map<String, ? extends MinMax> entries) {
            this.zoomLevels.putAll(entries);
            return this;
        }

        @JsonProperty(value="singleCollectionEnabled")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder singleCollectionEnabled(@Nullable Boolean singleCollectionEnabled) {
            this.singleCollectionEnabled = singleCollectionEnabled;
            return this;
        }

        @JsonProperty(value="multiCollectionEnabled")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder multiCollectionEnabled(@Nullable Boolean multiCollectionEnabled) {
            this.multiCollectionEnabled = multiCollectionEnabled;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putZoomLevelsCache(String key, MinMax value) {
            this.zoomLevelsCache.put(key, value);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putZoomLevelsCache(Map.Entry<String, ? extends MinMax> entry) {
            this.zoomLevelsCache.put(entry);
            return this;
        }

        @JsonProperty(value="zoomLevelsCache")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder zoomLevelsCache(Map<String, ? extends MinMax> entries) {
            this.zoomLevelsCache = ImmutableMap.builder();
            return this.putAllZoomLevelsCache(entries);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putAllZoomLevelsCache(Map<String, ? extends MinMax> entries) {
            this.zoomLevelsCache.putAll(entries);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putSeeding(String key, MinMax value) {
            this.seeding.put(key, value);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putSeeding(Map.Entry<String, ? extends MinMax> entry) {
            this.seeding.put(entry);
            return this;
        }

        @JsonProperty(value="seeding")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder seeding(Map<String, ? extends MinMax> entries) {
            this.seeding = ImmutableMap.builder();
            return this.putAllSeeding(entries);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putAllSeeding(Map<String, ? extends MinMax> entries) {
            this.seeding.putAll(entries);
            return this;
        }

        @JsonProperty(value="limit")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        @JsonProperty(value="ignoreInvalidGeometries")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ignoreInvalidGeometries(@Nullable Boolean ignoreInvalidGeometries) {
            this.ignoreInvalidGeometries = ignoreInvalidGeometries;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putFilters(String key, List<PredefinedFilter> value) {
            this.filters.put(key, value);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putFilters(Map.Entry<String, ? extends List<PredefinedFilter>> entry) {
            this.filters.put(entry);
            return this;
        }

        @JsonProperty(value="filters")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder filters(Map<String, ? extends List<PredefinedFilter>> entries) {
            this.filters = ImmutableMap.builder();
            return this.putAllFilters(entries);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putAllFilters(Map<String, ? extends List<PredefinedFilter>> entries) {
            this.filters.putAll(entries);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putRules(String key, List<Rule> value) {
            this.rules.put(key, value);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putRules(Map.Entry<String, ? extends List<Rule>> entry) {
            this.rules.put(entry);
            return this;
        }

        @JsonProperty(value="rules")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder rules(Map<String, ? extends List<Rule>> entries) {
            this.rules = ImmutableMap.builder();
            return this.putAllRules(entries);
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder putAllRules(Map<String, ? extends List<Rule>> entries) {
            this.rules.putAll(entries);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxRelativeAreaChangeInPolygonRepair(double maxRelativeAreaChangeInPolygonRepair) {
            this.maxRelativeAreaChangeInPolygonRepair = maxRelativeAreaChangeInPolygonRepair;
            return this;
        }

        @JsonProperty(value="maxRelativeAreaChangeInPolygonRepair")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxRelativeAreaChangeInPolygonRepair(Optional<Double> maxRelativeAreaChangeInPolygonRepair) {
            this.maxRelativeAreaChangeInPolygonRepair = maxRelativeAreaChangeInPolygonRepair.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxAbsoluteAreaChangeInPolygonRepair(double maxAbsoluteAreaChangeInPolygonRepair) {
            this.maxAbsoluteAreaChangeInPolygonRepair = maxAbsoluteAreaChangeInPolygonRepair;
            return this;
        }

        @JsonProperty(value="maxAbsoluteAreaChangeInPolygonRepair")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxAbsoluteAreaChangeInPolygonRepair(Optional<Double> maxAbsoluteAreaChangeInPolygonRepair) {
            this.maxAbsoluteAreaChangeInPolygonRepair = maxAbsoluteAreaChangeInPolygonRepair.orElse(null);
            return this;
        }

        @JsonProperty(value="minimumSizeInPixel")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder minimumSizeInPixel(@Nullable Double minimumSizeInPixel) {
            this.minimumSizeInPixel = minimumSizeInPixel;
            return this;
        }

        @Override
        public ImmutableTilesConfiguration build() {
            return ImmutableTilesConfiguration.validate(new ImmutableTilesConfiguration(this.enabled, this.defaultValues, this.transformations.build(), this.caching == null ? null : ImmutableCaching.copyOf(this.caching), this.tileProvider, (ImmutableList<String>)this.tileSetEncodings.build(), this.cache, this.mapClientType, this.style, this.removeZoomLevelConstraints, (ImmutableList<String>)this.tileEncodings.build(), (ImmutableList<Double>)this.center.build(), this.zoomLevels.build(), this.singleCollectionEnabled, this.multiCollectionEnabled, this.zoomLevelsCache.build(), this.seeding.build(), this.limit, this.ignoreInvalidGeometries, this.filters.build(), this.rules.build(), this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel));
        }
    }

    @Generated(from="TilesConfiguration", generator="Immutables")
    private final class InitShim {
        private byte isEnabledBuildStage = 0;
        private boolean isEnabled;
        private byte hasDeprecatedTransformationKeysBuildStage = 0;
        private boolean hasDeprecatedTransformationKeys;
        private byte tileEncodingsDerivedBuildStage = 0;
        private List<String> tileEncodingsDerived;
        private byte centerDerivedBuildStage = 0;
        private List<Double> centerDerived;
        private byte zoomLevelsDerivedBuildStage = 0;
        private Map<String, MinMax> zoomLevelsDerived;
        private byte tileMatrixSetsBuildStage = 0;
        private Set<String> tileMatrixSets;
        private byte isSingleCollectionEnabledBuildStage = 0;
        private boolean isSingleCollectionEnabled;
        private byte isMultiCollectionEnabledBuildStage = 0;
        private boolean isMultiCollectionEnabled;
        private byte zoomLevelsCacheDerivedBuildStage = 0;
        private Map<String, MinMax> zoomLevelsCacheDerived;
        private byte seedingDerivedBuildStage = 0;
        private Map<String, MinMax> seedingDerived;
        private byte seedingOptionsBuildStage = 0;
        private Optional<SeedingOptions> seedingOptions;
        private byte limitDerivedBuildStage = 0;
        private Integer limitDerived;
        private byte isIgnoreInvalidGeometriesDerivedBuildStage = 0;
        private boolean isIgnoreInvalidGeometriesDerived;
        private byte filtersDerivedBuildStage = 0;
        private Map<String, List<PredefinedFilter>> filtersDerived;
        private byte rulesDerivedBuildStage = 0;
        private Map<String, List<Rule>> rulesDerived;
        private byte minimumSizeInPixelDerivedBuildStage = 0;
        private double minimumSizeInPixelDerived;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.isEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEnabledBuildStage == 0) {
                this.isEnabledBuildStage = (byte)-1;
                this.isEnabled = ImmutableTilesConfiguration.this.isEnabledInitialize();
                this.isEnabledBuildStage = 1;
            }
            return this.isEnabled;
        }

        boolean hasDeprecatedTransformationKeys() {
            if (this.hasDeprecatedTransformationKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasDeprecatedTransformationKeysBuildStage == 0) {
                this.hasDeprecatedTransformationKeysBuildStage = (byte)-1;
                this.hasDeprecatedTransformationKeys = ImmutableTilesConfiguration.this.hasDeprecatedTransformationKeysInitialize();
                this.hasDeprecatedTransformationKeysBuildStage = 1;
            }
            return this.hasDeprecatedTransformationKeys;
        }

        List<String> getTileEncodingsDerived() {
            if (this.tileEncodingsDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tileEncodingsDerivedBuildStage == 0) {
                this.tileEncodingsDerivedBuildStage = (byte)-1;
                this.tileEncodingsDerived = Objects.requireNonNull(ImmutableTilesConfiguration.this.getTileEncodingsDerivedInitialize(), "tileEncodingsDerived");
                this.tileEncodingsDerivedBuildStage = 1;
            }
            return this.tileEncodingsDerived;
        }

        List<Double> getCenterDerived() {
            if (this.centerDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.centerDerivedBuildStage == 0) {
                this.centerDerivedBuildStage = (byte)-1;
                this.centerDerived = Objects.requireNonNull(ImmutableTilesConfiguration.this.getCenterDerivedInitialize(), "centerDerived");
                this.centerDerivedBuildStage = 1;
            }
            return this.centerDerived;
        }

        Map<String, MinMax> getZoomLevelsDerived() {
            if (this.zoomLevelsDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.zoomLevelsDerivedBuildStage == 0) {
                this.zoomLevelsDerivedBuildStage = (byte)-1;
                this.zoomLevelsDerived = Objects.requireNonNull(ImmutableTilesConfiguration.this.getZoomLevelsDerivedInitialize(), "zoomLevelsDerived");
                this.zoomLevelsDerivedBuildStage = 1;
            }
            return this.zoomLevelsDerived;
        }

        Set<String> getTileMatrixSets() {
            if (this.tileMatrixSetsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tileMatrixSetsBuildStage == 0) {
                this.tileMatrixSetsBuildStage = (byte)-1;
                this.tileMatrixSets = Objects.requireNonNull(ImmutableTilesConfiguration.this.getTileMatrixSetsInitialize(), "tileMatrixSets");
                this.tileMatrixSetsBuildStage = 1;
            }
            return this.tileMatrixSets;
        }

        boolean isSingleCollectionEnabled() {
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSingleCollectionEnabledBuildStage == 0) {
                this.isSingleCollectionEnabledBuildStage = (byte)-1;
                this.isSingleCollectionEnabled = ImmutableTilesConfiguration.this.isSingleCollectionEnabledInitialize();
                this.isSingleCollectionEnabledBuildStage = 1;
            }
            return this.isSingleCollectionEnabled;
        }

        boolean isMultiCollectionEnabled() {
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isMultiCollectionEnabledBuildStage == 0) {
                this.isMultiCollectionEnabledBuildStage = (byte)-1;
                this.isMultiCollectionEnabled = ImmutableTilesConfiguration.this.isMultiCollectionEnabledInitialize();
                this.isMultiCollectionEnabledBuildStage = 1;
            }
            return this.isMultiCollectionEnabled;
        }

        Map<String, MinMax> getZoomLevelsCacheDerived() {
            if (this.zoomLevelsCacheDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.zoomLevelsCacheDerivedBuildStage == 0) {
                this.zoomLevelsCacheDerivedBuildStage = (byte)-1;
                this.zoomLevelsCacheDerived = Objects.requireNonNull(ImmutableTilesConfiguration.this.getZoomLevelsCacheDerivedInitialize(), "zoomLevelsCacheDerived");
                this.zoomLevelsCacheDerivedBuildStage = 1;
            }
            return this.zoomLevelsCacheDerived;
        }

        Map<String, MinMax> getSeedingDerived() {
            if (this.seedingDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedingDerivedBuildStage == 0) {
                this.seedingDerivedBuildStage = (byte)-1;
                this.seedingDerived = Objects.requireNonNull(ImmutableTilesConfiguration.this.getSeedingDerivedInitialize(), "seedingDerived");
                this.seedingDerivedBuildStage = 1;
            }
            return this.seedingDerived;
        }

        Optional<SeedingOptions> getSeedingOptions() {
            if (this.seedingOptionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedingOptionsBuildStage == 0) {
                this.seedingOptionsBuildStage = (byte)-1;
                this.seedingOptions = Objects.requireNonNull(ImmutableTilesConfiguration.this.getSeedingOptionsInitialize(), "seedingOptions");
                this.seedingOptionsBuildStage = 1;
            }
            return this.seedingOptions;
        }

        Integer getLimitDerived() {
            if (this.limitDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.limitDerivedBuildStage == 0) {
                this.limitDerivedBuildStage = (byte)-1;
                this.limitDerived = ImmutableTilesConfiguration.this.getLimitDerivedInitialize();
                this.limitDerivedBuildStage = 1;
            }
            return this.limitDerived;
        }

        boolean isIgnoreInvalidGeometriesDerived() {
            if (this.isIgnoreInvalidGeometriesDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isIgnoreInvalidGeometriesDerivedBuildStage == 0) {
                this.isIgnoreInvalidGeometriesDerivedBuildStage = (byte)-1;
                this.isIgnoreInvalidGeometriesDerived = ImmutableTilesConfiguration.this.isIgnoreInvalidGeometriesDerivedInitialize();
                this.isIgnoreInvalidGeometriesDerivedBuildStage = 1;
            }
            return this.isIgnoreInvalidGeometriesDerived;
        }

        Map<String, List<PredefinedFilter>> getFiltersDerived() {
            if (this.filtersDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filtersDerivedBuildStage == 0) {
                this.filtersDerivedBuildStage = (byte)-1;
                this.filtersDerived = Objects.requireNonNull(ImmutableTilesConfiguration.this.getFiltersDerivedInitialize(), "filtersDerived");
                this.filtersDerivedBuildStage = 1;
            }
            return this.filtersDerived;
        }

        Map<String, List<Rule>> getRulesDerived() {
            if (this.rulesDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rulesDerivedBuildStage == 0) {
                this.rulesDerivedBuildStage = (byte)-1;
                this.rulesDerived = Objects.requireNonNull(ImmutableTilesConfiguration.this.getRulesDerivedInitialize(), "rulesDerived");
                this.rulesDerivedBuildStage = 1;
            }
            return this.rulesDerived;
        }

        double getMinimumSizeInPixelDerived() {
            if (this.minimumSizeInPixelDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minimumSizeInPixelDerivedBuildStage == 0) {
                this.minimumSizeInPixelDerivedBuildStage = (byte)-1;
                this.minimumSizeInPixelDerived = ImmutableTilesConfiguration.this.getMinimumSizeInPixelDerivedInitialize();
                this.minimumSizeInPixelDerivedBuildStage = 1;
            }
            return this.minimumSizeInPixelDerived;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isEnabledBuildStage == -1) {
                attributes.add("isEnabled");
            }
            if (this.hasDeprecatedTransformationKeysBuildStage == -1) {
                attributes.add("hasDeprecatedTransformationKeys");
            }
            if (this.tileEncodingsDerivedBuildStage == -1) {
                attributes.add("tileEncodingsDerived");
            }
            if (this.centerDerivedBuildStage == -1) {
                attributes.add("centerDerived");
            }
            if (this.zoomLevelsDerivedBuildStage == -1) {
                attributes.add("zoomLevelsDerived");
            }
            if (this.tileMatrixSetsBuildStage == -1) {
                attributes.add("tileMatrixSets");
            }
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                attributes.add("isSingleCollectionEnabled");
            }
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                attributes.add("isMultiCollectionEnabled");
            }
            if (this.zoomLevelsCacheDerivedBuildStage == -1) {
                attributes.add("zoomLevelsCacheDerived");
            }
            if (this.seedingDerivedBuildStage == -1) {
                attributes.add("seedingDerived");
            }
            if (this.seedingOptionsBuildStage == -1) {
                attributes.add("seedingOptions");
            }
            if (this.limitDerivedBuildStage == -1) {
                attributes.add("limitDerived");
            }
            if (this.isIgnoreInvalidGeometriesDerivedBuildStage == -1) {
                attributes.add("isIgnoreInvalidGeometriesDerived");
            }
            if (this.filtersDerivedBuildStage == -1) {
                attributes.add("filtersDerived");
            }
            if (this.rulesDerivedBuildStage == -1) {
                attributes.add("rulesDerived");
            }
            if (this.minimumSizeInPixelDerivedBuildStage == -1) {
                attributes.add("minimumSizeInPixelDerived");
            }
            return "Cannot build TilesConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

