/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.foundation.domain.ImmutableLink;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.foundation.domain.Metadata2;
import de.ii.ogcapi.foundation.domain.MetadataDates;
import de.ii.ogcapi.foundation.domain.PageRepresentation;
import de.ii.ogcapi.tiles.domain.ImmutableTileLayer;
import de.ii.ogcapi.tiles.domain.TileLayer;
import de.ii.ogcapi.tiles.domain.TilePoint;
import de.ii.ogcapi.tiles.domain.TileSet;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.ImmutableTileMatrixSetLimits;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.ImmutableTilesBoundingBox;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetData;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetLimits;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TilesBoundingBox;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAnyGetter;
import shadow.com.fasterxml.jackson.annotation.JsonAnySetter;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TileSet", generator="Immutables")
@Immutable
public final class ImmutableTileSet
extends TileSet {
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    private final ImmutableList<Link> links;
    @Nullable
    private final Date lastModified;
    private final ImmutableList<Map<String, Object>> sections;
    private final transient List<Map<String, Object>> orderedSections;
    private final boolean sectionsFirst;
    private final ImmutableList<String> keywords;
    @Nullable
    private final String publisher;
    @Nullable
    private final String pointOfContact;
    @Nullable
    private final String accessConstraints;
    @Nullable
    private final String license;
    @Nullable
    private final String attribution;
    @Nullable
    private final MetadataDates dates;
    @Nullable
    private final String version;
    private final TileSet.DataType dataType;
    private final String tileMatrixSetId;
    @Nullable
    private final TileMatrixSetData tileMatrixSet;
    @Nullable
    private final String tileMatrixSetURI;
    @Nullable
    private final String tileMatrixSetDefinition;
    private final ImmutableList<TileMatrixSetLimits> tileMatrixSetLimits;
    private final ImmutableTilesBoundingBox boundingBox;
    @Nullable
    private final TilePoint centerPoint;
    private final ImmutableList<TileLayer> layers;
    private final ImmutableMap<String, Object> extensions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTileSet(Builder builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.links = builder.links.build();
        this.lastModified = builder.lastModified;
        this.sections = builder.sections.build();
        this.keywords = builder.keywords.build();
        this.publisher = builder.publisher;
        this.pointOfContact = builder.pointOfContact;
        this.accessConstraints = builder.accessConstraints;
        this.license = builder.license;
        this.attribution = builder.attribution;
        this.dates = builder.dates;
        this.version = builder.version;
        this.dataType = builder.dataType;
        this.tileMatrixSetId = builder.tileMatrixSetId;
        this.tileMatrixSet = builder.tileMatrixSet;
        this.tileMatrixSetURI = builder.tileMatrixSetURI;
        this.tileMatrixSetDefinition = builder.tileMatrixSetDefinition;
        this.tileMatrixSetLimits = builder.tileMatrixSetLimits.build();
        this.boundingBox = ImmutableTilesBoundingBox.copyOf(builder.boundingBox);
        this.centerPoint = builder.centerPoint;
        this.layers = builder.layers.build();
        this.extensions = builder.extensions.build();
        if (builder.sectionsFirstIsSet()) {
            this.initShim.sectionsFirst(builder.sectionsFirst);
        }
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.initShim = null;
    }

    private ImmutableTileSet(@Nullable String title, @Nullable String description, ImmutableList<Link> links, @Nullable Date lastModified, ImmutableList<Map<String, Object>> sections, boolean sectionsFirst, ImmutableList<String> keywords, @Nullable String publisher, @Nullable String pointOfContact, @Nullable String accessConstraints, @Nullable String license, @Nullable String attribution, @Nullable MetadataDates dates, @Nullable String version, TileSet.DataType dataType, String tileMatrixSetId, @Nullable TileMatrixSetData tileMatrixSet, @Nullable String tileMatrixSetURI, @Nullable String tileMatrixSetDefinition, ImmutableList<TileMatrixSetLimits> tileMatrixSetLimits, ImmutableTilesBoundingBox boundingBox, @Nullable TilePoint centerPoint, ImmutableList<TileLayer> layers, ImmutableMap<String, Object> extensions) {
        this.title = title;
        this.description = description;
        this.links = links;
        this.lastModified = lastModified;
        this.sections = sections;
        this.initShim.sectionsFirst(sectionsFirst);
        this.keywords = keywords;
        this.publisher = publisher;
        this.pointOfContact = pointOfContact;
        this.accessConstraints = accessConstraints;
        this.license = license;
        this.attribution = attribution;
        this.dates = dates;
        this.version = version;
        this.dataType = dataType;
        this.tileMatrixSetId = tileMatrixSetId;
        this.tileMatrixSet = tileMatrixSet;
        this.tileMatrixSetURI = tileMatrixSetURI;
        this.tileMatrixSetDefinition = tileMatrixSetDefinition;
        this.tileMatrixSetLimits = tileMatrixSetLimits;
        this.boundingBox = boundingBox;
        this.centerPoint = centerPoint;
        this.layers = layers;
        this.extensions = extensions;
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="links")
    public ImmutableList<Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="lastModified")
    @JsonIgnore
    public Optional<Date> getLastModified() {
        return Optional.ofNullable(this.lastModified);
    }

    @JsonProperty(value="sections")
    @JsonIgnore
    public ImmutableList<Map<String, Object>> getSections() {
        return this.sections;
    }

    @Override
    @JsonProperty(value="orderedSections")
    @JsonIgnore
    public List<Map<String, Object>> getOrderedSections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOrderedSections() : this.orderedSections;
    }

    @Override
    @JsonProperty(value="sectionsFirst")
    @JsonIgnore
    public boolean getSectionsFirst() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSectionsFirst() : this.sectionsFirst;
    }

    @JsonProperty(value="keywords")
    public ImmutableList<String> getKeywords() {
        return this.keywords;
    }

    @Override
    @JsonProperty(value="publisher")
    public Optional<String> getPublisher() {
        return Optional.ofNullable(this.publisher);
    }

    @Override
    @JsonProperty(value="pointOfContact")
    public Optional<String> getPointOfContact() {
        return Optional.ofNullable(this.pointOfContact);
    }

    @Override
    @JsonProperty(value="accessConstraints")
    public Optional<String> getAccessConstraints() {
        return Optional.ofNullable(this.accessConstraints);
    }

    @Override
    @JsonProperty(value="license")
    public Optional<String> getLicense() {
        return Optional.ofNullable(this.license);
    }

    @Override
    @JsonProperty(value="attribution")
    public Optional<String> getAttribution() {
        return Optional.ofNullable(this.attribution);
    }

    @Override
    @JsonProperty(value="dates")
    public Optional<MetadataDates> getDates() {
        return Optional.ofNullable(this.dates);
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="dataType")
    public TileSet.DataType getDataType() {
        return this.dataType;
    }

    @Override
    @JsonProperty(value="tileMatrixSetId")
    public String getTileMatrixSetId() {
        return this.tileMatrixSetId;
    }

    @Override
    @JsonProperty(value="tileMatrixSet")
    public Optional<TileMatrixSetData> getTileMatrixSet() {
        return Optional.ofNullable(this.tileMatrixSet);
    }

    @Override
    @JsonProperty(value="tileMatrixSetURI")
    public Optional<String> getTileMatrixSetURI() {
        return Optional.ofNullable(this.tileMatrixSetURI);
    }

    @Override
    @JsonProperty(value="tileMatrixSetDefinition")
    public Optional<String> getTileMatrixSetDefinition() {
        return Optional.ofNullable(this.tileMatrixSetDefinition);
    }

    @JsonProperty(value="tileMatrixSetLimits")
    public ImmutableList<TileMatrixSetLimits> getTileMatrixSetLimits() {
        return this.tileMatrixSetLimits;
    }

    @Override
    @JsonProperty(value="boundingBox")
    public ImmutableTilesBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    @JsonProperty(value="centerPoint")
    public Optional<TilePoint> getCenterPoint() {
        return Optional.ofNullable(this.centerPoint);
    }

    @JsonProperty(value="layers")
    public ImmutableList<TileLayer> getLayers() {
        return this.layers;
    }

    @JsonProperty(value="extensions")
    @JsonAnyGetter
    public ImmutableMap<String, Object> getExtensions() {
        return this.extensions;
    }

    public final ImmutableTileSet withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutableTileSet(newValue, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableTileSet(value, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, newValue, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, value, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withLinks(Link ... elements) {
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withLinks(Iterable<? extends Link> elements) {
        if (this.links == elements) {
            return this;
        }
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withLastModified(Date value) {
        Date newValue = Objects.requireNonNull(value, "lastModified");
        if (this.lastModified == newValue) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, newValue, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withLastModified(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, value, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    @SafeVarargs
    public final ImmutableTileSet withSections(Map<String, Object> ... elements) {
        ImmutableList<Map<String, Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withSections(Iterable<? extends Map<String, Object>> elements) {
        if (this.sections == elements) {
            return this;
        }
        ImmutableList<Map<String, Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withSectionsFirst(boolean value) {
        if (this.sectionsFirst == value) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, value, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withKeywords(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, newValue, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withKeywords(Iterable<String> elements) {
        if (this.keywords == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, newValue, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withPublisher(String value) {
        String newValue = Objects.requireNonNull(value, "publisher");
        if (Objects.equals(this.publisher, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, newValue, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withPublisher(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.publisher, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, value, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withPointOfContact(String value) {
        String newValue = Objects.requireNonNull(value, "pointOfContact");
        if (Objects.equals(this.pointOfContact, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, newValue, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withPointOfContact(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.pointOfContact, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, value, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withAccessConstraints(String value) {
        String newValue = Objects.requireNonNull(value, "accessConstraints");
        if (Objects.equals(this.accessConstraints, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, newValue, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withAccessConstraints(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.accessConstraints, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, value, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withLicense(String value) {
        String newValue = Objects.requireNonNull(value, "license");
        if (Objects.equals(this.license, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, newValue, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withLicense(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.license, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, value, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withAttribution(String value) {
        String newValue = Objects.requireNonNull(value, "attribution");
        if (Objects.equals(this.attribution, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, newValue, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withAttribution(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.attribution, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, value, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withDates(MetadataDates value) {
        MetadataDates newValue = Objects.requireNonNull(value, "dates");
        if (this.dates == newValue) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, newValue, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withDates(Optional<? extends MetadataDates> optional) {
        MetadataDates value = optional.orElse(null);
        if (this.dates == value) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, value, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, newValue, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, value, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withDataType(TileSet.DataType value) {
        if (this.dataType == value) {
            return this;
        }
        TileSet.DataType newValue = Objects.requireNonNull(value, "dataType");
        if (this.dataType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, newValue, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSetId(String value) {
        String newValue = Objects.requireNonNull(value, "tileMatrixSetId");
        if (this.tileMatrixSetId.equals(newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, newValue, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSet(TileMatrixSetData value) {
        TileMatrixSetData newValue = Objects.requireNonNull(value, "tileMatrixSet");
        if (this.tileMatrixSet == newValue) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, newValue, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSet(Optional<? extends TileMatrixSetData> optional) {
        TileMatrixSetData value = optional.orElse(null);
        if (this.tileMatrixSet == value) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, value, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSetURI(String value) {
        String newValue = Objects.requireNonNull(value, "tileMatrixSetURI");
        if (Objects.equals(this.tileMatrixSetURI, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, newValue, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSetURI(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tileMatrixSetURI, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, value, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSetDefinition(String value) {
        String newValue = Objects.requireNonNull(value, "tileMatrixSetDefinition");
        if (Objects.equals(this.tileMatrixSetDefinition, newValue)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, newValue, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSetDefinition(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tileMatrixSetDefinition, value)) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, value, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSetLimits(TileMatrixSetLimits ... elements) {
        ImmutableList<TileMatrixSetLimits> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, newValue, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withTileMatrixSetLimits(Iterable<? extends TileMatrixSetLimits> elements) {
        if (this.tileMatrixSetLimits == elements) {
            return this;
        }
        ImmutableList<TileMatrixSetLimits> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, newValue, this.boundingBox, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withBoundingBox(TilesBoundingBox value) {
        if (this.boundingBox == value) {
            return this;
        }
        ImmutableTilesBoundingBox newValue = ImmutableTilesBoundingBox.copyOf(value);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, newValue, this.centerPoint, this.layers, this.extensions);
    }

    public final ImmutableTileSet withCenterPoint(TilePoint value) {
        TilePoint newValue = Objects.requireNonNull(value, "centerPoint");
        if (this.centerPoint == newValue) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, newValue, this.layers, this.extensions);
    }

    public final ImmutableTileSet withCenterPoint(Optional<? extends TilePoint> optional) {
        TilePoint value = optional.orElse(null);
        if (this.centerPoint == value) {
            return this;
        }
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, value, this.layers, this.extensions);
    }

    public final ImmutableTileSet withLayers(TileLayer ... elements) {
        ImmutableList<TileLayer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, newValue, this.extensions);
    }

    public final ImmutableTileSet withLayers(Iterable<? extends TileLayer> elements) {
        if (this.layers == elements) {
            return this;
        }
        ImmutableList<TileLayer> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, newValue, this.extensions);
    }

    public final ImmutableTileSet withExtensions(Map<String, ? extends Object> entries) {
        if (this.extensions == entries) {
            return this;
        }
        ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTileSet(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.dataType, this.tileMatrixSetId, this.tileMatrixSet, this.tileMatrixSetURI, this.tileMatrixSetDefinition, this.tileMatrixSetLimits, this.boundingBox, this.centerPoint, this.layers, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTileSet && this.equalTo((ImmutableTileSet)another);
    }

    private boolean equalTo(ImmutableTileSet another) {
        return Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && this.links.equals(another.links) && Objects.equals(this.lastModified, another.lastModified) && this.sections.equals(another.sections) && this.orderedSections.equals(another.orderedSections) && this.sectionsFirst == another.sectionsFirst && this.keywords.equals(another.keywords) && Objects.equals(this.publisher, another.publisher) && Objects.equals(this.pointOfContact, another.pointOfContact) && Objects.equals(this.accessConstraints, another.accessConstraints) && Objects.equals(this.license, another.license) && Objects.equals(this.attribution, another.attribution) && Objects.equals(this.dates, another.dates) && Objects.equals(this.version, another.version) && this.dataType.equals((Object)another.dataType) && this.tileMatrixSetId.equals(another.tileMatrixSetId) && Objects.equals(this.tileMatrixSet, another.tileMatrixSet) && Objects.equals(this.tileMatrixSetURI, another.tileMatrixSetURI) && Objects.equals(this.tileMatrixSetDefinition, another.tileMatrixSetDefinition) && this.tileMatrixSetLimits.equals(another.tileMatrixSetLimits) && this.boundingBox.equals(another.boundingBox) && Objects.equals(this.centerPoint, another.centerPoint) && this.layers.equals(another.layers) && this.extensions.equals(another.extensions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + this.sections.hashCode();
        h += (h << 5) + this.orderedSections.hashCode();
        h += (h << 5) + Booleans.hashCode(this.sectionsFirst);
        h += (h << 5) + this.keywords.hashCode();
        h += (h << 5) + Objects.hashCode(this.publisher);
        h += (h << 5) + Objects.hashCode(this.pointOfContact);
        h += (h << 5) + Objects.hashCode(this.accessConstraints);
        h += (h << 5) + Objects.hashCode(this.license);
        h += (h << 5) + Objects.hashCode(this.attribution);
        h += (h << 5) + Objects.hashCode(this.dates);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + this.dataType.hashCode();
        h += (h << 5) + this.tileMatrixSetId.hashCode();
        h += (h << 5) + Objects.hashCode(this.tileMatrixSet);
        h += (h << 5) + Objects.hashCode(this.tileMatrixSetURI);
        h += (h << 5) + Objects.hashCode(this.tileMatrixSetDefinition);
        h += (h << 5) + this.tileMatrixSetLimits.hashCode();
        h += (h << 5) + this.boundingBox.hashCode();
        h += (h << 5) + Objects.hashCode(this.centerPoint);
        h += (h << 5) + this.layers.hashCode();
        h += (h << 5) + this.extensions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TileSet").omitNullValues().add("title", this.title).add("description", this.description).add("links", this.links).add("lastModified", this.lastModified).add("sections", this.sections).add("orderedSections", this.orderedSections).add("sectionsFirst", this.sectionsFirst).add("keywords", this.keywords).add("publisher", this.publisher).add("pointOfContact", this.pointOfContact).add("accessConstraints", this.accessConstraints).add("license", this.license).add("attribution", this.attribution).add("dates", this.dates).add("version", this.version).add("dataType", (Object)this.dataType).add("tileMatrixSetId", this.tileMatrixSetId).add("tileMatrixSet", this.tileMatrixSet).add("tileMatrixSetURI", this.tileMatrixSetURI).add("tileMatrixSetDefinition", this.tileMatrixSetDefinition).add("tileMatrixSetLimits", this.tileMatrixSetLimits).add("boundingBox", this.boundingBox).add("centerPoint", this.centerPoint).add("layers", this.layers).add("extensions", this.extensions).toString();
    }

    public static ImmutableTileSet copyOf(TileSet instance) {
        if (instance instanceof ImmutableTileSet) {
            return (ImmutableTileSet)instance;
        }
        return ImmutableTileSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TileSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATA_TYPE = 1L;
        private static final long INIT_BIT_TILE_MATRIX_SET_ID = 2L;
        private static final long INIT_BIT_BOUNDING_BOX = 4L;
        private static final long OPT_BIT_SECTIONS_FIRST = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private String title;
        @Nullable
        private String description;
        private ImmutableList.Builder<Link> links = ImmutableList.builder();
        @Nullable
        private Date lastModified;
        private ImmutableList.Builder<Map<String, Object>> sections = ImmutableList.builder();
        private boolean sectionsFirst;
        private ImmutableList.Builder<String> keywords = ImmutableList.builder();
        @Nullable
        private String publisher;
        @Nullable
        private String pointOfContact;
        @Nullable
        private String accessConstraints;
        @Nullable
        private String license;
        @Nullable
        private String attribution;
        @Nullable
        private MetadataDates dates;
        @Nullable
        private String version;
        @Nullable
        private TileSet.DataType dataType;
        @Nullable
        private String tileMatrixSetId;
        @Nullable
        private TileMatrixSetData tileMatrixSet;
        @Nullable
        private String tileMatrixSetURI;
        @Nullable
        private String tileMatrixSetDefinition;
        private ImmutableList.Builder<TileMatrixSetLimits> tileMatrixSetLimits = ImmutableList.builder();
        @Nullable
        private TilesBoundingBox boundingBox;
        @Nullable
        private TilePoint centerPoint;
        private ImmutableList.Builder<TileLayer> layers = ImmutableList.builder();
        private ImmutableMap.Builder<String, Object> extensions = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PageRepresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Metadata2 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TileSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageRepresentation instance;
            if (object instanceof PageRepresentation) {
                Optional<String> titleOptional;
                instance = (PageRepresentation)object;
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.description(descriptionOptional);
                }
                this.addAllLinks(instance.getLinks());
                Optional<Date> lastModifiedOptional = instance.getLastModified();
                if (lastModifiedOptional.isPresent()) {
                    this.lastModified(lastModifiedOptional);
                }
                if ((titleOptional = instance.getTitle()).isPresent()) {
                    this.title(titleOptional);
                }
                this.addAllSections(instance.getSections());
                this.sectionsFirst(instance.getSectionsFirst());
            }
            if (object instanceof Metadata2) {
                Optional<String> pointOfContactOptional;
                Optional<String> accessConstraintsOptional;
                Optional<String> versionOptional;
                Optional<MetadataDates> datesOptional;
                Optional<String> publisherOptional;
                instance = (Metadata2)object;
                Optional<String> licenseOptional = ((Metadata2)instance).getLicense();
                if (licenseOptional.isPresent()) {
                    this.license(licenseOptional);
                }
                this.addAllKeywords(((Metadata2)instance).getKeywords());
                Optional<String> attributionOptional = ((Metadata2)instance).getAttribution();
                if (attributionOptional.isPresent()) {
                    this.attribution(attributionOptional);
                }
                if ((publisherOptional = ((Metadata2)instance).getPublisher()).isPresent()) {
                    this.publisher(publisherOptional);
                }
                if ((datesOptional = ((Metadata2)instance).getDates()).isPresent()) {
                    this.dates(datesOptional);
                }
                if ((versionOptional = ((Metadata2)instance).getVersion()).isPresent()) {
                    this.version(versionOptional);
                }
                if ((accessConstraintsOptional = ((Metadata2)instance).getAccessConstraints()).isPresent()) {
                    this.accessConstraints(accessConstraintsOptional);
                }
                if ((pointOfContactOptional = ((Metadata2)instance).getPointOfContact()).isPresent()) {
                    this.pointOfContact(pointOfContactOptional);
                }
            }
            if (object instanceof TileSet) {
                Optional<TilePoint> centerPointOptional;
                instance = (TileSet)object;
                Optional<TileMatrixSetData> tileMatrixSetOptional = ((TileSet)instance).getTileMatrixSet();
                if (tileMatrixSetOptional.isPresent()) {
                    this.tileMatrixSet(tileMatrixSetOptional);
                }
                this.boundingBox(((TileSet)instance).getBoundingBox());
                this.putAllExtensions(((TileSet)instance).getExtensions());
                this.tileMatrixSetId(((TileSet)instance).getTileMatrixSetId());
                Optional<String> tileMatrixSetURIOptional = ((TileSet)instance).getTileMatrixSetURI();
                if (tileMatrixSetURIOptional.isPresent()) {
                    this.tileMatrixSetURI(tileMatrixSetURIOptional);
                }
                this.dataType(((TileSet)instance).getDataType());
                this.addAllLayers(((TileSet)instance).getLayers());
                this.addAllTileMatrixSetLimits(((TileSet)instance).getTileMatrixSetLimits());
                Optional<String> tileMatrixSetDefinitionOptional = ((TileSet)instance).getTileMatrixSetDefinition();
                if (tileMatrixSetDefinitionOptional.isPresent()) {
                    this.tileMatrixSetDefinition(tileMatrixSetDefinitionOptional);
                }
                if ((centerPointOptional = ((TileSet)instance).getCenterPoint()).isPresent()) {
                    this.centerPoint(centerPointOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link element) {
            element = ImmutableLink.copyOf(element);
            this.links.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link ... elements) {
            for (Link element : elements) {
                element = ImmutableLink.copyOf(element);
                this.links.add((Object)Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @JsonProperty(value="links")
        @CanIgnoreReturnValue
        public final Builder links(Iterable<? extends Link> elements) {
            this.links = ImmutableList.builder();
            return this.addAllLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLinks(Iterable<? extends Link> elements) {
            for (Link link : elements) {
                ImmutableLink immutableLink = ImmutableLink.copyOf(link);
                this.links.add((Object)Objects.requireNonNull(immutableLink, "links element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastModified(Date lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            return this;
        }

        @JsonProperty(value="lastModified")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder lastModified(Optional<? extends Date> lastModified) {
            this.lastModified = lastModified.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> element) {
            this.sections.add((Object)element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> ... elements) {
            this.sections.add(elements);
            return this;
        }

        @JsonProperty(value="sections")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sections(Iterable<? extends Map<String, Object>> elements) {
            this.sections = ImmutableList.builder();
            return this.addAllSections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSections(Iterable<? extends Map<String, Object>> elements) {
            this.sections.addAll(elements);
            return this;
        }

        @JsonProperty(value="sectionsFirst")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String element) {
            this.keywords.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String ... elements) {
            this.keywords.add(elements);
            return this;
        }

        @JsonProperty(value="keywords")
        @CanIgnoreReturnValue
        public final Builder keywords(Iterable<String> elements) {
            this.keywords = ImmutableList.builder();
            return this.addAllKeywords(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeywords(Iterable<String> elements) {
            this.keywords.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publisher(String publisher) {
            this.publisher = Objects.requireNonNull(publisher, "publisher");
            return this;
        }

        @JsonProperty(value="publisher")
        @CanIgnoreReturnValue
        public final Builder publisher(Optional<String> publisher) {
            this.publisher = publisher.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointOfContact(String pointOfContact) {
            this.pointOfContact = Objects.requireNonNull(pointOfContact, "pointOfContact");
            return this;
        }

        @JsonProperty(value="pointOfContact")
        @CanIgnoreReturnValue
        public final Builder pointOfContact(Optional<String> pointOfContact) {
            this.pointOfContact = pointOfContact.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessConstraints(String accessConstraints) {
            this.accessConstraints = Objects.requireNonNull(accessConstraints, "accessConstraints");
            return this;
        }

        @JsonProperty(value="accessConstraints")
        @CanIgnoreReturnValue
        public final Builder accessConstraints(Optional<String> accessConstraints) {
            this.accessConstraints = accessConstraints.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder license(String license) {
            this.license = Objects.requireNonNull(license, "license");
            return this;
        }

        @JsonProperty(value="license")
        @CanIgnoreReturnValue
        public final Builder license(Optional<String> license) {
            this.license = license.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attribution(String attribution) {
            this.attribution = Objects.requireNonNull(attribution, "attribution");
            return this;
        }

        @JsonProperty(value="attribution")
        @CanIgnoreReturnValue
        public final Builder attribution(Optional<String> attribution) {
            this.attribution = attribution.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dates(MetadataDates dates) {
            this.dates = Objects.requireNonNull(dates, "dates");
            return this;
        }

        @JsonProperty(value="dates")
        @CanIgnoreReturnValue
        public final Builder dates(Optional<? extends MetadataDates> dates) {
            this.dates = dates.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        @JsonProperty(value="dataType")
        @CanIgnoreReturnValue
        public final Builder dataType(TileSet.DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="tileMatrixSetId")
        @CanIgnoreReturnValue
        public final Builder tileMatrixSetId(String tileMatrixSetId) {
            this.tileMatrixSetId = Objects.requireNonNull(tileMatrixSetId, "tileMatrixSetId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileMatrixSet(TileMatrixSetData tileMatrixSet) {
            this.tileMatrixSet = Objects.requireNonNull(tileMatrixSet, "tileMatrixSet");
            return this;
        }

        @JsonProperty(value="tileMatrixSet")
        @CanIgnoreReturnValue
        public final Builder tileMatrixSet(Optional<? extends TileMatrixSetData> tileMatrixSet) {
            this.tileMatrixSet = tileMatrixSet.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileMatrixSetURI(String tileMatrixSetURI) {
            this.tileMatrixSetURI = Objects.requireNonNull(tileMatrixSetURI, "tileMatrixSetURI");
            return this;
        }

        @JsonProperty(value="tileMatrixSetURI")
        @CanIgnoreReturnValue
        public final Builder tileMatrixSetURI(Optional<String> tileMatrixSetURI) {
            this.tileMatrixSetURI = tileMatrixSetURI.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileMatrixSetDefinition(String tileMatrixSetDefinition) {
            this.tileMatrixSetDefinition = Objects.requireNonNull(tileMatrixSetDefinition, "tileMatrixSetDefinition");
            return this;
        }

        @JsonProperty(value="tileMatrixSetDefinition")
        @CanIgnoreReturnValue
        public final Builder tileMatrixSetDefinition(Optional<String> tileMatrixSetDefinition) {
            this.tileMatrixSetDefinition = tileMatrixSetDefinition.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileMatrixSetLimits(TileMatrixSetLimits element) {
            element = ImmutableTileMatrixSetLimits.copyOf(element);
            this.tileMatrixSetLimits.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileMatrixSetLimits(TileMatrixSetLimits ... elements) {
            for (TileMatrixSetLimits element : elements) {
                element = ImmutableTileMatrixSetLimits.copyOf(element);
                this.tileMatrixSetLimits.add((Object)Objects.requireNonNull(element, "tileMatrixSetLimits element"));
            }
            return this;
        }

        @JsonProperty(value="tileMatrixSetLimits")
        @CanIgnoreReturnValue
        public final Builder tileMatrixSetLimits(Iterable<? extends TileMatrixSetLimits> elements) {
            this.tileMatrixSetLimits = ImmutableList.builder();
            return this.addAllTileMatrixSetLimits(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTileMatrixSetLimits(Iterable<? extends TileMatrixSetLimits> elements) {
            for (TileMatrixSetLimits tileMatrixSetLimits : elements) {
                ImmutableTileMatrixSetLimits immutableTileMatrixSetLimits = ImmutableTileMatrixSetLimits.copyOf(tileMatrixSetLimits);
                this.tileMatrixSetLimits.add((Object)Objects.requireNonNull(immutableTileMatrixSetLimits, "tileMatrixSetLimits element"));
            }
            return this;
        }

        @JsonProperty(value="boundingBox")
        @CanIgnoreReturnValue
        public final Builder boundingBox(TilesBoundingBox boundingBox) {
            this.boundingBox = ImmutableTilesBoundingBox.copyOf(boundingBox);
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder centerPoint(TilePoint centerPoint) {
            this.centerPoint = Objects.requireNonNull(centerPoint, "centerPoint");
            return this;
        }

        @JsonProperty(value="centerPoint")
        @CanIgnoreReturnValue
        public final Builder centerPoint(Optional<? extends TilePoint> centerPoint) {
            this.centerPoint = centerPoint.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLayers(TileLayer element) {
            element = ImmutableTileLayer.copyOf(element);
            this.layers.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLayers(TileLayer ... elements) {
            for (TileLayer element : elements) {
                element = ImmutableTileLayer.copyOf(element);
                this.layers.add((Object)Objects.requireNonNull(element, "layers element"));
            }
            return this;
        }

        @JsonProperty(value="layers")
        @CanIgnoreReturnValue
        public final Builder layers(Iterable<? extends TileLayer> elements) {
            this.layers = ImmutableList.builder();
            return this.addAllLayers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLayers(Iterable<? extends TileLayer> elements) {
            for (TileLayer tileLayer : elements) {
                ImmutableTileLayer immutableTileLayer = ImmutableTileLayer.copyOf(tileLayer);
                this.layers.add((Object)Objects.requireNonNull(immutableTileLayer, "layers element"));
            }
            return this;
        }

        @JsonAnySetter
        @CanIgnoreReturnValue
        public final Builder putExtensions(String key, Object value) {
            this.extensions.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExtensions(Map.Entry<String, ? extends Object> entry) {
            this.extensions.put(entry);
            return this;
        }

        @JsonProperty(value="extensions")
        @CanIgnoreReturnValue
        public final Builder extensions(Map<String, ? extends Object> entries) {
            this.extensions = ImmutableMap.builder();
            return this.putAllExtensions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExtensions(Map<String, ? extends Object> entries) {
            this.extensions.putAll(entries);
            return this;
        }

        public ImmutableTileSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTileSet(this);
        }

        private boolean sectionsFirstIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dataType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tileMatrixSetId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("boundingBox");
            }
            return "Cannot build TileSet, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="TileSet", generator="Immutables")
    private final class InitShim {
        private byte orderedSectionsBuildStage = 0;
        private List<Map<String, Object>> orderedSections;
        private byte sectionsFirstBuildStage = 0;
        private boolean sectionsFirst;

        private InitShim() {
        }

        List<Map<String, Object>> getOrderedSections() {
            if (this.orderedSectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orderedSectionsBuildStage == 0) {
                this.orderedSectionsBuildStage = (byte)-1;
                this.orderedSections = Objects.requireNonNull(ImmutableTileSet.super.getOrderedSections(), "orderedSections");
                this.orderedSectionsBuildStage = 1;
            }
            return this.orderedSections;
        }

        boolean getSectionsFirst() {
            if (this.sectionsFirstBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sectionsFirstBuildStage == 0) {
                this.sectionsFirstBuildStage = (byte)-1;
                this.sectionsFirst = ImmutableTileSet.super.getSectionsFirst();
                this.sectionsFirstBuildStage = 1;
            }
            return this.sectionsFirst;
        }

        void sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.sectionsFirstBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.orderedSectionsBuildStage == -1) {
                attributes.add("orderedSections");
            }
            if (this.sectionsFirstBuildStage == -1) {
                attributes.add("sectionsFirst");
            }
            return "Cannot build TileSet, attribute initializers form cycle " + attributes;
        }
    }
}

