/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.tiles.domain.TilePoint;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TilePoint", generator="Immutables")
@Immutable
public final class ImmutableTilePoint
implements TilePoint {
    private final ImmutableList<Double> coordinates;
    @Nullable
    private final String tileMatrix;

    private ImmutableTilePoint(ImmutableList<Double> coordinates, @Nullable String tileMatrix) {
        this.coordinates = coordinates;
        this.tileMatrix = tileMatrix;
    }

    @JsonProperty(value="coordinates")
    public ImmutableList<Double> getCoordinates() {
        return this.coordinates;
    }

    @Override
    @JsonProperty(value="tileMatrix")
    public Optional<String> getTileMatrix() {
        return Optional.ofNullable(this.tileMatrix);
    }

    public final ImmutableTilePoint withCoordinates(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new ImmutableTilePoint(newValue, this.tileMatrix);
    }

    public final ImmutableTilePoint withCoordinates(Iterable<Double> elements) {
        if (this.coordinates == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTilePoint(newValue, this.tileMatrix);
    }

    public final ImmutableTilePoint withTileMatrix(String value) {
        String newValue = Objects.requireNonNull(value, "tileMatrix");
        if (Objects.equals(this.tileMatrix, newValue)) {
            return this;
        }
        return new ImmutableTilePoint(this.coordinates, newValue);
    }

    public final ImmutableTilePoint withTileMatrix(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tileMatrix, value)) {
            return this;
        }
        return new ImmutableTilePoint(this.coordinates, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTilePoint && this.equalTo((ImmutableTilePoint)another);
    }

    private boolean equalTo(ImmutableTilePoint another) {
        return this.coordinates.equals(another.coordinates) && Objects.equals(this.tileMatrix, another.tileMatrix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.coordinates.hashCode();
        h += (h << 5) + Objects.hashCode(this.tileMatrix);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TilePoint").omitNullValues().add("coordinates", this.coordinates).add("tileMatrix", this.tileMatrix).toString();
    }

    public static ImmutableTilePoint copyOf(TilePoint instance) {
        if (instance instanceof ImmutableTilePoint) {
            return (ImmutableTilePoint)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="TilePoint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Double> coordinates = ImmutableList.builder();
        @Nullable
        private String tileMatrix;

        @CanIgnoreReturnValue
        public final Builder from(TilePoint instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCoordinates(instance.getCoordinates());
            Optional<String> tileMatrixOptional = instance.getTileMatrix();
            if (tileMatrixOptional.isPresent()) {
                this.tileMatrix(tileMatrixOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(double element) {
            this.coordinates.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCoordinates(double ... elements) {
            this.coordinates.addAll(Doubles.asList(elements));
            return this;
        }

        @JsonProperty(value="coordinates")
        @CanIgnoreReturnValue
        public final Builder coordinates(Iterable<Double> elements) {
            this.coordinates = ImmutableList.builder();
            return this.addAllCoordinates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCoordinates(Iterable<Double> elements) {
            this.coordinates.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileMatrix(String tileMatrix) {
            this.tileMatrix = Objects.requireNonNull(tileMatrix, "tileMatrix");
            return this;
        }

        @JsonProperty(value="tileMatrix")
        @CanIgnoreReturnValue
        public final Builder tileMatrix(Optional<String> tileMatrix) {
            this.tileMatrix = tileMatrix.orElse(null);
            return this;
        }

        public ImmutableTilePoint build() {
            return new ImmutableTilePoint((ImmutableList<Double>)this.coordinates.build(), this.tileMatrix);
        }
    }
}

