/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.features.geojson.domain.JsonSchemaObject;
import de.ii.ogcapi.foundation.domain.ImmutableLink;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.foundation.domain.Metadata2;
import de.ii.ogcapi.foundation.domain.MetadataDates;
import de.ii.ogcapi.foundation.domain.PageRepresentation;
import de.ii.ogcapi.tiles.domain.TileLayer;
import de.ii.ogcapi.tiles.domain.TileSet;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TilesBoundingBox;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TileLayer", generator="Immutables")
@Immutable
public final class ImmutableTileLayer
extends TileLayer {
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    private final ImmutableList<Link> links;
    @Nullable
    private final Date lastModified;
    private final ImmutableList<Map<String, Object>> sections;
    private final transient List<Map<String, Object>> orderedSections;
    private final boolean sectionsFirst;
    private final ImmutableList<String> keywords;
    @Nullable
    private final String publisher;
    @Nullable
    private final String pointOfContact;
    @Nullable
    private final String accessConstraints;
    @Nullable
    private final String license;
    @Nullable
    private final String attribution;
    @Nullable
    private final MetadataDates dates;
    @Nullable
    private final String version;
    private final String id;
    private final TileSet.DataType dataType;
    @Nullable
    private final String featureType;
    @Nullable
    private final TileLayer.GeometryType geometryType;
    @Nullable
    private final String theme;
    @Nullable
    private final String minTileMatrix;
    @Nullable
    private final String maxTileMatrix;
    @Nullable
    private final Double minCellSize;
    @Nullable
    private final Double maxCellSize;
    @Nullable
    private final Double minScaleDenominator;
    @Nullable
    private final Double maxScaleDenominator;
    @Nullable
    private final TilesBoundingBox boundingBox;
    @Nullable
    private final JsonSchemaObject propertiesSchema;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTileLayer(Builder builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.links = builder.links.build();
        this.lastModified = builder.lastModified;
        this.sections = builder.sections.build();
        this.keywords = builder.keywords.build();
        this.publisher = builder.publisher;
        this.pointOfContact = builder.pointOfContact;
        this.accessConstraints = builder.accessConstraints;
        this.license = builder.license;
        this.attribution = builder.attribution;
        this.dates = builder.dates;
        this.version = builder.version;
        this.id = builder.id;
        this.dataType = builder.dataType;
        this.featureType = builder.featureType;
        this.geometryType = builder.geometryType;
        this.theme = builder.theme;
        this.minTileMatrix = builder.minTileMatrix;
        this.maxTileMatrix = builder.maxTileMatrix;
        this.minCellSize = builder.minCellSize;
        this.maxCellSize = builder.maxCellSize;
        this.minScaleDenominator = builder.minScaleDenominator;
        this.maxScaleDenominator = builder.maxScaleDenominator;
        this.boundingBox = builder.boundingBox;
        this.propertiesSchema = builder.propertiesSchema;
        if (builder.sectionsFirstIsSet()) {
            this.initShim.sectionsFirst(builder.sectionsFirst);
        }
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.initShim = null;
    }

    private ImmutableTileLayer(@Nullable String title, @Nullable String description, ImmutableList<Link> links, @Nullable Date lastModified, ImmutableList<Map<String, Object>> sections, boolean sectionsFirst, ImmutableList<String> keywords, @Nullable String publisher, @Nullable String pointOfContact, @Nullable String accessConstraints, @Nullable String license, @Nullable String attribution, @Nullable MetadataDates dates, @Nullable String version, String id, TileSet.DataType dataType, @Nullable String featureType, @Nullable TileLayer.GeometryType geometryType, @Nullable String theme, @Nullable String minTileMatrix, @Nullable String maxTileMatrix, @Nullable Double minCellSize, @Nullable Double maxCellSize, @Nullable Double minScaleDenominator, @Nullable Double maxScaleDenominator, @Nullable TilesBoundingBox boundingBox, @Nullable JsonSchemaObject propertiesSchema) {
        this.title = title;
        this.description = description;
        this.links = links;
        this.lastModified = lastModified;
        this.sections = sections;
        this.initShim.sectionsFirst(sectionsFirst);
        this.keywords = keywords;
        this.publisher = publisher;
        this.pointOfContact = pointOfContact;
        this.accessConstraints = accessConstraints;
        this.license = license;
        this.attribution = attribution;
        this.dates = dates;
        this.version = version;
        this.id = id;
        this.dataType = dataType;
        this.featureType = featureType;
        this.geometryType = geometryType;
        this.theme = theme;
        this.minTileMatrix = minTileMatrix;
        this.maxTileMatrix = maxTileMatrix;
        this.minCellSize = minCellSize;
        this.maxCellSize = maxCellSize;
        this.minScaleDenominator = minScaleDenominator;
        this.maxScaleDenominator = maxScaleDenominator;
        this.boundingBox = boundingBox;
        this.propertiesSchema = propertiesSchema;
        this.orderedSections = this.initShim.getOrderedSections();
        this.sectionsFirst = this.initShim.getSectionsFirst();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @JsonProperty(value="links")
    public ImmutableList<Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="lastModified")
    @JsonIgnore
    public Optional<Date> getLastModified() {
        return Optional.ofNullable(this.lastModified);
    }

    @JsonProperty(value="sections")
    @JsonIgnore
    public ImmutableList<Map<String, Object>> getSections() {
        return this.sections;
    }

    @Override
    @JsonProperty(value="orderedSections")
    @JsonIgnore
    public List<Map<String, Object>> getOrderedSections() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOrderedSections() : this.orderedSections;
    }

    @Override
    @JsonProperty(value="sectionsFirst")
    @JsonIgnore
    public boolean getSectionsFirst() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSectionsFirst() : this.sectionsFirst;
    }

    @JsonProperty(value="keywords")
    public ImmutableList<String> getKeywords() {
        return this.keywords;
    }

    @Override
    @JsonProperty(value="publisher")
    public Optional<String> getPublisher() {
        return Optional.ofNullable(this.publisher);
    }

    @Override
    @JsonProperty(value="pointOfContact")
    public Optional<String> getPointOfContact() {
        return Optional.ofNullable(this.pointOfContact);
    }

    @Override
    @JsonProperty(value="accessConstraints")
    public Optional<String> getAccessConstraints() {
        return Optional.ofNullable(this.accessConstraints);
    }

    @Override
    @JsonProperty(value="license")
    public Optional<String> getLicense() {
        return Optional.ofNullable(this.license);
    }

    @Override
    @JsonProperty(value="attribution")
    public Optional<String> getAttribution() {
        return Optional.ofNullable(this.attribution);
    }

    @Override
    @JsonProperty(value="dates")
    public Optional<MetadataDates> getDates() {
        return Optional.ofNullable(this.dates);
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="dataType")
    public TileSet.DataType getDataType() {
        return this.dataType;
    }

    @Override
    @JsonProperty(value="featureType")
    public Optional<String> getFeatureType() {
        return Optional.ofNullable(this.featureType);
    }

    @Override
    @JsonProperty(value="geometryType")
    public Optional<TileLayer.GeometryType> getGeometryType() {
        return Optional.ofNullable(this.geometryType);
    }

    @Override
    @JsonProperty(value="theme")
    public Optional<String> getTheme() {
        return Optional.ofNullable(this.theme);
    }

    @Override
    @JsonProperty(value="minTileMatrix")
    public Optional<String> getMinTileMatrix() {
        return Optional.ofNullable(this.minTileMatrix);
    }

    @Override
    @JsonProperty(value="maxTileMatrix")
    public Optional<String> getMaxTileMatrix() {
        return Optional.ofNullable(this.maxTileMatrix);
    }

    @Override
    @JsonProperty(value="minCellSize")
    public Optional<Double> getMinCellSize() {
        return Optional.ofNullable(this.minCellSize);
    }

    @Override
    @JsonProperty(value="maxCellSize")
    public Optional<Double> getMaxCellSize() {
        return Optional.ofNullable(this.maxCellSize);
    }

    @Override
    @JsonProperty(value="minScaleDenominator")
    public Optional<Double> getMinScaleDenominator() {
        return Optional.ofNullable(this.minScaleDenominator);
    }

    @Override
    @JsonProperty(value="maxScaleDenominator")
    public Optional<Double> getMaxScaleDenominator() {
        return Optional.ofNullable(this.maxScaleDenominator);
    }

    @Override
    @JsonProperty(value="boundingBox")
    public Optional<TilesBoundingBox> getBoundingBox() {
        return Optional.ofNullable(this.boundingBox);
    }

    @Override
    @JsonProperty(value="propertiesSchema")
    public Optional<JsonSchemaObject> getPropertiesSchema() {
        return Optional.ofNullable(this.propertiesSchema);
    }

    public final ImmutableTileLayer withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(newValue, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new ImmutableTileLayer(value, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, newValue, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, value, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withLinks(Link ... elements) {
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileLayer(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withLinks(Iterable<? extends Link> elements) {
        if (this.links == elements) {
            return this;
        }
        ImmutableList<Link> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileLayer(this.title, this.description, newValue, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withLastModified(Date value) {
        Date newValue = Objects.requireNonNull(value, "lastModified");
        if (this.lastModified == newValue) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, newValue, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withLastModified(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, value, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    @SafeVarargs
    public final ImmutableTileLayer withSections(Map<String, Object> ... elements) {
        ImmutableList<Map<String, Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withSections(Iterable<? extends Map<String, Object>> elements) {
        if (this.sections == elements) {
            return this;
        }
        ImmutableList<Map<String, Object>> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, newValue, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withSectionsFirst(boolean value) {
        if (this.sectionsFirst == value) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, value, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withKeywords(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, newValue, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withKeywords(Iterable<String> elements) {
        if (this.keywords == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, newValue, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withPublisher(String value) {
        String newValue = Objects.requireNonNull(value, "publisher");
        if (Objects.equals(this.publisher, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, newValue, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withPublisher(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.publisher, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, value, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withPointOfContact(String value) {
        String newValue = Objects.requireNonNull(value, "pointOfContact");
        if (Objects.equals(this.pointOfContact, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, newValue, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withPointOfContact(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.pointOfContact, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, value, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withAccessConstraints(String value) {
        String newValue = Objects.requireNonNull(value, "accessConstraints");
        if (Objects.equals(this.accessConstraints, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, newValue, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withAccessConstraints(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.accessConstraints, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, value, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withLicense(String value) {
        String newValue = Objects.requireNonNull(value, "license");
        if (Objects.equals(this.license, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, newValue, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withLicense(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.license, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, value, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withAttribution(String value) {
        String newValue = Objects.requireNonNull(value, "attribution");
        if (Objects.equals(this.attribution, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, newValue, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withAttribution(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.attribution, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, value, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withDates(MetadataDates value) {
        MetadataDates newValue = Objects.requireNonNull(value, "dates");
        if (this.dates == newValue) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, newValue, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withDates(Optional<? extends MetadataDates> optional) {
        MetadataDates value = optional.orElse(null);
        if (this.dates == value) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, value, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, newValue, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, value, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, newValue, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withDataType(TileSet.DataType value) {
        if (this.dataType == value) {
            return this;
        }
        TileSet.DataType newValue = Objects.requireNonNull(value, "dataType");
        if (this.dataType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, newValue, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withFeatureType(String value) {
        String newValue = Objects.requireNonNull(value, "featureType");
        if (Objects.equals(this.featureType, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, newValue, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withFeatureType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.featureType, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, value, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withGeometryType(TileLayer.GeometryType value) {
        TileLayer.GeometryType newValue = Objects.requireNonNull(value, "geometryType");
        if (this.geometryType == newValue) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, newValue, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withGeometryType(Optional<? extends TileLayer.GeometryType> optional) {
        TileLayer.GeometryType value = optional.orElse(null);
        if (Objects.equals((Object)this.geometryType, (Object)value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, value, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withTheme(String value) {
        String newValue = Objects.requireNonNull(value, "theme");
        if (Objects.equals(this.theme, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, newValue, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withTheme(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.theme, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, value, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMinTileMatrix(String value) {
        String newValue = Objects.requireNonNull(value, "minTileMatrix");
        if (Objects.equals(this.minTileMatrix, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, newValue, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMinTileMatrix(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.minTileMatrix, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, value, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMaxTileMatrix(String value) {
        String newValue = Objects.requireNonNull(value, "maxTileMatrix");
        if (Objects.equals(this.maxTileMatrix, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, newValue, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMaxTileMatrix(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.maxTileMatrix, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, value, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMinCellSize(double value) {
        Double newValue = value;
        if (Objects.equals(this.minCellSize, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, newValue, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMinCellSize(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.minCellSize, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, value, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMaxCellSize(double value) {
        Double newValue = value;
        if (Objects.equals(this.maxCellSize, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, newValue, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMaxCellSize(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.maxCellSize, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, value, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMinScaleDenominator(double value) {
        Double newValue = value;
        if (Objects.equals(this.minScaleDenominator, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, newValue, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMinScaleDenominator(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.minScaleDenominator, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, value, this.maxScaleDenominator, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMaxScaleDenominator(double value) {
        Double newValue = value;
        if (Objects.equals(this.maxScaleDenominator, newValue)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, newValue, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withMaxScaleDenominator(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.maxScaleDenominator, value)) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, value, this.boundingBox, this.propertiesSchema);
    }

    public final ImmutableTileLayer withBoundingBox(TilesBoundingBox value) {
        TilesBoundingBox newValue = Objects.requireNonNull(value, "boundingBox");
        if (this.boundingBox == newValue) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, newValue, this.propertiesSchema);
    }

    public final ImmutableTileLayer withBoundingBox(Optional<? extends TilesBoundingBox> optional) {
        TilesBoundingBox value = optional.orElse(null);
        if (this.boundingBox == value) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, value, this.propertiesSchema);
    }

    public final ImmutableTileLayer withPropertiesSchema(JsonSchemaObject value) {
        JsonSchemaObject newValue = Objects.requireNonNull(value, "propertiesSchema");
        if (this.propertiesSchema == newValue) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, newValue);
    }

    public final ImmutableTileLayer withPropertiesSchema(Optional<? extends JsonSchemaObject> optional) {
        JsonSchemaObject value = optional.orElse(null);
        if (this.propertiesSchema == value) {
            return this;
        }
        return new ImmutableTileLayer(this.title, this.description, this.links, this.lastModified, this.sections, this.sectionsFirst, this.keywords, this.publisher, this.pointOfContact, this.accessConstraints, this.license, this.attribution, this.dates, this.version, this.id, this.dataType, this.featureType, this.geometryType, this.theme, this.minTileMatrix, this.maxTileMatrix, this.minCellSize, this.maxCellSize, this.minScaleDenominator, this.maxScaleDenominator, this.boundingBox, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTileLayer && this.equalTo((ImmutableTileLayer)another);
    }

    private boolean equalTo(ImmutableTileLayer another) {
        return Objects.equals(this.title, another.title) && Objects.equals(this.description, another.description) && this.links.equals(another.links) && Objects.equals(this.lastModified, another.lastModified) && this.sections.equals(another.sections) && this.orderedSections.equals(another.orderedSections) && this.sectionsFirst == another.sectionsFirst && this.keywords.equals(another.keywords) && Objects.equals(this.publisher, another.publisher) && Objects.equals(this.pointOfContact, another.pointOfContact) && Objects.equals(this.accessConstraints, another.accessConstraints) && Objects.equals(this.license, another.license) && Objects.equals(this.attribution, another.attribution) && Objects.equals(this.dates, another.dates) && Objects.equals(this.version, another.version) && this.id.equals(another.id) && this.dataType.equals((Object)another.dataType) && Objects.equals(this.featureType, another.featureType) && Objects.equals((Object)this.geometryType, (Object)another.geometryType) && Objects.equals(this.theme, another.theme) && Objects.equals(this.minTileMatrix, another.minTileMatrix) && Objects.equals(this.maxTileMatrix, another.maxTileMatrix) && Objects.equals(this.minCellSize, another.minCellSize) && Objects.equals(this.maxCellSize, another.maxCellSize) && Objects.equals(this.minScaleDenominator, another.minScaleDenominator) && Objects.equals(this.maxScaleDenominator, another.maxScaleDenominator) && Objects.equals(this.boundingBox, another.boundingBox) && Objects.equals(this.propertiesSchema, another.propertiesSchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.links.hashCode();
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + this.sections.hashCode();
        h += (h << 5) + this.orderedSections.hashCode();
        h += (h << 5) + Booleans.hashCode(this.sectionsFirst);
        h += (h << 5) + this.keywords.hashCode();
        h += (h << 5) + Objects.hashCode(this.publisher);
        h += (h << 5) + Objects.hashCode(this.pointOfContact);
        h += (h << 5) + Objects.hashCode(this.accessConstraints);
        h += (h << 5) + Objects.hashCode(this.license);
        h += (h << 5) + Objects.hashCode(this.attribution);
        h += (h << 5) + Objects.hashCode(this.dates);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.dataType.hashCode();
        h += (h << 5) + Objects.hashCode(this.featureType);
        h += (h << 5) + Objects.hashCode((Object)this.geometryType);
        h += (h << 5) + Objects.hashCode(this.theme);
        h += (h << 5) + Objects.hashCode(this.minTileMatrix);
        h += (h << 5) + Objects.hashCode(this.maxTileMatrix);
        h += (h << 5) + Objects.hashCode(this.minCellSize);
        h += (h << 5) + Objects.hashCode(this.maxCellSize);
        h += (h << 5) + Objects.hashCode(this.minScaleDenominator);
        h += (h << 5) + Objects.hashCode(this.maxScaleDenominator);
        h += (h << 5) + Objects.hashCode(this.boundingBox);
        h += (h << 5) + Objects.hashCode(this.propertiesSchema);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TileLayer").omitNullValues().add("title", this.title).add("description", this.description).add("links", this.links).add("lastModified", this.lastModified).add("sections", this.sections).add("orderedSections", this.orderedSections).add("sectionsFirst", this.sectionsFirst).add("keywords", this.keywords).add("publisher", this.publisher).add("pointOfContact", this.pointOfContact).add("accessConstraints", this.accessConstraints).add("license", this.license).add("attribution", this.attribution).add("dates", this.dates).add("version", this.version).add("id", this.id).add("dataType", (Object)this.dataType).add("featureType", this.featureType).add("geometryType", (Object)this.geometryType).add("theme", this.theme).add("minTileMatrix", this.minTileMatrix).add("maxTileMatrix", this.maxTileMatrix).add("minCellSize", this.minCellSize).add("maxCellSize", this.maxCellSize).add("minScaleDenominator", this.minScaleDenominator).add("maxScaleDenominator", this.maxScaleDenominator).add("boundingBox", this.boundingBox).add("propertiesSchema", this.propertiesSchema).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTileLayer fromJson(Json json) {
        Builder builder = ImmutableTileLayer.builder();
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.links != null) {
            builder.addAllLinks(json.links);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        if (json.sections != null) {
            builder.addAllSections(json.sections);
        }
        if (json.sectionsFirstIsSet) {
            builder.sectionsFirst(json.sectionsFirst);
        }
        if (json.keywords != null) {
            builder.addAllKeywords(json.keywords);
        }
        if (json.publisher != null) {
            builder.publisher(json.publisher);
        }
        if (json.pointOfContact != null) {
            builder.pointOfContact(json.pointOfContact);
        }
        if (json.accessConstraints != null) {
            builder.accessConstraints(json.accessConstraints);
        }
        if (json.license != null) {
            builder.license(json.license);
        }
        if (json.attribution != null) {
            builder.attribution(json.attribution);
        }
        if (json.dates != null) {
            builder.dates(json.dates);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.dataType != null) {
            builder.dataType(json.dataType);
        }
        if (json.featureType != null) {
            builder.featureType(json.featureType);
        }
        if (json.geometryType != null) {
            builder.geometryType(json.geometryType);
        }
        if (json.theme != null) {
            builder.theme(json.theme);
        }
        if (json.minTileMatrix != null) {
            builder.minTileMatrix(json.minTileMatrix);
        }
        if (json.maxTileMatrix != null) {
            builder.maxTileMatrix(json.maxTileMatrix);
        }
        if (json.minCellSize != null) {
            builder.minCellSize(json.minCellSize);
        }
        if (json.maxCellSize != null) {
            builder.maxCellSize(json.maxCellSize);
        }
        if (json.minScaleDenominator != null) {
            builder.minScaleDenominator(json.minScaleDenominator);
        }
        if (json.maxScaleDenominator != null) {
            builder.maxScaleDenominator(json.maxScaleDenominator);
        }
        if (json.boundingBox != null) {
            builder.boundingBox(json.boundingBox);
        }
        if (json.propertiesSchema != null) {
            builder.propertiesSchema(json.propertiesSchema);
        }
        return builder.build();
    }

    public static ImmutableTileLayer copyOf(TileLayer instance) {
        if (instance instanceof ImmutableTileLayer) {
            return (ImmutableTileLayer)instance;
        }
        return ImmutableTileLayer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TileLayer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_DATA_TYPE = 2L;
        private static final long OPT_BIT_SECTIONS_FIRST = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String title;
        @Nullable
        private String description;
        private ImmutableList.Builder<Link> links = ImmutableList.builder();
        @Nullable
        private Date lastModified;
        private ImmutableList.Builder<Map<String, Object>> sections = ImmutableList.builder();
        private boolean sectionsFirst;
        private ImmutableList.Builder<String> keywords = ImmutableList.builder();
        @Nullable
        private String publisher;
        @Nullable
        private String pointOfContact;
        @Nullable
        private String accessConstraints;
        @Nullable
        private String license;
        @Nullable
        private String attribution;
        @Nullable
        private MetadataDates dates;
        @Nullable
        private String version;
        @Nullable
        private String id;
        @Nullable
        private TileSet.DataType dataType;
        @Nullable
        private String featureType;
        @Nullable
        private TileLayer.GeometryType geometryType;
        @Nullable
        private String theme;
        @Nullable
        private String minTileMatrix;
        @Nullable
        private String maxTileMatrix;
        @Nullable
        private Double minCellSize;
        @Nullable
        private Double maxCellSize;
        @Nullable
        private Double minScaleDenominator;
        @Nullable
        private Double maxScaleDenominator;
        @Nullable
        private TilesBoundingBox boundingBox;
        @Nullable
        private JsonSchemaObject propertiesSchema;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TileLayer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PageRepresentation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Metadata2 instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageRepresentation instance;
            if (object instanceof TileLayer) {
                Optional<TileLayer.GeometryType> geometryTypeOptional;
                Optional<Double> minCellSizeOptional;
                Optional<String> themeOptional;
                Optional<String> featureTypeOptional;
                Optional<Double> maxCellSizeOptional;
                Optional<Double> minScaleDenominatorOptional;
                Optional<Double> maxScaleDenominatorOptional;
                Optional<String> maxTileMatrixOptional;
                instance = (TileLayer)object;
                Optional<TilesBoundingBox> boundingBoxOptional = ((TileLayer)instance).getBoundingBox();
                if (boundingBoxOptional.isPresent()) {
                    this.boundingBox(boundingBoxOptional);
                }
                this.dataType(((TileLayer)instance).getDataType());
                Optional<JsonSchemaObject> propertiesSchemaOptional = ((TileLayer)instance).getPropertiesSchema();
                if (propertiesSchemaOptional.isPresent()) {
                    this.propertiesSchema(propertiesSchemaOptional);
                }
                if ((maxTileMatrixOptional = ((TileLayer)instance).getMaxTileMatrix()).isPresent()) {
                    this.maxTileMatrix(maxTileMatrixOptional);
                }
                if ((maxScaleDenominatorOptional = ((TileLayer)instance).getMaxScaleDenominator()).isPresent()) {
                    this.maxScaleDenominator(maxScaleDenominatorOptional);
                }
                if ((minScaleDenominatorOptional = ((TileLayer)instance).getMinScaleDenominator()).isPresent()) {
                    this.minScaleDenominator(minScaleDenominatorOptional);
                }
                if ((maxCellSizeOptional = ((TileLayer)instance).getMaxCellSize()).isPresent()) {
                    this.maxCellSize(maxCellSizeOptional);
                }
                if ((featureTypeOptional = ((TileLayer)instance).getFeatureType()).isPresent()) {
                    this.featureType(featureTypeOptional);
                }
                if ((themeOptional = ((TileLayer)instance).getTheme()).isPresent()) {
                    this.theme(themeOptional);
                }
                if ((minCellSizeOptional = ((TileLayer)instance).getMinCellSize()).isPresent()) {
                    this.minCellSize(minCellSizeOptional);
                }
                this.id(((TileLayer)instance).getId());
                Optional<String> minTileMatrixOptional = ((TileLayer)instance).getMinTileMatrix();
                if (minTileMatrixOptional.isPresent()) {
                    this.minTileMatrix(minTileMatrixOptional);
                }
                if ((geometryTypeOptional = ((TileLayer)instance).getGeometryType()).isPresent()) {
                    this.geometryType(geometryTypeOptional);
                }
            }
            if (object instanceof PageRepresentation) {
                Optional<String> titleOptional;
                instance = (PageRepresentation)object;
                Optional<String> descriptionOptional = instance.getDescription();
                if (descriptionOptional.isPresent()) {
                    this.description(descriptionOptional);
                }
                this.addAllLinks(instance.getLinks());
                Optional<Date> lastModifiedOptional = instance.getLastModified();
                if (lastModifiedOptional.isPresent()) {
                    this.lastModified(lastModifiedOptional);
                }
                if ((titleOptional = instance.getTitle()).isPresent()) {
                    this.title(titleOptional);
                }
                this.addAllSections(instance.getSections());
                this.sectionsFirst(instance.getSectionsFirst());
            }
            if (object instanceof Metadata2) {
                Optional<String> pointOfContactOptional;
                Optional<String> versionOptional;
                Optional<String> accessConstraintsOptional;
                Optional<MetadataDates> datesOptional;
                Optional<String> publisherOptional;
                instance = (Metadata2)object;
                Optional<String> licenseOptional = ((Metadata2)instance).getLicense();
                if (licenseOptional.isPresent()) {
                    this.license(licenseOptional);
                }
                this.addAllKeywords(((Metadata2)instance).getKeywords());
                Optional<String> attributionOptional = ((Metadata2)instance).getAttribution();
                if (attributionOptional.isPresent()) {
                    this.attribution(attributionOptional);
                }
                if ((publisherOptional = ((Metadata2)instance).getPublisher()).isPresent()) {
                    this.publisher(publisherOptional);
                }
                if ((datesOptional = ((Metadata2)instance).getDates()).isPresent()) {
                    this.dates(datesOptional);
                }
                if ((accessConstraintsOptional = ((Metadata2)instance).getAccessConstraints()).isPresent()) {
                    this.accessConstraints(accessConstraintsOptional);
                }
                if ((versionOptional = ((Metadata2)instance).getVersion()).isPresent()) {
                    this.version(versionOptional);
                }
                if ((pointOfContactOptional = ((Metadata2)instance).getPointOfContact()).isPresent()) {
                    this.pointOfContact(pointOfContactOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        @JsonProperty(value="title")
        @CanIgnoreReturnValue
        public final Builder title(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link element) {
            element = ImmutableLink.copyOf(element);
            this.links.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addLinks(Link ... elements) {
            for (Link element : elements) {
                element = ImmutableLink.copyOf(element);
                this.links.add((Object)Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @JsonProperty(value="links")
        @CanIgnoreReturnValue
        public final Builder links(Iterable<? extends Link> elements) {
            this.links = ImmutableList.builder();
            return this.addAllLinks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllLinks(Iterable<? extends Link> elements) {
            for (Link link : elements) {
                ImmutableLink immutableLink = ImmutableLink.copyOf(link);
                this.links.add((Object)Objects.requireNonNull(immutableLink, "links element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastModified(Date lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            return this;
        }

        @JsonProperty(value="lastModified")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder lastModified(Optional<? extends Date> lastModified) {
            this.lastModified = lastModified.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> element) {
            this.sections.add((Object)element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addSections(Map<String, Object> ... elements) {
            this.sections.add(elements);
            return this;
        }

        @JsonProperty(value="sections")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sections(Iterable<? extends Map<String, Object>> elements) {
            this.sections = ImmutableList.builder();
            return this.addAllSections(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSections(Iterable<? extends Map<String, Object>> elements) {
            this.sections.addAll(elements);
            return this;
        }

        @JsonProperty(value="sectionsFirst")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String element) {
            this.keywords.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeywords(String ... elements) {
            this.keywords.add(elements);
            return this;
        }

        @JsonProperty(value="keywords")
        @CanIgnoreReturnValue
        public final Builder keywords(Iterable<String> elements) {
            this.keywords = ImmutableList.builder();
            return this.addAllKeywords(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeywords(Iterable<String> elements) {
            this.keywords.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publisher(String publisher) {
            this.publisher = Objects.requireNonNull(publisher, "publisher");
            return this;
        }

        @JsonProperty(value="publisher")
        @CanIgnoreReturnValue
        public final Builder publisher(Optional<String> publisher) {
            this.publisher = publisher.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointOfContact(String pointOfContact) {
            this.pointOfContact = Objects.requireNonNull(pointOfContact, "pointOfContact");
            return this;
        }

        @JsonProperty(value="pointOfContact")
        @CanIgnoreReturnValue
        public final Builder pointOfContact(Optional<String> pointOfContact) {
            this.pointOfContact = pointOfContact.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accessConstraints(String accessConstraints) {
            this.accessConstraints = Objects.requireNonNull(accessConstraints, "accessConstraints");
            return this;
        }

        @JsonProperty(value="accessConstraints")
        @CanIgnoreReturnValue
        public final Builder accessConstraints(Optional<String> accessConstraints) {
            this.accessConstraints = accessConstraints.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder license(String license) {
            this.license = Objects.requireNonNull(license, "license");
            return this;
        }

        @JsonProperty(value="license")
        @CanIgnoreReturnValue
        public final Builder license(Optional<String> license) {
            this.license = license.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attribution(String attribution) {
            this.attribution = Objects.requireNonNull(attribution, "attribution");
            return this;
        }

        @JsonProperty(value="attribution")
        @CanIgnoreReturnValue
        public final Builder attribution(Optional<String> attribution) {
            this.attribution = attribution.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dates(MetadataDates dates) {
            this.dates = Objects.requireNonNull(dates, "dates");
            return this;
        }

        @JsonProperty(value="dates")
        @CanIgnoreReturnValue
        public final Builder dates(Optional<? extends MetadataDates> dates) {
            this.dates = dates.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return this;
        }

        @JsonProperty(value="version")
        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="dataType")
        @CanIgnoreReturnValue
        public final Builder dataType(TileSet.DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureType(String featureType) {
            this.featureType = Objects.requireNonNull(featureType, "featureType");
            return this;
        }

        @JsonProperty(value="featureType")
        @CanIgnoreReturnValue
        public final Builder featureType(Optional<String> featureType) {
            this.featureType = featureType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder geometryType(TileLayer.GeometryType geometryType) {
            this.geometryType = Objects.requireNonNull(geometryType, "geometryType");
            return this;
        }

        @JsonProperty(value="geometryType")
        @CanIgnoreReturnValue
        public final Builder geometryType(Optional<? extends TileLayer.GeometryType> geometryType) {
            this.geometryType = geometryType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder theme(String theme) {
            this.theme = Objects.requireNonNull(theme, "theme");
            return this;
        }

        @JsonProperty(value="theme")
        @CanIgnoreReturnValue
        public final Builder theme(Optional<String> theme) {
            this.theme = theme.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minTileMatrix(String minTileMatrix) {
            this.minTileMatrix = Objects.requireNonNull(minTileMatrix, "minTileMatrix");
            return this;
        }

        @JsonProperty(value="minTileMatrix")
        @CanIgnoreReturnValue
        public final Builder minTileMatrix(Optional<String> minTileMatrix) {
            this.minTileMatrix = minTileMatrix.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxTileMatrix(String maxTileMatrix) {
            this.maxTileMatrix = Objects.requireNonNull(maxTileMatrix, "maxTileMatrix");
            return this;
        }

        @JsonProperty(value="maxTileMatrix")
        @CanIgnoreReturnValue
        public final Builder maxTileMatrix(Optional<String> maxTileMatrix) {
            this.maxTileMatrix = maxTileMatrix.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minCellSize(double minCellSize) {
            this.minCellSize = minCellSize;
            return this;
        }

        @JsonProperty(value="minCellSize")
        @CanIgnoreReturnValue
        public final Builder minCellSize(Optional<Double> minCellSize) {
            this.minCellSize = minCellSize.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxCellSize(double maxCellSize) {
            this.maxCellSize = maxCellSize;
            return this;
        }

        @JsonProperty(value="maxCellSize")
        @CanIgnoreReturnValue
        public final Builder maxCellSize(Optional<Double> maxCellSize) {
            this.maxCellSize = maxCellSize.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder minScaleDenominator(double minScaleDenominator) {
            this.minScaleDenominator = minScaleDenominator;
            return this;
        }

        @JsonProperty(value="minScaleDenominator")
        @CanIgnoreReturnValue
        public final Builder minScaleDenominator(Optional<Double> minScaleDenominator) {
            this.minScaleDenominator = minScaleDenominator.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxScaleDenominator(double maxScaleDenominator) {
            this.maxScaleDenominator = maxScaleDenominator;
            return this;
        }

        @JsonProperty(value="maxScaleDenominator")
        @CanIgnoreReturnValue
        public final Builder maxScaleDenominator(Optional<Double> maxScaleDenominator) {
            this.maxScaleDenominator = maxScaleDenominator.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder boundingBox(TilesBoundingBox boundingBox) {
            this.boundingBox = Objects.requireNonNull(boundingBox, "boundingBox");
            return this;
        }

        @JsonProperty(value="boundingBox")
        @CanIgnoreReturnValue
        public final Builder boundingBox(Optional<? extends TilesBoundingBox> boundingBox) {
            this.boundingBox = boundingBox.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder propertiesSchema(JsonSchemaObject propertiesSchema) {
            this.propertiesSchema = Objects.requireNonNull(propertiesSchema, "propertiesSchema");
            return this;
        }

        @JsonProperty(value="propertiesSchema")
        @CanIgnoreReturnValue
        public final Builder propertiesSchema(Optional<? extends JsonSchemaObject> propertiesSchema) {
            this.propertiesSchema = propertiesSchema.orElse(null);
            return this;
        }

        public ImmutableTileLayer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTileLayer(this);
        }

        private boolean sectionsFirstIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dataType");
            }
            return "Cannot build TileLayer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TileLayer", generator="Immutables")
    static final class Json
    extends TileLayer {
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        List<Link> links = ImmutableList.of();
        @Nullable
        Optional<Date> lastModified = Optional.empty();
        @Nullable
        List<Map<String, Object>> sections = ImmutableList.of();
        boolean sectionsFirst;
        boolean sectionsFirstIsSet;
        @Nullable
        List<String> keywords = ImmutableList.of();
        @Nullable
        Optional<String> publisher = Optional.empty();
        @Nullable
        Optional<String> pointOfContact = Optional.empty();
        @Nullable
        Optional<String> accessConstraints = Optional.empty();
        @Nullable
        Optional<String> license = Optional.empty();
        @Nullable
        Optional<String> attribution = Optional.empty();
        @Nullable
        Optional<MetadataDates> dates = Optional.empty();
        @Nullable
        Optional<String> version = Optional.empty();
        @Nullable
        String id;
        @Nullable
        TileSet.DataType dataType;
        @Nullable
        Optional<String> featureType = Optional.empty();
        @Nullable
        Optional<TileLayer.GeometryType> geometryType = Optional.empty();
        @Nullable
        Optional<String> theme = Optional.empty();
        @Nullable
        Optional<String> minTileMatrix = Optional.empty();
        @Nullable
        Optional<String> maxTileMatrix = Optional.empty();
        @Nullable
        Optional<Double> minCellSize = Optional.empty();
        @Nullable
        Optional<Double> maxCellSize = Optional.empty();
        @Nullable
        Optional<Double> minScaleDenominator = Optional.empty();
        @Nullable
        Optional<Double> maxScaleDenominator = Optional.empty();
        @Nullable
        Optional<TilesBoundingBox> boundingBox = Optional.empty();
        @Nullable
        Optional<JsonSchemaObject> propertiesSchema = Optional.empty();

        Json() {
        }

        @JsonProperty(value="title")
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="links")
        public void setLinks(List<Link> links) {
            this.links = links;
        }

        @JsonProperty(value="lastModified")
        @JsonIgnore
        public void setLastModified(Optional<Date> lastModified) {
            this.lastModified = lastModified;
        }

        @JsonProperty(value="sections")
        @JsonIgnore
        public void setSections(List<Map<String, Object>> sections) {
            this.sections = sections;
        }

        @JsonProperty(value="sectionsFirst")
        @JsonIgnore
        public void setSectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.sectionsFirstIsSet = true;
        }

        @JsonProperty(value="keywords")
        public void setKeywords(List<String> keywords) {
            this.keywords = keywords;
        }

        @JsonProperty(value="publisher")
        public void setPublisher(Optional<String> publisher) {
            this.publisher = publisher;
        }

        @JsonProperty(value="pointOfContact")
        public void setPointOfContact(Optional<String> pointOfContact) {
            this.pointOfContact = pointOfContact;
        }

        @JsonProperty(value="accessConstraints")
        public void setAccessConstraints(Optional<String> accessConstraints) {
            this.accessConstraints = accessConstraints;
        }

        @JsonProperty(value="license")
        public void setLicense(Optional<String> license) {
            this.license = license;
        }

        @JsonProperty(value="attribution")
        public void setAttribution(Optional<String> attribution) {
            this.attribution = attribution;
        }

        @JsonProperty(value="dates")
        public void setDates(Optional<MetadataDates> dates) {
            this.dates = dates;
        }

        @JsonProperty(value="version")
        public void setVersion(Optional<String> version) {
            this.version = version;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="dataType")
        public void setDataType(TileSet.DataType dataType) {
            this.dataType = dataType;
        }

        @JsonProperty(value="featureType")
        public void setFeatureType(Optional<String> featureType) {
            this.featureType = featureType;
        }

        @JsonProperty(value="geometryType")
        public void setGeometryType(Optional<TileLayer.GeometryType> geometryType) {
            this.geometryType = geometryType;
        }

        @JsonProperty(value="theme")
        public void setTheme(Optional<String> theme) {
            this.theme = theme;
        }

        @JsonProperty(value="minTileMatrix")
        public void setMinTileMatrix(Optional<String> minTileMatrix) {
            this.minTileMatrix = minTileMatrix;
        }

        @JsonProperty(value="maxTileMatrix")
        public void setMaxTileMatrix(Optional<String> maxTileMatrix) {
            this.maxTileMatrix = maxTileMatrix;
        }

        @JsonProperty(value="minCellSize")
        public void setMinCellSize(Optional<Double> minCellSize) {
            this.minCellSize = minCellSize;
        }

        @JsonProperty(value="maxCellSize")
        public void setMaxCellSize(Optional<Double> maxCellSize) {
            this.maxCellSize = maxCellSize;
        }

        @JsonProperty(value="minScaleDenominator")
        public void setMinScaleDenominator(Optional<Double> minScaleDenominator) {
            this.minScaleDenominator = minScaleDenominator;
        }

        @JsonProperty(value="maxScaleDenominator")
        public void setMaxScaleDenominator(Optional<Double> maxScaleDenominator) {
            this.maxScaleDenominator = maxScaleDenominator;
        }

        @JsonProperty(value="boundingBox")
        public void setBoundingBox(Optional<TilesBoundingBox> boundingBox) {
            this.boundingBox = boundingBox;
        }

        @JsonProperty(value="propertiesSchema")
        public void setPropertiesSchema(Optional<JsonSchemaObject> propertiesSchema) {
            this.propertiesSchema = propertiesSchema;
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Link> getLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Date> getLastModified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Map<String, Object>> getSections() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public List<Map<String, Object>> getOrderedSections() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getSectionsFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getKeywords() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPublisher() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPointOfContact() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAccessConstraints() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLicense() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAttribution() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<MetadataDates> getDates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TileSet.DataType getDataType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getFeatureType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TileLayer.GeometryType> getGeometryType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTheme() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getMinTileMatrix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getMaxTileMatrix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Double> getMinCellSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Double> getMaxCellSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Double> getMinScaleDenominator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Double> getMaxScaleDenominator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TilesBoundingBox> getBoundingBox() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<JsonSchemaObject> getPropertiesSchema() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="TileLayer", generator="Immutables")
    private final class InitShim {
        private byte orderedSectionsBuildStage = 0;
        private List<Map<String, Object>> orderedSections;
        private byte sectionsFirstBuildStage = 0;
        private boolean sectionsFirst;

        private InitShim() {
        }

        List<Map<String, Object>> getOrderedSections() {
            if (this.orderedSectionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.orderedSectionsBuildStage == 0) {
                this.orderedSectionsBuildStage = (byte)-1;
                this.orderedSections = Objects.requireNonNull(ImmutableTileLayer.super.getOrderedSections(), "orderedSections");
                this.orderedSectionsBuildStage = 1;
            }
            return this.orderedSections;
        }

        boolean getSectionsFirst() {
            if (this.sectionsFirstBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sectionsFirstBuildStage == 0) {
                this.sectionsFirstBuildStage = (byte)-1;
                this.sectionsFirst = ImmutableTileLayer.super.getSectionsFirst();
                this.sectionsFirstBuildStage = 1;
            }
            return this.sectionsFirst;
        }

        void sectionsFirst(boolean sectionsFirst) {
            this.sectionsFirst = sectionsFirst;
            this.sectionsFirstBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.orderedSectionsBuildStage == -1) {
                attributes.add("orderedSections");
            }
            if (this.sectionsFirstBuildStage == -1) {
                attributes.add("sectionsFirst");
            }
            return "Cannot build TileLayer, attribute initializers form cycle " + attributes;
        }
    }
}

