/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.foundation.domain.ImmutableOgcApiDataV2;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.tiles.domain.Tile;
import de.ii.ogcapi.tiles.domain.TileFormatExtension;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSet;
import de.ii.xtraplatform.crs.domain.ImmutableBoundingBox;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;
import shadow.org.locationtech.jts.geom.util.AffineTransformation;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Tile", generator="Immutables")
@Immutable
public final class ImmutableTile
extends Tile {
    private final TileMatrixSet tileMatrixSet;
    private final int tileLevel;
    private final int tileRow;
    private final int tileCol;
    private final ImmutableList<String> collectionIds;
    private final ImmutableOgcApiDataV2 apiData;
    @Nullable
    private final FeatureProvider2 featureProvider;
    private final TileFormatExtension outputFormat;
    private final boolean temporary;
    private final boolean isDatasetTile;
    @Nullable
    private final transient String collectionId;
    private final transient Path relativePath;
    private final transient AffineTransformation createTransformNativeToTile;
    private final transient ImmutableBoundingBox boundingBox;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTile(TileMatrixSet tileMatrixSet, int tileLevel, int tileRow, int tileCol, ImmutableList<String> collectionIds, ImmutableOgcApiDataV2 apiData, @Nullable FeatureProvider2 featureProvider, TileFormatExtension outputFormat, boolean temporary, boolean isDatasetTile) {
        this.tileMatrixSet = tileMatrixSet;
        this.tileLevel = tileLevel;
        this.tileRow = tileRow;
        this.tileCol = tileCol;
        this.collectionIds = collectionIds;
        this.apiData = apiData;
        this.featureProvider = featureProvider;
        this.outputFormat = outputFormat;
        this.temporary = temporary;
        this.isDatasetTile = isDatasetTile;
        this.collectionId = this.initShim.getCollectionId();
        this.relativePath = this.initShim.getRelativePath();
        this.createTransformNativeToTile = this.initShim.createTransformNativeToTile();
        this.boundingBox = this.initShim.getBoundingBox();
        this.initShim = null;
    }

    @Override
    public TileMatrixSet getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    @Override
    public int getTileLevel() {
        return this.tileLevel;
    }

    @Override
    public int getTileRow() {
        return this.tileRow;
    }

    @Override
    public int getTileCol() {
        return this.tileCol;
    }

    public ImmutableList<String> getCollectionIds() {
        return this.collectionIds;
    }

    @Override
    public ImmutableOgcApiDataV2 getApiData() {
        return this.apiData;
    }

    @Override
    public Optional<FeatureProvider2> getFeatureProvider() {
        return Optional.ofNullable(this.featureProvider);
    }

    @Override
    public TileFormatExtension getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public boolean getTemporary() {
        return this.temporary;
    }

    @Override
    public boolean isDatasetTile() {
        return this.isDatasetTile;
    }

    @Override
    @Nullable
    public String getCollectionId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCollectionId() : this.collectionId;
    }

    @Override
    public Path getRelativePath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRelativePath() : this.relativePath;
    }

    @Override
    public AffineTransformation createTransformNativeToTile() {
        InitShim shim = this.initShim;
        return shim != null ? shim.createTransformNativeToTile() : this.createTransformNativeToTile;
    }

    @Override
    public ImmutableBoundingBox getBoundingBox() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBoundingBox() : this.boundingBox;
    }

    public final ImmutableTile withTileMatrixSet(TileMatrixSet value) {
        if (this.tileMatrixSet == value) {
            return this;
        }
        TileMatrixSet newValue = Objects.requireNonNull(value, "tileMatrixSet");
        return new ImmutableTile(newValue, this.tileLevel, this.tileRow, this.tileCol, this.collectionIds, this.apiData, this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withTileLevel(int value) {
        if (this.tileLevel == value) {
            return this;
        }
        return new ImmutableTile(this.tileMatrixSet, value, this.tileRow, this.tileCol, this.collectionIds, this.apiData, this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withTileRow(int value) {
        if (this.tileRow == value) {
            return this;
        }
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, value, this.tileCol, this.collectionIds, this.apiData, this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withTileCol(int value) {
        if (this.tileCol == value) {
            return this;
        }
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, value, this.collectionIds, this.apiData, this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withCollectionIds(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, newValue, this.apiData, this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withCollectionIds(Iterable<String> elements) {
        if (this.collectionIds == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, newValue, this.apiData, this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withApiData(OgcApiDataV2 value) {
        if (this.apiData == value) {
            return this;
        }
        ImmutableOgcApiDataV2 newValue = ImmutableOgcApiDataV2.copyOf(value);
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, this.collectionIds, newValue, this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withFeatureProvider(FeatureProvider2 value) {
        FeatureProvider2 newValue = Objects.requireNonNull(value, "featureProvider");
        if (this.featureProvider == newValue) {
            return this;
        }
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, this.collectionIds, this.apiData, newValue, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withFeatureProvider(Optional<? extends FeatureProvider2> optional) {
        FeatureProvider2 value = optional.orElse(null);
        if (this.featureProvider == value) {
            return this;
        }
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, this.collectionIds, this.apiData, value, this.outputFormat, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withOutputFormat(TileFormatExtension value) {
        if (this.outputFormat == value) {
            return this;
        }
        TileFormatExtension newValue = Objects.requireNonNull(value, "outputFormat");
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, this.collectionIds, this.apiData, this.featureProvider, newValue, this.temporary, this.isDatasetTile);
    }

    public final ImmutableTile withTemporary(boolean value) {
        if (this.temporary == value) {
            return this;
        }
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, this.collectionIds, this.apiData, this.featureProvider, this.outputFormat, value, this.isDatasetTile);
    }

    public final ImmutableTile withIsDatasetTile(boolean value) {
        if (this.isDatasetTile == value) {
            return this;
        }
        return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, this.collectionIds, this.apiData, this.featureProvider, this.outputFormat, this.temporary, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTile && this.equalTo((ImmutableTile)another);
    }

    private boolean equalTo(ImmutableTile another) {
        return this.tileMatrixSet.equals(another.tileMatrixSet) && this.tileLevel == another.tileLevel && this.tileRow == another.tileRow && this.tileCol == another.tileCol && this.collectionIds.equals(another.collectionIds) && this.apiData.equals(another.apiData) && Objects.equals(this.featureProvider, another.featureProvider) && this.outputFormat.equals(another.outputFormat) && this.temporary == another.temporary && this.isDatasetTile == another.isDatasetTile;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tileMatrixSet.hashCode();
        h += (h << 5) + this.tileLevel;
        h += (h << 5) + this.tileRow;
        h += (h << 5) + this.tileCol;
        h += (h << 5) + this.collectionIds.hashCode();
        h += (h << 5) + this.apiData.hashCode();
        h += (h << 5) + Objects.hashCode(this.featureProvider);
        h += (h << 5) + this.outputFormat.hashCode();
        h += (h << 5) + Booleans.hashCode(this.temporary);
        h += (h << 5) + Booleans.hashCode(this.isDatasetTile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Tile").omitNullValues().add("tileMatrixSet", this.tileMatrixSet).add("tileLevel", this.tileLevel).add("tileRow", this.tileRow).add("tileCol", this.tileCol).add("collectionIds", this.collectionIds).add("apiData", this.apiData).add("featureProvider", this.featureProvider).add("outputFormat", this.outputFormat).add("temporary", this.temporary).add("isDatasetTile", this.isDatasetTile).toString();
    }

    public static ImmutableTile copyOf(Tile instance) {
        if (instance instanceof ImmutableTile) {
            return (ImmutableTile)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Tile", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TILE_MATRIX_SET = 1L;
        private static final long INIT_BIT_TILE_LEVEL = 2L;
        private static final long INIT_BIT_TILE_ROW = 4L;
        private static final long INIT_BIT_TILE_COL = 8L;
        private static final long INIT_BIT_API_DATA = 16L;
        private static final long INIT_BIT_OUTPUT_FORMAT = 32L;
        private static final long INIT_BIT_TEMPORARY = 64L;
        private static final long INIT_BIT_IS_DATASET_TILE = 128L;
        private long initBits = 255L;
        @Nullable
        private TileMatrixSet tileMatrixSet;
        private int tileLevel;
        private int tileRow;
        private int tileCol;
        private ImmutableList.Builder<String> collectionIds = ImmutableList.builder();
        @Nullable
        private OgcApiDataV2 apiData;
        @Nullable
        private FeatureProvider2 featureProvider;
        @Nullable
        private TileFormatExtension outputFormat;
        private boolean temporary;
        private boolean isDatasetTile;

        @CanIgnoreReturnValue
        public final Builder from(Tile instance) {
            Objects.requireNonNull(instance, "instance");
            this.tileMatrixSet(instance.getTileMatrixSet());
            this.tileLevel(instance.getTileLevel());
            this.tileRow(instance.getTileRow());
            this.tileCol(instance.getTileCol());
            this.addAllCollectionIds(instance.getCollectionIds());
            this.apiData(instance.getApiData());
            Optional<FeatureProvider2> featureProviderOptional = instance.getFeatureProvider();
            if (featureProviderOptional.isPresent()) {
                this.featureProvider(featureProviderOptional);
            }
            this.outputFormat(instance.getOutputFormat());
            this.temporary(instance.getTemporary());
            this.isDatasetTile(instance.isDatasetTile());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileMatrixSet(TileMatrixSet tileMatrixSet) {
            this.tileMatrixSet = Objects.requireNonNull(tileMatrixSet, "tileMatrixSet");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileLevel(int tileLevel) {
            this.tileLevel = tileLevel;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileRow(int tileRow) {
            this.tileRow = tileRow;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tileCol(int tileCol) {
            this.tileCol = tileCol;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCollectionIds(String element) {
            this.collectionIds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCollectionIds(String ... elements) {
            this.collectionIds.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collectionIds(Iterable<String> elements) {
            this.collectionIds = ImmutableList.builder();
            return this.addAllCollectionIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCollectionIds(Iterable<String> elements) {
            this.collectionIds.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiData(OgcApiDataV2 apiData) {
            this.apiData = ImmutableOgcApiDataV2.copyOf(apiData);
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureProvider(FeatureProvider2 featureProvider) {
            this.featureProvider = Objects.requireNonNull(featureProvider, "featureProvider");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder featureProvider(Optional<? extends FeatureProvider2> featureProvider) {
            this.featureProvider = featureProvider.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputFormat(TileFormatExtension outputFormat) {
            this.outputFormat = Objects.requireNonNull(outputFormat, "outputFormat");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder temporary(boolean temporary) {
            this.temporary = temporary;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isDatasetTile(boolean isDatasetTile) {
            this.isDatasetTile = isDatasetTile;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableTile build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTile(this.tileMatrixSet, this.tileLevel, this.tileRow, this.tileCol, (ImmutableList<String>)this.collectionIds.build(), ImmutableOgcApiDataV2.copyOf(this.apiData), this.featureProvider, this.outputFormat, this.temporary, this.isDatasetTile);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tileMatrixSet");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tileLevel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("tileRow");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("tileCol");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("apiData");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("outputFormat");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("temporary");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("isDatasetTile");
            }
            return "Cannot build Tile, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Tile", generator="Immutables")
    private final class InitShim {
        private byte collectionIdBuildStage = 0;
        private String collectionId;
        private byte relativePathBuildStage = 0;
        private Path relativePath;
        private byte createTransformNativeToTileBuildStage = 0;
        private AffineTransformation createTransformNativeToTile;
        private byte boundingBoxBuildStage = 0;
        private ImmutableBoundingBox boundingBox;

        private InitShim() {
        }

        String getCollectionId() {
            if (this.collectionIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.collectionIdBuildStage == 0) {
                this.collectionIdBuildStage = (byte)-1;
                this.collectionId = ImmutableTile.super.getCollectionId();
                this.collectionIdBuildStage = 1;
            }
            return this.collectionId;
        }

        Path getRelativePath() {
            if (this.relativePathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relativePathBuildStage == 0) {
                this.relativePathBuildStage = (byte)-1;
                this.relativePath = Objects.requireNonNull(ImmutableTile.super.getRelativePath(), "relativePath");
                this.relativePathBuildStage = 1;
            }
            return this.relativePath;
        }

        AffineTransformation createTransformNativeToTile() {
            if (this.createTransformNativeToTileBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.createTransformNativeToTileBuildStage == 0) {
                this.createTransformNativeToTileBuildStage = (byte)-1;
                this.createTransformNativeToTile = Objects.requireNonNull(ImmutableTile.super.createTransformNativeToTile(), "createTransformNativeToTile");
                this.createTransformNativeToTileBuildStage = 1;
            }
            return this.createTransformNativeToTile;
        }

        ImmutableBoundingBox getBoundingBox() {
            if (this.boundingBoxBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.boundingBoxBuildStage == 0) {
                this.boundingBoxBuildStage = (byte)-1;
                this.boundingBox = ImmutableBoundingBox.copyOf(ImmutableTile.super.getBoundingBox());
                this.boundingBoxBuildStage = 1;
            }
            return this.boundingBox;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.collectionIdBuildStage == -1) {
                attributes.add("collectionId");
            }
            if (this.relativePathBuildStage == -1) {
                attributes.add("relativePath");
            }
            if (this.createTransformNativeToTileBuildStage == -1) {
                attributes.add("createTransformNativeToTile");
            }
            if (this.boundingBoxBuildStage == -1) {
                attributes.add("boundingBox");
            }
            return "Cannot build Tile, attribute initializers form cycle " + attributes;
        }
    }
}

