/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.tiles.domain.SeedingOptions;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SeedingOptions", generator="Immutables")
@Immutable
public final class ImmutableSeedingOptions
implements SeedingOptions {
    @Nullable
    private final Boolean runOnStartup;
    @Nullable
    private final String runPeriodic;
    @Nullable
    private final Boolean purge;
    @Nullable
    private final Integer maxThreads;
    private volatile transient long lazyInitBitmap;
    private static final long SHOULD_RUN_ON_STARTUP_LAZY_INIT_BIT = 1L;
    private transient boolean shouldRunOnStartup;
    private static final long SHOULD_RUN_PERIODIC_LAZY_INIT_BIT = 2L;
    private transient boolean shouldRunPeriodic;
    private static final long CRON_EXPRESSION_LAZY_INIT_BIT = 4L;
    private transient Optional<String> cronExpression;
    private static final long SHOULD_PURGE_LAZY_INIT_BIT = 8L;
    private transient boolean shouldPurge;
    private static final long EFFECTIVE_MAX_THREADS_LAZY_INIT_BIT = 16L;
    private transient int effectiveMaxThreads;

    private ImmutableSeedingOptions(@Nullable Boolean runOnStartup, @Nullable String runPeriodic, @Nullable Boolean purge, @Nullable Integer maxThreads) {
        this.runOnStartup = runOnStartup;
        this.runPeriodic = runPeriodic;
        this.purge = purge;
        this.maxThreads = maxThreads;
    }

    @Override
    @JsonProperty(value="runOnStartup")
    @Nullable
    public Boolean getRunOnStartup() {
        return this.runOnStartup;
    }

    @Override
    @JsonProperty(value="runPeriodic")
    @Nullable
    public String getRunPeriodic() {
        return this.runPeriodic;
    }

    @Override
    @JsonProperty(value="purge")
    @Nullable
    public Boolean getPurge() {
        return this.purge;
    }

    @Override
    @JsonProperty(value="maxThreads")
    @Nullable
    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public final ImmutableSeedingOptions withRunOnStartup(@Nullable Boolean value) {
        if (Objects.equals(this.runOnStartup, value)) {
            return this;
        }
        return new ImmutableSeedingOptions(value, this.runPeriodic, this.purge, this.maxThreads);
    }

    public final ImmutableSeedingOptions withRunPeriodic(@Nullable String value) {
        if (Objects.equals(this.runPeriodic, value)) {
            return this;
        }
        return new ImmutableSeedingOptions(this.runOnStartup, value, this.purge, this.maxThreads);
    }

    public final ImmutableSeedingOptions withPurge(@Nullable Boolean value) {
        if (Objects.equals(this.purge, value)) {
            return this;
        }
        return new ImmutableSeedingOptions(this.runOnStartup, this.runPeriodic, value, this.maxThreads);
    }

    public final ImmutableSeedingOptions withMaxThreads(@Nullable Integer value) {
        if (Objects.equals(this.maxThreads, value)) {
            return this;
        }
        return new ImmutableSeedingOptions(this.runOnStartup, this.runPeriodic, this.purge, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSeedingOptions && this.equalTo((ImmutableSeedingOptions)another);
    }

    private boolean equalTo(ImmutableSeedingOptions another) {
        return Objects.equals(this.runOnStartup, another.runOnStartup) && Objects.equals(this.runPeriodic, another.runPeriodic) && Objects.equals(this.purge, another.purge) && Objects.equals(this.maxThreads, another.maxThreads);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.runOnStartup);
        h += (h << 5) + Objects.hashCode(this.runPeriodic);
        h += (h << 5) + Objects.hashCode(this.purge);
        h += (h << 5) + Objects.hashCode(this.maxThreads);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SeedingOptions").omitNullValues().add("runOnStartup", this.runOnStartup).add("runPeriodic", this.runPeriodic).add("purge", this.purge).add("maxThreads", this.maxThreads).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldRunOnStartup() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableSeedingOptions immutableSeedingOptions = this;
            synchronized (immutableSeedingOptions) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.shouldRunOnStartup = SeedingOptions.super.shouldRunOnStartup();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.shouldRunOnStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldRunPeriodic() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableSeedingOptions immutableSeedingOptions = this;
            synchronized (immutableSeedingOptions) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.shouldRunPeriodic = SeedingOptions.super.shouldRunPeriodic();
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.shouldRunPeriodic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getCronExpression() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableSeedingOptions immutableSeedingOptions = this;
            synchronized (immutableSeedingOptions) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.cronExpression = Objects.requireNonNull(SeedingOptions.super.getCronExpression(), "cronExpression");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.cronExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldPurge() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableSeedingOptions immutableSeedingOptions = this;
            synchronized (immutableSeedingOptions) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.shouldPurge = SeedingOptions.super.shouldPurge();
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.shouldPurge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEffectiveMaxThreads() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableSeedingOptions immutableSeedingOptions = this;
            synchronized (immutableSeedingOptions) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.effectiveMaxThreads = SeedingOptions.super.getEffectiveMaxThreads();
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.effectiveMaxThreads;
    }

    public static ImmutableSeedingOptions copyOf(SeedingOptions instance) {
        if (instance instanceof ImmutableSeedingOptions) {
            return (ImmutableSeedingOptions)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="SeedingOptions", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean runOnStartup;
        @Nullable
        private String runPeriodic;
        @Nullable
        private Boolean purge;
        @Nullable
        private Integer maxThreads;

        @CanIgnoreReturnValue
        public final Builder from(SeedingOptions instance) {
            Integer maxThreadsValue;
            Boolean purgeValue;
            String runPeriodicValue;
            Objects.requireNonNull(instance, "instance");
            Boolean runOnStartupValue = instance.getRunOnStartup();
            if (runOnStartupValue != null) {
                this.runOnStartup(runOnStartupValue);
            }
            if ((runPeriodicValue = instance.getRunPeriodic()) != null) {
                this.runPeriodic(runPeriodicValue);
            }
            if ((purgeValue = instance.getPurge()) != null) {
                this.purge(purgeValue);
            }
            if ((maxThreadsValue = instance.getMaxThreads()) != null) {
                this.maxThreads(maxThreadsValue);
            }
            return this;
        }

        @JsonProperty(value="runOnStartup")
        @CanIgnoreReturnValue
        public final Builder runOnStartup(@Nullable Boolean runOnStartup) {
            this.runOnStartup = runOnStartup;
            return this;
        }

        @JsonProperty(value="runPeriodic")
        @CanIgnoreReturnValue
        public final Builder runPeriodic(@Nullable String runPeriodic) {
            this.runPeriodic = runPeriodic;
            return this;
        }

        @JsonProperty(value="purge")
        @CanIgnoreReturnValue
        public final Builder purge(@Nullable Boolean purge) {
            this.purge = purge;
            return this;
        }

        @JsonProperty(value="maxThreads")
        @CanIgnoreReturnValue
        public final Builder maxThreads(@Nullable Integer maxThreads) {
            this.maxThreads = maxThreads;
            return this;
        }

        public ImmutableSeedingOptions build() {
            return new ImmutableSeedingOptions(this.runOnStartup, this.runPeriodic, this.purge, this.maxThreads);
        }
    }
}

