/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.tiles.domain.Rule;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Rule", generator="Immutables")
@Immutable
public final class ImmutableRule
implements Rule {
    private final int min;
    private final int max;
    @Nullable
    private final Boolean merge;
    @Nullable
    private final Boolean reduceInClusters;
    private final ImmutableList<String> groupBy;
    private final ImmutableList<String> properties;

    private ImmutableRule(int min, int max, @Nullable Boolean merge, @Nullable Boolean reduceInClusters, ImmutableList<String> groupBy, ImmutableList<String> properties) {
        this.min = min;
        this.max = max;
        this.merge = merge;
        this.reduceInClusters = reduceInClusters;
        this.groupBy = groupBy;
        this.properties = properties;
    }

    @Override
    @JsonProperty(value="min")
    public int getMin() {
        return this.min;
    }

    @Override
    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    @Override
    @JsonProperty(value="merge")
    public Optional<Boolean> getMerge() {
        return Optional.ofNullable(this.merge);
    }

    @Override
    @JsonProperty(value="reduceInClusters")
    public Optional<Boolean> getReduceInClusters() {
        return Optional.ofNullable(this.reduceInClusters);
    }

    @JsonProperty(value="groupBy")
    public ImmutableList<String> getGroupBy() {
        return this.groupBy;
    }

    @JsonProperty(value="properties")
    public ImmutableList<String> getProperties() {
        return this.properties;
    }

    public final ImmutableRule withMin(int value) {
        if (this.min == value) {
            return this;
        }
        return new ImmutableRule(value, this.max, this.merge, this.reduceInClusters, this.groupBy, this.properties);
    }

    public final ImmutableRule withMax(int value) {
        if (this.max == value) {
            return this;
        }
        return new ImmutableRule(this.min, value, this.merge, this.reduceInClusters, this.groupBy, this.properties);
    }

    public final ImmutableRule withMerge(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.merge, newValue)) {
            return this;
        }
        return new ImmutableRule(this.min, this.max, newValue, this.reduceInClusters, this.groupBy, this.properties);
    }

    public final ImmutableRule withMerge(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.merge, value)) {
            return this;
        }
        return new ImmutableRule(this.min, this.max, value, this.reduceInClusters, this.groupBy, this.properties);
    }

    public final ImmutableRule withReduceInClusters(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.reduceInClusters, newValue)) {
            return this;
        }
        return new ImmutableRule(this.min, this.max, this.merge, newValue, this.groupBy, this.properties);
    }

    public final ImmutableRule withReduceInClusters(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.reduceInClusters, value)) {
            return this;
        }
        return new ImmutableRule(this.min, this.max, this.merge, value, this.groupBy, this.properties);
    }

    public final ImmutableRule withGroupBy(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableRule(this.min, this.max, this.merge, this.reduceInClusters, newValue, this.properties);
    }

    public final ImmutableRule withGroupBy(Iterable<String> elements) {
        if (this.groupBy == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableRule(this.min, this.max, this.merge, this.reduceInClusters, newValue, this.properties);
    }

    public final ImmutableRule withProperties(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableRule(this.min, this.max, this.merge, this.reduceInClusters, this.groupBy, newValue);
    }

    public final ImmutableRule withProperties(Iterable<String> elements) {
        if (this.properties == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableRule(this.min, this.max, this.merge, this.reduceInClusters, this.groupBy, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRule && this.equalTo((ImmutableRule)another);
    }

    private boolean equalTo(ImmutableRule another) {
        return this.min == another.min && this.max == another.max && Objects.equals(this.merge, another.merge) && Objects.equals(this.reduceInClusters, another.reduceInClusters) && this.groupBy.equals(another.groupBy) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.min;
        h += (h << 5) + this.max;
        h += (h << 5) + Objects.hashCode(this.merge);
        h += (h << 5) + Objects.hashCode(this.reduceInClusters);
        h += (h << 5) + this.groupBy.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Rule").omitNullValues().add("min", this.min).add("max", this.max).add("merge", this.merge).add("reduceInClusters", this.reduceInClusters).add("groupBy", this.groupBy).add("properties", this.properties).toString();
    }

    public static ImmutableRule copyOf(Rule instance) {
        if (instance instanceof ImmutableRule) {
            return (ImmutableRule)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="Rule", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MIN = 1L;
        private static final long INIT_BIT_MAX = 2L;
        private long initBits = 3L;
        private int min;
        private int max;
        @Nullable
        private Boolean merge;
        @Nullable
        private Boolean reduceInClusters;
        private ImmutableList.Builder<String> groupBy = ImmutableList.builder();
        private ImmutableList.Builder<String> properties = ImmutableList.builder();

        @CanIgnoreReturnValue
        public final Builder from(Rule instance) {
            Optional<Boolean> reduceInClustersOptional;
            Objects.requireNonNull(instance, "instance");
            this.min(instance.getMin());
            this.max(instance.getMax());
            Optional<Boolean> mergeOptional = instance.getMerge();
            if (mergeOptional.isPresent()) {
                this.merge(mergeOptional);
            }
            if ((reduceInClustersOptional = instance.getReduceInClusters()).isPresent()) {
                this.reduceInClusters(reduceInClustersOptional);
            }
            this.addAllGroupBy(instance.getGroupBy());
            this.addAllProperties(instance.getProperties());
            return this;
        }

        @JsonProperty(value="min")
        @CanIgnoreReturnValue
        public final Builder min(int min) {
            this.min = min;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="max")
        @CanIgnoreReturnValue
        public final Builder max(int max) {
            this.max = max;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder merge(boolean merge) {
            this.merge = merge;
            return this;
        }

        @JsonProperty(value="merge")
        @CanIgnoreReturnValue
        public final Builder merge(Optional<Boolean> merge) {
            this.merge = merge.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reduceInClusters(boolean reduceInClusters) {
            this.reduceInClusters = reduceInClusters;
            return this;
        }

        @JsonProperty(value="reduceInClusters")
        @CanIgnoreReturnValue
        public final Builder reduceInClusters(Optional<Boolean> reduceInClusters) {
            this.reduceInClusters = reduceInClusters.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGroupBy(String element) {
            this.groupBy.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addGroupBy(String ... elements) {
            this.groupBy.add(elements);
            return this;
        }

        @JsonProperty(value="groupBy")
        @CanIgnoreReturnValue
        public final Builder groupBy(Iterable<String> elements) {
            this.groupBy = ImmutableList.builder();
            return this.addAllGroupBy(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllGroupBy(Iterable<String> elements) {
            this.groupBy.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(String element) {
            this.properties.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProperties(String ... elements) {
            this.properties.add(elements);
            return this;
        }

        @JsonProperty(value="properties")
        @CanIgnoreReturnValue
        public final Builder properties(Iterable<String> elements) {
            this.properties = ImmutableList.builder();
            return this.addAllProperties(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProperties(Iterable<String> elements) {
            this.properties.addAll((Iterable)elements);
            return this;
        }

        public ImmutableRule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRule(this.min, this.max, this.merge, this.reduceInClusters, (ImmutableList<String>)this.groupBy.build(), (ImmutableList<String>)this.properties.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("max");
            }
            return "Cannot build Rule, some of required attributes are not set " + attributes;
        }
    }
}

