/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.features.core.domain.processing.FeatureProcessChain;
import de.ii.ogcapi.foundation.domain.QueryInput;
import de.ii.ogcapi.tiles.domain.ImmutableTile;
import de.ii.ogcapi.tiles.domain.Tile;
import de.ii.ogcapi.tiles.domain.TilesQueriesHandler;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableEpsgCrs;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TilesQueriesHandler.QueryInputTileMultiLayer", generator="Immutables")
@Immutable
public final class ImmutableQueryInputTileMultiLayer
implements TilesQueriesHandler.QueryInputTileMultiLayer {
    private final boolean includeLinkHeader;
    @Nullable
    private final Date lastModified;
    @Nullable
    private final Date expires;
    @Nullable
    private final String cacheControl;
    private final ImmutableTile tile;
    private final ImmutableMap<String, Tile> singleLayerTileMap;
    private final ImmutableMap<String, FeatureQuery> queryMap;
    private final ImmutableEpsgCrs defaultCrs;
    @Nullable
    private final OutputStream outputStream;
    @Nullable
    private final FeatureProcessChain processes;
    private final ImmutableMap<String, Object> processingParameters;

    private ImmutableQueryInputTileMultiLayer(Builder builder) {
        this.lastModified = builder.lastModified;
        this.expires = builder.expires;
        this.cacheControl = builder.cacheControl;
        this.tile = ImmutableQueryInputTileMultiLayer.convertToValueTypede_ii_ogcapi_tiles_domain_ImmutableTile(builder.tile);
        this.singleLayerTileMap = builder.singleLayerTileMap.build();
        this.queryMap = builder.queryMap.build();
        this.defaultCrs = ImmutableQueryInputTileMultiLayer.convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(builder.defaultCrs);
        this.outputStream = builder.outputStream;
        this.processes = builder.processes;
        this.processingParameters = builder.processingParameters.build();
        this.includeLinkHeader = builder.includeLinkHeaderIsSet() ? builder.includeLinkHeader : TilesQueriesHandler.QueryInputTileMultiLayer.super.getIncludeLinkHeader();
    }

    private ImmutableQueryInputTileMultiLayer(boolean includeLinkHeader, @Nullable Date lastModified, @Nullable Date expires, @Nullable String cacheControl, ImmutableTile tile, ImmutableMap<String, Tile> singleLayerTileMap, ImmutableMap<String, FeatureQuery> queryMap, ImmutableEpsgCrs defaultCrs, @Nullable OutputStream outputStream, @Nullable FeatureProcessChain processes, ImmutableMap<String, Object> processingParameters) {
        this.includeLinkHeader = includeLinkHeader;
        this.lastModified = lastModified;
        this.expires = expires;
        this.cacheControl = cacheControl;
        this.tile = tile;
        this.singleLayerTileMap = singleLayerTileMap;
        this.queryMap = queryMap;
        this.defaultCrs = defaultCrs;
        this.outputStream = outputStream;
        this.processes = processes;
        this.processingParameters = processingParameters;
    }

    @Override
    public boolean getIncludeLinkHeader() {
        return this.includeLinkHeader;
    }

    @Override
    public Optional<Date> getLastModified() {
        return Optional.ofNullable(this.lastModified);
    }

    @Override
    public Optional<Date> getExpires() {
        return Optional.ofNullable(this.expires);
    }

    @Override
    public Optional<String> getCacheControl() {
        return Optional.ofNullable(this.cacheControl);
    }

    @Override
    public ImmutableTile getTile() {
        return this.tile;
    }

    public ImmutableMap<String, Tile> getSingleLayerTileMap() {
        return this.singleLayerTileMap;
    }

    public ImmutableMap<String, FeatureQuery> getQueryMap() {
        return this.queryMap;
    }

    @Override
    public ImmutableEpsgCrs getDefaultCrs() {
        return this.defaultCrs;
    }

    @Override
    public Optional<OutputStream> getOutputStream() {
        return Optional.ofNullable(this.outputStream);
    }

    @Override
    public Optional<FeatureProcessChain> getProcesses() {
        return Optional.ofNullable(this.processes);
    }

    public ImmutableMap<String, Object> getProcessingParameters() {
        return this.processingParameters;
    }

    public final ImmutableQueryInputTileMultiLayer withIncludeLinkHeader(boolean value) {
        if (this.includeLinkHeader == value) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(value, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withLastModified(Date value) {
        Date newValue = Objects.requireNonNull(value, "lastModified");
        if (this.lastModified == newValue) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, newValue, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withLastModified(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.lastModified == value) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, value, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withExpires(Date value) {
        Date newValue = Objects.requireNonNull(value, "expires");
        if (this.expires == newValue) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, newValue, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withExpires(Optional<? extends Date> optional) {
        Date value = optional.orElse(null);
        if (this.expires == value) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, value, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withCacheControl(String value) {
        String newValue = Objects.requireNonNull(value, "cacheControl");
        if (Objects.equals(this.cacheControl, newValue)) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, newValue, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withCacheControl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cacheControl, value)) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, value, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withTile(Tile value) {
        if (this.tile == value) {
            return this;
        }
        ImmutableTile newValue = new ImmutableTile.Builder().from(value).build();
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, newValue, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withSingleLayerTileMap(Map<String, ? extends Tile> entries) {
        if (this.singleLayerTileMap == entries) {
            return this;
        }
        ImmutableMap<String, Tile> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, newValue, this.queryMap, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withQueryMap(Map<String, ? extends FeatureQuery> entries) {
        if (this.queryMap == entries) {
            return this;
        }
        ImmutableMap<String, FeatureQuery> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, newValue, this.defaultCrs, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withDefaultCrs(EpsgCrs value) {
        if (this.defaultCrs == value) {
            return this;
        }
        ImmutableEpsgCrs newValue = new ImmutableEpsgCrs.Builder().from(value).build();
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, newValue, this.outputStream, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withOutputStream(OutputStream value) {
        OutputStream newValue = Objects.requireNonNull(value, "outputStream");
        if (this.outputStream == newValue) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, newValue, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withOutputStream(Optional<? extends OutputStream> optional) {
        OutputStream value = optional.orElse(null);
        if (this.outputStream == value) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, value, this.processes, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withProcesses(FeatureProcessChain value) {
        FeatureProcessChain newValue = Objects.requireNonNull(value, "processes");
        if (this.processes == newValue) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, newValue, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withProcesses(Optional<? extends FeatureProcessChain> optional) {
        FeatureProcessChain value = optional.orElse(null);
        if (this.processes == value) {
            return this;
        }
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, value, this.processingParameters);
    }

    public final ImmutableQueryInputTileMultiLayer withProcessingParameters(Map<String, ? extends Object> entries) {
        if (this.processingParameters == entries) {
            return this;
        }
        ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableQueryInputTileMultiLayer(this.includeLinkHeader, this.lastModified, this.expires, this.cacheControl, this.tile, this.singleLayerTileMap, this.queryMap, this.defaultCrs, this.outputStream, this.processes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryInputTileMultiLayer && this.equalTo((ImmutableQueryInputTileMultiLayer)another);
    }

    private boolean equalTo(ImmutableQueryInputTileMultiLayer another) {
        return this.includeLinkHeader == another.includeLinkHeader && Objects.equals(this.lastModified, another.lastModified) && Objects.equals(this.expires, another.expires) && Objects.equals(this.cacheControl, another.cacheControl) && this.tile.equals(another.tile) && this.singleLayerTileMap.equals(another.singleLayerTileMap) && this.queryMap.equals(another.queryMap) && this.defaultCrs.equals(another.defaultCrs) && Objects.equals(this.outputStream, another.outputStream) && Objects.equals(this.processes, another.processes) && this.processingParameters.equals(another.processingParameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode(this.includeLinkHeader);
        h += (h << 5) + Objects.hashCode(this.lastModified);
        h += (h << 5) + Objects.hashCode(this.expires);
        h += (h << 5) + Objects.hashCode(this.cacheControl);
        h += (h << 5) + this.tile.hashCode();
        h += (h << 5) + this.singleLayerTileMap.hashCode();
        h += (h << 5) + this.queryMap.hashCode();
        h += (h << 5) + this.defaultCrs.hashCode();
        h += (h << 5) + Objects.hashCode(this.outputStream);
        h += (h << 5) + Objects.hashCode(this.processes);
        h += (h << 5) + this.processingParameters.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryInputTileMultiLayer").omitNullValues().add("includeLinkHeader", this.includeLinkHeader).add("lastModified", this.lastModified).add("expires", this.expires).add("cacheControl", this.cacheControl).add("tile", this.tile).add("singleLayerTileMap", this.singleLayerTileMap).add("queryMap", this.queryMap).add("defaultCrs", this.defaultCrs).add("outputStream", this.outputStream).add("processes", this.processes).add("processingParameters", this.processingParameters).toString();
    }

    public static ImmutableQueryInputTileMultiLayer copyOf(TilesQueriesHandler.QueryInputTileMultiLayer instance) {
        if (instance instanceof ImmutableQueryInputTileMultiLayer) {
            return (ImmutableQueryInputTileMultiLayer)instance;
        }
        return new Builder().from(instance).build();
    }

    @Nullable
    private static ImmutableTile convertToValueTypede_ii_ogcapi_tiles_domain_ImmutableTile(@Nullable ImmutableTile.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static Tile convertToValueTypede_ii_ogcapi_tiles_domain_ImmutableTile(@Nullable Tile value) {
        if (value == null) {
            return null;
        }
        return new ImmutableTile.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableTile.Builder convertToBuilderTypede_ii_ogcapi_tiles_domain_ImmutableTile(@Nullable Tile value) {
        if (value == null) {
            return null;
        }
        return new ImmutableTile.Builder().from(value);
    }

    @Nullable
    private static ImmutableEpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable ImmutableEpsgCrs.Builder builder) {
        if (builder == null) {
            return null;
        }
        return builder.build();
    }

    @Nullable
    private static EpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
        if (value == null) {
            return null;
        }
        return new ImmutableEpsgCrs.Builder().from(value).build();
    }

    @Nullable
    private static ImmutableEpsgCrs.Builder convertToBuilderTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
        if (value == null) {
            return null;
        }
        return new ImmutableEpsgCrs.Builder().from(value);
    }

    @Generated(from="TilesQueriesHandler.QueryInputTileMultiLayer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TILE = 1L;
        private static final long INIT_BIT_DEFAULT_CRS = 2L;
        private static final long OPT_BIT_INCLUDE_LINK_HEADER = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean includeLinkHeader;
        @Nullable
        private Date lastModified;
        @Nullable
        private Date expires;
        @Nullable
        private String cacheControl;
        @Nullable
        private ImmutableTile.Builder tile;
        private ImmutableMap.Builder<String, Tile> singleLayerTileMap = ImmutableMap.builder();
        private ImmutableMap.Builder<String, FeatureQuery> queryMap = ImmutableMap.builder();
        @Nullable
        private ImmutableEpsgCrs.Builder defaultCrs;
        @Nullable
        private OutputStream outputStream;
        @Nullable
        private FeatureProcessChain processes;
        private ImmutableMap.Builder<String, Object> processingParameters = ImmutableMap.builder();

        @CanIgnoreReturnValue
        public final Builder from(TilesQueriesHandler.QueryInputTileMultiLayer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(QueryInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            QueryInput instance;
            if (object instanceof TilesQueriesHandler.QueryInputTileMultiLayer) {
                instance = (TilesQueriesHandler.QueryInputTileMultiLayer)object;
                this.putAllQueryMap(instance.getQueryMap());
                this.defaultCrs(instance.getDefaultCrs());
                Optional<FeatureProcessChain> processesOptional = instance.getProcesses();
                if (processesOptional.isPresent()) {
                    this.processes(processesOptional);
                }
                this.putAllSingleLayerTileMap(instance.getSingleLayerTileMap());
                this.putAllProcessingParameters(instance.getProcessingParameters());
                this.tile(instance.getTile());
                Optional<OutputStream> outputStreamOptional = instance.getOutputStream();
                if (outputStreamOptional.isPresent()) {
                    this.outputStream(outputStreamOptional);
                }
            }
            if (object instanceof QueryInput) {
                Optional<Date> lastModifiedOptional;
                instance = (QueryInput)object;
                Optional<Date> expiresOptional = instance.getExpires();
                if (expiresOptional.isPresent()) {
                    this.expires(expiresOptional);
                }
                if ((lastModifiedOptional = instance.getLastModified()).isPresent()) {
                    this.lastModified(lastModifiedOptional);
                }
                this.includeLinkHeader(instance.getIncludeLinkHeader());
                Optional<String> cacheControlOptional = instance.getCacheControl();
                if (cacheControlOptional.isPresent()) {
                    this.cacheControl(cacheControlOptional);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder includeLinkHeader(boolean includeLinkHeader) {
            this.includeLinkHeader = includeLinkHeader;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastModified(Date lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified, "lastModified");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastModified(Optional<? extends Date> lastModified) {
            this.lastModified = lastModified.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expires(Date expires) {
            this.expires = Objects.requireNonNull(expires, "expires");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expires(Optional<? extends Date> expires) {
            this.expires = expires.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = Objects.requireNonNull(cacheControl, "cacheControl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder cacheControl(Optional<String> cacheControl) {
            this.cacheControl = cacheControl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tile(Tile tile) {
            this.tile = new ImmutableTile.Builder().from(Builder.convertToValueTypede_ii_ogcapi_tiles_domain_ImmutableTile(tile));
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final ImmutableTile.Builder tileBuilder() {
            if (this.tile == null) {
                this.tile = new ImmutableTile.Builder();
            }
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this.tile;
        }

        @CanIgnoreReturnValue
        public final Builder tileBuilder(ImmutableTile.Builder tile) {
            this.tile = tile;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSingleLayerTileMap(String key, Tile value) {
            this.singleLayerTileMap.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSingleLayerTileMap(Map.Entry<String, ? extends Tile> entry) {
            this.singleLayerTileMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder singleLayerTileMap(Map<String, ? extends Tile> entries) {
            this.singleLayerTileMap = ImmutableMap.builder();
            return this.putAllSingleLayerTileMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSingleLayerTileMap(Map<String, ? extends Tile> entries) {
            this.singleLayerTileMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putQueryMap(String key, FeatureQuery value) {
            this.queryMap.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putQueryMap(Map.Entry<String, ? extends FeatureQuery> entry) {
            this.queryMap.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder queryMap(Map<String, ? extends FeatureQuery> entries) {
            this.queryMap = ImmutableMap.builder();
            return this.putAllQueryMap(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllQueryMap(Map<String, ? extends FeatureQuery> entries) {
            this.queryMap.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultCrs(int code) {
            return this.defaultCrs(ImmutableEpsgCrs.of(code));
        }

        @CanIgnoreReturnValue
        public final Builder defaultCrs(EpsgCrs defaultCrs) {
            this.defaultCrs = new ImmutableEpsgCrs.Builder().from(Builder.convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(defaultCrs));
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final ImmutableEpsgCrs.Builder defaultCrsBuilder() {
            if (this.defaultCrs == null) {
                this.defaultCrs = new ImmutableEpsgCrs.Builder();
            }
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this.defaultCrs;
        }

        @CanIgnoreReturnValue
        public final Builder defaultCrsBuilder(ImmutableEpsgCrs.Builder defaultCrs) {
            this.defaultCrs = defaultCrs;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputStream(OutputStream outputStream) {
            this.outputStream = Objects.requireNonNull(outputStream, "outputStream");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputStream(Optional<? extends OutputStream> outputStream) {
            this.outputStream = outputStream.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processes(FeatureProcessChain processes) {
            this.processes = Objects.requireNonNull(processes, "processes");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processes(Optional<? extends FeatureProcessChain> processes) {
            this.processes = processes.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProcessingParameters(String key, Object value) {
            this.processingParameters.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProcessingParameters(Map.Entry<String, ? extends Object> entry) {
            this.processingParameters.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder processingParameters(Map<String, ? extends Object> entries) {
            this.processingParameters = ImmutableMap.builder();
            return this.putAllProcessingParameters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProcessingParameters(Map<String, ? extends Object> entries) {
            this.processingParameters.putAll(entries);
            return this;
        }

        public ImmutableQueryInputTileMultiLayer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryInputTileMultiLayer(this);
        }

        private boolean includeLinkHeaderIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tile");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("defaultCrs");
            }
            return "Cannot build QueryInputTileMultiLayer, some of required attributes are not set " + attributes;
        }

        @Nullable
        private static ImmutableTile convertToValueTypede_ii_ogcapi_tiles_domain_ImmutableTile(@Nullable ImmutableTile.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static Tile convertToValueTypede_ii_ogcapi_tiles_domain_ImmutableTile(@Nullable Tile value) {
            if (value == null) {
                return null;
            }
            return new ImmutableTile.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableTile.Builder convertToBuilderTypede_ii_ogcapi_tiles_domain_ImmutableTile(@Nullable Tile value) {
            if (value == null) {
                return null;
            }
            return new ImmutableTile.Builder().from(value);
        }

        @Nullable
        private static ImmutableEpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable ImmutableEpsgCrs.Builder builder) {
            if (builder == null) {
                return null;
            }
            return builder.build();
        }

        @Nullable
        private static EpsgCrs convertToValueTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
            if (value == null) {
                return null;
            }
            return new ImmutableEpsgCrs.Builder().from(value).build();
        }

        @Nullable
        private static ImmutableEpsgCrs.Builder convertToBuilderTypede_ii_xtraplatform_crs_domain_ImmutableEpsgCrs(@Nullable EpsgCrs value) {
            if (value == null) {
                return null;
            }
            return new ImmutableEpsgCrs.Builder().from(value);
        }
    }
}

