/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.tiles.domain.PredefinedFilter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PredefinedFilter", generator="Immutables")
@Immutable
public final class ImmutablePredefinedFilter
implements PredefinedFilter {
    private final int min;
    private final int max;
    @Nullable
    private final String filter;

    private ImmutablePredefinedFilter(int min, int max, @Nullable String filter) {
        this.min = min;
        this.max = max;
        this.filter = filter;
    }

    @Override
    @JsonProperty(value="min")
    public int getMin() {
        return this.min;
    }

    @Override
    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    @Override
    @JsonProperty(value="filter")
    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public final ImmutablePredefinedFilter withMin(int value) {
        if (this.min == value) {
            return this;
        }
        return new ImmutablePredefinedFilter(value, this.max, this.filter);
    }

    public final ImmutablePredefinedFilter withMax(int value) {
        if (this.max == value) {
            return this;
        }
        return new ImmutablePredefinedFilter(this.min, value, this.filter);
    }

    public final ImmutablePredefinedFilter withFilter(String value) {
        String newValue = Objects.requireNonNull(value, "filter");
        if (Objects.equals(this.filter, newValue)) {
            return this;
        }
        return new ImmutablePredefinedFilter(this.min, this.max, newValue);
    }

    public final ImmutablePredefinedFilter withFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.filter, value)) {
            return this;
        }
        return new ImmutablePredefinedFilter(this.min, this.max, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePredefinedFilter && this.equalTo((ImmutablePredefinedFilter)another);
    }

    private boolean equalTo(ImmutablePredefinedFilter another) {
        return this.min == another.min && this.max == another.max && Objects.equals(this.filter, another.filter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.min;
        h += (h << 5) + this.max;
        h += (h << 5) + Objects.hashCode(this.filter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("PredefinedFilter").omitNullValues().add("min", this.min).add("max", this.max).add("filter", this.filter).toString();
    }

    public static ImmutablePredefinedFilter copyOf(PredefinedFilter instance) {
        if (instance instanceof ImmutablePredefinedFilter) {
            return (ImmutablePredefinedFilter)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="PredefinedFilter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MIN = 1L;
        private static final long INIT_BIT_MAX = 2L;
        private long initBits = 3L;
        private int min;
        private int max;
        @Nullable
        private String filter;

        @CanIgnoreReturnValue
        public final Builder from(PredefinedFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.min(instance.getMin());
            this.max(instance.getMax());
            Optional<String> filterOptional = instance.getFilter();
            if (filterOptional.isPresent()) {
                this.filter(filterOptional);
            }
            return this;
        }

        @JsonProperty(value="min")
        @CanIgnoreReturnValue
        public final Builder min(int min) {
            this.min = min;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="max")
        @CanIgnoreReturnValue
        public final Builder max(int max) {
            this.max = max;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(String filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            return this;
        }

        @JsonProperty(value="filter")
        @CanIgnoreReturnValue
        public final Builder filter(Optional<String> filter) {
            this.filter = filter.orElse(null);
            return this;
        }

        public ImmutablePredefinedFilter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePredefinedFilter(this.min, this.max, this.filter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("max");
            }
            return "Cannot build PredefinedFilter, some of required attributes are not set " + attributes;
        }
    }
}

