/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.domain;

import de.ii.ogcapi.tiles.domain.MinMax;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MinMax", generator="Immutables")
@Immutable
public final class ImmutableMinMax
implements MinMax {
    private final int min;
    private final int max;
    @Nullable
    private final Integer getDefault;

    private ImmutableMinMax(int min, int max, @Nullable Integer getDefault) {
        this.min = min;
        this.max = max;
        this.getDefault = getDefault;
    }

    @Override
    @JsonProperty(value="min")
    public int getMin() {
        return this.min;
    }

    @Override
    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    @Override
    @JsonProperty(value="default")
    public Optional<Integer> getDefault() {
        return Optional.ofNullable(this.getDefault);
    }

    public final ImmutableMinMax withMin(int value) {
        if (this.min == value) {
            return this;
        }
        return new ImmutableMinMax(value, this.max, this.getDefault);
    }

    public final ImmutableMinMax withMax(int value) {
        if (this.max == value) {
            return this;
        }
        return new ImmutableMinMax(this.min, value, this.getDefault);
    }

    public final ImmutableMinMax withDefault(int value) {
        Integer newValue = value;
        if (Objects.equals(this.getDefault, newValue)) {
            return this;
        }
        return new ImmutableMinMax(this.min, this.max, newValue);
    }

    public final ImmutableMinMax withDefault(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.getDefault, value)) {
            return this;
        }
        return new ImmutableMinMax(this.min, this.max, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMinMax && this.equalTo((ImmutableMinMax)another);
    }

    private boolean equalTo(ImmutableMinMax another) {
        return this.min == another.min && this.max == another.max && Objects.equals(this.getDefault, another.getDefault);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.min;
        h += (h << 5) + this.max;
        h += (h << 5) + Objects.hashCode(this.getDefault);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MinMax").omitNullValues().add("min", this.min).add("max", this.max).add("default", this.getDefault).toString();
    }

    public static ImmutableMinMax copyOf(MinMax instance) {
        if (instance instanceof ImmutableMinMax) {
            return (ImmutableMinMax)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="MinMax", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MIN = 1L;
        private static final long INIT_BIT_MAX = 2L;
        private long initBits = 3L;
        private int min;
        private int max;
        @Nullable
        private Integer getDefault;

        @CanIgnoreReturnValue
        public final Builder from(MinMax instance) {
            Objects.requireNonNull(instance, "instance");
            this.min(instance.getMin());
            this.max(instance.getMax());
            Optional<Integer> getDefaultOptional = instance.getDefault();
            if (getDefaultOptional.isPresent()) {
                this.getDefault(getDefaultOptional);
            }
            return this;
        }

        @JsonProperty(value="min")
        @CanIgnoreReturnValue
        public final Builder min(int min) {
            this.min = min;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="max")
        @CanIgnoreReturnValue
        public final Builder max(int max) {
            this.max = max;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder getDefault(int getDefault) {
            this.getDefault = getDefault;
            return this;
        }

        @JsonProperty(value="default")
        @CanIgnoreReturnValue
        public final Builder getDefault(Optional<Integer> getDefault) {
            this.getDefault = getDefault.orElse(null);
            return this;
        }

        public ImmutableMinMax build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMinMax(this.min, this.max, this.getDefault);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("min");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("max");
            }
            return "Cannot build MinMax, some of required attributes are not set " + attributes;
        }
    }
}

