/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.app.tileMatrixSet;

import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrix;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSet;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetData;
import de.ii.xtraplatform.crs.domain.BoundingBox;
import de.ii.xtraplatform.crs.domain.CrsTransformationException;
import de.ii.xtraplatform.crs.domain.CrsTransformer;
import de.ii.xtraplatform.crs.domain.CrsTransformerFactory;
import de.ii.xtraplatform.crs.domain.EpsgCrs;
import de.ii.xtraplatform.crs.domain.ImmutableBoundingBox;
import de.ii.xtraplatform.crs.domain.OgcCrs;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import shadow.com.google.common.collect.ImmutableList;

public class TileMatrixSetImpl
implements TileMatrixSet {
    private final TileMatrixSetData data;

    public TileMatrixSetImpl(TileMatrixSetData data) {
        this.data = data;
    }

    @Override
    public String getId() {
        return this.data.getId();
    }

    @Override
    public Optional<URI> getURI() {
        return this.data.getUri();
    }

    @Override
    public Optional<String> getTitle() {
        return this.data.getTitle();
    }

    @Override
    public Optional<String> getDescription() {
        return this.data.getDescription();
    }

    @Override
    public List<String> getKeywords() {
        return this.data.getKeywords();
    }

    @Override
    public EpsgCrs getCrs() {
        EpsgCrs crs;
        try {
            crs = EpsgCrs.fromString(this.data.getCrs());
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("The CRS URI '%s' is invalid: %s", this.data.getCrs(), e.getMessage()), e);
        }
        return crs;
    }

    @Override
    public List<String> getOrderedAxes() {
        return this.data.getOrderedAxes();
    }

    @Override
    public Optional<URI> getWellKnownScaleSet() {
        return this.data.getWellKnownScaleSet();
    }

    @Override
    public int getCols(int level) {
        return this.data.getTileMatrices().stream().filter(tm -> tm.getTileLevel() == level).findAny().map(TileMatrix::getMatrixWidth).orElse(0L).intValue();
    }

    @Override
    public int getRows(int level) {
        return this.data.getTileMatrices().stream().filter(tm -> tm.getTileLevel() == level).findAny().map(TileMatrix::getMatrixHeight).orElse(0L).intValue();
    }

    @Override
    public int getMaxLevel() {
        return this.data.getTileMatrices().stream().mapToInt(TileMatrix::getTileLevel).max().orElse(0);
    }

    @Override
    public int getMinLevel() {
        return this.data.getTileMatrices().stream().mapToInt(TileMatrix::getTileLevel).min().orElse(0);
    }

    @Override
    public TileMatrixSetData getTileMatrixSetData() {
        return this.data;
    }

    @Override
    public double getInitialScaleDenominator() {
        int minLevel = this.getMinLevel();
        return this.data.getTileMatrices().stream().filter(tm -> tm.getTileLevel() == minLevel).findAny().map(tm -> tm.getScaleDenominator().doubleValue()).orElse(Double.NaN);
    }

    @Override
    public int getInitialWidth() {
        return this.getCols(this.getMinLevel());
    }

    @Override
    public int getInitialHeight() {
        return this.getRows(this.getMinLevel());
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.data.getBoundingBox().map(bbox -> new ImmutableBoundingBox.Builder().epsgCrs(bbox.getCrs().map(EpsgCrs::fromString).orElse(this.getCrs())).xmin(bbox.getLowerLeft()[0].doubleValue()).ymin(bbox.getLowerLeft()[1].doubleValue()).xmax(bbox.getUpperRight()[0].doubleValue()).ymax(bbox.getUpperRight()[1].doubleValue()).build()).orElse(new ImmutableBoundingBox.Builder().epsgCrs(this.getCrs()).xmin(this.data.getTileMatrices().stream().filter(tm -> tm.getCornerOfOrigin().equals("topLeft")).mapToDouble(tm -> tm.getPointOfOrigin()[0].doubleValue()).min().orElse(Double.NaN)).ymin(this.data.getTileMatrices().stream().filter(tm -> tm.getCornerOfOrigin().equals("topLeft")).mapToDouble(tm -> tm.getPointOfOrigin()[1].doubleValue() - tm.getCellSize().doubleValue() * (double)tm.getTileHeight() * (double)tm.getMatrixHeight()).min().orElse(Double.NaN)).xmax(this.data.getTileMatrices().stream().filter(tm -> tm.getCornerOfOrigin().equals("topLeft")).mapToDouble(tm -> tm.getPointOfOrigin()[0].doubleValue() + tm.getCellSize().doubleValue() * (double)tm.getTileWidth() * (double)tm.getMatrixWidth()).max().orElse(Double.NaN)).ymax(this.data.getTileMatrices().stream().filter(tm -> tm.getCornerOfOrigin().equals("topLeft")).mapToDouble(tm -> tm.getPointOfOrigin()[1].doubleValue()).max().orElse(Double.NaN)).build());
    }

    @Override
    public BoundingBox getBoundingBoxCrs84(CrsTransformerFactory crsTransformerFactory) throws CrsTransformationException {
        if (this.getCrs().equals(OgcCrs.CRS84)) {
            return this.getBoundingBox();
        }
        CrsTransformer crsTransformer = crsTransformerFactory.getTransformer(this.getCrs(), OgcCrs.CRS84, true).orElseThrow(() -> new IllegalStateException(String.format("Could not transform the bounding box of tile matrix set '%s' to CRS84.", this.getId())));
        return crsTransformer.transformBoundingBox(this.getBoundingBox());
    }

    @Override
    public List<TileMatrix> getTileMatrices(int minLevel, int maxLevel) {
        return this.data.getTileMatrices().stream().filter(tm -> tm.getTileLevel() >= minLevel && tm.getTileLevel() <= maxLevel).collect(ImmutableList.toImmutableList());
    }

    @Override
    public TileMatrix getTileMatrix(int level) {
        return this.data.getTileMatrices().stream().filter(tm -> tm.getTileLevel() == level).findAny().orElse(null);
    }
}

