/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.app;

import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.foundation.domain.OgcApiQueryParameter;
import de.ii.ogcapi.foundation.domain.QueryInput;
import de.ii.ogcapi.foundation.domain.URICustomizer;
import de.ii.ogcapi.tiles.app.ImmutableTileProviderTileServer;
import de.ii.ogcapi.tiles.domain.ImmutableQueryInputTileTileServerTile;
import de.ii.ogcapi.tiles.domain.Tile;
import de.ii.ogcapi.tiles.domain.TileProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.Lists;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTileProviderTileServer.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TileProviderTileServer
extends TileProvider {
    public final String getType() {
        return "TILESERVER";
    }

    @Nullable
    public abstract String getUrlTemplate();

    @Nullable
    public abstract String getUrlTemplateSingleCollection();

    @Override
    public abstract List<String> getTileEncodings();

    @Override
    @JsonIgnore
    public QueryInput getQueryInput(OgcApiDataV2 apiData, URICustomizer uriCustomizer, Map<String, String> queryParameters, List<OgcApiQueryParameter> allowedParameters, QueryInput genericInput, Tile tile) {
        return new ImmutableQueryInputTileTileServerTile.Builder().from(genericInput).tile(tile).provider(this).build();
    }

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public boolean isMultiCollectionEnabled() {
        return Objects.nonNull(this.getUrlTemplate());
    }

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public boolean isSingleCollectionEnabled() {
        return Objects.nonNull(this.getUrlTemplateSingleCollection());
    }

    @Override
    public TileProvider mergeInto(TileProvider source) {
        if (Objects.isNull(source) || !(source instanceof TileProviderTileServer)) {
            return this;
        }
        TileProviderTileServer src = (TileProviderTileServer)source;
        ImmutableTileProviderTileServer.Builder builder = ImmutableTileProviderTileServer.builder().from(src).from(this);
        ArrayList<String> tileEncodings = Objects.nonNull(src.getTileEncodings()) ? Lists.newArrayList(src.getTileEncodings()) : Lists.newArrayList();
        this.getTileEncodings().forEach(tileEncoding -> {
            if (!tileEncodings.contains(tileEncoding)) {
                tileEncodings.add((String)tileEncoding);
            }
        });
        builder.tileEncodings(tileEncodings);
        return builder.build();
    }
}

