/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.app;

import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.foundation.domain.OgcApiQueryParameter;
import de.ii.ogcapi.foundation.domain.QueryInput;
import de.ii.ogcapi.foundation.domain.URICustomizer;
import de.ii.ogcapi.tiles.app.ImmutableTileProviderMbtiles;
import de.ii.ogcapi.tiles.domain.ImmutableQueryInputTileMbtilesTile;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.Tile;
import de.ii.ogcapi.tiles.domain.TileProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTileProviderMbtiles.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TileProviderMbtiles
extends TileProvider {
    public final String getType() {
        return "MBTILES";
    }

    @Nullable
    public abstract String getFilename();

    @JsonIgnore
    public abstract Map<String, MinMax> getZoomLevels();

    @Nullable
    @JsonIgnore
    public abstract String getTileEncoding();

    @Override
    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    public List<String> getTileEncodings() {
        return Objects.nonNull(this.getTileEncoding()) ? ImmutableList.of(this.getTileEncoding()) : ImmutableList.of();
    }

    @JsonIgnore
    public abstract List<Double> getCenter();

    @Override
    @JsonIgnore
    @Value.Default
    public boolean requiresQuerySupport() {
        return false;
    }

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public boolean isMultiCollectionEnabled() {
        return true;
    }

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public boolean isSingleCollectionEnabled() {
        return false;
    }

    @Override
    public TileProvider mergeInto(TileProvider source) {
        if (Objects.isNull(source) || !(source instanceof TileProviderMbtiles)) {
            return this;
        }
        TileProviderMbtiles src = (TileProviderMbtiles)source;
        ImmutableTileProviderMbtiles.Builder builder = ImmutableTileProviderMbtiles.builder().from(src).from(this);
        if (!this.getCenter().isEmpty()) {
            builder.center(this.getCenter());
        } else if (!src.getCenter().isEmpty()) {
            builder.center(src.getCenter());
        }
        return builder.build();
    }

    @Override
    @JsonIgnore
    @Value.Derived
    public QueryInput getQueryInput(OgcApiDataV2 apiData, URICustomizer uriCustomizer, Map<String, String> queryParameters, List<OgcApiQueryParameter> allowedParameters, QueryInput genericInput, Tile tile) {
        return new ImmutableQueryInputTileMbtilesTile.Builder().from(genericInput).tile(tile).provider(this).build();
    }
}

