/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.app;

import de.ii.ogcapi.features.core.domain.FeaturesCoreConfiguration;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.foundation.domain.OgcApiQueryParameter;
import de.ii.ogcapi.foundation.domain.QueryInput;
import de.ii.ogcapi.foundation.domain.URICustomizer;
import de.ii.ogcapi.tiles.app.ImmutableTileProviderFeatures;
import de.ii.ogcapi.tiles.domain.ImmutableQueryInputTileEmpty;
import de.ii.ogcapi.tiles.domain.ImmutableQueryInputTileMultiLayer;
import de.ii.ogcapi.tiles.domain.ImmutableQueryInputTileSingleLayer;
import de.ii.ogcapi.tiles.domain.ImmutableTile;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.PredefinedFilter;
import de.ii.ogcapi.tiles.domain.Rule;
import de.ii.ogcapi.tiles.domain.SeedingOptions;
import de.ii.ogcapi.tiles.domain.Tile;
import de.ii.ogcapi.tiles.domain.TileFormatExtension;
import de.ii.ogcapi.tiles.domain.TileFormatWithQuerySupportExtension;
import de.ii.ogcapi.tiles.domain.TileFromFeatureQuery;
import de.ii.ogcapi.tiles.domain.TileProvider;
import de.ii.ogcapi.tiles.domain.TilesConfiguration;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import de.ii.xtraplatform.features.domain.FeatureQuery;
import de.ii.xtraplatform.features.domain.ImmutableFeatureQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.Lists;
import shadow.com.google.common.collect.Maps;
import shadow.javax.annotation.Nullable;
import shadow.javax.ws.rs.NotAcceptableException;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableTileProviderFeatures.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class TileProviderFeatures
extends TileProvider {
    public final String getType() {
        return "FEATURES";
    }

    @Override
    public abstract List<String> getTileEncodings();

    public abstract Map<String, MinMax> getZoomLevels();

    public abstract Map<String, MinMax> getZoomLevelsCache();

    public abstract Optional<SeedingOptions> getSeedingOptions();

    public abstract Map<String, MinMax> getSeeding();

    public abstract Map<String, List<PredefinedFilter>> getFilters();

    public abstract Map<String, List<Rule>> getRules();

    public abstract List<Double> getCenter();

    @Nullable
    public abstract Integer getLimit();

    @Nullable
    public abstract Boolean getSingleCollectionEnabled();

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public boolean isSingleCollectionEnabled() {
        return Objects.equals(this.getSingleCollectionEnabled(), true);
    }

    @Nullable
    public abstract Boolean getMultiCollectionEnabled();

    @Override
    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public boolean isMultiCollectionEnabled() {
        return Objects.equals(this.getMultiCollectionEnabled(), true);
    }

    @Nullable
    public abstract Boolean getIgnoreInvalidGeometries();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    public boolean isIgnoreInvalidGeometries() {
        return Objects.equals(this.getIgnoreInvalidGeometries(), true);
    }

    @Deprecated
    public abstract Optional<Double> getMaxRelativeAreaChangeInPolygonRepair();

    @Deprecated
    public abstract Optional<Double> getMaxAbsoluteAreaChangeInPolygonRepair();

    @Nullable
    public abstract Double getMinimumSizeInPixel();

    @Override
    @JsonIgnore
    @Value.Default
    public boolean tilesMayBeCached() {
        return true;
    }

    @Override
    @JsonIgnore
    @Value.Derived
    public QueryInput getQueryInput(OgcApiDataV2 apiData, URICustomizer uriCustomizer, Map<String, String> queryParameters, List<OgcApiQueryParameter> allowedParameters, QueryInput genericInput, Tile tile) {
        if (!tile.getFeatureProvider().map(FeatureProvider2::supportsQueries).orElse(false).booleanValue()) {
            throw new IllegalStateException("Tile cannot be generated. The feature provider does not support feature queries.");
        }
        TileFormatExtension outputFormat = tile.getOutputFormat();
        List<String> collections = tile.getCollectionIds();
        if (collections.isEmpty()) {
            return new ImmutableQueryInputTileEmpty.Builder().from(genericInput).tile(tile).build();
        }
        if (!(outputFormat instanceof TileFormatWithQuerySupportExtension)) {
            throw new RuntimeException(String.format("Unexpected tile format without query support. Found: %s", outputFormat.getClass().getSimpleName()));
        }
        Map<String, Object> processingParameters = new HashMap<String, Object>();
        for (OgcApiQueryParameter parameter : allowedParameters) {
            processingParameters = parameter.transformContext(null, processingParameters, queryParameters, apiData);
        }
        if (tile.isDatasetTile()) {
            if (!outputFormat.canMultiLayer() && collections.size() > 1) {
                throw new NotAcceptableException("The requested tile format supports only a single layer. Please select only a single collection.");
            }
            Map singleLayerTileMap = collections.stream().collect(ImmutableMap.toImmutableMap(collectionId -> collectionId, collectionId -> new ImmutableTile.Builder().from(tile).collectionIds(ImmutableList.of(collectionId)).isDatasetTile(false).build()));
            Map queryMap = collections.stream().filter(collectionId -> {
                Optional<FeaturesCoreConfiguration> featuresConfiguration = ((FeatureTypeConfigurationOgcApi)apiData.getCollections().get(collectionId)).getExtension(FeaturesCoreConfiguration.class);
                return featuresConfiguration.isPresent() && featuresConfiguration.get().getQueryables().isPresent() && !featuresConfiguration.get().getQueryables().get().getSpatial().isEmpty();
            }).collect(ImmutableMap.toImmutableMap(collectionId -> collectionId, collectionId -> {
                String featureTypeId = ((FeatureTypeConfigurationOgcApi)apiData.getCollections().get(collectionId)).getExtension(FeaturesCoreConfiguration.class).map(cfg -> cfg.getFeatureType().orElse((String)collectionId)).orElse((String)collectionId);
                TilesConfiguration layerConfiguration = apiData.getExtension(TilesConfiguration.class, (String)collectionId).orElseThrow();
                FeatureQuery query = ((TileFormatWithQuerySupportExtension)outputFormat).getQuery((Tile)singleLayerTileMap.get(collectionId), allowedParameters, queryParameters, layerConfiguration, uriCustomizer);
                return ImmutableFeatureQuery.builder().from(query).type(featureTypeId).build();
            }));
            FeaturesCoreConfiguration coreConfiguration = apiData.getExtension(FeaturesCoreConfiguration.class).orElseThrow();
            return new ImmutableQueryInputTileMultiLayer.Builder().from(genericInput).tile(tile).singleLayerTileMap(singleLayerTileMap).queryMap(queryMap).processingParameters(processingParameters).defaultCrs(apiData.getExtension(FeaturesCoreConfiguration.class).map(FeaturesCoreConfiguration::getDefaultEpsgCrs).orElseThrow()).build();
        }
        String collectionId2 = tile.getCollectionId();
        FeatureTypeConfigurationOgcApi featureType = apiData.getCollectionData(collectionId2).orElseThrow();
        TilesConfiguration layerConfiguration = apiData.getExtension(TilesConfiguration.class, collectionId2).orElseThrow();
        FeatureQuery query = ((TileFromFeatureQuery)((Object)outputFormat)).getQuery(tile, allowedParameters, queryParameters, layerConfiguration, uriCustomizer);
        FeaturesCoreConfiguration coreConfiguration = featureType.getExtension(FeaturesCoreConfiguration.class).orElseThrow();
        return new ImmutableQueryInputTileSingleLayer.Builder().from(genericInput).tile(tile).query(query).processingParameters(processingParameters).defaultCrs(featureType.getExtension(FeaturesCoreConfiguration.class).map(FeaturesCoreConfiguration::getDefaultEpsgCrs).orElseThrow()).build();
    }

    @Override
    public TileProvider mergeInto(TileProvider source) {
        LinkedHashMap mergedFilters;
        LinkedHashMap mergedRules;
        LinkedHashMap mergedZoomLevelsCache;
        LinkedHashMap mergedZoomLevels;
        LinkedHashMap mergedSeeding;
        if (Objects.isNull(source) || !(source instanceof TileProviderFeatures)) {
            return this;
        }
        ImmutableTileProviderFeatures.Builder builder = ImmutableTileProviderFeatures.builder().from((TileProviderFeatures)source).from(this);
        TileProviderFeatures src = (TileProviderFeatures)source;
        ArrayList<String> tileEncodings = Objects.nonNull(src.getTileEncodings()) ? Lists.newArrayList(src.getTileEncodings()) : Lists.newArrayList();
        this.getTileEncodings().forEach(tileEncoding -> {
            if (!tileEncodings.contains(tileEncoding)) {
                tileEncodings.add((String)tileEncoding);
            }
        });
        builder.tileEncodings(tileEncodings);
        LinkedHashMap<Object, Object> linkedHashMap = mergedSeeding = Objects.nonNull(src.getSeeding()) ? Maps.newLinkedHashMap(src.getSeeding()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getSeeding())) {
            this.getSeeding().forEach(mergedSeeding::put);
        }
        builder.seeding(mergedSeeding);
        LinkedHashMap<Object, Object> linkedHashMap2 = mergedZoomLevels = Objects.nonNull(src.getZoomLevels()) ? Maps.newLinkedHashMap(src.getZoomLevels()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getZoomLevels())) {
            this.getZoomLevels().forEach(mergedZoomLevels::put);
        }
        builder.zoomLevels(mergedZoomLevels);
        if (!this.getCenter().isEmpty()) {
            builder.center(this.getCenter());
        } else if (!src.getCenter().isEmpty()) {
            builder.center(src.getCenter());
        }
        LinkedHashMap<Object, Object> linkedHashMap3 = mergedZoomLevelsCache = Objects.nonNull(src.getZoomLevelsCache()) ? Maps.newLinkedHashMap(src.getZoomLevelsCache()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getZoomLevelsCache())) {
            this.getZoomLevelsCache().forEach(mergedZoomLevelsCache::put);
        }
        builder.zoomLevelsCache(mergedZoomLevelsCache);
        LinkedHashMap<Object, Object> linkedHashMap4 = mergedRules = Objects.nonNull(src.getRules()) ? Maps.newLinkedHashMap(src.getRules()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getRules())) {
            this.getRules().forEach(mergedRules::put);
        }
        builder.rules(mergedRules);
        LinkedHashMap<Object, Object> linkedHashMap5 = mergedFilters = Objects.nonNull(src.getFilters()) ? Maps.newLinkedHashMap(src.getFilters()) : Maps.newLinkedHashMap();
        if (Objects.nonNull(this.getFilters())) {
            this.getFilters().forEach(mergedFilters::put);
        }
        builder.filters(mergedFilters);
        if (Objects.nonNull(this.getCenter())) {
            builder.center(this.getCenter());
        } else if (Objects.nonNull(src.getCenter())) {
            builder.center(src.getCenter());
        }
        return builder.build();
    }
}

