/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.app;

import de.ii.ogcapi.tiles.app.TileProviderTileServer;
import de.ii.ogcapi.tiles.domain.TileProvider;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TileProviderTileServer", generator="Immutables")
@Immutable
public final class ImmutableTileProviderTileServer
extends TileProviderTileServer {
    private final boolean tilesMayBeCached;
    private final boolean requiresQuerySupport;
    private final boolean supportsTilesHints;
    @Nullable
    private final String urlTemplate;
    @Nullable
    private final String urlTemplateSingleCollection;
    private final ImmutableList<String> tileEncodings;
    private final transient boolean isMultiCollectionEnabled;
    private final transient boolean isSingleCollectionEnabled;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTileProviderTileServer(Builder builder) {
        this.urlTemplate = builder.urlTemplate;
        this.urlTemplateSingleCollection = builder.urlTemplateSingleCollection;
        this.tileEncodings = builder.tileEncodings.build();
        if (builder.tilesMayBeCachedIsSet()) {
            this.initShim.tilesMayBeCached(builder.tilesMayBeCached);
        }
        if (builder.requiresQuerySupportIsSet()) {
            this.initShim.requiresQuerySupport(builder.requiresQuerySupport);
        }
        if (builder.supportsTilesHintsIsSet()) {
            this.initShim.supportsTilesHints(builder.supportsTilesHints);
        }
        this.tilesMayBeCached = this.initShim.tilesMayBeCached();
        this.requiresQuerySupport = this.initShim.requiresQuerySupport();
        this.supportsTilesHints = this.initShim.supportsTilesHints();
        this.isMultiCollectionEnabled = this.initShim.isMultiCollectionEnabled();
        this.isSingleCollectionEnabled = this.initShim.isSingleCollectionEnabled();
        this.initShim = null;
    }

    private ImmutableTileProviderTileServer(boolean tilesMayBeCached, boolean requiresQuerySupport, boolean supportsTilesHints, @Nullable String urlTemplate, @Nullable String urlTemplateSingleCollection, ImmutableList<String> tileEncodings) {
        this.initShim.tilesMayBeCached(tilesMayBeCached);
        this.initShim.requiresQuerySupport(requiresQuerySupport);
        this.initShim.supportsTilesHints(supportsTilesHints);
        this.urlTemplate = urlTemplate;
        this.urlTemplateSingleCollection = urlTemplateSingleCollection;
        this.tileEncodings = tileEncodings;
        this.tilesMayBeCached = this.initShim.tilesMayBeCached();
        this.requiresQuerySupport = this.initShim.requiresQuerySupport();
        this.supportsTilesHints = this.initShim.supportsTilesHints();
        this.isMultiCollectionEnabled = this.initShim.isMultiCollectionEnabled();
        this.isSingleCollectionEnabled = this.initShim.isSingleCollectionEnabled();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="tilesMayBeCached")
    @JsonIgnore
    public boolean tilesMayBeCached() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tilesMayBeCached() : this.tilesMayBeCached;
    }

    @Override
    @JsonProperty(value="requiresQuerySupport")
    @JsonIgnore
    public boolean requiresQuerySupport() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requiresQuerySupport() : this.requiresQuerySupport;
    }

    @Override
    @JsonProperty(value="supportsTilesHints")
    @JsonIgnore
    public boolean supportsTilesHints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportsTilesHints() : this.supportsTilesHints;
    }

    @Override
    @JsonProperty(value="urlTemplate")
    @Nullable
    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    @Override
    @JsonProperty(value="urlTemplateSingleCollection")
    @Nullable
    public String getUrlTemplateSingleCollection() {
        return this.urlTemplateSingleCollection;
    }

    @JsonProperty(value="tileEncodings")
    public ImmutableList<String> getTileEncodings() {
        return this.tileEncodings;
    }

    @Override
    @JsonProperty(value="isMultiCollectionEnabled")
    @JsonIgnore
    public boolean isMultiCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isMultiCollectionEnabled() : this.isMultiCollectionEnabled;
    }

    @Override
    @JsonProperty(value="isSingleCollectionEnabled")
    @JsonIgnore
    public boolean isSingleCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSingleCollectionEnabled() : this.isSingleCollectionEnabled;
    }

    public final ImmutableTileProviderTileServer withTilesMayBeCached(boolean value) {
        if (this.tilesMayBeCached == value) {
            return this;
        }
        return new ImmutableTileProviderTileServer(value, this.requiresQuerySupport, this.supportsTilesHints, this.urlTemplate, this.urlTemplateSingleCollection, this.tileEncodings);
    }

    public final ImmutableTileProviderTileServer withRequiresQuerySupport(boolean value) {
        if (this.requiresQuerySupport == value) {
            return this;
        }
        return new ImmutableTileProviderTileServer(this.tilesMayBeCached, value, this.supportsTilesHints, this.urlTemplate, this.urlTemplateSingleCollection, this.tileEncodings);
    }

    public final ImmutableTileProviderTileServer withSupportsTilesHints(boolean value) {
        if (this.supportsTilesHints == value) {
            return this;
        }
        return new ImmutableTileProviderTileServer(this.tilesMayBeCached, this.requiresQuerySupport, value, this.urlTemplate, this.urlTemplateSingleCollection, this.tileEncodings);
    }

    public final ImmutableTileProviderTileServer withUrlTemplate(@Nullable String value) {
        if (Objects.equals(this.urlTemplate, value)) {
            return this;
        }
        return new ImmutableTileProviderTileServer(this.tilesMayBeCached, this.requiresQuerySupport, this.supportsTilesHints, value, this.urlTemplateSingleCollection, this.tileEncodings);
    }

    public final ImmutableTileProviderTileServer withUrlTemplateSingleCollection(@Nullable String value) {
        if (Objects.equals(this.urlTemplateSingleCollection, value)) {
            return this;
        }
        return new ImmutableTileProviderTileServer(this.tilesMayBeCached, this.requiresQuerySupport, this.supportsTilesHints, this.urlTemplate, value, this.tileEncodings);
    }

    public final ImmutableTileProviderTileServer withTileEncodings(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileProviderTileServer(this.tilesMayBeCached, this.requiresQuerySupport, this.supportsTilesHints, this.urlTemplate, this.urlTemplateSingleCollection, newValue);
    }

    public final ImmutableTileProviderTileServer withTileEncodings(Iterable<String> elements) {
        if (this.tileEncodings == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileProviderTileServer(this.tilesMayBeCached, this.requiresQuerySupport, this.supportsTilesHints, this.urlTemplate, this.urlTemplateSingleCollection, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTileProviderTileServer && this.equalTo((ImmutableTileProviderTileServer)another);
    }

    private boolean equalTo(ImmutableTileProviderTileServer another) {
        return this.tilesMayBeCached == another.tilesMayBeCached && this.requiresQuerySupport == another.requiresQuerySupport && this.supportsTilesHints == another.supportsTilesHints && Objects.equals(this.urlTemplate, another.urlTemplate) && Objects.equals(this.urlTemplateSingleCollection, another.urlTemplateSingleCollection) && this.tileEncodings.equals(another.tileEncodings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode(this.tilesMayBeCached);
        h += (h << 5) + Booleans.hashCode(this.requiresQuerySupport);
        h += (h << 5) + Booleans.hashCode(this.supportsTilesHints);
        h += (h << 5) + Objects.hashCode(this.urlTemplate);
        h += (h << 5) + Objects.hashCode(this.urlTemplateSingleCollection);
        h += (h << 5) + this.tileEncodings.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TileProviderTileServer").omitNullValues().add("tilesMayBeCached", this.tilesMayBeCached).add("requiresQuerySupport", this.requiresQuerySupport).add("supportsTilesHints", this.supportsTilesHints).add("urlTemplate", this.urlTemplate).add("urlTemplateSingleCollection", this.urlTemplateSingleCollection).add("tileEncodings", this.tileEncodings).toString();
    }

    public static ImmutableTileProviderTileServer copyOf(TileProviderTileServer instance) {
        if (instance instanceof ImmutableTileProviderTileServer) {
            return (ImmutableTileProviderTileServer)instance;
        }
        return ImmutableTileProviderTileServer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TileProviderTileServer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_TILES_MAY_BE_CACHED = 1L;
        private static final long OPT_BIT_REQUIRES_QUERY_SUPPORT = 2L;
        private static final long OPT_BIT_SUPPORTS_TILES_HINTS = 4L;
        private long optBits;
        private boolean tilesMayBeCached;
        private boolean requiresQuerySupport;
        private boolean supportsTilesHints;
        @Nullable
        private String urlTemplate;
        @Nullable
        private String urlTemplateSingleCollection;
        private ImmutableList.Builder<String> tileEncodings = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TileProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TileProviderTileServer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TileProvider instance;
            long bits = 0L;
            if (object instanceof TileProvider) {
                instance = (TileProvider)object;
                this.requiresQuerySupport(instance.requiresQuerySupport());
                if ((bits & 1L) == 0L) {
                    this.addAllTileEncodings(instance.getTileEncodings());
                    bits |= 1L;
                }
                this.supportsTilesHints(instance.supportsTilesHints());
                this.tilesMayBeCached(instance.tilesMayBeCached());
            }
            if (object instanceof TileProviderTileServer) {
                String urlTemplateValue;
                instance = (TileProviderTileServer)object;
                String urlTemplateSingleCollectionValue = ((TileProviderTileServer)instance).getUrlTemplateSingleCollection();
                if (urlTemplateSingleCollectionValue != null) {
                    this.urlTemplateSingleCollection(urlTemplateSingleCollectionValue);
                }
                if ((urlTemplateValue = ((TileProviderTileServer)instance).getUrlTemplate()) != null) {
                    this.urlTemplate(urlTemplateValue);
                }
                if ((bits & 1L) == 0L) {
                    this.addAllTileEncodings(((TileProviderTileServer)instance).getTileEncodings());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="tilesMayBeCached")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder tilesMayBeCached(boolean tilesMayBeCached) {
            this.tilesMayBeCached = tilesMayBeCached;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="requiresQuerySupport")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder requiresQuerySupport(boolean requiresQuerySupport) {
            this.requiresQuerySupport = requiresQuerySupport;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="supportsTilesHints")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder supportsTilesHints(boolean supportsTilesHints) {
            this.supportsTilesHints = supportsTilesHints;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="urlTemplate")
        @CanIgnoreReturnValue
        public final Builder urlTemplate(@Nullable String urlTemplate) {
            this.urlTemplate = urlTemplate;
            return this;
        }

        @JsonProperty(value="urlTemplateSingleCollection")
        @CanIgnoreReturnValue
        public final Builder urlTemplateSingleCollection(@Nullable String urlTemplateSingleCollection) {
            this.urlTemplateSingleCollection = urlTemplateSingleCollection;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileEncodings(String element) {
            this.tileEncodings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileEncodings(String ... elements) {
            this.tileEncodings.add(elements);
            return this;
        }

        @JsonProperty(value="tileEncodings")
        @CanIgnoreReturnValue
        public final Builder tileEncodings(Iterable<String> elements) {
            this.tileEncodings = ImmutableList.builder();
            return this.addAllTileEncodings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTileEncodings(Iterable<String> elements) {
            this.tileEncodings.addAll((Iterable)elements);
            return this;
        }

        public ImmutableTileProviderTileServer build() {
            return new ImmutableTileProviderTileServer(this);
        }

        private boolean tilesMayBeCachedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean requiresQuerySupportIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean supportsTilesHintsIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Generated(from="TileProviderTileServer", generator="Immutables")
    private final class InitShim {
        private byte tilesMayBeCachedBuildStage = 0;
        private boolean tilesMayBeCached;
        private byte requiresQuerySupportBuildStage = 0;
        private boolean requiresQuerySupport;
        private byte supportsTilesHintsBuildStage = 0;
        private boolean supportsTilesHints;
        private byte isMultiCollectionEnabledBuildStage = 0;
        private boolean isMultiCollectionEnabled;
        private byte isSingleCollectionEnabledBuildStage = 0;
        private boolean isSingleCollectionEnabled;

        private InitShim() {
        }

        boolean tilesMayBeCached() {
            if (this.tilesMayBeCachedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tilesMayBeCachedBuildStage == 0) {
                this.tilesMayBeCachedBuildStage = (byte)-1;
                this.tilesMayBeCached = ImmutableTileProviderTileServer.super.tilesMayBeCached();
                this.tilesMayBeCachedBuildStage = 1;
            }
            return this.tilesMayBeCached;
        }

        void tilesMayBeCached(boolean tilesMayBeCached) {
            this.tilesMayBeCached = tilesMayBeCached;
            this.tilesMayBeCachedBuildStage = 1;
        }

        boolean requiresQuerySupport() {
            if (this.requiresQuerySupportBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requiresQuerySupportBuildStage == 0) {
                this.requiresQuerySupportBuildStage = (byte)-1;
                this.requiresQuerySupport = ImmutableTileProviderTileServer.super.requiresQuerySupport();
                this.requiresQuerySupportBuildStage = 1;
            }
            return this.requiresQuerySupport;
        }

        void requiresQuerySupport(boolean requiresQuerySupport) {
            this.requiresQuerySupport = requiresQuerySupport;
            this.requiresQuerySupportBuildStage = 1;
        }

        boolean supportsTilesHints() {
            if (this.supportsTilesHintsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportsTilesHintsBuildStage == 0) {
                this.supportsTilesHintsBuildStage = (byte)-1;
                this.supportsTilesHints = ImmutableTileProviderTileServer.super.supportsTilesHints();
                this.supportsTilesHintsBuildStage = 1;
            }
            return this.supportsTilesHints;
        }

        void supportsTilesHints(boolean supportsTilesHints) {
            this.supportsTilesHints = supportsTilesHints;
            this.supportsTilesHintsBuildStage = 1;
        }

        boolean isMultiCollectionEnabled() {
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isMultiCollectionEnabledBuildStage == 0) {
                this.isMultiCollectionEnabledBuildStage = (byte)-1;
                this.isMultiCollectionEnabled = ImmutableTileProviderTileServer.super.isMultiCollectionEnabled();
                this.isMultiCollectionEnabledBuildStage = 1;
            }
            return this.isMultiCollectionEnabled;
        }

        boolean isSingleCollectionEnabled() {
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSingleCollectionEnabledBuildStage == 0) {
                this.isSingleCollectionEnabledBuildStage = (byte)-1;
                this.isSingleCollectionEnabled = ImmutableTileProviderTileServer.super.isSingleCollectionEnabled();
                this.isSingleCollectionEnabledBuildStage = 1;
            }
            return this.isSingleCollectionEnabled;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.tilesMayBeCachedBuildStage == -1) {
                attributes.add("tilesMayBeCached");
            }
            if (this.requiresQuerySupportBuildStage == -1) {
                attributes.add("requiresQuerySupport");
            }
            if (this.supportsTilesHintsBuildStage == -1) {
                attributes.add("supportsTilesHints");
            }
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                attributes.add("isMultiCollectionEnabled");
            }
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                attributes.add("isSingleCollectionEnabled");
            }
            return "Cannot build TileProviderTileServer, attribute initializers form cycle " + attributes;
        }
    }
}

