/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.app;

import de.ii.ogcapi.tiles.app.TileProviderFeatures;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.PredefinedFilter;
import de.ii.ogcapi.tiles.domain.Rule;
import de.ii.ogcapi.tiles.domain.SeedingOptions;
import de.ii.ogcapi.tiles.domain.TileProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.primitives.Booleans;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TileProviderFeatures", generator="Immutables")
@Immutable
public final class ImmutableTileProviderFeatures
extends TileProviderFeatures {
    private final boolean requiresQuerySupport;
    private final boolean supportsTilesHints;
    private final ImmutableList<String> tileEncodings;
    private final ImmutableMap<String, MinMax> zoomLevels;
    private final ImmutableMap<String, MinMax> zoomLevelsCache;
    @Nullable
    private final SeedingOptions seedingOptions;
    private final ImmutableMap<String, MinMax> seeding;
    private final ImmutableMap<String, List<PredefinedFilter>> filters;
    private final ImmutableMap<String, List<Rule>> rules;
    private final ImmutableList<Double> center;
    @Nullable
    private final Integer limit;
    @Nullable
    private final Boolean singleCollectionEnabled;
    private final transient boolean isSingleCollectionEnabled;
    @Nullable
    private final Boolean multiCollectionEnabled;
    private final transient boolean isMultiCollectionEnabled;
    @Nullable
    private final Boolean ignoreInvalidGeometries;
    private final transient boolean isIgnoreInvalidGeometries;
    @Nullable
    private final Double maxRelativeAreaChangeInPolygonRepair;
    @Nullable
    private final Double maxAbsoluteAreaChangeInPolygonRepair;
    @Nullable
    private final Double minimumSizeInPixel;
    private final boolean tilesMayBeCached;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTileProviderFeatures(Builder builder) {
        this.tileEncodings = builder.tileEncodings.build();
        this.zoomLevels = builder.zoomLevels.build();
        this.zoomLevelsCache = builder.zoomLevelsCache.build();
        this.seedingOptions = builder.seedingOptions;
        this.seeding = builder.seeding.build();
        this.filters = builder.filters.build();
        this.rules = builder.rules.build();
        this.center = builder.center.build();
        this.limit = builder.limit;
        this.singleCollectionEnabled = builder.singleCollectionEnabled;
        this.multiCollectionEnabled = builder.multiCollectionEnabled;
        this.ignoreInvalidGeometries = builder.ignoreInvalidGeometries;
        this.maxRelativeAreaChangeInPolygonRepair = builder.maxRelativeAreaChangeInPolygonRepair;
        this.maxAbsoluteAreaChangeInPolygonRepair = builder.maxAbsoluteAreaChangeInPolygonRepair;
        this.minimumSizeInPixel = builder.minimumSizeInPixel;
        if (builder.requiresQuerySupportIsSet()) {
            this.initShim.requiresQuerySupport(builder.requiresQuerySupport);
        }
        if (builder.supportsTilesHintsIsSet()) {
            this.initShim.supportsTilesHints(builder.supportsTilesHints);
        }
        if (builder.tilesMayBeCachedIsSet()) {
            this.initShim.tilesMayBeCached(builder.tilesMayBeCached);
        }
        this.requiresQuerySupport = this.initShim.requiresQuerySupport();
        this.supportsTilesHints = this.initShim.supportsTilesHints();
        this.isSingleCollectionEnabled = this.initShim.isSingleCollectionEnabled();
        this.isMultiCollectionEnabled = this.initShim.isMultiCollectionEnabled();
        this.isIgnoreInvalidGeometries = this.initShim.isIgnoreInvalidGeometries();
        this.tilesMayBeCached = this.initShim.tilesMayBeCached();
        this.initShim = null;
    }

    private ImmutableTileProviderFeatures(boolean requiresQuerySupport, boolean supportsTilesHints, ImmutableList<String> tileEncodings, ImmutableMap<String, MinMax> zoomLevels, ImmutableMap<String, MinMax> zoomLevelsCache, @Nullable SeedingOptions seedingOptions, ImmutableMap<String, MinMax> seeding, ImmutableMap<String, List<PredefinedFilter>> filters, ImmutableMap<String, List<Rule>> rules, ImmutableList<Double> center, @Nullable Integer limit, @Nullable Boolean singleCollectionEnabled, @Nullable Boolean multiCollectionEnabled, @Nullable Boolean ignoreInvalidGeometries, @Nullable Double maxRelativeAreaChangeInPolygonRepair, @Nullable Double maxAbsoluteAreaChangeInPolygonRepair, @Nullable Double minimumSizeInPixel, boolean tilesMayBeCached) {
        this.initShim.requiresQuerySupport(requiresQuerySupport);
        this.initShim.supportsTilesHints(supportsTilesHints);
        this.tileEncodings = tileEncodings;
        this.zoomLevels = zoomLevels;
        this.zoomLevelsCache = zoomLevelsCache;
        this.seedingOptions = seedingOptions;
        this.seeding = seeding;
        this.filters = filters;
        this.rules = rules;
        this.center = center;
        this.limit = limit;
        this.singleCollectionEnabled = singleCollectionEnabled;
        this.multiCollectionEnabled = multiCollectionEnabled;
        this.ignoreInvalidGeometries = ignoreInvalidGeometries;
        this.maxRelativeAreaChangeInPolygonRepair = maxRelativeAreaChangeInPolygonRepair;
        this.maxAbsoluteAreaChangeInPolygonRepair = maxAbsoluteAreaChangeInPolygonRepair;
        this.minimumSizeInPixel = minimumSizeInPixel;
        this.initShim.tilesMayBeCached(tilesMayBeCached);
        this.requiresQuerySupport = this.initShim.requiresQuerySupport();
        this.supportsTilesHints = this.initShim.supportsTilesHints();
        this.isSingleCollectionEnabled = this.initShim.isSingleCollectionEnabled();
        this.isMultiCollectionEnabled = this.initShim.isMultiCollectionEnabled();
        this.isIgnoreInvalidGeometries = this.initShim.isIgnoreInvalidGeometries();
        this.tilesMayBeCached = this.initShim.tilesMayBeCached();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="requiresQuerySupport")
    @JsonIgnore
    public boolean requiresQuerySupport() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requiresQuerySupport() : this.requiresQuerySupport;
    }

    @Override
    @JsonProperty(value="supportsTilesHints")
    @JsonIgnore
    public boolean supportsTilesHints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportsTilesHints() : this.supportsTilesHints;
    }

    @JsonProperty(value="tileEncodings")
    public ImmutableList<String> getTileEncodings() {
        return this.tileEncodings;
    }

    @JsonProperty(value="zoomLevels")
    public ImmutableMap<String, MinMax> getZoomLevels() {
        return this.zoomLevels;
    }

    @JsonProperty(value="zoomLevelsCache")
    public ImmutableMap<String, MinMax> getZoomLevelsCache() {
        return this.zoomLevelsCache;
    }

    @Override
    @JsonProperty(value="seedingOptions")
    public Optional<SeedingOptions> getSeedingOptions() {
        return Optional.ofNullable(this.seedingOptions);
    }

    @JsonProperty(value="seeding")
    public ImmutableMap<String, MinMax> getSeeding() {
        return this.seeding;
    }

    @JsonProperty(value="filters")
    public ImmutableMap<String, List<PredefinedFilter>> getFilters() {
        return this.filters;
    }

    @JsonProperty(value="rules")
    public ImmutableMap<String, List<Rule>> getRules() {
        return this.rules;
    }

    @JsonProperty(value="center")
    public ImmutableList<Double> getCenter() {
        return this.center;
    }

    @Override
    @JsonProperty(value="limit")
    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    @Override
    @JsonProperty(value="singleCollectionEnabled")
    @Nullable
    public Boolean getSingleCollectionEnabled() {
        return this.singleCollectionEnabled;
    }

    @Override
    @JsonProperty(value="isSingleCollectionEnabled")
    @JsonIgnore
    public boolean isSingleCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSingleCollectionEnabled() : this.isSingleCollectionEnabled;
    }

    @Override
    @JsonProperty(value="multiCollectionEnabled")
    @Nullable
    public Boolean getMultiCollectionEnabled() {
        return this.multiCollectionEnabled;
    }

    @Override
    @JsonProperty(value="isMultiCollectionEnabled")
    @JsonIgnore
    public boolean isMultiCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isMultiCollectionEnabled() : this.isMultiCollectionEnabled;
    }

    @Override
    @JsonProperty(value="ignoreInvalidGeometries")
    @Nullable
    public Boolean getIgnoreInvalidGeometries() {
        return this.ignoreInvalidGeometries;
    }

    @Override
    @JsonProperty(value="isIgnoreInvalidGeometries")
    @JsonIgnore
    public boolean isIgnoreInvalidGeometries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isIgnoreInvalidGeometries() : this.isIgnoreInvalidGeometries;
    }

    @Override
    @JsonProperty(value="maxRelativeAreaChangeInPolygonRepair")
    @Deprecated
    public Optional<Double> getMaxRelativeAreaChangeInPolygonRepair() {
        return Optional.ofNullable(this.maxRelativeAreaChangeInPolygonRepair);
    }

    @Override
    @JsonProperty(value="maxAbsoluteAreaChangeInPolygonRepair")
    @Deprecated
    public Optional<Double> getMaxAbsoluteAreaChangeInPolygonRepair() {
        return Optional.ofNullable(this.maxAbsoluteAreaChangeInPolygonRepair);
    }

    @Override
    @JsonProperty(value="minimumSizeInPixel")
    @Nullable
    public Double getMinimumSizeInPixel() {
        return this.minimumSizeInPixel;
    }

    @Override
    @JsonProperty(value="tilesMayBeCached")
    @JsonIgnore
    public boolean tilesMayBeCached() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tilesMayBeCached() : this.tilesMayBeCached;
    }

    public final ImmutableTileProviderFeatures withRequiresQuerySupport(boolean value) {
        if (this.requiresQuerySupport == value) {
            return this;
        }
        return new ImmutableTileProviderFeatures(value, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withSupportsTilesHints(boolean value) {
        if (this.supportsTilesHints == value) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, value, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withTileEncodings(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, newValue, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withTileEncodings(Iterable<String> elements) {
        if (this.tileEncodings == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, newValue, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withZoomLevels(Map<String, ? extends MinMax> entries) {
        if (this.zoomLevels == entries) {
            return this;
        }
        ImmutableMap<String, MinMax> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, newValue, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withZoomLevelsCache(Map<String, ? extends MinMax> entries) {
        if (this.zoomLevelsCache == entries) {
            return this;
        }
        ImmutableMap<String, MinMax> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, newValue, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withSeedingOptions(SeedingOptions value) {
        SeedingOptions newValue = Objects.requireNonNull(value, "seedingOptions");
        if (this.seedingOptions == newValue) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, newValue, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withSeedingOptions(Optional<? extends SeedingOptions> optional) {
        SeedingOptions value = optional.orElse(null);
        if (this.seedingOptions == value) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, value, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withSeeding(Map<String, ? extends MinMax> entries) {
        if (this.seeding == entries) {
            return this;
        }
        ImmutableMap<String, MinMax> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, newValue, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withFilters(Map<String, ? extends List<PredefinedFilter>> entries) {
        if (this.filters == entries) {
            return this;
        }
        ImmutableMap<String, List<PredefinedFilter>> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, newValue, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withRules(Map<String, ? extends List<Rule>> entries) {
        if (this.rules == entries) {
            return this;
        }
        ImmutableMap<String, List<Rule>> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, newValue, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withCenter(double ... elements) {
        ImmutableList<Double> newValue = ImmutableList.copyOf(Doubles.asList(elements));
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, newValue, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withCenter(Iterable<Double> elements) {
        if (this.center == elements) {
            return this;
        }
        ImmutableList<Double> newValue = ImmutableList.copyOf(elements);
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, newValue, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withLimit(@Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, value, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withSingleCollectionEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.singleCollectionEnabled, value)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, value, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withMultiCollectionEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.multiCollectionEnabled, value)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, value, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withIgnoreInvalidGeometries(@Nullable Boolean value) {
        if (Objects.equals(this.ignoreInvalidGeometries, value)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, value, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    @Deprecated
    public final ImmutableTileProviderFeatures withMaxRelativeAreaChangeInPolygonRepair(double value) {
        Double newValue = value;
        if (Objects.equals(this.maxRelativeAreaChangeInPolygonRepair, newValue)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, newValue, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    @Deprecated
    public final ImmutableTileProviderFeatures withMaxRelativeAreaChangeInPolygonRepair(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.maxRelativeAreaChangeInPolygonRepair, value)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, value, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    @Deprecated
    public final ImmutableTileProviderFeatures withMaxAbsoluteAreaChangeInPolygonRepair(double value) {
        Double newValue = value;
        if (Objects.equals(this.maxAbsoluteAreaChangeInPolygonRepair, newValue)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, newValue, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    @Deprecated
    public final ImmutableTileProviderFeatures withMaxAbsoluteAreaChangeInPolygonRepair(Optional<Double> optional) {
        Double value = optional.orElse(null);
        if (Objects.equals(this.maxAbsoluteAreaChangeInPolygonRepair, value)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, value, this.minimumSizeInPixel, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withMinimumSizeInPixel(@Nullable Double value) {
        if (Objects.equals(this.minimumSizeInPixel, value)) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, value, this.tilesMayBeCached);
    }

    public final ImmutableTileProviderFeatures withTilesMayBeCached(boolean value) {
        if (this.tilesMayBeCached == value) {
            return this;
        }
        return new ImmutableTileProviderFeatures(this.requiresQuerySupport, this.supportsTilesHints, this.tileEncodings, this.zoomLevels, this.zoomLevelsCache, this.seedingOptions, this.seeding, this.filters, this.rules, this.center, this.limit, this.singleCollectionEnabled, this.multiCollectionEnabled, this.ignoreInvalidGeometries, this.maxRelativeAreaChangeInPolygonRepair, this.maxAbsoluteAreaChangeInPolygonRepair, this.minimumSizeInPixel, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTileProviderFeatures && this.equalTo((ImmutableTileProviderFeatures)another);
    }

    private boolean equalTo(ImmutableTileProviderFeatures another) {
        return this.requiresQuerySupport == another.requiresQuerySupport && this.supportsTilesHints == another.supportsTilesHints && this.tileEncodings.equals(another.tileEncodings) && this.zoomLevels.equals(another.zoomLevels) && this.zoomLevelsCache.equals(another.zoomLevelsCache) && Objects.equals(this.seedingOptions, another.seedingOptions) && this.seeding.equals(another.seeding) && this.filters.equals(another.filters) && this.rules.equals(another.rules) && this.center.equals(another.center) && Objects.equals(this.limit, another.limit) && Objects.equals(this.singleCollectionEnabled, another.singleCollectionEnabled) && Objects.equals(this.multiCollectionEnabled, another.multiCollectionEnabled) && Objects.equals(this.ignoreInvalidGeometries, another.ignoreInvalidGeometries) && Objects.equals(this.maxRelativeAreaChangeInPolygonRepair, another.maxRelativeAreaChangeInPolygonRepair) && Objects.equals(this.maxAbsoluteAreaChangeInPolygonRepair, another.maxAbsoluteAreaChangeInPolygonRepair) && Objects.equals(this.minimumSizeInPixel, another.minimumSizeInPixel) && this.tilesMayBeCached == another.tilesMayBeCached;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode(this.requiresQuerySupport);
        h += (h << 5) + Booleans.hashCode(this.supportsTilesHints);
        h += (h << 5) + this.tileEncodings.hashCode();
        h += (h << 5) + this.zoomLevels.hashCode();
        h += (h << 5) + this.zoomLevelsCache.hashCode();
        h += (h << 5) + Objects.hashCode(this.seedingOptions);
        h += (h << 5) + this.seeding.hashCode();
        h += (h << 5) + this.filters.hashCode();
        h += (h << 5) + this.rules.hashCode();
        h += (h << 5) + this.center.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.singleCollectionEnabled);
        h += (h << 5) + Objects.hashCode(this.multiCollectionEnabled);
        h += (h << 5) + Objects.hashCode(this.ignoreInvalidGeometries);
        h += (h << 5) + Objects.hashCode(this.maxRelativeAreaChangeInPolygonRepair);
        h += (h << 5) + Objects.hashCode(this.maxAbsoluteAreaChangeInPolygonRepair);
        h += (h << 5) + Objects.hashCode(this.minimumSizeInPixel);
        h += (h << 5) + Booleans.hashCode(this.tilesMayBeCached);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TileProviderFeatures").omitNullValues().add("requiresQuerySupport", this.requiresQuerySupport).add("supportsTilesHints", this.supportsTilesHints).add("tileEncodings", this.tileEncodings).add("zoomLevels", this.zoomLevels).add("zoomLevelsCache", this.zoomLevelsCache).add("seedingOptions", this.seedingOptions).add("seeding", this.seeding).add("filters", this.filters).add("rules", this.rules).add("center", this.center).add("limit", this.limit).add("singleCollectionEnabled", this.singleCollectionEnabled).add("multiCollectionEnabled", this.multiCollectionEnabled).add("ignoreInvalidGeometries", this.ignoreInvalidGeometries).add("maxRelativeAreaChangeInPolygonRepair", this.maxRelativeAreaChangeInPolygonRepair).add("maxAbsoluteAreaChangeInPolygonRepair", this.maxAbsoluteAreaChangeInPolygonRepair).add("minimumSizeInPixel", this.minimumSizeInPixel).add("tilesMayBeCached", this.tilesMayBeCached).toString();
    }

    public static ImmutableTileProviderFeatures copyOf(TileProviderFeatures instance) {
        if (instance instanceof ImmutableTileProviderFeatures) {
            return (ImmutableTileProviderFeatures)instance;
        }
        return ImmutableTileProviderFeatures.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TileProviderFeatures", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_REQUIRES_QUERY_SUPPORT = 1L;
        private static final long OPT_BIT_SUPPORTS_TILES_HINTS = 2L;
        private static final long OPT_BIT_TILES_MAY_BE_CACHED = 4L;
        private long optBits;
        private boolean requiresQuerySupport;
        private boolean supportsTilesHints;
        private ImmutableList.Builder<String> tileEncodings = ImmutableList.builder();
        private ImmutableMap.Builder<String, MinMax> zoomLevels = ImmutableMap.builder();
        private ImmutableMap.Builder<String, MinMax> zoomLevelsCache = ImmutableMap.builder();
        @Nullable
        private SeedingOptions seedingOptions;
        private ImmutableMap.Builder<String, MinMax> seeding = ImmutableMap.builder();
        private ImmutableMap.Builder<String, List<PredefinedFilter>> filters = ImmutableMap.builder();
        private ImmutableMap.Builder<String, List<Rule>> rules = ImmutableMap.builder();
        private ImmutableList.Builder<Double> center = ImmutableList.builder();
        @Nullable
        private Integer limit;
        @Nullable
        private Boolean singleCollectionEnabled;
        @Nullable
        private Boolean multiCollectionEnabled;
        @Nullable
        private Boolean ignoreInvalidGeometries;
        @Nullable
        private Double maxRelativeAreaChangeInPolygonRepair;
        @Nullable
        private Double maxAbsoluteAreaChangeInPolygonRepair;
        @Nullable
        private Double minimumSizeInPixel;
        private boolean tilesMayBeCached;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TileProviderFeatures instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TileProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TileProvider instance;
            long bits = 0L;
            if (object instanceof TileProviderFeatures) {
                Optional<Double> maxRelativeAreaChangeInPolygonRepairOptional;
                Boolean multiCollectionEnabledValue;
                Optional<SeedingOptions> seedingOptionsOptional;
                Double minimumSizeInPixelValue;
                Boolean singleCollectionEnabledValue;
                instance = (TileProviderFeatures)object;
                Boolean ignoreInvalidGeometriesValue = ((TileProviderFeatures)instance).getIgnoreInvalidGeometries();
                if (ignoreInvalidGeometriesValue != null) {
                    this.ignoreInvalidGeometries(ignoreInvalidGeometriesValue);
                }
                if ((singleCollectionEnabledValue = ((TileProviderFeatures)instance).getSingleCollectionEnabled()) != null) {
                    this.singleCollectionEnabled(singleCollectionEnabledValue);
                }
                if ((minimumSizeInPixelValue = ((TileProviderFeatures)instance).getMinimumSizeInPixel()) != null) {
                    this.minimumSizeInPixel(minimumSizeInPixelValue);
                }
                this.addAllCenter(((TileProviderFeatures)instance).getCenter());
                this.putAllZoomLevelsCache(((TileProviderFeatures)instance).getZoomLevelsCache());
                this.putAllRules(((TileProviderFeatures)instance).getRules());
                this.putAllFilters(((TileProviderFeatures)instance).getFilters());
                this.putAllZoomLevels(((TileProviderFeatures)instance).getZoomLevels());
                Optional<Double> maxAbsoluteAreaChangeInPolygonRepairOptional = ((TileProviderFeatures)instance).getMaxAbsoluteAreaChangeInPolygonRepair();
                if (maxAbsoluteAreaChangeInPolygonRepairOptional.isPresent()) {
                    this.maxAbsoluteAreaChangeInPolygonRepair(maxAbsoluteAreaChangeInPolygonRepairOptional);
                }
                if ((seedingOptionsOptional = ((TileProviderFeatures)instance).getSeedingOptions()).isPresent()) {
                    this.seedingOptions(seedingOptionsOptional);
                }
                if ((multiCollectionEnabledValue = ((TileProviderFeatures)instance).getMultiCollectionEnabled()) != null) {
                    this.multiCollectionEnabled(multiCollectionEnabledValue);
                }
                this.putAllSeeding(((TileProviderFeatures)instance).getSeeding());
                Integer limitValue = ((TileProviderFeatures)instance).getLimit();
                if (limitValue != null) {
                    this.limit(limitValue);
                }
                if ((bits & 1L) == 0L) {
                    this.addAllTileEncodings(((TileProviderFeatures)instance).getTileEncodings());
                    bits |= 1L;
                }
                if ((maxRelativeAreaChangeInPolygonRepairOptional = ((TileProviderFeatures)instance).getMaxRelativeAreaChangeInPolygonRepair()).isPresent()) {
                    this.maxRelativeAreaChangeInPolygonRepair(maxRelativeAreaChangeInPolygonRepairOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.tilesMayBeCached(((TileProviderFeatures)instance).tilesMayBeCached());
                    bits |= 2L;
                }
            }
            if (object instanceof TileProvider) {
                instance = (TileProvider)object;
                this.requiresQuerySupport(instance.requiresQuerySupport());
                if ((bits & 1L) == 0L) {
                    this.addAllTileEncodings(instance.getTileEncodings());
                    bits |= 1L;
                }
                this.supportsTilesHints(instance.supportsTilesHints());
                if ((bits & 2L) == 0L) {
                    this.tilesMayBeCached(instance.tilesMayBeCached());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="requiresQuerySupport")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder requiresQuerySupport(boolean requiresQuerySupport) {
            this.requiresQuerySupport = requiresQuerySupport;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="supportsTilesHints")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder supportsTilesHints(boolean supportsTilesHints) {
            this.supportsTilesHints = supportsTilesHints;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileEncodings(String element) {
            this.tileEncodings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTileEncodings(String ... elements) {
            this.tileEncodings.add(elements);
            return this;
        }

        @JsonProperty(value="tileEncodings")
        @CanIgnoreReturnValue
        public final Builder tileEncodings(Iterable<String> elements) {
            this.tileEncodings = ImmutableList.builder();
            return this.addAllTileEncodings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTileEncodings(Iterable<String> elements) {
            this.tileEncodings.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putZoomLevels(String key, MinMax value) {
            this.zoomLevels.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putZoomLevels(Map.Entry<String, ? extends MinMax> entry) {
            this.zoomLevels.put(entry);
            return this;
        }

        @JsonProperty(value="zoomLevels")
        @CanIgnoreReturnValue
        public final Builder zoomLevels(Map<String, ? extends MinMax> entries) {
            this.zoomLevels = ImmutableMap.builder();
            return this.putAllZoomLevels(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllZoomLevels(Map<String, ? extends MinMax> entries) {
            this.zoomLevels.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putZoomLevelsCache(String key, MinMax value) {
            this.zoomLevelsCache.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putZoomLevelsCache(Map.Entry<String, ? extends MinMax> entry) {
            this.zoomLevelsCache.put(entry);
            return this;
        }

        @JsonProperty(value="zoomLevelsCache")
        @CanIgnoreReturnValue
        public final Builder zoomLevelsCache(Map<String, ? extends MinMax> entries) {
            this.zoomLevelsCache = ImmutableMap.builder();
            return this.putAllZoomLevelsCache(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllZoomLevelsCache(Map<String, ? extends MinMax> entries) {
            this.zoomLevelsCache.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder seedingOptions(SeedingOptions seedingOptions) {
            this.seedingOptions = Objects.requireNonNull(seedingOptions, "seedingOptions");
            return this;
        }

        @JsonProperty(value="seedingOptions")
        @CanIgnoreReturnValue
        public final Builder seedingOptions(Optional<? extends SeedingOptions> seedingOptions) {
            this.seedingOptions = seedingOptions.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSeeding(String key, MinMax value) {
            this.seeding.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSeeding(Map.Entry<String, ? extends MinMax> entry) {
            this.seeding.put(entry);
            return this;
        }

        @JsonProperty(value="seeding")
        @CanIgnoreReturnValue
        public final Builder seeding(Map<String, ? extends MinMax> entries) {
            this.seeding = ImmutableMap.builder();
            return this.putAllSeeding(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSeeding(Map<String, ? extends MinMax> entries) {
            this.seeding.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFilters(String key, List<PredefinedFilter> value) {
            this.filters.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putFilters(Map.Entry<String, ? extends List<PredefinedFilter>> entry) {
            this.filters.put(entry);
            return this;
        }

        @JsonProperty(value="filters")
        @CanIgnoreReturnValue
        public final Builder filters(Map<String, ? extends List<PredefinedFilter>> entries) {
            this.filters = ImmutableMap.builder();
            return this.putAllFilters(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllFilters(Map<String, ? extends List<PredefinedFilter>> entries) {
            this.filters.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRules(String key, List<Rule> value) {
            this.rules.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putRules(Map.Entry<String, ? extends List<Rule>> entry) {
            this.rules.put(entry);
            return this;
        }

        @JsonProperty(value="rules")
        @CanIgnoreReturnValue
        public final Builder rules(Map<String, ? extends List<Rule>> entries) {
            this.rules = ImmutableMap.builder();
            return this.putAllRules(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllRules(Map<String, ? extends List<Rule>> entries) {
            this.rules.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCenter(double element) {
            this.center.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCenter(double ... elements) {
            this.center.addAll(Doubles.asList(elements));
            return this;
        }

        @JsonProperty(value="center")
        @CanIgnoreReturnValue
        public final Builder center(Iterable<Double> elements) {
            this.center = ImmutableList.builder();
            return this.addAllCenter(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCenter(Iterable<Double> elements) {
            this.center.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        @JsonProperty(value="singleCollectionEnabled")
        @CanIgnoreReturnValue
        public final Builder singleCollectionEnabled(@Nullable Boolean singleCollectionEnabled) {
            this.singleCollectionEnabled = singleCollectionEnabled;
            return this;
        }

        @JsonProperty(value="multiCollectionEnabled")
        @CanIgnoreReturnValue
        public final Builder multiCollectionEnabled(@Nullable Boolean multiCollectionEnabled) {
            this.multiCollectionEnabled = multiCollectionEnabled;
            return this;
        }

        @JsonProperty(value="ignoreInvalidGeometries")
        @CanIgnoreReturnValue
        public final Builder ignoreInvalidGeometries(@Nullable Boolean ignoreInvalidGeometries) {
            this.ignoreInvalidGeometries = ignoreInvalidGeometries;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxRelativeAreaChangeInPolygonRepair(double maxRelativeAreaChangeInPolygonRepair) {
            this.maxRelativeAreaChangeInPolygonRepair = maxRelativeAreaChangeInPolygonRepair;
            return this;
        }

        @JsonProperty(value="maxRelativeAreaChangeInPolygonRepair")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxRelativeAreaChangeInPolygonRepair(Optional<Double> maxRelativeAreaChangeInPolygonRepair) {
            this.maxRelativeAreaChangeInPolygonRepair = maxRelativeAreaChangeInPolygonRepair.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxAbsoluteAreaChangeInPolygonRepair(double maxAbsoluteAreaChangeInPolygonRepair) {
            this.maxAbsoluteAreaChangeInPolygonRepair = maxAbsoluteAreaChangeInPolygonRepair;
            return this;
        }

        @JsonProperty(value="maxAbsoluteAreaChangeInPolygonRepair")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder maxAbsoluteAreaChangeInPolygonRepair(Optional<Double> maxAbsoluteAreaChangeInPolygonRepair) {
            this.maxAbsoluteAreaChangeInPolygonRepair = maxAbsoluteAreaChangeInPolygonRepair.orElse(null);
            return this;
        }

        @JsonProperty(value="minimumSizeInPixel")
        @CanIgnoreReturnValue
        public final Builder minimumSizeInPixel(@Nullable Double minimumSizeInPixel) {
            this.minimumSizeInPixel = minimumSizeInPixel;
            return this;
        }

        @JsonProperty(value="tilesMayBeCached")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder tilesMayBeCached(boolean tilesMayBeCached) {
            this.tilesMayBeCached = tilesMayBeCached;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableTileProviderFeatures build() {
            return new ImmutableTileProviderFeatures(this);
        }

        private boolean requiresQuerySupportIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean supportsTilesHintsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean tilesMayBeCachedIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Generated(from="TileProviderFeatures", generator="Immutables")
    private final class InitShim {
        private byte requiresQuerySupportBuildStage = 0;
        private boolean requiresQuerySupport;
        private byte supportsTilesHintsBuildStage = 0;
        private boolean supportsTilesHints;
        private byte isSingleCollectionEnabledBuildStage = 0;
        private boolean isSingleCollectionEnabled;
        private byte isMultiCollectionEnabledBuildStage = 0;
        private boolean isMultiCollectionEnabled;
        private byte isIgnoreInvalidGeometriesBuildStage = 0;
        private boolean isIgnoreInvalidGeometries;
        private byte tilesMayBeCachedBuildStage = 0;
        private boolean tilesMayBeCached;

        private InitShim() {
        }

        boolean requiresQuerySupport() {
            if (this.requiresQuerySupportBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requiresQuerySupportBuildStage == 0) {
                this.requiresQuerySupportBuildStage = (byte)-1;
                this.requiresQuerySupport = ImmutableTileProviderFeatures.super.requiresQuerySupport();
                this.requiresQuerySupportBuildStage = 1;
            }
            return this.requiresQuerySupport;
        }

        void requiresQuerySupport(boolean requiresQuerySupport) {
            this.requiresQuerySupport = requiresQuerySupport;
            this.requiresQuerySupportBuildStage = 1;
        }

        boolean supportsTilesHints() {
            if (this.supportsTilesHintsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportsTilesHintsBuildStage == 0) {
                this.supportsTilesHintsBuildStage = (byte)-1;
                this.supportsTilesHints = ImmutableTileProviderFeatures.super.supportsTilesHints();
                this.supportsTilesHintsBuildStage = 1;
            }
            return this.supportsTilesHints;
        }

        void supportsTilesHints(boolean supportsTilesHints) {
            this.supportsTilesHints = supportsTilesHints;
            this.supportsTilesHintsBuildStage = 1;
        }

        boolean isSingleCollectionEnabled() {
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSingleCollectionEnabledBuildStage == 0) {
                this.isSingleCollectionEnabledBuildStage = (byte)-1;
                this.isSingleCollectionEnabled = ImmutableTileProviderFeatures.super.isSingleCollectionEnabled();
                this.isSingleCollectionEnabledBuildStage = 1;
            }
            return this.isSingleCollectionEnabled;
        }

        boolean isMultiCollectionEnabled() {
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isMultiCollectionEnabledBuildStage == 0) {
                this.isMultiCollectionEnabledBuildStage = (byte)-1;
                this.isMultiCollectionEnabled = ImmutableTileProviderFeatures.super.isMultiCollectionEnabled();
                this.isMultiCollectionEnabledBuildStage = 1;
            }
            return this.isMultiCollectionEnabled;
        }

        boolean isIgnoreInvalidGeometries() {
            if (this.isIgnoreInvalidGeometriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isIgnoreInvalidGeometriesBuildStage == 0) {
                this.isIgnoreInvalidGeometriesBuildStage = (byte)-1;
                this.isIgnoreInvalidGeometries = ImmutableTileProviderFeatures.super.isIgnoreInvalidGeometries();
                this.isIgnoreInvalidGeometriesBuildStage = 1;
            }
            return this.isIgnoreInvalidGeometries;
        }

        boolean tilesMayBeCached() {
            if (this.tilesMayBeCachedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tilesMayBeCachedBuildStage == 0) {
                this.tilesMayBeCachedBuildStage = (byte)-1;
                this.tilesMayBeCached = ImmutableTileProviderFeatures.super.tilesMayBeCached();
                this.tilesMayBeCachedBuildStage = 1;
            }
            return this.tilesMayBeCached;
        }

        void tilesMayBeCached(boolean tilesMayBeCached) {
            this.tilesMayBeCached = tilesMayBeCached;
            this.tilesMayBeCachedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.requiresQuerySupportBuildStage == -1) {
                attributes.add("requiresQuerySupport");
            }
            if (this.supportsTilesHintsBuildStage == -1) {
                attributes.add("supportsTilesHints");
            }
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                attributes.add("isSingleCollectionEnabled");
            }
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                attributes.add("isMultiCollectionEnabled");
            }
            if (this.isIgnoreInvalidGeometriesBuildStage == -1) {
                attributes.add("isIgnoreInvalidGeometries");
            }
            if (this.tilesMayBeCachedBuildStage == -1) {
                attributes.add("tilesMayBeCached");
            }
            return "Cannot build TileProviderFeatures, attribute initializers form cycle " + attributes;
        }
    }
}

