/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.tiles.app;

import de.ii.ogcapi.features.core.domain.FeaturesCoreProviders;
import de.ii.ogcapi.features.core.domain.FeaturesQuery;
import de.ii.ogcapi.features.core.domain.SchemaInfo;
import de.ii.ogcapi.foundation.domain.ApiBuildingBlock;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionRegistry;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.FormatExtension;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.tiles.app.ImmutableTileProviderFeatures;
import de.ii.ogcapi.tiles.app.TileProviderFeatures;
import de.ii.ogcapi.tiles.domain.ImmutableMinMax;
import de.ii.ogcapi.tiles.domain.ImmutableTilesConfiguration;
import de.ii.ogcapi.tiles.domain.MinMax;
import de.ii.ogcapi.tiles.domain.PredefinedFilter;
import de.ii.ogcapi.tiles.domain.Rule;
import de.ii.ogcapi.tiles.domain.TileFormatExtension;
import de.ii.ogcapi.tiles.domain.TileFormatWithQuerySupportExtension;
import de.ii.ogcapi.tiles.domain.TileSetFormatExtension;
import de.ii.ogcapi.tiles.domain.TilesConfiguration;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSet;
import de.ii.ogcapi.tiles.domain.tileMatrixSet.TileMatrixSetRepository;
import de.ii.xtraplatform.cql.domain.Cql;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.store.domain.entities.ImmutableValidationResult;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.common.collect.ImmutableSet;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;
import shadow.org.sqlite.SQLiteJDBCLoader;

@Singleton
@AutoBind
public class CapabilityTiles
implements ApiBuildingBlock {
    public static final int LIMIT_DEFAULT = 100000;
    public static final double MINIMUM_SIZE_IN_PIXEL = 0.5;
    public static final String DATASET_TILES = "__all__";
    private final ExtensionRegistry extensionRegistry;
    private final FeaturesCoreProviders providers;
    private final FeaturesQuery queryParser;
    private final SchemaInfo schemaInfo;
    private final TileMatrixSetRepository tileMatrixSetRepository;

    @Inject
    public CapabilityTiles(ExtensionRegistry extensionRegistry, FeaturesQuery queryParser, FeaturesCoreProviders providers, SchemaInfo schemaInfo, TileMatrixSetRepository tileMatrixSetRepository) {
        this.extensionRegistry = extensionRegistry;
        this.queryParser = queryParser;
        this.providers = providers;
        this.schemaInfo = schemaInfo;
        this.tileMatrixSetRepository = tileMatrixSetRepository;
    }

    @Override
    public ExtensionConfiguration getDefaultConfiguration() {
        return new ImmutableTilesConfiguration.Builder().enabled(false).tileProvider(ImmutableTileProviderFeatures.builder().tileEncodings(this.extensionRegistry.getExtensionsForType(TileFormatWithQuerySupportExtension.class).stream().filter(FormatExtension::isEnabledByDefault).map(format -> format.getMediaType().label()).collect(ImmutableList.toImmutableList())).center(ImmutableList.of(Double.valueOf(0.0), Double.valueOf(0.0))).zoomLevels(ImmutableMap.of("WebMercatorQuad", new ImmutableMinMax.Builder().min(0).max(23).build())).zoomLevelsCache(ImmutableMap.of()).seeding(ImmutableMap.of()).limit(100000).singleCollectionEnabled(true).multiCollectionEnabled(true).ignoreInvalidGeometries(false).minimumSizeInPixel(0.5).build()).tileSetEncodings(this.extensionRegistry.getExtensionsForType(TileSetFormatExtension.class).stream().filter(FormatExtension::isEnabledByDefault).map(format -> format.getMediaType().label()).collect(ImmutableList.toImmutableList())).cache(TilesConfiguration.TileCacheType.FILES).style("DEFAULT").build();
    }

    private MinMax getZoomLevels(OgcApiDataV2 apiData, TilesConfiguration config, String tileMatrixSetId) {
        if (Objects.nonNull(config.getZoomLevelsDerived())) {
            return config.getZoomLevelsDerived().get(tileMatrixSetId);
        }
        Optional<TileMatrixSet> tileMatrixSet = this.tileMatrixSetRepository.get(tileMatrixSetId).filter(tms -> config.getTileMatrixSets().contains(tms.getId()));
        return tileMatrixSet.map(matrixSet -> new ImmutableMinMax.Builder().min(matrixSet.getMinLevel()).max(matrixSet.getMaxLevel()).build()).orElse(null);
    }

    private MinMax getZoomLevels(OgcApiDataV2 apiData, String tileMatrixSetId) {
        Optional<TileMatrixSet> tileMatrixSet = this.tileMatrixSetRepository.get(tileMatrixSetId).filter(tms -> apiData.getExtension(TilesConfiguration.class).map(TilesConfiguration::getTileMatrixSets).filter(set -> set.contains(tms.getId())).isPresent());
        return tileMatrixSet.map(matrixSet -> new ImmutableMinMax.Builder().min(matrixSet.getMinLevel()).max(matrixSet.getMaxLevel()).build()).orElse(null);
    }

    @Override
    public ValidationResult onStartup(OgcApiDataV2 apiData, ValidationResult.MODE apiValidation) {
        if (!apiData.getExtension(TilesConfiguration.class).map(ExtensionConfiguration::getEnabled).orElse(false).booleanValue()) {
            return ValidationResult.of();
        }
        try {
            SQLiteJDBCLoader.initialize();
        }
        catch (Exception e) {
            return ImmutableValidationResult.builder().mode(apiValidation).addStrictErrors(MessageFormat.format("Could not load SQLite: {}", e.getMessage())).build();
        }
        if (apiValidation == ValidationResult.MODE.NONE) {
            return ValidationResult.of();
        }
        ImmutableValidationResult.Builder builder = ImmutableValidationResult.builder().mode(apiValidation);
        for (Map.Entry<String, TilesConfiguration> entry2 : apiData.getCollections().entrySet().stream().filter(entry -> ((FeatureTypeConfigurationOgcApi)entry.getValue()).getEnabled() && ((FeatureTypeConfigurationOgcApi)entry.getValue()).getExtension(TilesConfiguration.class).isPresent()).map(entry -> new AbstractMap.SimpleImmutableEntry<String, TilesConfiguration>((String)entry.getKey(), ((FeatureTypeConfigurationOgcApi)entry.getValue()).getExtension(TilesConfiguration.class).get())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).entrySet()) {
            Map<String, List<Rule>> rules;
            Map<String, List<PredefinedFilter>> map;
            Integer limit;
            Map<String, MinMax> seeding;
            String collectionId = entry2.getKey();
            TilesConfiguration config = entry2.getValue();
            Optional<FeatureSchema> schema = this.providers.getFeatureSchema(apiData, (FeatureTypeConfigurationOgcApi)apiData.getCollections().get(collectionId));
            ImmutableList featureProperties = schema.isPresent() ? this.schemaInfo.getPropertyNames(schema.get(), false, false) : ImmutableList.of();
            List formatLabels = this.extensionRegistry.getExtensionsForType(TileFormatExtension.class).stream().filter(formatExtension -> formatExtension.isEnabledForApi(apiData)).map(format -> format.getMediaType().label()).collect(Collectors.toUnmodifiableList());
            List<String> tileEncodings = config.getTileEncodingsDerived();
            if (Objects.isNull(tileEncodings)) {
                builder.addStrictErrors(MessageFormat.format("No tile encoding has been specified in the TILES module configuration of collection ''{0}''.", collectionId));
            } else {
                for (String encoding : config.getTileEncodingsDerived()) {
                    if (formatLabels.contains(encoding)) continue;
                    builder.addStrictErrors(MessageFormat.format("The tile encoding ''{0}'' is specified in the TILES module configuration of collection ''{1}'', but the format does not exist.", encoding, collectionId));
                }
            }
            formatLabels = this.extensionRegistry.getExtensionsForType(TileSetFormatExtension.class).stream().filter(formatExtension -> formatExtension.isEnabledForApi(apiData)).map(format -> format.getMediaType().label()).collect(Collectors.toUnmodifiableList());
            for (String encoding : config.getTileSetEncodings()) {
                if (formatLabels.contains(encoding)) continue;
                builder.addStrictErrors(MessageFormat.format("The tile set encoding ''{0}'' is specified in the TILES module configuration of collection ''{1}'', but the format does not exist.", encoding, collectionId));
            }
            List<Double> center = config.getCenterDerived();
            if (center.size() != 0 && center.size() != 2) {
                builder.addStrictErrors(MessageFormat.format("The center has been specified in the TILES module configuration of collection ''{1}'', but the array length is ''{0}'', not 2.", center.size(), collectionId));
            }
            Map<String, MinMax> zoomLevels = config.getZoomLevelsDerived();
            for (Map.Entry<String, MinMax> entry22 : zoomLevels.entrySet()) {
                Integer defaultLevel;
                String tileMatrixSetId = entry22.getKey();
                Optional<TileMatrixSet> optional = this.tileMatrixSetRepository.get(tileMatrixSetId).filter(tms -> config.getTileMatrixSets().contains(tms.getId()));
                if (optional.isEmpty()) {
                    builder.addStrictErrors(MessageFormat.format("The configuration in the TILES module of collection ''{0}'' references a tile matrix set ''{1}'' that is not available in this API.", collectionId, tileMatrixSetId));
                    continue;
                }
                if (optional.get().getMinLevel() > ((MinMax)entry22.getValue()).getMin()) {
                    builder.addStrictErrors(MessageFormat.format("The configuration in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to start at level ''{2}'', but the minimum level of the tile matrix set is ''{3}''.", collectionId, tileMatrixSetId, ((MinMax)entry22.getValue()).getMin(), optional.get().getMinLevel()));
                }
                if (optional.get().getMaxLevel() < ((MinMax)entry22.getValue()).getMax()) {
                    builder.addStrictErrors(MessageFormat.format("The configuration in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to end at level ''{2}'', but the maximum level of the tile matrix set is ''{3}''.", collectionId, tileMatrixSetId, ((MinMax)entry22.getValue()).getMax(), optional.get().getMaxLevel()));
                }
                if (!((MinMax)entry22.getValue()).getDefault().isPresent() || (defaultLevel = ((MinMax)entry22.getValue()).getDefault().get()) >= ((MinMax)entry22.getValue()).getMin() && defaultLevel <= ((MinMax)entry22.getValue()).getMax()) continue;
                builder.addStrictErrors(MessageFormat.format("The configuration in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' specifies a default level ''{2}'' that is outside of the range [ ''{3}'' : ''{4}'' ].", tileMatrixSetId, defaultLevel, ((MinMax)entry22.getValue()).getMin(), ((MinMax)entry22.getValue()).getMax()));
            }
            if (!(config.getTileProvider() instanceof TileProviderFeatures)) continue;
            Map<String, MinMax> zoomLevelsCache = config.getZoomLevelsCacheDerived();
            if (Objects.nonNull(zoomLevelsCache)) {
                Map.Entry<String, MinMax> entry22;
                entry22 = zoomLevelsCache.entrySet().iterator();
                while (entry22.hasNext()) {
                    Map.Entry entry23 = (Map.Entry)entry22.next();
                    String string = (String)entry23.getKey();
                    MinMax zoomLevelsTms = this.getZoomLevels(apiData, string);
                    if (Objects.isNull(zoomLevelsTms)) {
                        builder.addStrictErrors(MessageFormat.format("The cache in the TILES module of collection ''{0}'' references a tile matrix set ''{1}'' that is not configured for this API.", collectionId, string));
                        continue;
                    }
                    if (zoomLevelsTms.getMin() > ((MinMax)entry23.getValue()).getMin()) {
                        builder.addStrictErrors(MessageFormat.format("The cache in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to start at level ''{2}'', but the minimum level is ''{3}''.", collectionId, string, ((MinMax)entry23.getValue()).getMin(), zoomLevelsTms.getMin()));
                    }
                    if (zoomLevelsTms.getMax() >= ((MinMax)entry23.getValue()).getMax()) continue;
                    builder.addStrictErrors(MessageFormat.format("The cache in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to end at level ''{2}'', but the maximum level is ''{3}''.", collectionId, string, ((MinMax)entry23.getValue()).getMax(), zoomLevelsTms.getMax()));
                }
            }
            if (Objects.nonNull(seeding = config.getSeedingDerived())) {
                for (Map.Entry entry3 : seeding.entrySet()) {
                    String tileMatrixSetId = (String)entry3.getKey();
                    MinMax minMax = this.getZoomLevels(apiData, tileMatrixSetId);
                    if (Objects.isNull(minMax)) {
                        builder.addStrictErrors(MessageFormat.format("The seeding in the TILES module of collection ''{0}'' references a tile matrix set ''{1}'' that is not configured for this API.", collectionId, tileMatrixSetId));
                        continue;
                    }
                    if (minMax.getMin() > ((MinMax)entry3.getValue()).getMin()) {
                        builder.addStrictErrors(MessageFormat.format("The seeding in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to start at level ''{2}'', but the minimum level is ''{3}''.", collectionId, tileMatrixSetId, ((MinMax)entry3.getValue()).getMin(), minMax.getMin()));
                    }
                    if (minMax.getMax() >= ((MinMax)entry3.getValue()).getMax()) continue;
                    builder.addStrictErrors(MessageFormat.format("The seeding in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to end at level ''{2}'', but the maximum level is ''{3}''.", collectionId, tileMatrixSetId, ((MinMax)entry3.getValue()).getMax(), minMax.getMax()));
                }
            }
            if ((limit = Objects.requireNonNullElse(config.getLimitDerived(), 0)) < 1) {
                builder.addStrictErrors(MessageFormat.format("The feature limit in the TILES module must be a positive integer. Found in collection ''{1}'': {0}.", limit, collectionId));
            }
            if (Objects.nonNull(map = config.getFiltersDerived())) {
                for (Map.Entry entry4 : map.entrySet()) {
                    String tileMatrixSetId = (String)entry4.getKey();
                    MinMax zoomLevelsCfg = this.getZoomLevels(apiData, config, tileMatrixSetId);
                    if (Objects.isNull(zoomLevelsCfg)) {
                        builder.addStrictErrors(MessageFormat.format("The filters in the TILES module of collection ''{0}'' references a tile matrix set ''{0}'' that is not configured for this API.", collectionId, tileMatrixSetId));
                        continue;
                    }
                    for (PredefinedFilter filter : (List)entry4.getValue()) {
                        if (zoomLevelsCfg.getMin() > filter.getMin()) {
                            builder.addStrictErrors(MessageFormat.format("A filter in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to start at level ''{2}'', but the minimum level is ''{3}''.", collectionId, tileMatrixSetId, filter.getMin(), zoomLevelsCfg.getMin()));
                        }
                        if (zoomLevelsCfg.getMax() < filter.getMax()) {
                            builder.addStrictErrors(MessageFormat.format("A filter in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to end at level ''{2}'', but the maximum level is ''{3}''.", collectionId, tileMatrixSetId, filter.getMax(), zoomLevelsCfg.getMax()));
                        }
                        if (!filter.getFilter().isPresent()) continue;
                        String expression = filter.getFilter().get();
                        FeatureTypeConfigurationOgcApi collectionData = (FeatureTypeConfigurationOgcApi)apiData.getCollections().get(collectionId);
                        Map<String, String> filterableFields = this.queryParser.getFilterableFields(apiData, collectionData);
                        Map<String, String> queryableTypes = this.queryParser.getQueryableTypes(apiData, collectionData);
                        try {
                            this.queryParser.getFilterFromQuery(ImmutableMap.of("filter", expression), filterableFields, ImmutableSet.of("filter"), queryableTypes, Cql.Format.TEXT);
                        }
                        catch (Exception e) {
                            builder.addErrors(MessageFormat.format("A filter ''{0}'' in the TILES module of collection ''{1}'' for tile matrix set ''{2}'' is invalid. Reason: {3}", expression, collectionId, tileMatrixSetId, e.getMessage()));
                        }
                    }
                }
            }
            if (!Objects.nonNull(rules = config.getRulesDerived())) continue;
            for (Map.Entry<String, List<Rule>> entry26 : rules.entrySet()) {
                String tileMatrixSetId = entry26.getKey();
                MinMax zoomLevelsCfg = this.getZoomLevels(apiData, config, tileMatrixSetId);
                if (Objects.isNull(zoomLevelsCfg)) {
                    builder.addStrictErrors(MessageFormat.format("The rules in the TILES module of collection ''{0}'' references a tile matrix set ''{0}'' that is not configured for this API.", collectionId, tileMatrixSetId));
                    continue;
                }
                for (Rule rule : entry26.getValue()) {
                    if (zoomLevelsCfg.getMin() > rule.getMin()) {
                        builder.addStrictErrors(MessageFormat.format("A rule in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to start at level ''{2}'', but the minimum level is ''{3}''.", collectionId, tileMatrixSetId, rule.getMin(), zoomLevelsCfg.getMin()));
                    }
                    if (zoomLevelsCfg.getMax() < rule.getMax()) {
                        builder.addStrictErrors(MessageFormat.format("A rule in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' is specified to end at level ''{2}'', but the maximum level is ''{3}''.", collectionId, tileMatrixSetId, rule.getMax(), zoomLevelsCfg.getMax()));
                    }
                    for (String property : rule.getProperties()) {
                        if (featureProperties.contains(property)) continue;
                        builder.addErrors(MessageFormat.format("A rule in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' references property ''{2}'' that is not part of the feature schema.", collectionId, tileMatrixSetId, property));
                    }
                    for (String property : rule.getGroupBy()) {
                        if (featureProperties.contains(property)) continue;
                        builder.addErrors(MessageFormat.format("A rule in the TILES module of collection ''{0}'' for tile matrix set ''{1}'' references group-by property ''{2}'' that is not part of the feature schema.", collectionId, tileMatrixSetId, property));
                    }
                }
            }
        }
        return builder.build();
    }
}

