/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.styles.domain;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class StylesheetContent {
    final String descriptor;
    final byte[] content;
    final boolean inStore;

    public StylesheetContent(File file) throws IOException {
        this.content = Files.readAllBytes(file.toPath());
        this.descriptor = file.getAbsolutePath();
        this.inStore = true;
    }

    public StylesheetContent(Path path) throws IOException {
        this.content = Files.readAllBytes(path);
        this.descriptor = path.toFile().getAbsolutePath();
        this.inStore = true;
    }

    public StylesheetContent(byte[] content, String descriptor, boolean inStore) {
        this.content = content;
        this.descriptor = descriptor;
        this.inStore = inStore;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean getInStore() {
        return this.inStore;
    }
}

