/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.styles.domain;

import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.styles.domain.ImmutableStylesConfiguration;
import java.util.ArrayList;
import java.util.List;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.Lists;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableStylesConfiguration.Builder.class)
@Value.Immutable
@Value.Style(builder="new")
public interface StylesConfiguration
extends ExtensionConfiguration,
CachingConfiguration {
    public List<String> getStyleEncodings();

    @Nullable
    public Boolean getManagerEnabled();

    @Nullable
    public Boolean getValidationEnabled();

    @Nullable
    public Boolean getUseIdFromStylesheet();

    @Deprecated
    @Nullable
    public Boolean getResourcesEnabled();

    @Deprecated
    @Nullable
    public Boolean getResourceManagerEnabled();

    @Deprecated(since="3.1.0")
    @Nullable
    public String getDefaultStyle();

    @Nullable
    public Boolean getDeriveCollectionStyles();

    @Nullable
    public Boolean getWebmapWithPopup();

    @Nullable
    public Boolean getWebmapWithLayerControl();

    @Nullable
    public Boolean getLayerControlAllLayers();

    default public Builder getBuilder() {
        return new ImmutableStylesConfiguration.Builder();
    }

    @Override
    default public ExtensionConfiguration mergeInto(ExtensionConfiguration source) {
        ImmutableStylesConfiguration.Builder builder = ((ImmutableStylesConfiguration.Builder)source.getBuilder()).from(source).from(this);
        ArrayList<String> styleEncodings = Lists.newArrayList(((StylesConfiguration)source).getStyleEncodings());
        this.getStyleEncodings().forEach(styleEncoding -> {
            if (!styleEncodings.contains(styleEncoding)) {
                styleEncodings.add((String)styleEncoding);
            }
        });
        builder.styleEncodings(styleEncodings);
        return builder.build();
    }

    public static abstract class Builder
    extends ExtensionConfiguration.Builder {
    }
}

