/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.styles.domain;

import de.ii.ogcapi.features.geojson.domain.JsonSchema;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.styles.domain.ImmutableStyleLayer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.hash.Funnel;
import shadow.org.immutables.value.Value;

@JsonDeserialize(as=ImmutableStyleLayer.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true)
public abstract class StyleLayer {
    public static final Funnel<StyleLayer> FUNNEL = (from, into) -> {
        into.putString(from.getId(), StandardCharsets.UTF_8);
        from.getDescription().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getType().ifPresent(val -> into.putString((CharSequence)val, StandardCharsets.UTF_8));
        from.getAttributes().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> JsonSchema.FUNNEL.funnel((JsonSchema)entry.getValue(), into));
        from.getSampleData().ifPresent(link -> into.putString(link.getHref(), StandardCharsets.UTF_8).putString(Objects.requireNonNullElse(link.getRel(), ""), StandardCharsets.UTF_8));
    };

    public abstract String getId();

    public abstract Optional<String> getDescription();

    public abstract Optional<String> getType();

    public abstract Map<String, JsonSchema> getAttributes();

    public abstract Optional<Link> getSampleData();

    @JsonIgnore
    @Value.Lazy
    public Optional<String> getAttributeList() {
        return this.getAttributes().isEmpty() ? Optional.empty() : Optional.of(String.join((CharSequence)", ", this.getAttributes().keySet().stream().sorted().collect(Collectors.toUnmodifiableList())));
    }
}

