/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.styles.domain;

import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.styles.domain.StylesConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StylesConfiguration", generator="Immutables")
@Immutable
public final class ImmutableStylesConfiguration
implements StylesConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final Caching caching;
    private final ImmutableList<String> styleEncodings;
    @Nullable
    private final Boolean managerEnabled;
    @Nullable
    private final Boolean validationEnabled;
    @Nullable
    private final Boolean useIdFromStylesheet;
    @Nullable
    private final Boolean resourcesEnabled;
    @Nullable
    private final Boolean resourceManagerEnabled;
    @Nullable
    private final String defaultStyle;
    @Nullable
    private final Boolean deriveCollectionStyles;
    @Nullable
    private final Boolean webmapWithPopup;
    @Nullable
    private final Boolean webmapWithLayerControl;
    @Nullable
    private final Boolean layerControlAllLayers;

    private ImmutableStylesConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Caching caching, ImmutableList<String> styleEncodings, @Nullable Boolean managerEnabled, @Nullable Boolean validationEnabled, @Nullable Boolean useIdFromStylesheet, @Nullable Boolean resourcesEnabled, @Nullable Boolean resourceManagerEnabled, @Nullable String defaultStyle, @Nullable Boolean deriveCollectionStyles, @Nullable Boolean webmapWithPopup, @Nullable Boolean webmapWithLayerControl, @Nullable Boolean layerControlAllLayers) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.caching = caching;
        this.styleEncodings = styleEncodings;
        this.managerEnabled = managerEnabled;
        this.validationEnabled = validationEnabled;
        this.useIdFromStylesheet = useIdFromStylesheet;
        this.resourcesEnabled = resourcesEnabled;
        this.resourceManagerEnabled = resourceManagerEnabled;
        this.defaultStyle = defaultStyle;
        this.deriveCollectionStyles = deriveCollectionStyles;
        this.webmapWithPopup = webmapWithPopup;
        this.webmapWithLayerControl = webmapWithLayerControl;
        this.layerControlAllLayers = layerControlAllLayers;
        this.isEnabled = StylesConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="caching")
    @Nullable
    public Caching getCaching() {
        return this.caching;
    }

    @JsonProperty(value="styleEncodings")
    public ImmutableList<String> getStyleEncodings() {
        return this.styleEncodings;
    }

    @Override
    @JsonProperty(value="managerEnabled")
    @Nullable
    public Boolean getManagerEnabled() {
        return this.managerEnabled;
    }

    @Override
    @JsonProperty(value="validationEnabled")
    @Nullable
    public Boolean getValidationEnabled() {
        return this.validationEnabled;
    }

    @Override
    @JsonProperty(value="useIdFromStylesheet")
    @Nullable
    public Boolean getUseIdFromStylesheet() {
        return this.useIdFromStylesheet;
    }

    @Override
    @JsonProperty(value="resourcesEnabled")
    @Deprecated
    @Nullable
    public Boolean getResourcesEnabled() {
        return this.resourcesEnabled;
    }

    @Override
    @JsonProperty(value="resourceManagerEnabled")
    @Deprecated
    @Nullable
    public Boolean getResourceManagerEnabled() {
        return this.resourceManagerEnabled;
    }

    @Override
    @JsonProperty(value="defaultStyle")
    @Deprecated
    @Nullable
    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    @Override
    @JsonProperty(value="deriveCollectionStyles")
    @Nullable
    public Boolean getDeriveCollectionStyles() {
        return this.deriveCollectionStyles;
    }

    @Override
    @JsonProperty(value="webmapWithPopup")
    @Nullable
    public Boolean getWebmapWithPopup() {
        return this.webmapWithPopup;
    }

    @Override
    @JsonProperty(value="webmapWithLayerControl")
    @Nullable
    public Boolean getWebmapWithLayerControl() {
        return this.webmapWithLayerControl;
    }

    @Override
    @JsonProperty(value="layerControlAllLayers")
    @Nullable
    public Boolean getLayerControlAllLayers() {
        return this.layerControlAllLayers;
    }

    public final ImmutableStylesConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(value, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, newValue, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, value, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withCaching(@Nullable Caching value) {
        if (this.caching == value) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, value, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withStyleEncodings(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, newValue, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withStyleEncodings(Iterable<String> elements) {
        if (this.styleEncodings == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, newValue, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withManagerEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.managerEnabled, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, value, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withValidationEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.validationEnabled, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, value, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withUseIdFromStylesheet(@Nullable Boolean value) {
        if (Objects.equals(this.useIdFromStylesheet, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, value, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    @Deprecated
    public final ImmutableStylesConfiguration withResourcesEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.resourcesEnabled, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, value, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    @Deprecated
    public final ImmutableStylesConfiguration withResourceManagerEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.resourceManagerEnabled, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, value, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    @Deprecated
    public final ImmutableStylesConfiguration withDefaultStyle(@Nullable String value) {
        if (Objects.equals(this.defaultStyle, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, value, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withDeriveCollectionStyles(@Nullable Boolean value) {
        if (Objects.equals(this.deriveCollectionStyles, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, value, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withWebmapWithPopup(@Nullable Boolean value) {
        if (Objects.equals(this.webmapWithPopup, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, value, this.webmapWithLayerControl, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withWebmapWithLayerControl(@Nullable Boolean value) {
        if (Objects.equals(this.webmapWithLayerControl, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, value, this.layerControlAllLayers);
    }

    public final ImmutableStylesConfiguration withLayerControlAllLayers(@Nullable Boolean value) {
        if (Objects.equals(this.layerControlAllLayers, value)) {
            return this;
        }
        return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, this.styleEncodings, this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStylesConfiguration && this.equalTo((ImmutableStylesConfiguration)another);
    }

    private boolean equalTo(ImmutableStylesConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.caching, another.caching) && this.styleEncodings.equals(another.styleEncodings) && Objects.equals(this.managerEnabled, another.managerEnabled) && Objects.equals(this.validationEnabled, another.validationEnabled) && Objects.equals(this.useIdFromStylesheet, another.useIdFromStylesheet) && Objects.equals(this.resourcesEnabled, another.resourcesEnabled) && Objects.equals(this.resourceManagerEnabled, another.resourceManagerEnabled) && Objects.equals(this.defaultStyle, another.defaultStyle) && Objects.equals(this.deriveCollectionStyles, another.deriveCollectionStyles) && Objects.equals(this.webmapWithPopup, another.webmapWithPopup) && Objects.equals(this.webmapWithLayerControl, another.webmapWithLayerControl) && Objects.equals(this.layerControlAllLayers, another.layerControlAllLayers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.caching);
        h += (h << 5) + this.styleEncodings.hashCode();
        h += (h << 5) + Objects.hashCode(this.managerEnabled);
        h += (h << 5) + Objects.hashCode(this.validationEnabled);
        h += (h << 5) + Objects.hashCode(this.useIdFromStylesheet);
        h += (h << 5) + Objects.hashCode(this.resourcesEnabled);
        h += (h << 5) + Objects.hashCode(this.resourceManagerEnabled);
        h += (h << 5) + Objects.hashCode(this.defaultStyle);
        h += (h << 5) + Objects.hashCode(this.deriveCollectionStyles);
        h += (h << 5) + Objects.hashCode(this.webmapWithPopup);
        h += (h << 5) + Objects.hashCode(this.webmapWithLayerControl);
        h += (h << 5) + Objects.hashCode(this.layerControlAllLayers);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StylesConfiguration").omitNullValues().add("enabled", this.enabled).add("caching", this.caching).add("styleEncodings", this.styleEncodings).add("managerEnabled", this.managerEnabled).add("validationEnabled", this.validationEnabled).add("useIdFromStylesheet", this.useIdFromStylesheet).add("resourcesEnabled", this.resourcesEnabled).add("resourceManagerEnabled", this.resourceManagerEnabled).add("defaultStyle", this.defaultStyle).add("deriveCollectionStyles", this.deriveCollectionStyles).add("webmapWithPopup", this.webmapWithPopup).add("webmapWithLayerControl", this.webmapWithLayerControl).add("layerControlAllLayers", this.layerControlAllLayers).toString();
    }

    public static ImmutableStylesConfiguration copyOf(StylesConfiguration instance) {
        if (instance instanceof ImmutableStylesConfiguration) {
            return (ImmutableStylesConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="StylesConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends StylesConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Caching caching;
        private ImmutableList.Builder<String> styleEncodings = ImmutableList.builder();
        @Nullable
        private Boolean managerEnabled;
        @Nullable
        private Boolean validationEnabled;
        @Nullable
        private Boolean useIdFromStylesheet;
        @Nullable
        private Boolean resourcesEnabled;
        @Nullable
        private Boolean resourceManagerEnabled;
        @Nullable
        private String defaultStyle;
        @Nullable
        private Boolean deriveCollectionStyles;
        @Nullable
        private Boolean webmapWithPopup;
        @Nullable
        private Boolean webmapWithLayerControl;
        @Nullable
        private Boolean layerControlAllLayers;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CachingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(StylesConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Caching cachingValue;
            Object instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof CachingConfiguration && (cachingValue = (instance = (CachingConfiguration)object).getCaching()) != null) {
                this.caching(cachingValue);
            }
            if (object instanceof StylesConfiguration) {
                Boolean managerEnabledValue;
                Boolean webmapWithPopupValue;
                Boolean resourcesEnabledValue;
                Boolean layerControlAllLayersValue;
                Boolean deriveCollectionStylesValue;
                Boolean validationEnabledValue;
                String defaultStyleValue;
                Boolean resourceManagerEnabledValue;
                instance = (StylesConfiguration)object;
                Boolean useIdFromStylesheetValue = instance.getUseIdFromStylesheet();
                if (useIdFromStylesheetValue != null) {
                    this.useIdFromStylesheet(useIdFromStylesheetValue);
                }
                if ((resourceManagerEnabledValue = instance.getResourceManagerEnabled()) != null) {
                    this.resourceManagerEnabled(resourceManagerEnabledValue);
                }
                if ((defaultStyleValue = instance.getDefaultStyle()) != null) {
                    this.defaultStyle(defaultStyleValue);
                }
                if ((validationEnabledValue = instance.getValidationEnabled()) != null) {
                    this.validationEnabled(validationEnabledValue);
                }
                if ((deriveCollectionStylesValue = instance.getDeriveCollectionStyles()) != null) {
                    this.deriveCollectionStyles(deriveCollectionStylesValue);
                }
                if ((layerControlAllLayersValue = instance.getLayerControlAllLayers()) != null) {
                    this.layerControlAllLayers(layerControlAllLayersValue);
                }
                if ((resourcesEnabledValue = instance.getResourcesEnabled()) != null) {
                    this.resourcesEnabled(resourcesEnabledValue);
                }
                if ((webmapWithPopupValue = instance.getWebmapWithPopup()) != null) {
                    this.webmapWithPopup(webmapWithPopupValue);
                }
                this.addAllStyleEncodings(instance.getStyleEncodings());
                Boolean webmapWithLayerControlValue = instance.getWebmapWithLayerControl();
                if (webmapWithLayerControlValue != null) {
                    this.webmapWithLayerControl(webmapWithLayerControlValue);
                }
                if ((managerEnabledValue = instance.getManagerEnabled()) != null) {
                    this.managerEnabled(managerEnabledValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="caching")
        @CanIgnoreReturnValue
        public final Builder caching(@Nullable Caching caching) {
            this.caching = caching;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStyleEncodings(String element) {
            this.styleEncodings.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStyleEncodings(String ... elements) {
            this.styleEncodings.add(elements);
            return this;
        }

        @JsonProperty(value="styleEncodings")
        @CanIgnoreReturnValue
        public final Builder styleEncodings(Iterable<String> elements) {
            this.styleEncodings = ImmutableList.builder();
            return this.addAllStyleEncodings(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStyleEncodings(Iterable<String> elements) {
            this.styleEncodings.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="managerEnabled")
        @CanIgnoreReturnValue
        public final Builder managerEnabled(@Nullable Boolean managerEnabled) {
            this.managerEnabled = managerEnabled;
            return this;
        }

        @JsonProperty(value="validationEnabled")
        @CanIgnoreReturnValue
        public final Builder validationEnabled(@Nullable Boolean validationEnabled) {
            this.validationEnabled = validationEnabled;
            return this;
        }

        @JsonProperty(value="useIdFromStylesheet")
        @CanIgnoreReturnValue
        public final Builder useIdFromStylesheet(@Nullable Boolean useIdFromStylesheet) {
            this.useIdFromStylesheet = useIdFromStylesheet;
            return this;
        }

        @JsonProperty(value="resourcesEnabled")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder resourcesEnabled(@Nullable Boolean resourcesEnabled) {
            this.resourcesEnabled = resourcesEnabled;
            return this;
        }

        @JsonProperty(value="resourceManagerEnabled")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder resourceManagerEnabled(@Nullable Boolean resourceManagerEnabled) {
            this.resourceManagerEnabled = resourceManagerEnabled;
            return this;
        }

        @JsonProperty(value="defaultStyle")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder defaultStyle(@Nullable String defaultStyle) {
            this.defaultStyle = defaultStyle;
            return this;
        }

        @JsonProperty(value="deriveCollectionStyles")
        @CanIgnoreReturnValue
        public final Builder deriveCollectionStyles(@Nullable Boolean deriveCollectionStyles) {
            this.deriveCollectionStyles = deriveCollectionStyles;
            return this;
        }

        @JsonProperty(value="webmapWithPopup")
        @CanIgnoreReturnValue
        public final Builder webmapWithPopup(@Nullable Boolean webmapWithPopup) {
            this.webmapWithPopup = webmapWithPopup;
            return this;
        }

        @JsonProperty(value="webmapWithLayerControl")
        @CanIgnoreReturnValue
        public final Builder webmapWithLayerControl(@Nullable Boolean webmapWithLayerControl) {
            this.webmapWithLayerControl = webmapWithLayerControl;
            return this;
        }

        @JsonProperty(value="layerControlAllLayers")
        @CanIgnoreReturnValue
        public final Builder layerControlAllLayers(@Nullable Boolean layerControlAllLayers) {
            this.layerControlAllLayers = layerControlAllLayers;
            return this;
        }

        @Override
        public ImmutableStylesConfiguration build() {
            return new ImmutableStylesConfiguration(this.enabled, this.defaultValues, this.caching, (ImmutableList<String>)this.styleEncodings.build(), this.managerEnabled, this.validationEnabled, this.useIdFromStylesheet, this.resourcesEnabled, this.resourceManagerEnabled, this.defaultStyle, this.deriveCollectionStyles, this.webmapWithPopup, this.webmapWithLayerControl, this.layerControlAllLayers);
        }
    }
}

