/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.styles.domain;

import de.ii.ogcapi.features.geojson.domain.JsonSchema;
import de.ii.ogcapi.foundation.domain.Link;
import de.ii.ogcapi.styles.domain.StyleLayer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonAutoDetect;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StyleLayer", generator="Immutables")
@Immutable
public final class ImmutableStyleLayer
extends StyleLayer {
    private final String id;
    @Nullable
    private final String description;
    @Nullable
    private final String type;
    private final ImmutableMap<String, JsonSchema> attributes;
    @Nullable
    private final Link sampleData;
    private volatile transient long lazyInitBitmap;
    private static final long ATTRIBUTE_LIST_LAZY_INIT_BIT = 1L;
    private transient Optional<String> attributeList;

    private ImmutableStyleLayer(String id, @Nullable String description, @Nullable String type, ImmutableMap<String, JsonSchema> attributes, @Nullable Link sampleData) {
        this.id = id;
        this.description = description;
        this.type = type;
        this.attributes = attributes;
        this.sampleData = sampleData;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="type")
    public Optional<String> getType() {
        return Optional.ofNullable(this.type);
    }

    @JsonProperty(value="attributes")
    public ImmutableMap<String, JsonSchema> getAttributes() {
        return this.attributes;
    }

    @Override
    @JsonProperty(value="sampleData")
    public Optional<Link> getSampleData() {
        return Optional.ofNullable(this.sampleData);
    }

    public final ImmutableStyleLayer withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableStyleLayer(newValue, this.description, this.type, this.attributes, this.sampleData);
    }

    public final ImmutableStyleLayer withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableStyleLayer(this.id, newValue, this.type, this.attributes, this.sampleData);
    }

    public final ImmutableStyleLayer withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableStyleLayer(this.id, value, this.type, this.attributes, this.sampleData);
    }

    public final ImmutableStyleLayer withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (Objects.equals(this.type, newValue)) {
            return this;
        }
        return new ImmutableStyleLayer(this.id, this.description, newValue, this.attributes, this.sampleData);
    }

    public final ImmutableStyleLayer withType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableStyleLayer(this.id, this.description, value, this.attributes, this.sampleData);
    }

    public final ImmutableStyleLayer withAttributes(Map<String, ? extends JsonSchema> entries) {
        if (this.attributes == entries) {
            return this;
        }
        ImmutableMap<String, JsonSchema> newValue = ImmutableMap.copyOf(entries);
        return new ImmutableStyleLayer(this.id, this.description, this.type, newValue, this.sampleData);
    }

    public final ImmutableStyleLayer withSampleData(Link value) {
        Link newValue = Objects.requireNonNull(value, "sampleData");
        if (this.sampleData == newValue) {
            return this;
        }
        return new ImmutableStyleLayer(this.id, this.description, this.type, this.attributes, newValue);
    }

    public final ImmutableStyleLayer withSampleData(Optional<? extends Link> optional) {
        Link value = optional.orElse(null);
        if (this.sampleData == value) {
            return this;
        }
        return new ImmutableStyleLayer(this.id, this.description, this.type, this.attributes, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStyleLayer && this.equalTo((ImmutableStyleLayer)another);
    }

    private boolean equalTo(ImmutableStyleLayer another) {
        return this.id.equals(another.id) && Objects.equals(this.description, another.description) && Objects.equals(this.type, another.type) && this.attributes.equals(another.attributes) && Objects.equals(this.sampleData, another.sampleData);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + this.attributes.hashCode();
        h += (h << 5) + Objects.hashCode(this.sampleData);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("StyleLayer").omitNullValues().add("id", this.id).add("description", this.description).add("type", this.type).add("attributes", this.attributes).add("sampleData", this.sampleData).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStyleLayer fromJson(Json json) {
        Builder builder = ImmutableStyleLayer.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.attributes != null) {
            builder.putAllAttributes(json.attributes);
        }
        if (json.sampleData != null) {
            builder.sampleData(json.sampleData);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getAttributeList() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableStyleLayer immutableStyleLayer = this;
            synchronized (immutableStyleLayer) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.attributeList = Objects.requireNonNull(super.getAttributeList(), "attributeList");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.attributeList;
    }

    public static ImmutableStyleLayer copyOf(StyleLayer instance) {
        if (instance instanceof ImmutableStyleLayer) {
            return (ImmutableStyleLayer)instance;
        }
        return ImmutableStyleLayer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StyleLayer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String description;
        @Nullable
        private String type;
        private ImmutableMap.Builder<String, JsonSchema> attributes = ImmutableMap.builder();
        @Nullable
        private Link sampleData;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StyleLayer instance) {
            Optional<String> typeOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            Optional<String> descriptionOptional = instance.getDescription();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            if ((typeOptional = instance.getType()).isPresent()) {
                this.type(typeOptional);
            }
            this.putAllAttributes(instance.getAttributes());
            Optional<Link> sampleDataOptional = instance.getSampleData();
            if (sampleDataOptional.isPresent()) {
                this.sampleData(sampleDataOptional);
            }
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(Optional<String> type) {
            this.type = type.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAttributes(String key, JsonSchema value) {
            this.attributes.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAttributes(Map.Entry<String, ? extends JsonSchema> entry) {
            this.attributes.put(entry);
            return this;
        }

        @JsonProperty(value="attributes")
        @CanIgnoreReturnValue
        public final Builder attributes(Map<String, ? extends JsonSchema> entries) {
            this.attributes = ImmutableMap.builder();
            return this.putAllAttributes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAttributes(Map<String, ? extends JsonSchema> entries) {
            this.attributes.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sampleData(Link sampleData) {
            this.sampleData = Objects.requireNonNull(sampleData, "sampleData");
            return this;
        }

        @JsonProperty(value="sampleData")
        @CanIgnoreReturnValue
        public final Builder sampleData(Optional<? extends Link> sampleData) {
            this.sampleData = sampleData.orElse(null);
            return this;
        }

        public ImmutableStyleLayer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStyleLayer(this.id, this.description, this.type, this.attributes.build(), this.sampleData);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build StyleLayer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StyleLayer", generator="Immutables")
    static final class Json
    extends StyleLayer {
        @Nullable
        String id;
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        Optional<String> type = Optional.empty();
        @Nullable
        Map<String, JsonSchema> attributes = ImmutableMap.of();
        @Nullable
        Optional<Link> sampleData = Optional.empty();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="type")
        public void setType(Optional<String> type) {
            this.type = type;
        }

        @JsonProperty(value="attributes")
        public void setAttributes(Map<String, JsonSchema> attributes) {
            this.attributes = attributes;
        }

        @JsonProperty(value="sampleData")
        public void setSampleData(Optional<Link> sampleData) {
            this.sampleData = sampleData;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, JsonSchema> getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Link> getSampleData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAttributeList() {
            throw new UnsupportedOperationException();
        }
    }
}

