/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.sorting.app;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.sorting.app.SortingConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SortingConfiguration", generator="Immutables")
@Immutable
public final class ImmutableSortingConfiguration
implements SortingConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    private final ImmutableList<String> sortables;

    private ImmutableSortingConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, ImmutableList<String> sortables) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.sortables = sortables;
        this.isEnabled = SortingConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @JsonProperty(value="sortables")
    public ImmutableList<String> getSortables() {
        return this.sortables;
    }

    public final ImmutableSortingConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableSortingConfiguration(value, this.defaultValues, this.sortables);
    }

    public final ImmutableSortingConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableSortingConfiguration(this.enabled, newValue, this.sortables);
    }

    public final ImmutableSortingConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableSortingConfiguration(this.enabled, value, this.sortables);
    }

    public final ImmutableSortingConfiguration withSortables(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSortingConfiguration(this.enabled, this.defaultValues, newValue);
    }

    public final ImmutableSortingConfiguration withSortables(Iterable<String> elements) {
        if (this.sortables == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableSortingConfiguration(this.enabled, this.defaultValues, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSortingConfiguration && this.equalTo((ImmutableSortingConfiguration)another);
    }

    private boolean equalTo(ImmutableSortingConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && this.sortables.equals(another.sortables);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + this.sortables.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("SortingConfiguration").omitNullValues().add("enabled", this.enabled).add("sortables", this.sortables).toString();
    }

    public static ImmutableSortingConfiguration copyOf(SortingConfiguration instance) {
        if (instance instanceof ImmutableSortingConfiguration) {
            return (ImmutableSortingConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="SortingConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends SortingConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        private ImmutableList.Builder<String> sortables = ImmutableList.builder();

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(SortingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            ExtensionConfiguration instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof SortingConfiguration) {
                instance = (SortingConfiguration)object;
                this.addAllSortables(instance.getSortables());
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortables(String element) {
            this.sortables.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSortables(String ... elements) {
            this.sortables.add(elements);
            return this;
        }

        @JsonProperty(value="sortables")
        @CanIgnoreReturnValue
        public final Builder sortables(Iterable<String> elements) {
            this.sortables = ImmutableList.builder();
            return this.addAllSortables(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSortables(Iterable<String> elements) {
            this.sortables.addAll((Iterable)elements);
            return this;
        }

        @Override
        public ImmutableSortingConfiguration build() {
            return new ImmutableSortingConfiguration(this.enabled, this.defaultValues, (ImmutableList<String>)this.sortables.build());
        }
    }
}

