/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.sorting.app;

import de.ii.ogcapi.features.core.domain.FeaturesCoreProviders;
import de.ii.ogcapi.features.core.domain.SchemaInfo;
import de.ii.ogcapi.foundation.domain.ApiBuildingBlock;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.foundation.domain.FeatureTypeConfigurationOgcApi;
import de.ii.ogcapi.foundation.domain.OgcApiDataV2;
import de.ii.ogcapi.sorting.app.ImmutableSortingConfiguration;
import de.ii.ogcapi.sorting.app.SortingConfiguration;
import de.ii.xtraplatform.features.domain.FeatureProvider2;
import de.ii.xtraplatform.features.domain.FeatureSchema;
import de.ii.xtraplatform.store.domain.entities.ImmutableValidationResult;
import de.ii.xtraplatform.store.domain.entities.ValidationResult;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.github.azahnen.dagger.annotations.AutoBind;
import shadow.com.google.common.collect.ImmutableList;
import shadow.com.google.common.collect.ImmutableMap;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;

@Singleton
@AutoBind
public class CapabilitySorting
implements ApiBuildingBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilitySorting.class);
    static final List<String> VALID_TYPES = ImmutableList.of("STRING", "DATETIME", "INTEGER", "FLOAT");
    private final SchemaInfo schemaInfo;
    private final FeaturesCoreProviders providers;

    @Inject
    public CapabilitySorting(FeaturesCoreProviders providers, SchemaInfo schemaInfo) {
        this.providers = providers;
        this.schemaInfo = schemaInfo;
    }

    @Override
    public ExtensionConfiguration getDefaultConfiguration() {
        return new ImmutableSortingConfiguration.Builder().enabled(false).build();
    }

    @Override
    public ValidationResult onStartup(OgcApiDataV2 apiData, ValidationResult.MODE apiValidation) {
        Map configs = apiData.getCollections().entrySet().stream().map(entry -> {
            FeatureTypeConfigurationOgcApi collectionData = (FeatureTypeConfigurationOgcApi)entry.getValue();
            SortingConfiguration config = collectionData.getExtension(SortingConfiguration.class).orElse(null);
            if (Objects.isNull(config) || !config.isEnabled()) {
                return null;
            }
            return new AbstractMap.SimpleImmutableEntry<String, SortingConfiguration>((String)entry.getKey(), config);
        }).filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        if (configs.isEmpty()) {
            return ValidationResult.of();
        }
        ImmutableValidationResult.Builder builder = ImmutableValidationResult.builder().mode(apiValidation);
        FeatureProvider2 provider = this.providers.getFeatureProviderOrThrow(apiData);
        if (!provider.supportsSorting()) {
            builder.addErrors(MessageFormat.format("Sorting is enabled, but the feature provider of the API '{0}' does not support sorting.", provider.getData().getId()));
        }
        if (apiValidation == ValidationResult.MODE.NONE) {
            return builder.build();
        }
        for (Map.Entry entry2 : configs.entrySet()) {
            List<String> sortables = ((SortingConfiguration)entry2.getValue()).getSortables();
            if (sortables.isEmpty()) {
                builder.addStrictErrors(MessageFormat.format("Sorting is enabled for collection ''{0}'', but no sortable property has been configured.", entry2.getKey()));
            }
            List<String> properties = this.schemaInfo.getPropertyNames(apiData, (String)entry2.getKey());
            Optional<FeatureSchema> schema = this.providers.getFeatureSchema(apiData, (FeatureTypeConfigurationOgcApi)apiData.getCollections().get(entry2.getKey()));
            if (schema.isEmpty()) {
                builder.addErrors(MessageFormat.format("Sorting is enabled for collection ''{0}'', but no provider has been configured.", entry2.getKey()));
                continue;
            }
            for (String sortable : sortables) {
                if (!properties.contains(sortable)) {
                    builder.addErrors(MessageFormat.format("The sorting configuration for collection ''{0}'' includes a sortable property ''{1}'', but the property does not exist.", entry2.getKey(), sortable));
                }
                schema.get().getProperties().stream().filter(property -> sortable.equals(property.getName())).findAny().ifPresentOrElse(property -> {
                    if (!VALID_TYPES.contains(property.getType().toString())) {
                        builder.addErrors(MessageFormat.format("The sorting configuration for collection ''{0}'' includes a sortable property ''{1}'', but the property is not of a simple type. Found: ''{2}''.", entry2.getKey(), sortable, property.getType().toString()));
                    }
                }, () -> builder.addErrors(MessageFormat.format("The sorting configuration for collection ''{0}'' includes a sortable property ''{1}'', but the property is a nested property, not a top-level property.", entry2.getKey(), sortable)));
            }
        }
        return builder.build();
    }
}

