/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.resources.domain;

import de.ii.ogcapi.foundation.domain.Caching;
import de.ii.ogcapi.foundation.domain.CachingConfiguration;
import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.resources.domain.ResourcesConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ResourcesConfiguration", generator="Immutables")
@Immutable
public final class ImmutableResourcesConfiguration
implements ResourcesConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final Caching caching;
    @Nullable
    private final Boolean managerEnabled;

    private ImmutableResourcesConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Caching caching, @Nullable Boolean managerEnabled) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.caching = caching;
        this.managerEnabled = managerEnabled;
        this.isEnabled = ResourcesConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="caching")
    @Nullable
    public Caching getCaching() {
        return this.caching;
    }

    @Override
    @JsonProperty(value="managerEnabled")
    @Nullable
    public Boolean getManagerEnabled() {
        return this.managerEnabled;
    }

    public final ImmutableResourcesConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableResourcesConfiguration(value, this.defaultValues, this.caching, this.managerEnabled);
    }

    public final ImmutableResourcesConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableResourcesConfiguration(this.enabled, newValue, this.caching, this.managerEnabled);
    }

    public final ImmutableResourcesConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableResourcesConfiguration(this.enabled, value, this.caching, this.managerEnabled);
    }

    public final ImmutableResourcesConfiguration withCaching(@Nullable Caching value) {
        if (this.caching == value) {
            return this;
        }
        return new ImmutableResourcesConfiguration(this.enabled, this.defaultValues, value, this.managerEnabled);
    }

    public final ImmutableResourcesConfiguration withManagerEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.managerEnabled, value)) {
            return this;
        }
        return new ImmutableResourcesConfiguration(this.enabled, this.defaultValues, this.caching, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResourcesConfiguration && this.equalTo((ImmutableResourcesConfiguration)another);
    }

    private boolean equalTo(ImmutableResourcesConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.caching, another.caching) && Objects.equals(this.managerEnabled, another.managerEnabled);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.caching);
        h += (h << 5) + Objects.hashCode(this.managerEnabled);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ResourcesConfiguration").omitNullValues().add("enabled", this.enabled).add("caching", this.caching).add("managerEnabled", this.managerEnabled).toString();
    }

    public static ImmutableResourcesConfiguration copyOf(ResourcesConfiguration instance) {
        if (instance instanceof ImmutableResourcesConfiguration) {
            return (ImmutableResourcesConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="ResourcesConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends ResourcesConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Caching caching;
        @Nullable
        private Boolean managerEnabled;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CachingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ResourcesConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Boolean managerEnabledValue;
            Caching cachingValue;
            Object instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof CachingConfiguration && (cachingValue = (instance = (CachingConfiguration)object).getCaching()) != null) {
                this.caching(cachingValue);
            }
            if (object instanceof ResourcesConfiguration && (managerEnabledValue = (instance = (ResourcesConfiguration)object).getManagerEnabled()) != null) {
                this.managerEnabled(managerEnabledValue);
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="caching")
        @CanIgnoreReturnValue
        public final Builder caching(@Nullable Caching caching) {
            this.caching = caching;
            return this;
        }

        @JsonProperty(value="managerEnabled")
        @CanIgnoreReturnValue
        public final Builder managerEnabled(@Nullable Boolean managerEnabled) {
            this.managerEnabled = managerEnabled;
            return this;
        }

        @Override
        public ImmutableResourcesConfiguration build() {
            return new ImmutableResourcesConfiguration(this.enabled, this.defaultValues, this.caching, this.managerEnabled);
        }
    }
}

