/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.projections.app;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.projections.app.ProjectionsConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProjectionsConfiguration", generator="Immutables")
@Immutable
public final class ImmutableProjectionsConfiguration
implements ProjectionsConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;

    private ImmutableProjectionsConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.isEnabled = ProjectionsConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    public final ImmutableProjectionsConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableProjectionsConfiguration(value, this.defaultValues);
    }

    public final ImmutableProjectionsConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableProjectionsConfiguration(this.enabled, newValue);
    }

    public final ImmutableProjectionsConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableProjectionsConfiguration(this.enabled, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProjectionsConfiguration && this.equalTo((ImmutableProjectionsConfiguration)another);
    }

    private boolean equalTo(ImmutableProjectionsConfiguration another) {
        return Objects.equals(this.enabled, another.enabled);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ProjectionsConfiguration").omitNullValues().add("enabled", this.enabled).toString();
    }

    public static ImmutableProjectionsConfiguration copyOf(ProjectionsConfiguration instance) {
        if (instance instanceof ImmutableProjectionsConfiguration) {
            return (ImmutableProjectionsConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="ProjectionsConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends ProjectionsConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ProjectionsConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                ExtensionConfiguration instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @Override
        public ImmutableProjectionsConfiguration build() {
            return new ImmutableProjectionsConfiguration(this.enabled, this.defaultValues);
        }
    }
}

