/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.maps.domain;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.maps.domain.ImmutableMapTilesConfiguration;
import de.ii.ogcapi.tiles.domain.TileProvider;
import de.ii.ogcapi.tiles.domain.TilesConfiguration;
import java.util.List;
import java.util.Objects;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.google.common.collect.ImmutableList;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableMapTilesConfiguration.Builder.class)
@Value.Immutable
@Value.Style(deepImmutablesDetection=true, builder="new")
public interface MapTilesConfiguration
extends ExtensionConfiguration {
    @Nullable
    public TileProvider getMapProvider();

    @Nullable
    public TilesConfiguration.TileCacheType getCache();

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public List<String> getTileEncodingsDerived() {
        if (Objects.isNull(this.getMapProvider())) {
            return ImmutableList.of();
        }
        return Objects.requireNonNullElse(this.getMapProvider().getTileEncodings(), ImmutableList.of());
    }

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public boolean isMultiCollectionEnabled() {
        if (Objects.isNull(this.getMapProvider())) {
            return false;
        }
        return this.getMapProvider().isMultiCollectionEnabled();
    }

    @JsonIgnore
    @Value.Auxiliary
    @Value.Derived
    default public boolean isSingleCollectionEnabled() {
        if (Objects.isNull(this.getMapProvider())) {
            return false;
        }
        return this.getMapProvider().isSingleCollectionEnabled();
    }

    default public Builder getBuilder() {
        return new ImmutableMapTilesConfiguration.Builder();
    }

    @Override
    default public ExtensionConfiguration mergeInto(ExtensionConfiguration source) {
        if (Objects.isNull(source) || !(source instanceof MapTilesConfiguration)) {
            return this;
        }
        MapTilesConfiguration src = (MapTilesConfiguration)source;
        ImmutableMapTilesConfiguration.Builder builder = new ImmutableMapTilesConfiguration.Builder().from(src).from(this);
        return builder.build();
    }

    public static abstract class Builder
    extends ExtensionConfiguration.Builder {
    }
}

