/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.maps.domain;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.maps.domain.MapTilesConfiguration;
import de.ii.ogcapi.tiles.domain.TileProvider;
import de.ii.ogcapi.tiles.domain.TilesConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MapTilesConfiguration", generator="Immutables")
@Immutable
public final class ImmutableMapTilesConfiguration
implements MapTilesConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final TileProvider mapProvider;
    @Nullable
    private final TilesConfiguration.TileCacheType cache;
    private final transient List<String> tileEncodingsDerived;
    private final transient boolean isMultiCollectionEnabled;
    private final transient boolean isSingleCollectionEnabled;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMapTilesConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable TileProvider mapProvider, @Nullable TilesConfiguration.TileCacheType cache) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.mapProvider = mapProvider;
        this.cache = cache;
        this.isEnabled = this.initShim.isEnabled();
        this.tileEncodingsDerived = this.initShim.getTileEncodingsDerived();
        this.isMultiCollectionEnabled = this.initShim.isMultiCollectionEnabled();
        this.isSingleCollectionEnabled = this.initShim.isSingleCollectionEnabled();
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return MapTilesConfiguration.super.isEnabled();
    }

    private List<String> getTileEncodingsDerivedInitialize() {
        return MapTilesConfiguration.super.getTileEncodingsDerived();
    }

    private boolean isMultiCollectionEnabledInitialize() {
        return MapTilesConfiguration.super.isMultiCollectionEnabled();
    }

    private boolean isSingleCollectionEnabledInitialize() {
        return MapTilesConfiguration.super.isSingleCollectionEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="mapProvider")
    @Nullable
    public TileProvider getMapProvider() {
        return this.mapProvider;
    }

    @Override
    @JsonProperty(value="cache")
    @Nullable
    public TilesConfiguration.TileCacheType getCache() {
        return this.cache;
    }

    @Override
    @JsonProperty(value="tileEncodingsDerived")
    @JsonIgnore
    public List<String> getTileEncodingsDerived() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTileEncodingsDerived() : this.tileEncodingsDerived;
    }

    @Override
    @JsonProperty(value="isMultiCollectionEnabled")
    @JsonIgnore
    public boolean isMultiCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isMultiCollectionEnabled() : this.isMultiCollectionEnabled;
    }

    @Override
    @JsonProperty(value="isSingleCollectionEnabled")
    @JsonIgnore
    public boolean isSingleCollectionEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSingleCollectionEnabled() : this.isSingleCollectionEnabled;
    }

    public final ImmutableMapTilesConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableMapTilesConfiguration(value, this.defaultValues, this.mapProvider, this.cache);
    }

    public final ImmutableMapTilesConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableMapTilesConfiguration(this.enabled, newValue, this.mapProvider, this.cache);
    }

    public final ImmutableMapTilesConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableMapTilesConfiguration(this.enabled, value, this.mapProvider, this.cache);
    }

    public final ImmutableMapTilesConfiguration withMapProvider(@Nullable TileProvider value) {
        if (this.mapProvider == value) {
            return this;
        }
        return new ImmutableMapTilesConfiguration(this.enabled, this.defaultValues, value, this.cache);
    }

    public final ImmutableMapTilesConfiguration withCache(@Nullable TilesConfiguration.TileCacheType value) {
        if (this.cache == value) {
            return this;
        }
        if (Objects.equals((Object)this.cache, (Object)value)) {
            return this;
        }
        return new ImmutableMapTilesConfiguration(this.enabled, this.defaultValues, this.mapProvider, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMapTilesConfiguration && this.equalTo((ImmutableMapTilesConfiguration)another);
    }

    private boolean equalTo(ImmutableMapTilesConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.mapProvider, another.mapProvider) && Objects.equals((Object)this.cache, (Object)another.cache);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.mapProvider);
        h += (h << 5) + Objects.hashCode((Object)this.cache);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MapTilesConfiguration").omitNullValues().add("enabled", this.enabled).add("mapProvider", this.mapProvider).add("cache", (Object)this.cache).toString();
    }

    public static ImmutableMapTilesConfiguration copyOf(MapTilesConfiguration instance) {
        if (instance instanceof ImmutableMapTilesConfiguration) {
            return (ImmutableMapTilesConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="MapTilesConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends MapTilesConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private TileProvider mapProvider;
        @Nullable
        private TilesConfiguration.TileCacheType cache;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(MapTilesConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            ExtensionConfiguration instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof MapTilesConfiguration) {
                TileProvider mapProviderValue;
                instance = (MapTilesConfiguration)object;
                TilesConfiguration.TileCacheType cacheValue = instance.getCache();
                if (cacheValue != null) {
                    this.cache(cacheValue);
                }
                if ((mapProviderValue = instance.getMapProvider()) != null) {
                    this.mapProvider(mapProviderValue);
                }
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="mapProvider")
        @CanIgnoreReturnValue
        public final Builder mapProvider(@Nullable TileProvider mapProvider) {
            this.mapProvider = mapProvider;
            return this;
        }

        @JsonProperty(value="cache")
        @CanIgnoreReturnValue
        public final Builder cache(@Nullable TilesConfiguration.TileCacheType cache) {
            this.cache = cache;
            return this;
        }

        @Override
        public ImmutableMapTilesConfiguration build() {
            return new ImmutableMapTilesConfiguration(this.enabled, this.defaultValues, this.mapProvider, this.cache);
        }
    }

    @Generated(from="MapTilesConfiguration", generator="Immutables")
    private final class InitShim {
        private byte isEnabledBuildStage = 0;
        private boolean isEnabled;
        private byte tileEncodingsDerivedBuildStage = 0;
        private List<String> tileEncodingsDerived;
        private byte isMultiCollectionEnabledBuildStage = 0;
        private boolean isMultiCollectionEnabled;
        private byte isSingleCollectionEnabledBuildStage = 0;
        private boolean isSingleCollectionEnabled;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.isEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEnabledBuildStage == 0) {
                this.isEnabledBuildStage = (byte)-1;
                this.isEnabled = ImmutableMapTilesConfiguration.this.isEnabledInitialize();
                this.isEnabledBuildStage = 1;
            }
            return this.isEnabled;
        }

        List<String> getTileEncodingsDerived() {
            if (this.tileEncodingsDerivedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tileEncodingsDerivedBuildStage == 0) {
                this.tileEncodingsDerivedBuildStage = (byte)-1;
                this.tileEncodingsDerived = Objects.requireNonNull(ImmutableMapTilesConfiguration.this.getTileEncodingsDerivedInitialize(), "tileEncodingsDerived");
                this.tileEncodingsDerivedBuildStage = 1;
            }
            return this.tileEncodingsDerived;
        }

        boolean isMultiCollectionEnabled() {
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isMultiCollectionEnabledBuildStage == 0) {
                this.isMultiCollectionEnabledBuildStage = (byte)-1;
                this.isMultiCollectionEnabled = ImmutableMapTilesConfiguration.this.isMultiCollectionEnabledInitialize();
                this.isMultiCollectionEnabledBuildStage = 1;
            }
            return this.isMultiCollectionEnabled;
        }

        boolean isSingleCollectionEnabled() {
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSingleCollectionEnabledBuildStage == 0) {
                this.isSingleCollectionEnabledBuildStage = (byte)-1;
                this.isSingleCollectionEnabled = ImmutableMapTilesConfiguration.this.isSingleCollectionEnabledInitialize();
                this.isSingleCollectionEnabledBuildStage = 1;
            }
            return this.isSingleCollectionEnabled;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isEnabledBuildStage == -1) {
                attributes.add("isEnabled");
            }
            if (this.tileEncodingsDerivedBuildStage == -1) {
                attributes.add("tileEncodingsDerived");
            }
            if (this.isMultiCollectionEnabledBuildStage == -1) {
                attributes.add("isMultiCollectionEnabled");
            }
            if (this.isSingleCollectionEnabledBuildStage == -1) {
                attributes.add("isSingleCollectionEnabled");
            }
            return "Cannot build MapTilesConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

