/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.json.domain;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.json.domain.JsonConfiguration;
import java.util.Objects;
import java.util.Optional;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JsonConfiguration", generator="Immutables")
@Immutable
public final class ImmutableJsonConfiguration
implements JsonConfiguration {
    @Nullable
    private final Boolean enabled;
    private final transient boolean isEnabled;
    @Nullable
    private final ExtensionConfiguration defaultValues;
    @Nullable
    private final Boolean useFormattedJsonOutput;

    private ImmutableJsonConfiguration(@Nullable Boolean enabled, @Nullable ExtensionConfiguration defaultValues, @Nullable Boolean useFormattedJsonOutput) {
        this.enabled = enabled;
        this.defaultValues = defaultValues;
        this.useFormattedJsonOutput = useFormattedJsonOutput;
        this.isEnabled = JsonConfiguration.super.isEnabled();
    }

    @Override
    @JsonProperty(value="enabled")
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="isEnabled")
    @JsonIgnore
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="defaultValues")
    @JsonIgnore
    public Optional<ExtensionConfiguration> getDefaultValues() {
        return Optional.ofNullable(this.defaultValues);
    }

    @Override
    @JsonProperty(value="useFormattedJsonOutput")
    @Nullable
    public Boolean getUseFormattedJsonOutput() {
        return this.useFormattedJsonOutput;
    }

    public final ImmutableJsonConfiguration withEnabled(@Nullable Boolean value) {
        if (Objects.equals(this.enabled, value)) {
            return this;
        }
        return new ImmutableJsonConfiguration(value, this.defaultValues, this.useFormattedJsonOutput);
    }

    public final ImmutableJsonConfiguration withDefaultValues(ExtensionConfiguration value) {
        ExtensionConfiguration newValue = Objects.requireNonNull(value, "defaultValues");
        if (this.defaultValues == newValue) {
            return this;
        }
        return new ImmutableJsonConfiguration(this.enabled, newValue, this.useFormattedJsonOutput);
    }

    public final ImmutableJsonConfiguration withDefaultValues(Optional<? extends ExtensionConfiguration> optional) {
        ExtensionConfiguration value = optional.orElse(null);
        if (this.defaultValues == value) {
            return this;
        }
        return new ImmutableJsonConfiguration(this.enabled, value, this.useFormattedJsonOutput);
    }

    public final ImmutableJsonConfiguration withUseFormattedJsonOutput(@Nullable Boolean value) {
        if (Objects.equals(this.useFormattedJsonOutput, value)) {
            return this;
        }
        return new ImmutableJsonConfiguration(this.enabled, this.defaultValues, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonConfiguration && this.equalTo((ImmutableJsonConfiguration)another);
    }

    private boolean equalTo(ImmutableJsonConfiguration another) {
        return Objects.equals(this.enabled, another.enabled) && Objects.equals(this.useFormattedJsonOutput, another.useFormattedJsonOutput);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.useFormattedJsonOutput);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("JsonConfiguration").omitNullValues().add("enabled", this.enabled).add("useFormattedJsonOutput", this.useFormattedJsonOutput).toString();
    }

    public static ImmutableJsonConfiguration copyOf(JsonConfiguration instance) {
        if (instance instanceof ImmutableJsonConfiguration) {
            return (ImmutableJsonConfiguration)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="JsonConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    extends JsonConfiguration.Builder {
        @Nullable
        private Boolean enabled;
        @Nullable
        private ExtensionConfiguration defaultValues;
        @Nullable
        private Boolean useFormattedJsonOutput;

        @Override
        @CanIgnoreReturnValue
        public final Builder from(ExtensionConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(JsonConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @Override
        private void from(Object object) {
            Boolean useFormattedJsonOutputValue;
            ExtensionConfiguration instance;
            if (object instanceof ExtensionConfiguration) {
                Boolean enabledValue;
                instance = (ExtensionConfiguration)object;
                Optional<ExtensionConfiguration> defaultValuesOptional = instance.getDefaultValues();
                if (defaultValuesOptional.isPresent()) {
                    this.defaultValues(defaultValuesOptional);
                }
                if ((enabledValue = instance.getEnabled()) != null) {
                    this.enabled(enabledValue);
                }
            }
            if (object instanceof JsonConfiguration && (useFormattedJsonOutputValue = (instance = (JsonConfiguration)object).getUseFormattedJsonOutput()) != null) {
                this.useFormattedJsonOutput(useFormattedJsonOutputValue);
            }
        }

        @JsonProperty(value="enabled")
        @CanIgnoreReturnValue
        public final Builder enabled(@Nullable Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder defaultValues(ExtensionConfiguration defaultValues) {
            this.defaultValues = Objects.requireNonNull(defaultValues, "defaultValues");
            return this;
        }

        @JsonProperty(value="defaultValues")
        @JsonIgnore
        @CanIgnoreReturnValue
        public final Builder defaultValues(Optional<? extends ExtensionConfiguration> defaultValues) {
            this.defaultValues = defaultValues.orElse(null);
            return this;
        }

        @JsonProperty(value="useFormattedJsonOutput")
        @CanIgnoreReturnValue
        public final Builder useFormattedJsonOutput(@Nullable Boolean useFormattedJsonOutput) {
            this.useFormattedJsonOutput = useFormattedJsonOutput;
            return this;
        }

        @Override
        public ImmutableJsonConfiguration build() {
            return new ImmutableJsonConfiguration(this.enabled, this.defaultValues, this.useFormattedJsonOutput);
        }
    }
}

