/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.html.domain;

import de.ii.ogcapi.html.domain.ImmutableStyle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import shadow.com.google.common.collect.Multimap;
import shadow.org.immutables.value.Value;

@Value.Immutable
@Value.Style(builder="new", deepImmutablesDetection=true)
public interface MapClient {
    @Value.Default
    default public Type getType() {
        return Type.MAP_LIBRE;
    }

    public Optional<String> getStyleUrl();

    public Optional<String> getBackgroundUrl();

    public Optional<Source> getData();

    public Optional<String> getAttribution();

    @Value.Default
    default public boolean getSavePosition() {
        return false;
    }

    public Optional<Map<String, String>> getBounds();

    @Value.Default
    default public boolean drawBounds() {
        return false;
    }

    @Value.Default
    default public boolean isInteractive() {
        return true;
    }

    @Value.Default
    default public Style getDefaultStyle() {
        return new ImmutableStyle.Builder().build();
    }

    @Value.Default
    default public boolean getRemoveZoomLevelConstraints() {
        return false;
    }

    public Optional<Popup> getPopup();

    public Optional<Set<Map.Entry<String, Collection<String>>>> getLayerGroupControl();

    @Value.Lazy
    default public boolean isMapLibre() {
        return this.getType() == Type.MAP_LIBRE;
    }

    @Value.Lazy
    default public boolean isOpenLayers() {
        return this.getType() == Type.OPEN_LAYERS;
    }

    @Value.Lazy
    default public boolean isCesium() {
        return this.getType() == Type.CESIUM;
    }

    @Value.Immutable
    public static interface Style {
        @Value.Default
        default public String getColor() {
            return "#1D4E89";
        }

        @Value.Default
        default public double getOpacity() {
            return 1.0;
        }

        @Value.Default
        default public int getCircleRadius() {
            return 8;
        }

        @Value.Default
        default public int getCircleMinZoom() {
            return 0;
        }

        @Value.Default
        default public int getCircleMaxZoom() {
            return 24;
        }

        @Value.Default
        default public int getLineWidth() {
            return 4;
        }

        @Value.Default
        default public int getLineMinZoom() {
            return 0;
        }

        @Value.Default
        default public int getLineMaxZoom() {
            return 24;
        }

        @Value.Default
        default public double getFillOpacity() {
            return 0.2;
        }

        @Value.Default
        default public int getOutlineWidth() {
            return 2;
        }

        @Value.Default
        default public int getPolygonMinZoom() {
            return 0;
        }

        @Value.Default
        default public int getPolygonMaxZoom() {
            return 24;
        }
    }

    @Value.Immutable
    public static interface Source {
        public TYPE getType();

        public String getUrl();

        @Value.Default
        default public boolean isData() {
            return false;
        }

        public Multimap<String, List<String>> getLayers();

        public static enum TYPE {
            geojson,
            vector,
            raster;

        }
    }

    public static enum Popup {
        HOVER_ID,
        CLICK_PROPERTIES;

    }

    public static enum Type {
        MAP_LIBRE,
        OPEN_LAYERS,
        CESIUM;

    }
}

