/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.html.domain;

import de.ii.ogcapi.html.domain.MapClient;
import java.util.ArrayList;
import java.util.Objects;
import shadow.com.google.common.base.MoreObjects;
import shadow.com.google.common.primitives.Doubles;
import shadow.com.google.errorprone.annotations.CanIgnoreReturnValue;
import shadow.javax.annotation.CheckReturnValue;
import shadow.javax.annotation.Nullable;
import shadow.javax.annotation.ParametersAreNonnullByDefault;
import shadow.javax.annotation.concurrent.Immutable;
import shadow.javax.annotation.concurrent.NotThreadSafe;
import shadow.org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MapClient.Style", generator="Immutables")
@Immutable
public final class ImmutableStyle
implements MapClient.Style {
    private final String color;
    private final double opacity;
    private final int circleRadius;
    private final int circleMinZoom;
    private final int circleMaxZoom;
    private final int lineWidth;
    private final int lineMinZoom;
    private final int lineMaxZoom;
    private final double fillOpacity;
    private final int outlineWidth;
    private final int polygonMinZoom;
    private final int polygonMaxZoom;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStyle(Builder builder) {
        if (builder.color != null) {
            this.initShim.color(builder.color);
        }
        if (builder.opacityIsSet()) {
            this.initShim.opacity(builder.opacity);
        }
        if (builder.circleRadiusIsSet()) {
            this.initShim.circleRadius(builder.circleRadius);
        }
        if (builder.circleMinZoomIsSet()) {
            this.initShim.circleMinZoom(builder.circleMinZoom);
        }
        if (builder.circleMaxZoomIsSet()) {
            this.initShim.circleMaxZoom(builder.circleMaxZoom);
        }
        if (builder.lineWidthIsSet()) {
            this.initShim.lineWidth(builder.lineWidth);
        }
        if (builder.lineMinZoomIsSet()) {
            this.initShim.lineMinZoom(builder.lineMinZoom);
        }
        if (builder.lineMaxZoomIsSet()) {
            this.initShim.lineMaxZoom(builder.lineMaxZoom);
        }
        if (builder.fillOpacityIsSet()) {
            this.initShim.fillOpacity(builder.fillOpacity);
        }
        if (builder.outlineWidthIsSet()) {
            this.initShim.outlineWidth(builder.outlineWidth);
        }
        if (builder.polygonMinZoomIsSet()) {
            this.initShim.polygonMinZoom(builder.polygonMinZoom);
        }
        if (builder.polygonMaxZoomIsSet()) {
            this.initShim.polygonMaxZoom(builder.polygonMaxZoom);
        }
        this.color = this.initShim.getColor();
        this.opacity = this.initShim.getOpacity();
        this.circleRadius = this.initShim.getCircleRadius();
        this.circleMinZoom = this.initShim.getCircleMinZoom();
        this.circleMaxZoom = this.initShim.getCircleMaxZoom();
        this.lineWidth = this.initShim.getLineWidth();
        this.lineMinZoom = this.initShim.getLineMinZoom();
        this.lineMaxZoom = this.initShim.getLineMaxZoom();
        this.fillOpacity = this.initShim.getFillOpacity();
        this.outlineWidth = this.initShim.getOutlineWidth();
        this.polygonMinZoom = this.initShim.getPolygonMinZoom();
        this.polygonMaxZoom = this.initShim.getPolygonMaxZoom();
        this.initShim = null;
    }

    private ImmutableStyle(String color, double opacity, int circleRadius, int circleMinZoom, int circleMaxZoom, int lineWidth, int lineMinZoom, int lineMaxZoom, double fillOpacity, int outlineWidth, int polygonMinZoom, int polygonMaxZoom) {
        this.color = color;
        this.opacity = opacity;
        this.circleRadius = circleRadius;
        this.circleMinZoom = circleMinZoom;
        this.circleMaxZoom = circleMaxZoom;
        this.lineWidth = lineWidth;
        this.lineMinZoom = lineMinZoom;
        this.lineMaxZoom = lineMaxZoom;
        this.fillOpacity = fillOpacity;
        this.outlineWidth = outlineWidth;
        this.polygonMinZoom = polygonMinZoom;
        this.polygonMaxZoom = polygonMaxZoom;
        this.initShim = null;
    }

    private String getColorInitialize() {
        return MapClient.Style.super.getColor();
    }

    private double getOpacityInitialize() {
        return MapClient.Style.super.getOpacity();
    }

    private int getCircleRadiusInitialize() {
        return MapClient.Style.super.getCircleRadius();
    }

    private int getCircleMinZoomInitialize() {
        return MapClient.Style.super.getCircleMinZoom();
    }

    private int getCircleMaxZoomInitialize() {
        return MapClient.Style.super.getCircleMaxZoom();
    }

    private int getLineWidthInitialize() {
        return MapClient.Style.super.getLineWidth();
    }

    private int getLineMinZoomInitialize() {
        return MapClient.Style.super.getLineMinZoom();
    }

    private int getLineMaxZoomInitialize() {
        return MapClient.Style.super.getLineMaxZoom();
    }

    private double getFillOpacityInitialize() {
        return MapClient.Style.super.getFillOpacity();
    }

    private int getOutlineWidthInitialize() {
        return MapClient.Style.super.getOutlineWidth();
    }

    private int getPolygonMinZoomInitialize() {
        return MapClient.Style.super.getPolygonMinZoom();
    }

    private int getPolygonMaxZoomInitialize() {
        return MapClient.Style.super.getPolygonMaxZoom();
    }

    @Override
    public String getColor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getColor() : this.color;
    }

    @Override
    public double getOpacity() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOpacity() : this.opacity;
    }

    @Override
    public int getCircleRadius() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCircleRadius() : this.circleRadius;
    }

    @Override
    public int getCircleMinZoom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCircleMinZoom() : this.circleMinZoom;
    }

    @Override
    public int getCircleMaxZoom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCircleMaxZoom() : this.circleMaxZoom;
    }

    @Override
    public int getLineWidth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLineWidth() : this.lineWidth;
    }

    @Override
    public int getLineMinZoom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLineMinZoom() : this.lineMinZoom;
    }

    @Override
    public int getLineMaxZoom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLineMaxZoom() : this.lineMaxZoom;
    }

    @Override
    public double getFillOpacity() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFillOpacity() : this.fillOpacity;
    }

    @Override
    public int getOutlineWidth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutlineWidth() : this.outlineWidth;
    }

    @Override
    public int getPolygonMinZoom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPolygonMinZoom() : this.polygonMinZoom;
    }

    @Override
    public int getPolygonMaxZoom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getPolygonMaxZoom() : this.polygonMaxZoom;
    }

    public final ImmutableStyle withColor(String value) {
        String newValue = Objects.requireNonNull(value, "color");
        if (this.color.equals(newValue)) {
            return this;
        }
        return new ImmutableStyle(newValue, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withOpacity(double value) {
        if (Double.doubleToLongBits(this.opacity) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStyle(this.color, value, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withCircleRadius(int value) {
        if (this.circleRadius == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, value, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withCircleMinZoom(int value) {
        if (this.circleMinZoom == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, value, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withCircleMaxZoom(int value) {
        if (this.circleMaxZoom == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, value, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withLineWidth(int value) {
        if (this.lineWidth == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, value, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withLineMinZoom(int value) {
        if (this.lineMinZoom == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, value, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withLineMaxZoom(int value) {
        if (this.lineMaxZoom == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, value, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withFillOpacity(double value) {
        if (Double.doubleToLongBits(this.fillOpacity) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, value, this.outlineWidth, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withOutlineWidth(int value) {
        if (this.outlineWidth == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, value, this.polygonMinZoom, this.polygonMaxZoom);
    }

    public final ImmutableStyle withPolygonMinZoom(int value) {
        if (this.polygonMinZoom == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, value, this.polygonMaxZoom);
    }

    public final ImmutableStyle withPolygonMaxZoom(int value) {
        if (this.polygonMaxZoom == value) {
            return this;
        }
        return new ImmutableStyle(this.color, this.opacity, this.circleRadius, this.circleMinZoom, this.circleMaxZoom, this.lineWidth, this.lineMinZoom, this.lineMaxZoom, this.fillOpacity, this.outlineWidth, this.polygonMinZoom, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStyle && this.equalTo((ImmutableStyle)another);
    }

    private boolean equalTo(ImmutableStyle another) {
        return this.color.equals(another.color) && Double.doubleToLongBits(this.opacity) == Double.doubleToLongBits(another.opacity) && this.circleRadius == another.circleRadius && this.circleMinZoom == another.circleMinZoom && this.circleMaxZoom == another.circleMaxZoom && this.lineWidth == another.lineWidth && this.lineMinZoom == another.lineMinZoom && this.lineMaxZoom == another.lineMaxZoom && Double.doubleToLongBits(this.fillOpacity) == Double.doubleToLongBits(another.fillOpacity) && this.outlineWidth == another.outlineWidth && this.polygonMinZoom == another.polygonMinZoom && this.polygonMaxZoom == another.polygonMaxZoom;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.color.hashCode();
        h += (h << 5) + Doubles.hashCode(this.opacity);
        h += (h << 5) + this.circleRadius;
        h += (h << 5) + this.circleMinZoom;
        h += (h << 5) + this.circleMaxZoom;
        h += (h << 5) + this.lineWidth;
        h += (h << 5) + this.lineMinZoom;
        h += (h << 5) + this.lineMaxZoom;
        h += (h << 5) + Doubles.hashCode(this.fillOpacity);
        h += (h << 5) + this.outlineWidth;
        h += (h << 5) + this.polygonMinZoom;
        h += (h << 5) + this.polygonMaxZoom;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Style").omitNullValues().add("color", this.color).add("opacity", this.opacity).add("circleRadius", this.circleRadius).add("circleMinZoom", this.circleMinZoom).add("circleMaxZoom", this.circleMaxZoom).add("lineWidth", this.lineWidth).add("lineMinZoom", this.lineMinZoom).add("lineMaxZoom", this.lineMaxZoom).add("fillOpacity", this.fillOpacity).add("outlineWidth", this.outlineWidth).add("polygonMinZoom", this.polygonMinZoom).add("polygonMaxZoom", this.polygonMaxZoom).toString();
    }

    public static ImmutableStyle copyOf(MapClient.Style instance) {
        if (instance instanceof ImmutableStyle) {
            return (ImmutableStyle)instance;
        }
        return new Builder().from(instance).build();
    }

    @Generated(from="MapClient.Style", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_OPACITY = 1L;
        private static final long OPT_BIT_CIRCLE_RADIUS = 2L;
        private static final long OPT_BIT_CIRCLE_MIN_ZOOM = 4L;
        private static final long OPT_BIT_CIRCLE_MAX_ZOOM = 8L;
        private static final long OPT_BIT_LINE_WIDTH = 16L;
        private static final long OPT_BIT_LINE_MIN_ZOOM = 32L;
        private static final long OPT_BIT_LINE_MAX_ZOOM = 64L;
        private static final long OPT_BIT_FILL_OPACITY = 128L;
        private static final long OPT_BIT_OUTLINE_WIDTH = 256L;
        private static final long OPT_BIT_POLYGON_MIN_ZOOM = 512L;
        private static final long OPT_BIT_POLYGON_MAX_ZOOM = 1024L;
        private long optBits;
        @Nullable
        private String color;
        private double opacity;
        private int circleRadius;
        private int circleMinZoom;
        private int circleMaxZoom;
        private int lineWidth;
        private int lineMinZoom;
        private int lineMaxZoom;
        private double fillOpacity;
        private int outlineWidth;
        private int polygonMinZoom;
        private int polygonMaxZoom;

        @CanIgnoreReturnValue
        public final Builder from(MapClient.Style instance) {
            Objects.requireNonNull(instance, "instance");
            this.color(instance.getColor());
            this.opacity(instance.getOpacity());
            this.circleRadius(instance.getCircleRadius());
            this.circleMinZoom(instance.getCircleMinZoom());
            this.circleMaxZoom(instance.getCircleMaxZoom());
            this.lineWidth(instance.getLineWidth());
            this.lineMinZoom(instance.getLineMinZoom());
            this.lineMaxZoom(instance.getLineMaxZoom());
            this.fillOpacity(instance.getFillOpacity());
            this.outlineWidth(instance.getOutlineWidth());
            this.polygonMinZoom(instance.getPolygonMinZoom());
            this.polygonMaxZoom(instance.getPolygonMaxZoom());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder color(String color) {
            this.color = Objects.requireNonNull(color, "color");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder opacity(double opacity) {
            this.opacity = opacity;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder circleRadius(int circleRadius) {
            this.circleRadius = circleRadius;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder circleMinZoom(int circleMinZoom) {
            this.circleMinZoom = circleMinZoom;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder circleMaxZoom(int circleMaxZoom) {
            this.circleMaxZoom = circleMaxZoom;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lineWidth(int lineWidth) {
            this.lineWidth = lineWidth;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lineMinZoom(int lineMinZoom) {
            this.lineMinZoom = lineMinZoom;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lineMaxZoom(int lineMaxZoom) {
            this.lineMaxZoom = lineMaxZoom;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fillOpacity(double fillOpacity) {
            this.fillOpacity = fillOpacity;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outlineWidth(int outlineWidth) {
            this.outlineWidth = outlineWidth;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder polygonMinZoom(int polygonMinZoom) {
            this.polygonMinZoom = polygonMinZoom;
            this.optBits |= 0x200L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder polygonMaxZoom(int polygonMaxZoom) {
            this.polygonMaxZoom = polygonMaxZoom;
            this.optBits |= 0x400L;
            return this;
        }

        public ImmutableStyle build() {
            return new ImmutableStyle(this);
        }

        private boolean opacityIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean circleRadiusIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean circleMinZoomIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean circleMaxZoomIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean lineWidthIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean lineMinZoomIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean lineMaxZoomIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean fillOpacityIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean outlineWidthIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean polygonMinZoomIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean polygonMaxZoomIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }
    }

    @Generated(from="MapClient.Style", generator="Immutables")
    private final class InitShim {
        private byte colorBuildStage = 0;
        private String color;
        private byte opacityBuildStage = 0;
        private double opacity;
        private byte circleRadiusBuildStage = 0;
        private int circleRadius;
        private byte circleMinZoomBuildStage = 0;
        private int circleMinZoom;
        private byte circleMaxZoomBuildStage = 0;
        private int circleMaxZoom;
        private byte lineWidthBuildStage = 0;
        private int lineWidth;
        private byte lineMinZoomBuildStage = 0;
        private int lineMinZoom;
        private byte lineMaxZoomBuildStage = 0;
        private int lineMaxZoom;
        private byte fillOpacityBuildStage = 0;
        private double fillOpacity;
        private byte outlineWidthBuildStage = 0;
        private int outlineWidth;
        private byte polygonMinZoomBuildStage = 0;
        private int polygonMinZoom;
        private byte polygonMaxZoomBuildStage = 0;
        private int polygonMaxZoom;

        private InitShim() {
        }

        String getColor() {
            if (this.colorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.colorBuildStage == 0) {
                this.colorBuildStage = (byte)-1;
                this.color = Objects.requireNonNull(ImmutableStyle.this.getColorInitialize(), "color");
                this.colorBuildStage = 1;
            }
            return this.color;
        }

        void color(String color) {
            this.color = color;
            this.colorBuildStage = 1;
        }

        double getOpacity() {
            if (this.opacityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.opacityBuildStage == 0) {
                this.opacityBuildStage = (byte)-1;
                this.opacity = ImmutableStyle.this.getOpacityInitialize();
                this.opacityBuildStage = 1;
            }
            return this.opacity;
        }

        void opacity(double opacity) {
            this.opacity = opacity;
            this.opacityBuildStage = 1;
        }

        int getCircleRadius() {
            if (this.circleRadiusBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.circleRadiusBuildStage == 0) {
                this.circleRadiusBuildStage = (byte)-1;
                this.circleRadius = ImmutableStyle.this.getCircleRadiusInitialize();
                this.circleRadiusBuildStage = 1;
            }
            return this.circleRadius;
        }

        void circleRadius(int circleRadius) {
            this.circleRadius = circleRadius;
            this.circleRadiusBuildStage = 1;
        }

        int getCircleMinZoom() {
            if (this.circleMinZoomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.circleMinZoomBuildStage == 0) {
                this.circleMinZoomBuildStage = (byte)-1;
                this.circleMinZoom = ImmutableStyle.this.getCircleMinZoomInitialize();
                this.circleMinZoomBuildStage = 1;
            }
            return this.circleMinZoom;
        }

        void circleMinZoom(int circleMinZoom) {
            this.circleMinZoom = circleMinZoom;
            this.circleMinZoomBuildStage = 1;
        }

        int getCircleMaxZoom() {
            if (this.circleMaxZoomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.circleMaxZoomBuildStage == 0) {
                this.circleMaxZoomBuildStage = (byte)-1;
                this.circleMaxZoom = ImmutableStyle.this.getCircleMaxZoomInitialize();
                this.circleMaxZoomBuildStage = 1;
            }
            return this.circleMaxZoom;
        }

        void circleMaxZoom(int circleMaxZoom) {
            this.circleMaxZoom = circleMaxZoom;
            this.circleMaxZoomBuildStage = 1;
        }

        int getLineWidth() {
            if (this.lineWidthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lineWidthBuildStage == 0) {
                this.lineWidthBuildStage = (byte)-1;
                this.lineWidth = ImmutableStyle.this.getLineWidthInitialize();
                this.lineWidthBuildStage = 1;
            }
            return this.lineWidth;
        }

        void lineWidth(int lineWidth) {
            this.lineWidth = lineWidth;
            this.lineWidthBuildStage = 1;
        }

        int getLineMinZoom() {
            if (this.lineMinZoomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lineMinZoomBuildStage == 0) {
                this.lineMinZoomBuildStage = (byte)-1;
                this.lineMinZoom = ImmutableStyle.this.getLineMinZoomInitialize();
                this.lineMinZoomBuildStage = 1;
            }
            return this.lineMinZoom;
        }

        void lineMinZoom(int lineMinZoom) {
            this.lineMinZoom = lineMinZoom;
            this.lineMinZoomBuildStage = 1;
        }

        int getLineMaxZoom() {
            if (this.lineMaxZoomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lineMaxZoomBuildStage == 0) {
                this.lineMaxZoomBuildStage = (byte)-1;
                this.lineMaxZoom = ImmutableStyle.this.getLineMaxZoomInitialize();
                this.lineMaxZoomBuildStage = 1;
            }
            return this.lineMaxZoom;
        }

        void lineMaxZoom(int lineMaxZoom) {
            this.lineMaxZoom = lineMaxZoom;
            this.lineMaxZoomBuildStage = 1;
        }

        double getFillOpacity() {
            if (this.fillOpacityBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fillOpacityBuildStage == 0) {
                this.fillOpacityBuildStage = (byte)-1;
                this.fillOpacity = ImmutableStyle.this.getFillOpacityInitialize();
                this.fillOpacityBuildStage = 1;
            }
            return this.fillOpacity;
        }

        void fillOpacity(double fillOpacity) {
            this.fillOpacity = fillOpacity;
            this.fillOpacityBuildStage = 1;
        }

        int getOutlineWidth() {
            if (this.outlineWidthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outlineWidthBuildStage == 0) {
                this.outlineWidthBuildStage = (byte)-1;
                this.outlineWidth = ImmutableStyle.this.getOutlineWidthInitialize();
                this.outlineWidthBuildStage = 1;
            }
            return this.outlineWidth;
        }

        void outlineWidth(int outlineWidth) {
            this.outlineWidth = outlineWidth;
            this.outlineWidthBuildStage = 1;
        }

        int getPolygonMinZoom() {
            if (this.polygonMinZoomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.polygonMinZoomBuildStage == 0) {
                this.polygonMinZoomBuildStage = (byte)-1;
                this.polygonMinZoom = ImmutableStyle.this.getPolygonMinZoomInitialize();
                this.polygonMinZoomBuildStage = 1;
            }
            return this.polygonMinZoom;
        }

        void polygonMinZoom(int polygonMinZoom) {
            this.polygonMinZoom = polygonMinZoom;
            this.polygonMinZoomBuildStage = 1;
        }

        int getPolygonMaxZoom() {
            if (this.polygonMaxZoomBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.polygonMaxZoomBuildStage == 0) {
                this.polygonMaxZoomBuildStage = (byte)-1;
                this.polygonMaxZoom = ImmutableStyle.this.getPolygonMaxZoomInitialize();
                this.polygonMaxZoomBuildStage = 1;
            }
            return this.polygonMaxZoom;
        }

        void polygonMaxZoom(int polygonMaxZoom) {
            this.polygonMaxZoom = polygonMaxZoom;
            this.polygonMaxZoomBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.colorBuildStage == -1) {
                attributes.add("color");
            }
            if (this.opacityBuildStage == -1) {
                attributes.add("opacity");
            }
            if (this.circleRadiusBuildStage == -1) {
                attributes.add("circleRadius");
            }
            if (this.circleMinZoomBuildStage == -1) {
                attributes.add("circleMinZoom");
            }
            if (this.circleMaxZoomBuildStage == -1) {
                attributes.add("circleMaxZoom");
            }
            if (this.lineWidthBuildStage == -1) {
                attributes.add("lineWidth");
            }
            if (this.lineMinZoomBuildStage == -1) {
                attributes.add("lineMinZoom");
            }
            if (this.lineMaxZoomBuildStage == -1) {
                attributes.add("lineMaxZoom");
            }
            if (this.fillOpacityBuildStage == -1) {
                attributes.add("fillOpacity");
            }
            if (this.outlineWidthBuildStage == -1) {
                attributes.add("outlineWidth");
            }
            if (this.polygonMinZoomBuildStage == -1) {
                attributes.add("polygonMinZoom");
            }
            if (this.polygonMaxZoomBuildStage == -1) {
                attributes.add("polygonMaxZoom");
            }
            return "Cannot build Style, attribute initializers form cycle " + attributes;
        }
    }
}

