/*
 * Decompiled with CFR 0.152.
 */
package de.ii.ogcapi.html.domain;

import de.ii.ogcapi.foundation.domain.ExtensionConfiguration;
import de.ii.ogcapi.html.domain.ImmutableHtmlConfiguration;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.annotation.JsonAlias;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.javax.annotation.Nullable;
import shadow.org.immutables.value.Value;

@JsonDeserialize(builder=ImmutableHtmlConfiguration.Builder.class)
@Value.Immutable
@Value.Style(builder="new", attributeBuilderDetection=true)
public interface HtmlConfiguration
extends ExtensionConfiguration {
    public static final Logger LOGGER = LoggerFactory.getLogger(HtmlConfiguration.class);

    @Nullable
    public Boolean getNoIndexEnabled();

    @JsonAlias(value={"microdataEnabled"})
    @Nullable
    public Boolean getSchemaOrgEnabled();

    @Nullable
    public Boolean getCollectionDescriptionsInOverview();

    @Nullable
    public Boolean getSendEtags();

    @Nullable
    public String getLegalName();

    @Nullable
    public String getLegalUrl();

    @Nullable
    public String getPrivacyName();

    @Nullable
    public String getPrivacyUrl();

    @Nullable
    public String getDefaultStyle();

    @Nullable
    public String getBasemapUrl();

    @Nullable
    public String getBasemapAttribution();

    @Deprecated(since="3.1.0")
    @Nullable
    public String getLeafletUrl();

    @Deprecated(since="3.1.0")
    @Nullable
    public String getLeafletAttribution();

    @Deprecated(since="3.1.0")
    @Nullable
    public String getOpenLayersUrl();

    @Deprecated(since="3.1.0")
    @Nullable
    public String getOpenLayersAttribution();

    @Nullable
    public String getFooterText();

    default public Builder getBuilder() {
        return new ImmutableHtmlConfiguration.Builder();
    }

    default public String getStyle(Optional<String> requestedStyle, Optional<String> collectionId, String serviceUrl) {
        String styleUrl = requestedStyle.map(s -> s.equals("DEFAULT") ? Objects.requireNonNullElse(this.getDefaultStyle(), "NONE") : s).filter(s -> !s.equals("NONE")).map(s -> collectionId.isEmpty() ? String.format("%s/styles/%s?f=mbs", serviceUrl, s) : String.format("%s/collections/%s/styles/%s?f=mbs", serviceUrl, collectionId.get(), s)).orElse(null);
        if (Objects.nonNull(styleUrl)) {
            try {
                URL url = new URL(styleUrl);
                HttpURLConnection http = (HttpURLConnection)url.openConnection();
                http.setRequestMethod("HEAD");
                if (http.getResponseCode() == 404 && collectionId.isPresent()) {
                    return this.getStyle(requestedStyle, Optional.empty(), serviceUrl);
                }
                if (http.getResponseCode() != 200) {
                    LOGGER.error("Could not access style '{}', falling back to style 'NONE'. Response code: '{}'. Message: {}", styleUrl, http.getResponseCode(), http.getResponseMessage());
                    return null;
                }
                http.disconnect();
            }
            catch (Exception e) {
                LOGGER.error("Could not access style '{}', falling back to style 'NONE'. Reason: {}", (Object)styleUrl, (Object)e.getMessage());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Stacktrace: ", e);
                }
                return null;
            }
        }
        return styleUrl;
    }

    public static abstract class Builder
    extends ExtensionConfiguration.Builder {
    }
}

